// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchSauronApiLambdaTwirp/twirp.proto

package TwitchSauronApiLambdaTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// ===============================
// TwitchSauronApiLambda Interface
// ===============================

type TwitchSauronApiLambda interface {
	GetActivityFeedEvents(context.Context, *GetActivityFeedEventsRequest) (*GetActivityFeedEventsResponse, error)

	GetPinnedActivityFeedEvents(context.Context, *GetPinnedActivityFeedEventsRequest) (*GetPinnedActivityFeedEventsResponse, error)

	DeleteAllUserData(context.Context, *DeleteAllUserDataRequest) (*DeleteAllUserDataResponse, error)

	PublishActivityFeedEvent(context.Context, *PublishActivityFeedEventRequest) (*PublishActivityFeedEventResponse, error)

	GetFilterCategories(context.Context, *GetFilterCategoriesRequest) (*GetFilterCategoriesResponse, error)

	UpdateActivityFeedEventPinnedState(context.Context, *UpdateActivityFeedEventPinnedStateRequest) (*UpdateActivityFeedEventPinnedStateResponse, error)

	// TEMP: remove once regression is fixed in Toolkit
	SimulateActivityFeedEvent(context.Context, *SimulateActivityFeedEventRequest) (*SimulateActivityFeedEventResponse, error)
}

// =====================================
// TwitchSauronApiLambda Protobuf Client
// =====================================

type twitchSauronApiLambdaProtobufClient struct {
	client HTTPClient
	urls   [7]string
	opts   twirp.ClientOptions
}

// NewTwitchSauronApiLambdaProtobufClient creates a Protobuf client that implements the TwitchSauronApiLambda interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchSauronApiLambdaProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchSauronApiLambda {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchSauronApiLambdaPathPrefix
	urls := [7]string{
		prefix + "GetActivityFeedEvents",
		prefix + "GetPinnedActivityFeedEvents",
		prefix + "DeleteAllUserData",
		prefix + "PublishActivityFeedEvent",
		prefix + "GetFilterCategories",
		prefix + "UpdateActivityFeedEventPinnedState",
		prefix + "SimulateActivityFeedEvent",
	}

	return &twitchSauronApiLambdaProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchSauronApiLambdaProtobufClient) GetActivityFeedEvents(ctx context.Context, in *GetActivityFeedEventsRequest) (*GetActivityFeedEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.sauron.twitchsauronapilambda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSauronApiLambda")
	ctx = ctxsetters.WithMethodName(ctx, "GetActivityFeedEvents")
	out := new(GetActivityFeedEventsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchSauronApiLambdaProtobufClient) GetPinnedActivityFeedEvents(ctx context.Context, in *GetPinnedActivityFeedEventsRequest) (*GetPinnedActivityFeedEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.sauron.twitchsauronapilambda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSauronApiLambda")
	ctx = ctxsetters.WithMethodName(ctx, "GetPinnedActivityFeedEvents")
	out := new(GetPinnedActivityFeedEventsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchSauronApiLambdaProtobufClient) DeleteAllUserData(ctx context.Context, in *DeleteAllUserDataRequest) (*DeleteAllUserDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.sauron.twitchsauronapilambda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSauronApiLambda")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAllUserData")
	out := new(DeleteAllUserDataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchSauronApiLambdaProtobufClient) PublishActivityFeedEvent(ctx context.Context, in *PublishActivityFeedEventRequest) (*PublishActivityFeedEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.sauron.twitchsauronapilambda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSauronApiLambda")
	ctx = ctxsetters.WithMethodName(ctx, "PublishActivityFeedEvent")
	out := new(PublishActivityFeedEventResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchSauronApiLambdaProtobufClient) GetFilterCategories(ctx context.Context, in *GetFilterCategoriesRequest) (*GetFilterCategoriesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.sauron.twitchsauronapilambda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSauronApiLambda")
	ctx = ctxsetters.WithMethodName(ctx, "GetFilterCategories")
	out := new(GetFilterCategoriesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchSauronApiLambdaProtobufClient) UpdateActivityFeedEventPinnedState(ctx context.Context, in *UpdateActivityFeedEventPinnedStateRequest) (*UpdateActivityFeedEventPinnedStateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.sauron.twitchsauronapilambda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSauronApiLambda")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateActivityFeedEventPinnedState")
	out := new(UpdateActivityFeedEventPinnedStateResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchSauronApiLambdaProtobufClient) SimulateActivityFeedEvent(ctx context.Context, in *SimulateActivityFeedEventRequest) (*SimulateActivityFeedEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.sauron.twitchsauronapilambda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSauronApiLambda")
	ctx = ctxsetters.WithMethodName(ctx, "SimulateActivityFeedEvent")
	out := new(SimulateActivityFeedEventResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =================================
// TwitchSauronApiLambda JSON Client
// =================================

type twitchSauronApiLambdaJSONClient struct {
	client HTTPClient
	urls   [7]string
	opts   twirp.ClientOptions
}

// NewTwitchSauronApiLambdaJSONClient creates a JSON client that implements the TwitchSauronApiLambda interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchSauronApiLambdaJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchSauronApiLambda {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchSauronApiLambdaPathPrefix
	urls := [7]string{
		prefix + "GetActivityFeedEvents",
		prefix + "GetPinnedActivityFeedEvents",
		prefix + "DeleteAllUserData",
		prefix + "PublishActivityFeedEvent",
		prefix + "GetFilterCategories",
		prefix + "UpdateActivityFeedEventPinnedState",
		prefix + "SimulateActivityFeedEvent",
	}

	return &twitchSauronApiLambdaJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchSauronApiLambdaJSONClient) GetActivityFeedEvents(ctx context.Context, in *GetActivityFeedEventsRequest) (*GetActivityFeedEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.sauron.twitchsauronapilambda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSauronApiLambda")
	ctx = ctxsetters.WithMethodName(ctx, "GetActivityFeedEvents")
	out := new(GetActivityFeedEventsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchSauronApiLambdaJSONClient) GetPinnedActivityFeedEvents(ctx context.Context, in *GetPinnedActivityFeedEventsRequest) (*GetPinnedActivityFeedEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.sauron.twitchsauronapilambda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSauronApiLambda")
	ctx = ctxsetters.WithMethodName(ctx, "GetPinnedActivityFeedEvents")
	out := new(GetPinnedActivityFeedEventsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchSauronApiLambdaJSONClient) DeleteAllUserData(ctx context.Context, in *DeleteAllUserDataRequest) (*DeleteAllUserDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.sauron.twitchsauronapilambda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSauronApiLambda")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAllUserData")
	out := new(DeleteAllUserDataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchSauronApiLambdaJSONClient) PublishActivityFeedEvent(ctx context.Context, in *PublishActivityFeedEventRequest) (*PublishActivityFeedEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.sauron.twitchsauronapilambda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSauronApiLambda")
	ctx = ctxsetters.WithMethodName(ctx, "PublishActivityFeedEvent")
	out := new(PublishActivityFeedEventResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchSauronApiLambdaJSONClient) GetFilterCategories(ctx context.Context, in *GetFilterCategoriesRequest) (*GetFilterCategoriesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.sauron.twitchsauronapilambda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSauronApiLambda")
	ctx = ctxsetters.WithMethodName(ctx, "GetFilterCategories")
	out := new(GetFilterCategoriesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchSauronApiLambdaJSONClient) UpdateActivityFeedEventPinnedState(ctx context.Context, in *UpdateActivityFeedEventPinnedStateRequest) (*UpdateActivityFeedEventPinnedStateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.sauron.twitchsauronapilambda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSauronApiLambda")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateActivityFeedEventPinnedState")
	out := new(UpdateActivityFeedEventPinnedStateResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchSauronApiLambdaJSONClient) SimulateActivityFeedEvent(ctx context.Context, in *SimulateActivityFeedEventRequest) (*SimulateActivityFeedEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.sauron.twitchsauronapilambda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSauronApiLambda")
	ctx = ctxsetters.WithMethodName(ctx, "SimulateActivityFeedEvent")
	out := new(SimulateActivityFeedEventResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ====================================
// TwitchSauronApiLambda Server Handler
// ====================================

type twitchSauronApiLambdaServer struct {
	TwitchSauronApiLambda
	hooks *twirp.ServerHooks
}

func NewTwitchSauronApiLambdaServer(svc TwitchSauronApiLambda, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchSauronApiLambdaServer{
		TwitchSauronApiLambda: svc,
		hooks:                 hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchSauronApiLambdaServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchSauronApiLambdaPathPrefix is used for all URL paths on a twirp TwitchSauronApiLambda server.
// Requests are always: POST TwitchSauronApiLambdaPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchSauronApiLambdaPathPrefix = "/twirp/twitch.fulton.sauron.twitchsauronapilambda.TwitchSauronApiLambda/"

func (s *twitchSauronApiLambdaServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.sauron.twitchsauronapilambda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchSauronApiLambda")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.sauron.twitchsauronapilambda.TwitchSauronApiLambda/GetActivityFeedEvents":
		s.serveGetActivityFeedEvents(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.sauron.twitchsauronapilambda.TwitchSauronApiLambda/GetPinnedActivityFeedEvents":
		s.serveGetPinnedActivityFeedEvents(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.sauron.twitchsauronapilambda.TwitchSauronApiLambda/DeleteAllUserData":
		s.serveDeleteAllUserData(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.sauron.twitchsauronapilambda.TwitchSauronApiLambda/PublishActivityFeedEvent":
		s.servePublishActivityFeedEvent(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.sauron.twitchsauronapilambda.TwitchSauronApiLambda/GetFilterCategories":
		s.serveGetFilterCategories(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.sauron.twitchsauronapilambda.TwitchSauronApiLambda/UpdateActivityFeedEventPinnedState":
		s.serveUpdateActivityFeedEventPinnedState(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.sauron.twitchsauronapilambda.TwitchSauronApiLambda/SimulateActivityFeedEvent":
		s.serveSimulateActivityFeedEvent(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchSauronApiLambdaServer) serveGetActivityFeedEvents(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetActivityFeedEventsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetActivityFeedEventsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchSauronApiLambdaServer) serveGetActivityFeedEventsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetActivityFeedEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetActivityFeedEventsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetActivityFeedEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchSauronApiLambda.GetActivityFeedEvents(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetActivityFeedEventsResponse and nil error while calling GetActivityFeedEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchSauronApiLambdaServer) serveGetActivityFeedEventsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetActivityFeedEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetActivityFeedEventsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetActivityFeedEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchSauronApiLambda.GetActivityFeedEvents(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetActivityFeedEventsResponse and nil error while calling GetActivityFeedEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchSauronApiLambdaServer) serveGetPinnedActivityFeedEvents(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPinnedActivityFeedEventsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPinnedActivityFeedEventsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchSauronApiLambdaServer) serveGetPinnedActivityFeedEventsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPinnedActivityFeedEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetPinnedActivityFeedEventsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetPinnedActivityFeedEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchSauronApiLambda.GetPinnedActivityFeedEvents(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPinnedActivityFeedEventsResponse and nil error while calling GetPinnedActivityFeedEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchSauronApiLambdaServer) serveGetPinnedActivityFeedEventsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPinnedActivityFeedEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetPinnedActivityFeedEventsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetPinnedActivityFeedEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchSauronApiLambda.GetPinnedActivityFeedEvents(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPinnedActivityFeedEventsResponse and nil error while calling GetPinnedActivityFeedEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchSauronApiLambdaServer) serveDeleteAllUserData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteAllUserDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteAllUserDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchSauronApiLambdaServer) serveDeleteAllUserDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAllUserData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteAllUserDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteAllUserDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchSauronApiLambda.DeleteAllUserData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteAllUserDataResponse and nil error while calling DeleteAllUserData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchSauronApiLambdaServer) serveDeleteAllUserDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAllUserData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteAllUserDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteAllUserDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchSauronApiLambda.DeleteAllUserData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteAllUserDataResponse and nil error while calling DeleteAllUserData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchSauronApiLambdaServer) servePublishActivityFeedEvent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePublishActivityFeedEventJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePublishActivityFeedEventProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchSauronApiLambdaServer) servePublishActivityFeedEventJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PublishActivityFeedEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(PublishActivityFeedEventRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PublishActivityFeedEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchSauronApiLambda.PublishActivityFeedEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PublishActivityFeedEventResponse and nil error while calling PublishActivityFeedEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchSauronApiLambdaServer) servePublishActivityFeedEventProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PublishActivityFeedEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(PublishActivityFeedEventRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PublishActivityFeedEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchSauronApiLambda.PublishActivityFeedEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PublishActivityFeedEventResponse and nil error while calling PublishActivityFeedEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchSauronApiLambdaServer) serveGetFilterCategories(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetFilterCategoriesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFilterCategoriesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchSauronApiLambdaServer) serveGetFilterCategoriesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFilterCategories")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetFilterCategoriesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetFilterCategoriesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchSauronApiLambda.GetFilterCategories(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFilterCategoriesResponse and nil error while calling GetFilterCategories. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchSauronApiLambdaServer) serveGetFilterCategoriesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFilterCategories")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetFilterCategoriesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetFilterCategoriesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchSauronApiLambda.GetFilterCategories(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFilterCategoriesResponse and nil error while calling GetFilterCategories. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchSauronApiLambdaServer) serveUpdateActivityFeedEventPinnedState(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateActivityFeedEventPinnedStateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateActivityFeedEventPinnedStateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchSauronApiLambdaServer) serveUpdateActivityFeedEventPinnedStateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateActivityFeedEventPinnedState")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateActivityFeedEventPinnedStateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateActivityFeedEventPinnedStateResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchSauronApiLambda.UpdateActivityFeedEventPinnedState(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateActivityFeedEventPinnedStateResponse and nil error while calling UpdateActivityFeedEventPinnedState. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchSauronApiLambdaServer) serveUpdateActivityFeedEventPinnedStateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateActivityFeedEventPinnedState")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateActivityFeedEventPinnedStateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateActivityFeedEventPinnedStateResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchSauronApiLambda.UpdateActivityFeedEventPinnedState(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateActivityFeedEventPinnedStateResponse and nil error while calling UpdateActivityFeedEventPinnedState. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchSauronApiLambdaServer) serveSimulateActivityFeedEvent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSimulateActivityFeedEventJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSimulateActivityFeedEventProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchSauronApiLambdaServer) serveSimulateActivityFeedEventJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SimulateActivityFeedEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SimulateActivityFeedEventRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SimulateActivityFeedEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchSauronApiLambda.SimulateActivityFeedEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SimulateActivityFeedEventResponse and nil error while calling SimulateActivityFeedEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchSauronApiLambdaServer) serveSimulateActivityFeedEventProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SimulateActivityFeedEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SimulateActivityFeedEventRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SimulateActivityFeedEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchSauronApiLambda.SimulateActivityFeedEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SimulateActivityFeedEventResponse and nil error while calling SimulateActivityFeedEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchSauronApiLambdaServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor1, 0
}

func (s *twitchSauronApiLambdaServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchSauronApiLambdaServer) PathPrefix() string {
	return TwitchSauronApiLambdaPathPrefix
}

var twirpFileDescriptor1 = []byte{
	// 391 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x94, 0xb1, 0x4e, 0xc3, 0x30,
	0x14, 0x45, 0x95, 0x85, 0xc1, 0x1b, 0x46, 0x95, 0xa0, 0x6c, 0x8c, 0x0c, 0x2e, 0x82, 0x0d, 0x09,
	0xa4, 0x42, 0x9b, 0x80, 0x28, 0x50, 0xd1, 0x96, 0x81, 0x05, 0xb9, 0xcd, 0x83, 0x1a, 0xb9, 0x4e,
	0xb0, 0x5f, 0x5a, 0xc1, 0xb7, 0x30, 0x30, 0x31, 0xb1, 0x22, 0x31, 0xf1, 0x13, 0xfc, 0x10, 0x22,
	0x89, 0x07, 0xda, 0x54, 0x60, 0x9a, 0x25, 0x52, 0x22, 0xdf, 0xf3, 0xce, 0x8d, 0x2d, 0x93, 0xdd,
	0x41, 0x14, 0x02, 0xbb, 0x4b, 0x0c, 0x0a, 0xc5, 0x70, 0x5c, 0xe3, 0xa3, 0x47, 0x55, 0xeb, 0x4e,
	0x04, 0x0e, 0x86, 0x1d, 0x9e, 0xe8, 0x48, 0xd5, 0x63, 0xd1, 0xe2, 0xa3, 0x7e, 0xc8, 0xbb, 0x13,
	0xa1, 0xe3, 0x1a, 0x7e, 0x3f, 0x59, 0xac, 0x23, 0x8c, 0xe8, 0x26, 0xa6, 0xeb, 0xd8, 0x4d, 0x22,
	0x31, 0x52, 0xcc, 0xa4, 0xeb, 0x59, 0xf6, 0x31, 0x7b, 0xe1, 0xb1, 0x90, 0x69, 0xb8, 0xba, 0xe7,
	0x38, 0x47, 0xc3, 0x7d, 0x02, 0x06, 0x4d, 0x36, 0xaa, 0xba, 0xef, 0x1c, 0x37, 0x71, 0xa4, 0x0c,
	0xd8, 0xbc, 0xef, 0x98, 0x17, 0x0a, 0x41, 0x2b, 0x2e, 0xaf, 0xa7, 0x3c, 0x82, 0xff, 0x73, 0x7e,
	0x08, 0x6d, 0x3f, 0x11, 0x52, 0x29, 0xcc, 0xd1, 0x57, 0x8f, 0x54, 0x02, 0xc0, 0xfa, 0x00, 0xc5,
	0x58, 0xe0, 0x83, 0x0f, 0x10, 0x36, 0xc7, 0xa0, 0xd0, 0xd0, 0x23, 0xf6, 0xf7, 0x1f, 0xce, 0x0a,
	0x11, 0x17, 0x59, 0x9b, 0xea, 0x71, 0x09, 0xa4, 0xac, 0x0f, 0xfd, 0xf0, 0xc8, 0x7a, 0x00, 0xd8,
	0x16, 0x4a, 0x41, 0x58, 0x20, 0x7d, 0xe6, 0x38, 0x6a, 0x1e, 0xc8, 0xaa, 0x9f, 0x97, 0xc6, 0xcb,
	0x0b, 0x3c, 0x7b, 0x64, 0xb9, 0x01, 0x12, 0x10, 0xea, 0x52, 0xf6, 0x0c, 0xe8, 0x06, 0x47, 0x4e,
	0x1b, 0x2e, 0x63, 0x66, 0xe2, 0x56, 0xb6, 0xb9, 0x20, 0x25, 0x57, 0x7c, 0xf3, 0xc8, 0x6a, 0x3b,
	0xe9, 0x4b, 0x61, 0x86, 0x33, 0x45, 0xe8, 0x89, 0xcb, 0x8c, 0x79, 0x14, 0x2b, 0xdc, 0x2a, 0x07,
	0x96, 0x7b, 0xbf, 0x78, 0x64, 0x25, 0x00, 0xf4, 0x85, 0x44, 0xd0, 0x87, 0x1c, 0xe1, 0x36, 0xd2,
	0x02, 0x0c, 0xf5, 0x1d, 0xf7, 0x70, 0x1a, 0x60, 0x6d, 0x83, 0x85, 0x39, 0xb9, 0xe8, 0xa7, 0x47,
	0x36, 0x7a, 0x71, 0xc8, 0x11, 0x66, 0xca, 0x64, 0xe7, 0xa7, 0x83, 0x1c, 0x81, 0xf6, 0x5c, 0xe6,
	0xfd, 0xce, 0xb3, 0x35, 0x2e, 0xcb, 0xc6, 0xe6, 0xad, 0xde, 0x3d, 0xb2, 0xd6, 0x11, 0xa3, 0x44,
	0x16, 0x05, 0xa8, 0xd3, 0x56, 0xcf, 0xc5, 0xd8, 0x0e, 0xa7, 0x25, 0xd1, 0x32, 0xf5, 0x83, 0xad,
	0x2b, 0xe6, 0x76, 0xd3, 0xf6, 0x97, 0xd2, 0x7b, 0x75, 0xe7, 0x2b, 0x00, 0x00, 0xff, 0xff, 0xfd,
	0x99, 0x1b, 0xc4, 0xd1, 0x06, 0x00, 0x00,
}
