// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchTahoeAPILambdaTwirp/twirp.proto

/*
Package TwitchTahoeAPILambdaTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchTahoeAPILambdaTwirp/twirp.proto
*/
package TwitchTahoeAPILambdaTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

import google_protobuf "github.com/golang/protobuf/ptypes/empty"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ===============================
// TwitchTahoeAPIService Interface
// ===============================

type TwitchTahoeAPIService interface {
	// Registers a producing application with Tahoe API
	RegisterProducer(context.Context, *RegisterProducerRequest) (*Producer, error)

	// Returns the current status of a producer.
	GetProducerStatus(context.Context, *GetProducerStatusRequest) (*GetProducerStatusResponse, error)

	// Query which Producers exist
	QueryProducers(context.Context, *QueryProducersRequest) (*QueryProducersResponse, error)

	// Update the values of a producer
	UpdateProducer(context.Context, *UpdateProducerRequest) (*Producer, error)

	// Create another API key for the producer
	CreateProducerAPIKey(context.Context, *CreateAPIKeyRequest) (*Producer, error)

	// Revoke another API key for the producer
	RevokeProducerAPIKey(context.Context, *RevokeAPIKeyRequest) (*google_protobuf.Empty, error)

	// Query which DAGs are available
	QueryDags(context.Context, *QueryDagsRequest) (*QueryDagsResponse, error)

	// Trigger a DAGRun for your ETL
	RunDag(context.Context, *RunDagRequest) (*Job, error)

	// Query recent Jobs
	QueryJobs(context.Context, *QueryJobsRequest) (*QueryJobsResponse, error)

	// Update the status of an ongoing job. Callers can update either the clean or dirty status.
	// The overall status will be updated accordingly.
	UpdateJobStatus(context.Context, *UpdateJobStatusRequest) (*UpdateJobStatusResponse, error)

	// Cancel a Job
	CancelJob(context.Context, *CancelJobRequest) (*google_protobuf.Empty, error)

	// Remove a specified partition
	RemovePartition(context.Context, *RemovePartitionRequest) (*google_protobuf.Empty, error)

	// Tap CRUD operations.
	CreateTap(context.Context, *CreateTapRequest) (*CreateTapResponse, error)

	GetTapStatus(context.Context, *GetTapStatusRequest) (*GetTapStatusResponse, error)

	GetTap(context.Context, *GetTapRequest) (*GetTapResponse, error)

	ListTaps(context.Context, *ListTapsRequest) (*ListTapsResponse, error)

	UpdateTap(context.Context, *UpdateTapRequest) (*UpdateTapResponse, error)

	DeleteTap(context.Context, *DeleteTapRequest) (*DeleteTapResponse, error)

	PurgeTap(context.Context, *PurgeTapRequest) (*PurgeTapResponse, error)

	// Tap CDK APIs
	RegisterTap(context.Context, *RegisterTapRequest) (*RegisterTapResponse, error)

	DeregisterTap(context.Context, *DeregisterTapRequest) (*DeregisterTapResponse, error)

	// Tap user CRUD operations.
	CreateTapUser(context.Context, *CreateTapUserRequest) (*CreateTapUserResponse, error)

	ListTapUsers(context.Context, *ListTapUsersRequest) (*ListTapUsersResponse, error)

	DeleteTapUser(context.Context, *DeleteTapUserRequest) (*DeleteTapUserResponse, error)

	UpdateTapUser(context.Context, *UpdateTapUserRequest) (*UpdateTapUserResponse, error)

	ResetTapUserPassword(context.Context, *ResetTapUserPasswordRequest) (*ResetTapUserPasswordResponse, error)

	// Subscribe a tap to to or unsubscribe a tap from a relation
	Subscribe(context.Context, *SubscribeRequest) (*SubscribeResponse, error)

	Unsubscribe(context.Context, *UnsubscribeRequest) (*UnsubscribeResponse, error)

	ListSubscriptions(context.Context, *ListSubscriptionsRequest) (*ListSubscriptionsResponse, error)

	// Create or Update a view.
	PutView(context.Context, *PutViewRequest) (*google_protobuf.Empty, error)

	// Delete a view.
	DropView(context.Context, *DropViewRequest) (*google_protobuf.Empty, error)

	// Create or update a table.
	PutTable(context.Context, *PutTableRequest) (*google_protobuf.Empty, error)

	// Add data to a table or a partition within a table.
	PutData(context.Context, *PutDataRequest) (*PutDataResponse, error)

	// Update the maximum data date of a table, indicating to consumers
	// that the data is complete up through a certain time even if there
	// is no new data to add.
	TouchTable(context.Context, *TouchTableRequest) (*google_protobuf.Empty, error)

	// Query for relations
	QueryRelation(context.Context, *QueryRelationRequest) (*QueryRelationResponse, error)

	ListViews(context.Context, *ListViewsRequest) (*ListViewsResponse, error)

	// Perform Table/View operations
	PerformTahoeOperationSequence(context.Context, *TahoeOperationSequence) (*google_protobuf.Empty, error)

	// Perform Table/View operations for a Tap
	PerformTapTahoeOperationSequence(context.Context, *TapTahoeOperationSequence) (*google_protobuf.Empty, error)

	// Updates sensitivity of table columns.
	UpdateTableColumnSensitivities(context.Context, *UpdateTableColumnSensitivitiesRequest) (*google_protobuf.Empty, error)

	// Deregisters a producing application with Tahoe API
	DeregisterProducer(context.Context, *DeregisterRequest) (*google_protobuf.Empty, error)

	// Deregister a DAG.
	DeregisterDag(context.Context, *DeregisterRequest) (*google_protobuf.Empty, error)

	// Register a DAG.
	RegisterDag(context.Context, *Dag) (*google_protobuf.Empty, error)

	// Query/Exec a Tap.
	QueryTap(context.Context, *QueryTapRequest) (*QueryTapResponse, error)

	ExecTap(context.Context, *ExecTapRequest) (*ExecTapResponse, error)

	// List all applications
	ListApplications(context.Context, *ListApplicationsRequest) (*ListApplicationsResponse, error)

	// Perform CRUD operations for VPC Endpoints
	CreateVpcEndpoint(context.Context, *VpcEndpointRequest) (*VpcEndpointResponse, error)

	UpdateVpcEndpoint(context.Context, *VpcEndpointRequest) (*VpcEndpointResponse, error)

	DeleteVpcEndpoint(context.Context, *VpcEndpointRequest) (*google_protobuf.Empty, error)

	// This is a temporary API for enabling running a job to migrate dirty data to clean.  It is only available on the Admin lambda.
	MigrateDirty(context.Context, *MigrateDirtyRequest) (*Job, error)

	// Update metadata for a partition
	UpdatePartition(context.Context, *UpdatePartitionRequest) (*google_protobuf.Empty, error)

	// Report the number of records written for a job to the associated table
	ReportRecordsWritten(context.Context, *ReportRecordsWrittenRequest) (*google_protobuf.Empty, error)

	// Increment the num_rows attribute of a table
	IncrementTableNumRows(context.Context, *IncrementTableNumRowsRequest) (*google_protobuf.Empty, error)

	// Check the subscription status for a tap
	CheckSubscriptionStatus(context.Context, *CheckSubscriptionStatusRequest) (*CheckSubscriptionStatusResponse, error)

	// Copy the subscriptions of one tap to another tap.
	// If there are subscriptions of the 'from' tap that are not compatible with
	// the 'to' tap, those subscriptions are skipped.
	CopySubscriptions(context.Context, *CopySubscriptionsRequest) (*CopySubscriptionsResponse, error)

	// Get details of a view. View definition will be transpiled to a SQL dialect that is compatible with the tap_type.
	GetView(context.Context, *GetViewRequest) (*GetViewResponse, error)
}

// =====================================
// TwitchTahoeAPIService Protobuf Client
// =====================================

type twitchTahoeAPIServiceProtobufClient struct {
	client HTTPClient
	urls   [55]string
	opts   twirp.ClientOptions
}

// NewTwitchTahoeAPIServiceProtobufClient creates a Protobuf client that implements the TwitchTahoeAPIService interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchTahoeAPIServiceProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchTahoeAPIService {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchTahoeAPIServicePathPrefix
	urls := [55]string{
		prefix + "RegisterProducer",
		prefix + "GetProducerStatus",
		prefix + "QueryProducers",
		prefix + "UpdateProducer",
		prefix + "CreateProducerAPIKey",
		prefix + "RevokeProducerAPIKey",
		prefix + "QueryDags",
		prefix + "RunDag",
		prefix + "QueryJobs",
		prefix + "UpdateJobStatus",
		prefix + "CancelJob",
		prefix + "RemovePartition",
		prefix + "CreateTap",
		prefix + "GetTapStatus",
		prefix + "GetTap",
		prefix + "ListTaps",
		prefix + "UpdateTap",
		prefix + "DeleteTap",
		prefix + "PurgeTap",
		prefix + "RegisterTap",
		prefix + "DeregisterTap",
		prefix + "CreateTapUser",
		prefix + "ListTapUsers",
		prefix + "DeleteTapUser",
		prefix + "UpdateTapUser",
		prefix + "ResetTapUserPassword",
		prefix + "Subscribe",
		prefix + "Unsubscribe",
		prefix + "ListSubscriptions",
		prefix + "PutView",
		prefix + "DropView",
		prefix + "PutTable",
		prefix + "PutData",
		prefix + "TouchTable",
		prefix + "QueryRelation",
		prefix + "ListViews",
		prefix + "PerformTahoeOperationSequence",
		prefix + "PerformTapTahoeOperationSequence",
		prefix + "UpdateTableColumnSensitivities",
		prefix + "DeregisterProducer",
		prefix + "DeregisterDag",
		prefix + "RegisterDag",
		prefix + "QueryTap",
		prefix + "ExecTap",
		prefix + "ListApplications",
		prefix + "CreateVpcEndpoint",
		prefix + "UpdateVpcEndpoint",
		prefix + "DeleteVpcEndpoint",
		prefix + "MigrateDirty",
		prefix + "UpdatePartition",
		prefix + "ReportRecordsWritten",
		prefix + "IncrementTableNumRows",
		prefix + "CheckSubscriptionStatus",
		prefix + "CopySubscriptions",
		prefix + "GetView",
	}

	return &twitchTahoeAPIServiceProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchTahoeAPIServiceProtobufClient) RegisterProducer(ctx context.Context, in *RegisterProducerRequest) (*Producer, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "RegisterProducer")
	out := new(Producer)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) GetProducerStatus(ctx context.Context, in *GetProducerStatusRequest) (*GetProducerStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "GetProducerStatus")
	out := new(GetProducerStatusResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) QueryProducers(ctx context.Context, in *QueryProducersRequest) (*QueryProducersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "QueryProducers")
	out := new(QueryProducersResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) UpdateProducer(ctx context.Context, in *UpdateProducerRequest) (*Producer, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateProducer")
	out := new(Producer)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) CreateProducerAPIKey(ctx context.Context, in *CreateAPIKeyRequest) (*Producer, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "CreateProducerAPIKey")
	out := new(Producer)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) RevokeProducerAPIKey(ctx context.Context, in *RevokeAPIKeyRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "RevokeProducerAPIKey")
	out := new(google_protobuf.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) QueryDags(ctx context.Context, in *QueryDagsRequest) (*QueryDagsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "QueryDags")
	out := new(QueryDagsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) RunDag(ctx context.Context, in *RunDagRequest) (*Job, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "RunDag")
	out := new(Job)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) QueryJobs(ctx context.Context, in *QueryJobsRequest) (*QueryJobsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "QueryJobs")
	out := new(QueryJobsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) UpdateJobStatus(ctx context.Context, in *UpdateJobStatusRequest) (*UpdateJobStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateJobStatus")
	out := new(UpdateJobStatusResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) CancelJob(ctx context.Context, in *CancelJobRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "CancelJob")
	out := new(google_protobuf.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) RemovePartition(ctx context.Context, in *RemovePartitionRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "RemovePartition")
	out := new(google_protobuf.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) CreateTap(ctx context.Context, in *CreateTapRequest) (*CreateTapResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "CreateTap")
	out := new(CreateTapResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) GetTapStatus(ctx context.Context, in *GetTapStatusRequest) (*GetTapStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "GetTapStatus")
	out := new(GetTapStatusResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) GetTap(ctx context.Context, in *GetTapRequest) (*GetTapResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "GetTap")
	out := new(GetTapResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) ListTaps(ctx context.Context, in *ListTapsRequest) (*ListTapsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "ListTaps")
	out := new(ListTapsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) UpdateTap(ctx context.Context, in *UpdateTapRequest) (*UpdateTapResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateTap")
	out := new(UpdateTapResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) DeleteTap(ctx context.Context, in *DeleteTapRequest) (*DeleteTapResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteTap")
	out := new(DeleteTapResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) PurgeTap(ctx context.Context, in *PurgeTapRequest) (*PurgeTapResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "PurgeTap")
	out := new(PurgeTapResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[18], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) RegisterTap(ctx context.Context, in *RegisterTapRequest) (*RegisterTapResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "RegisterTap")
	out := new(RegisterTapResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[19], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) DeregisterTap(ctx context.Context, in *DeregisterTapRequest) (*DeregisterTapResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "DeregisterTap")
	out := new(DeregisterTapResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[20], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) CreateTapUser(ctx context.Context, in *CreateTapUserRequest) (*CreateTapUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "CreateTapUser")
	out := new(CreateTapUserResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[21], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) ListTapUsers(ctx context.Context, in *ListTapUsersRequest) (*ListTapUsersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "ListTapUsers")
	out := new(ListTapUsersResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[22], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) DeleteTapUser(ctx context.Context, in *DeleteTapUserRequest) (*DeleteTapUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteTapUser")
	out := new(DeleteTapUserResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[23], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) UpdateTapUser(ctx context.Context, in *UpdateTapUserRequest) (*UpdateTapUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateTapUser")
	out := new(UpdateTapUserResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[24], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) ResetTapUserPassword(ctx context.Context, in *ResetTapUserPasswordRequest) (*ResetTapUserPasswordResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "ResetTapUserPassword")
	out := new(ResetTapUserPasswordResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[25], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) Subscribe(ctx context.Context, in *SubscribeRequest) (*SubscribeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "Subscribe")
	out := new(SubscribeResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[26], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) Unsubscribe(ctx context.Context, in *UnsubscribeRequest) (*UnsubscribeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "Unsubscribe")
	out := new(UnsubscribeResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[27], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest) (*ListSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "ListSubscriptions")
	out := new(ListSubscriptionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[28], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) PutView(ctx context.Context, in *PutViewRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "PutView")
	out := new(google_protobuf.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[29], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) DropView(ctx context.Context, in *DropViewRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "DropView")
	out := new(google_protobuf.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[30], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) PutTable(ctx context.Context, in *PutTableRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "PutTable")
	out := new(google_protobuf.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[31], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) PutData(ctx context.Context, in *PutDataRequest) (*PutDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "PutData")
	out := new(PutDataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[32], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) TouchTable(ctx context.Context, in *TouchTableRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "TouchTable")
	out := new(google_protobuf.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[33], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) QueryRelation(ctx context.Context, in *QueryRelationRequest) (*QueryRelationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "QueryRelation")
	out := new(QueryRelationResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[34], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) ListViews(ctx context.Context, in *ListViewsRequest) (*ListViewsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "ListViews")
	out := new(ListViewsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[35], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) PerformTahoeOperationSequence(ctx context.Context, in *TahoeOperationSequence) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "PerformTahoeOperationSequence")
	out := new(google_protobuf.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[36], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) PerformTapTahoeOperationSequence(ctx context.Context, in *TapTahoeOperationSequence) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "PerformTapTahoeOperationSequence")
	out := new(google_protobuf.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[37], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) UpdateTableColumnSensitivities(ctx context.Context, in *UpdateTableColumnSensitivitiesRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateTableColumnSensitivities")
	out := new(google_protobuf.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[38], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) DeregisterProducer(ctx context.Context, in *DeregisterRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "DeregisterProducer")
	out := new(google_protobuf.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[39], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) DeregisterDag(ctx context.Context, in *DeregisterRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "DeregisterDag")
	out := new(google_protobuf.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[40], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) RegisterDag(ctx context.Context, in *Dag) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "RegisterDag")
	out := new(google_protobuf.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[41], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) QueryTap(ctx context.Context, in *QueryTapRequest) (*QueryTapResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "QueryTap")
	out := new(QueryTapResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[42], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) ExecTap(ctx context.Context, in *ExecTapRequest) (*ExecTapResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "ExecTap")
	out := new(ExecTapResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[43], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) ListApplications(ctx context.Context, in *ListApplicationsRequest) (*ListApplicationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "ListApplications")
	out := new(ListApplicationsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[44], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) CreateVpcEndpoint(ctx context.Context, in *VpcEndpointRequest) (*VpcEndpointResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "CreateVpcEndpoint")
	out := new(VpcEndpointResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[45], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) UpdateVpcEndpoint(ctx context.Context, in *VpcEndpointRequest) (*VpcEndpointResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateVpcEndpoint")
	out := new(VpcEndpointResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[46], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) DeleteVpcEndpoint(ctx context.Context, in *VpcEndpointRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteVpcEndpoint")
	out := new(google_protobuf.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[47], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) MigrateDirty(ctx context.Context, in *MigrateDirtyRequest) (*Job, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "MigrateDirty")
	out := new(Job)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[48], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) UpdatePartition(ctx context.Context, in *UpdatePartitionRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdatePartition")
	out := new(google_protobuf.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[49], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) ReportRecordsWritten(ctx context.Context, in *ReportRecordsWrittenRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "ReportRecordsWritten")
	out := new(google_protobuf.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[50], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) IncrementTableNumRows(ctx context.Context, in *IncrementTableNumRowsRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "IncrementTableNumRows")
	out := new(google_protobuf.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[51], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) CheckSubscriptionStatus(ctx context.Context, in *CheckSubscriptionStatusRequest) (*CheckSubscriptionStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "CheckSubscriptionStatus")
	out := new(CheckSubscriptionStatusResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[52], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) CopySubscriptions(ctx context.Context, in *CopySubscriptionsRequest) (*CopySubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "CopySubscriptions")
	out := new(CopySubscriptionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[53], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceProtobufClient) GetView(ctx context.Context, in *GetViewRequest) (*GetViewResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "GetView")
	out := new(GetViewResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[54], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =================================
// TwitchTahoeAPIService JSON Client
// =================================

type twitchTahoeAPIServiceJSONClient struct {
	client HTTPClient
	urls   [55]string
	opts   twirp.ClientOptions
}

// NewTwitchTahoeAPIServiceJSONClient creates a JSON client that implements the TwitchTahoeAPIService interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchTahoeAPIServiceJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchTahoeAPIService {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchTahoeAPIServicePathPrefix
	urls := [55]string{
		prefix + "RegisterProducer",
		prefix + "GetProducerStatus",
		prefix + "QueryProducers",
		prefix + "UpdateProducer",
		prefix + "CreateProducerAPIKey",
		prefix + "RevokeProducerAPIKey",
		prefix + "QueryDags",
		prefix + "RunDag",
		prefix + "QueryJobs",
		prefix + "UpdateJobStatus",
		prefix + "CancelJob",
		prefix + "RemovePartition",
		prefix + "CreateTap",
		prefix + "GetTapStatus",
		prefix + "GetTap",
		prefix + "ListTaps",
		prefix + "UpdateTap",
		prefix + "DeleteTap",
		prefix + "PurgeTap",
		prefix + "RegisterTap",
		prefix + "DeregisterTap",
		prefix + "CreateTapUser",
		prefix + "ListTapUsers",
		prefix + "DeleteTapUser",
		prefix + "UpdateTapUser",
		prefix + "ResetTapUserPassword",
		prefix + "Subscribe",
		prefix + "Unsubscribe",
		prefix + "ListSubscriptions",
		prefix + "PutView",
		prefix + "DropView",
		prefix + "PutTable",
		prefix + "PutData",
		prefix + "TouchTable",
		prefix + "QueryRelation",
		prefix + "ListViews",
		prefix + "PerformTahoeOperationSequence",
		prefix + "PerformTapTahoeOperationSequence",
		prefix + "UpdateTableColumnSensitivities",
		prefix + "DeregisterProducer",
		prefix + "DeregisterDag",
		prefix + "RegisterDag",
		prefix + "QueryTap",
		prefix + "ExecTap",
		prefix + "ListApplications",
		prefix + "CreateVpcEndpoint",
		prefix + "UpdateVpcEndpoint",
		prefix + "DeleteVpcEndpoint",
		prefix + "MigrateDirty",
		prefix + "UpdatePartition",
		prefix + "ReportRecordsWritten",
		prefix + "IncrementTableNumRows",
		prefix + "CheckSubscriptionStatus",
		prefix + "CopySubscriptions",
		prefix + "GetView",
	}

	return &twitchTahoeAPIServiceJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchTahoeAPIServiceJSONClient) RegisterProducer(ctx context.Context, in *RegisterProducerRequest) (*Producer, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "RegisterProducer")
	out := new(Producer)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) GetProducerStatus(ctx context.Context, in *GetProducerStatusRequest) (*GetProducerStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "GetProducerStatus")
	out := new(GetProducerStatusResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) QueryProducers(ctx context.Context, in *QueryProducersRequest) (*QueryProducersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "QueryProducers")
	out := new(QueryProducersResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) UpdateProducer(ctx context.Context, in *UpdateProducerRequest) (*Producer, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateProducer")
	out := new(Producer)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) CreateProducerAPIKey(ctx context.Context, in *CreateAPIKeyRequest) (*Producer, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "CreateProducerAPIKey")
	out := new(Producer)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) RevokeProducerAPIKey(ctx context.Context, in *RevokeAPIKeyRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "RevokeProducerAPIKey")
	out := new(google_protobuf.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) QueryDags(ctx context.Context, in *QueryDagsRequest) (*QueryDagsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "QueryDags")
	out := new(QueryDagsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) RunDag(ctx context.Context, in *RunDagRequest) (*Job, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "RunDag")
	out := new(Job)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) QueryJobs(ctx context.Context, in *QueryJobsRequest) (*QueryJobsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "QueryJobs")
	out := new(QueryJobsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) UpdateJobStatus(ctx context.Context, in *UpdateJobStatusRequest) (*UpdateJobStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateJobStatus")
	out := new(UpdateJobStatusResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) CancelJob(ctx context.Context, in *CancelJobRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "CancelJob")
	out := new(google_protobuf.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) RemovePartition(ctx context.Context, in *RemovePartitionRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "RemovePartition")
	out := new(google_protobuf.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) CreateTap(ctx context.Context, in *CreateTapRequest) (*CreateTapResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "CreateTap")
	out := new(CreateTapResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) GetTapStatus(ctx context.Context, in *GetTapStatusRequest) (*GetTapStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "GetTapStatus")
	out := new(GetTapStatusResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) GetTap(ctx context.Context, in *GetTapRequest) (*GetTapResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "GetTap")
	out := new(GetTapResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) ListTaps(ctx context.Context, in *ListTapsRequest) (*ListTapsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "ListTaps")
	out := new(ListTapsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) UpdateTap(ctx context.Context, in *UpdateTapRequest) (*UpdateTapResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateTap")
	out := new(UpdateTapResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) DeleteTap(ctx context.Context, in *DeleteTapRequest) (*DeleteTapResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteTap")
	out := new(DeleteTapResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) PurgeTap(ctx context.Context, in *PurgeTapRequest) (*PurgeTapResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "PurgeTap")
	out := new(PurgeTapResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[18], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) RegisterTap(ctx context.Context, in *RegisterTapRequest) (*RegisterTapResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "RegisterTap")
	out := new(RegisterTapResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[19], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) DeregisterTap(ctx context.Context, in *DeregisterTapRequest) (*DeregisterTapResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "DeregisterTap")
	out := new(DeregisterTapResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[20], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) CreateTapUser(ctx context.Context, in *CreateTapUserRequest) (*CreateTapUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "CreateTapUser")
	out := new(CreateTapUserResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[21], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) ListTapUsers(ctx context.Context, in *ListTapUsersRequest) (*ListTapUsersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "ListTapUsers")
	out := new(ListTapUsersResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[22], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) DeleteTapUser(ctx context.Context, in *DeleteTapUserRequest) (*DeleteTapUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteTapUser")
	out := new(DeleteTapUserResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[23], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) UpdateTapUser(ctx context.Context, in *UpdateTapUserRequest) (*UpdateTapUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateTapUser")
	out := new(UpdateTapUserResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[24], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) ResetTapUserPassword(ctx context.Context, in *ResetTapUserPasswordRequest) (*ResetTapUserPasswordResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "ResetTapUserPassword")
	out := new(ResetTapUserPasswordResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[25], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) Subscribe(ctx context.Context, in *SubscribeRequest) (*SubscribeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "Subscribe")
	out := new(SubscribeResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[26], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) Unsubscribe(ctx context.Context, in *UnsubscribeRequest) (*UnsubscribeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "Unsubscribe")
	out := new(UnsubscribeResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[27], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest) (*ListSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "ListSubscriptions")
	out := new(ListSubscriptionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[28], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) PutView(ctx context.Context, in *PutViewRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "PutView")
	out := new(google_protobuf.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[29], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) DropView(ctx context.Context, in *DropViewRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "DropView")
	out := new(google_protobuf.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[30], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) PutTable(ctx context.Context, in *PutTableRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "PutTable")
	out := new(google_protobuf.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[31], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) PutData(ctx context.Context, in *PutDataRequest) (*PutDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "PutData")
	out := new(PutDataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[32], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) TouchTable(ctx context.Context, in *TouchTableRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "TouchTable")
	out := new(google_protobuf.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[33], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) QueryRelation(ctx context.Context, in *QueryRelationRequest) (*QueryRelationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "QueryRelation")
	out := new(QueryRelationResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[34], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) ListViews(ctx context.Context, in *ListViewsRequest) (*ListViewsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "ListViews")
	out := new(ListViewsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[35], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) PerformTahoeOperationSequence(ctx context.Context, in *TahoeOperationSequence) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "PerformTahoeOperationSequence")
	out := new(google_protobuf.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[36], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) PerformTapTahoeOperationSequence(ctx context.Context, in *TapTahoeOperationSequence) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "PerformTapTahoeOperationSequence")
	out := new(google_protobuf.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[37], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) UpdateTableColumnSensitivities(ctx context.Context, in *UpdateTableColumnSensitivitiesRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateTableColumnSensitivities")
	out := new(google_protobuf.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[38], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) DeregisterProducer(ctx context.Context, in *DeregisterRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "DeregisterProducer")
	out := new(google_protobuf.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[39], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) DeregisterDag(ctx context.Context, in *DeregisterRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "DeregisterDag")
	out := new(google_protobuf.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[40], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) RegisterDag(ctx context.Context, in *Dag) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "RegisterDag")
	out := new(google_protobuf.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[41], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) QueryTap(ctx context.Context, in *QueryTapRequest) (*QueryTapResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "QueryTap")
	out := new(QueryTapResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[42], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) ExecTap(ctx context.Context, in *ExecTapRequest) (*ExecTapResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "ExecTap")
	out := new(ExecTapResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[43], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) ListApplications(ctx context.Context, in *ListApplicationsRequest) (*ListApplicationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "ListApplications")
	out := new(ListApplicationsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[44], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) CreateVpcEndpoint(ctx context.Context, in *VpcEndpointRequest) (*VpcEndpointResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "CreateVpcEndpoint")
	out := new(VpcEndpointResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[45], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) UpdateVpcEndpoint(ctx context.Context, in *VpcEndpointRequest) (*VpcEndpointResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateVpcEndpoint")
	out := new(VpcEndpointResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[46], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) DeleteVpcEndpoint(ctx context.Context, in *VpcEndpointRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteVpcEndpoint")
	out := new(google_protobuf.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[47], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) MigrateDirty(ctx context.Context, in *MigrateDirtyRequest) (*Job, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "MigrateDirty")
	out := new(Job)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[48], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) UpdatePartition(ctx context.Context, in *UpdatePartitionRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdatePartition")
	out := new(google_protobuf.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[49], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) ReportRecordsWritten(ctx context.Context, in *ReportRecordsWrittenRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "ReportRecordsWritten")
	out := new(google_protobuf.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[50], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) IncrementTableNumRows(ctx context.Context, in *IncrementTableNumRowsRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "IncrementTableNumRows")
	out := new(google_protobuf.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[51], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) CheckSubscriptionStatus(ctx context.Context, in *CheckSubscriptionStatusRequest) (*CheckSubscriptionStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "CheckSubscriptionStatus")
	out := new(CheckSubscriptionStatusResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[52], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) CopySubscriptions(ctx context.Context, in *CopySubscriptionsRequest) (*CopySubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "CopySubscriptions")
	out := new(CopySubscriptionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[53], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchTahoeAPIServiceJSONClient) GetView(ctx context.Context, in *GetViewRequest) (*GetViewResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithMethodName(ctx, "GetView")
	out := new(GetViewResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[54], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ====================================
// TwitchTahoeAPIService Server Handler
// ====================================

type twitchTahoeAPIServiceServer struct {
	TwitchTahoeAPIService
	hooks *twirp.ServerHooks
}

func NewTwitchTahoeAPIServiceServer(svc TwitchTahoeAPIService, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchTahoeAPIServiceServer{
		TwitchTahoeAPIService: svc,
		hooks:                 hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchTahoeAPIServiceServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchTahoeAPIServicePathPrefix is used for all URL paths on a twirp TwitchTahoeAPIService server.
// Requests are always: POST TwitchTahoeAPIServicePathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchTahoeAPIServicePathPrefix = "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/"

func (s *twitchTahoeAPIServiceServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchtahoeapiservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchTahoeAPIService")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/RegisterProducer":
		s.serveRegisterProducer(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/GetProducerStatus":
		s.serveGetProducerStatus(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/QueryProducers":
		s.serveQueryProducers(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/UpdateProducer":
		s.serveUpdateProducer(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/CreateProducerAPIKey":
		s.serveCreateProducerAPIKey(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/RevokeProducerAPIKey":
		s.serveRevokeProducerAPIKey(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/QueryDags":
		s.serveQueryDags(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/RunDag":
		s.serveRunDag(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/QueryJobs":
		s.serveQueryJobs(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/UpdateJobStatus":
		s.serveUpdateJobStatus(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/CancelJob":
		s.serveCancelJob(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/RemovePartition":
		s.serveRemovePartition(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/CreateTap":
		s.serveCreateTap(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/GetTapStatus":
		s.serveGetTapStatus(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/GetTap":
		s.serveGetTap(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/ListTaps":
		s.serveListTaps(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/UpdateTap":
		s.serveUpdateTap(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/DeleteTap":
		s.serveDeleteTap(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/PurgeTap":
		s.servePurgeTap(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/RegisterTap":
		s.serveRegisterTap(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/DeregisterTap":
		s.serveDeregisterTap(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/CreateTapUser":
		s.serveCreateTapUser(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/ListTapUsers":
		s.serveListTapUsers(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/DeleteTapUser":
		s.serveDeleteTapUser(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/UpdateTapUser":
		s.serveUpdateTapUser(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/ResetTapUserPassword":
		s.serveResetTapUserPassword(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/Subscribe":
		s.serveSubscribe(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/Unsubscribe":
		s.serveUnsubscribe(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/ListSubscriptions":
		s.serveListSubscriptions(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/PutView":
		s.servePutView(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/DropView":
		s.serveDropView(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/PutTable":
		s.servePutTable(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/PutData":
		s.servePutData(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/TouchTable":
		s.serveTouchTable(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/QueryRelation":
		s.serveQueryRelation(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/ListViews":
		s.serveListViews(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/PerformTahoeOperationSequence":
		s.servePerformTahoeOperationSequence(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/PerformTapTahoeOperationSequence":
		s.servePerformTapTahoeOperationSequence(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/UpdateTableColumnSensitivities":
		s.serveUpdateTableColumnSensitivities(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/DeregisterProducer":
		s.serveDeregisterProducer(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/DeregisterDag":
		s.serveDeregisterDag(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/RegisterDag":
		s.serveRegisterDag(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/QueryTap":
		s.serveQueryTap(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/ExecTap":
		s.serveExecTap(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/ListApplications":
		s.serveListApplications(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/CreateVpcEndpoint":
		s.serveCreateVpcEndpoint(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/UpdateVpcEndpoint":
		s.serveUpdateVpcEndpoint(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/DeleteVpcEndpoint":
		s.serveDeleteVpcEndpoint(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/MigrateDirty":
		s.serveMigrateDirty(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/UpdatePartition":
		s.serveUpdatePartition(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/ReportRecordsWritten":
		s.serveReportRecordsWritten(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/IncrementTableNumRows":
		s.serveIncrementTableNumRows(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/CheckSubscriptionStatus":
		s.serveCheckSubscriptionStatus(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/CopySubscriptions":
		s.serveCopySubscriptions(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchtahoeapiservice.TwitchTahoeAPIService/GetView":
		s.serveGetView(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchTahoeAPIServiceServer) serveRegisterProducer(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRegisterProducerJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRegisterProducerProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveRegisterProducerJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RegisterProducer")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RegisterProducerRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Producer
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.RegisterProducer(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Producer and nil error while calling RegisterProducer. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveRegisterProducerProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RegisterProducer")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RegisterProducerRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Producer
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.RegisterProducer(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Producer and nil error while calling RegisterProducer. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveGetProducerStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetProducerStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetProducerStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveGetProducerStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetProducerStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetProducerStatusRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetProducerStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.GetProducerStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProducerStatusResponse and nil error while calling GetProducerStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveGetProducerStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetProducerStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetProducerStatusRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetProducerStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.GetProducerStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProducerStatusResponse and nil error while calling GetProducerStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveQueryProducers(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveQueryProducersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveQueryProducersProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveQueryProducersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "QueryProducers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(QueryProducersRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueryProducersResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.QueryProducers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueryProducersResponse and nil error while calling QueryProducers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveQueryProducersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "QueryProducers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(QueryProducersRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueryProducersResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.QueryProducers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueryProducersResponse and nil error while calling QueryProducers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveUpdateProducer(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateProducerJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateProducerProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveUpdateProducerJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateProducer")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateProducerRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Producer
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.UpdateProducer(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Producer and nil error while calling UpdateProducer. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveUpdateProducerProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateProducer")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateProducerRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Producer
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.UpdateProducer(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Producer and nil error while calling UpdateProducer. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveCreateProducerAPIKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateProducerAPIKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateProducerAPIKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveCreateProducerAPIKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateProducerAPIKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateAPIKeyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Producer
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.CreateProducerAPIKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Producer and nil error while calling CreateProducerAPIKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveCreateProducerAPIKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateProducerAPIKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateAPIKeyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Producer
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.CreateProducerAPIKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Producer and nil error while calling CreateProducerAPIKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveRevokeProducerAPIKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRevokeProducerAPIKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRevokeProducerAPIKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveRevokeProducerAPIKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RevokeProducerAPIKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RevokeAPIKeyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.RevokeProducerAPIKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling RevokeProducerAPIKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveRevokeProducerAPIKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RevokeProducerAPIKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RevokeAPIKeyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.RevokeProducerAPIKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling RevokeProducerAPIKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveQueryDags(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveQueryDagsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveQueryDagsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveQueryDagsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "QueryDags")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(QueryDagsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueryDagsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.QueryDags(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueryDagsResponse and nil error while calling QueryDags. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveQueryDagsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "QueryDags")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(QueryDagsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueryDagsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.QueryDags(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueryDagsResponse and nil error while calling QueryDags. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveRunDag(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRunDagJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRunDagProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveRunDagJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RunDag")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RunDagRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Job
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.RunDag(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Job and nil error while calling RunDag. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveRunDagProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RunDag")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RunDagRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Job
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.RunDag(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Job and nil error while calling RunDag. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveQueryJobs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveQueryJobsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveQueryJobsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveQueryJobsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "QueryJobs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(QueryJobsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueryJobsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.QueryJobs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueryJobsResponse and nil error while calling QueryJobs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveQueryJobsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "QueryJobs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(QueryJobsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueryJobsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.QueryJobs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueryJobsResponse and nil error while calling QueryJobs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveUpdateJobStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateJobStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateJobStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveUpdateJobStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateJobStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateJobStatusRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateJobStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.UpdateJobStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateJobStatusResponse and nil error while calling UpdateJobStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveUpdateJobStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateJobStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateJobStatusRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateJobStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.UpdateJobStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateJobStatusResponse and nil error while calling UpdateJobStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveCancelJob(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCancelJobJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCancelJobProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveCancelJobJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CancelJob")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CancelJobRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.CancelJob(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling CancelJob. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveCancelJobProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CancelJob")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CancelJobRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.CancelJob(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling CancelJob. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveRemovePartition(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemovePartitionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemovePartitionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveRemovePartitionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemovePartition")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemovePartitionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.RemovePartition(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling RemovePartition. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveRemovePartitionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemovePartition")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RemovePartitionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.RemovePartition(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling RemovePartition. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveCreateTap(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateTapJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateTapProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveCreateTapJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateTap")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateTapRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateTapResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.CreateTap(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateTapResponse and nil error while calling CreateTap. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveCreateTapProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateTap")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateTapRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateTapResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.CreateTap(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateTapResponse and nil error while calling CreateTap. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveGetTapStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetTapStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTapStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveGetTapStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTapStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetTapStatusRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetTapStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.GetTapStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTapStatusResponse and nil error while calling GetTapStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveGetTapStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTapStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetTapStatusRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetTapStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.GetTapStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTapStatusResponse and nil error while calling GetTapStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveGetTap(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetTapJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTapProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveGetTapJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTap")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetTapRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetTapResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.GetTap(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTapResponse and nil error while calling GetTap. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveGetTapProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTap")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetTapRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetTapResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.GetTap(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTapResponse and nil error while calling GetTap. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveListTaps(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListTapsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListTapsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveListTapsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListTaps")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListTapsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListTapsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.ListTaps(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListTapsResponse and nil error while calling ListTaps. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveListTapsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListTaps")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListTapsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListTapsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.ListTaps(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListTapsResponse and nil error while calling ListTaps. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveUpdateTap(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateTapJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateTapProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveUpdateTapJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateTap")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateTapRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateTapResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.UpdateTap(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateTapResponse and nil error while calling UpdateTap. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveUpdateTapProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateTap")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateTapRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateTapResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.UpdateTap(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateTapResponse and nil error while calling UpdateTap. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveDeleteTap(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteTapJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteTapProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveDeleteTapJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteTap")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteTapRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteTapResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.DeleteTap(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteTapResponse and nil error while calling DeleteTap. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveDeleteTapProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteTap")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteTapRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteTapResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.DeleteTap(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteTapResponse and nil error while calling DeleteTap. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) servePurgeTap(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePurgeTapJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePurgeTapProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) servePurgeTapJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PurgeTap")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(PurgeTapRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PurgeTapResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.PurgeTap(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PurgeTapResponse and nil error while calling PurgeTap. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) servePurgeTapProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PurgeTap")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(PurgeTapRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PurgeTapResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.PurgeTap(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PurgeTapResponse and nil error while calling PurgeTap. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveRegisterTap(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRegisterTapJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRegisterTapProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveRegisterTapJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RegisterTap")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RegisterTapRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RegisterTapResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.RegisterTap(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RegisterTapResponse and nil error while calling RegisterTap. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveRegisterTapProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RegisterTap")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RegisterTapRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RegisterTapResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.RegisterTap(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RegisterTapResponse and nil error while calling RegisterTap. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveDeregisterTap(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeregisterTapJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeregisterTapProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveDeregisterTapJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeregisterTap")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeregisterTapRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeregisterTapResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.DeregisterTap(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeregisterTapResponse and nil error while calling DeregisterTap. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveDeregisterTapProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeregisterTap")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeregisterTapRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeregisterTapResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.DeregisterTap(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeregisterTapResponse and nil error while calling DeregisterTap. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveCreateTapUser(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateTapUserJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateTapUserProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveCreateTapUserJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateTapUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateTapUserRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateTapUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.CreateTapUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateTapUserResponse and nil error while calling CreateTapUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveCreateTapUserProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateTapUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateTapUserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateTapUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.CreateTapUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateTapUserResponse and nil error while calling CreateTapUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveListTapUsers(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListTapUsersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListTapUsersProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveListTapUsersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListTapUsers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListTapUsersRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListTapUsersResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.ListTapUsers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListTapUsersResponse and nil error while calling ListTapUsers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveListTapUsersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListTapUsers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListTapUsersRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListTapUsersResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.ListTapUsers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListTapUsersResponse and nil error while calling ListTapUsers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveDeleteTapUser(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteTapUserJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteTapUserProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveDeleteTapUserJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteTapUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteTapUserRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteTapUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.DeleteTapUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteTapUserResponse and nil error while calling DeleteTapUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveDeleteTapUserProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteTapUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteTapUserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteTapUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.DeleteTapUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteTapUserResponse and nil error while calling DeleteTapUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveUpdateTapUser(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateTapUserJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateTapUserProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveUpdateTapUserJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateTapUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateTapUserRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateTapUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.UpdateTapUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateTapUserResponse and nil error while calling UpdateTapUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveUpdateTapUserProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateTapUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateTapUserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateTapUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.UpdateTapUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateTapUserResponse and nil error while calling UpdateTapUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveResetTapUserPassword(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveResetTapUserPasswordJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveResetTapUserPasswordProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveResetTapUserPasswordJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ResetTapUserPassword")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ResetTapUserPasswordRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ResetTapUserPasswordResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.ResetTapUserPassword(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ResetTapUserPasswordResponse and nil error while calling ResetTapUserPassword. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveResetTapUserPasswordProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ResetTapUserPassword")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ResetTapUserPasswordRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ResetTapUserPasswordResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.ResetTapUserPassword(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ResetTapUserPasswordResponse and nil error while calling ResetTapUserPassword. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveSubscribe(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSubscribeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSubscribeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveSubscribeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Subscribe")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SubscribeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SubscribeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.Subscribe(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SubscribeResponse and nil error while calling Subscribe. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveSubscribeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Subscribe")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SubscribeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SubscribeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.Subscribe(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SubscribeResponse and nil error while calling Subscribe. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveUnsubscribe(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUnsubscribeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUnsubscribeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveUnsubscribeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Unsubscribe")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UnsubscribeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UnsubscribeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.Unsubscribe(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UnsubscribeResponse and nil error while calling Unsubscribe. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveUnsubscribeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Unsubscribe")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UnsubscribeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UnsubscribeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.Unsubscribe(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UnsubscribeResponse and nil error while calling Unsubscribe. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveListSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveListSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.ListSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListSubscriptionsResponse and nil error while calling ListSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveListSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListSubscriptionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.ListSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListSubscriptionsResponse and nil error while calling ListSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) servePutView(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePutViewJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePutViewProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) servePutViewJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PutView")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(PutViewRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.PutView(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling PutView. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) servePutViewProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PutView")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(PutViewRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.PutView(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling PutView. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveDropView(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDropViewJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDropViewProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveDropViewJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DropView")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DropViewRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.DropView(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling DropView. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveDropViewProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DropView")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DropViewRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.DropView(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling DropView. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) servePutTable(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePutTableJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePutTableProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) servePutTableJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PutTable")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(PutTableRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.PutTable(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling PutTable. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) servePutTableProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PutTable")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(PutTableRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.PutTable(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling PutTable. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) servePutData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePutDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePutDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) servePutDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PutData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(PutDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PutDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.PutData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PutDataResponse and nil error while calling PutData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) servePutDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PutData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(PutDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PutDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.PutData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PutDataResponse and nil error while calling PutData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveTouchTable(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveTouchTableJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveTouchTableProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveTouchTableJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "TouchTable")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(TouchTableRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.TouchTable(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling TouchTable. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveTouchTableProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "TouchTable")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(TouchTableRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.TouchTable(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling TouchTable. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveQueryRelation(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveQueryRelationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveQueryRelationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveQueryRelationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "QueryRelation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(QueryRelationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueryRelationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.QueryRelation(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueryRelationResponse and nil error while calling QueryRelation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveQueryRelationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "QueryRelation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(QueryRelationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueryRelationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.QueryRelation(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueryRelationResponse and nil error while calling QueryRelation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveListViews(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListViewsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListViewsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveListViewsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListViews")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListViewsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListViewsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.ListViews(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListViewsResponse and nil error while calling ListViews. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveListViewsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListViews")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListViewsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListViewsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.ListViews(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListViewsResponse and nil error while calling ListViews. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) servePerformTahoeOperationSequence(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePerformTahoeOperationSequenceJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePerformTahoeOperationSequenceProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) servePerformTahoeOperationSequenceJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PerformTahoeOperationSequence")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(TahoeOperationSequence)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.PerformTahoeOperationSequence(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling PerformTahoeOperationSequence. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) servePerformTahoeOperationSequenceProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PerformTahoeOperationSequence")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(TahoeOperationSequence)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.PerformTahoeOperationSequence(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling PerformTahoeOperationSequence. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) servePerformTapTahoeOperationSequence(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePerformTapTahoeOperationSequenceJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePerformTapTahoeOperationSequenceProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) servePerformTapTahoeOperationSequenceJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PerformTapTahoeOperationSequence")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(TapTahoeOperationSequence)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.PerformTapTahoeOperationSequence(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling PerformTapTahoeOperationSequence. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) servePerformTapTahoeOperationSequenceProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PerformTapTahoeOperationSequence")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(TapTahoeOperationSequence)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.PerformTapTahoeOperationSequence(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling PerformTapTahoeOperationSequence. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveUpdateTableColumnSensitivities(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateTableColumnSensitivitiesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateTableColumnSensitivitiesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveUpdateTableColumnSensitivitiesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateTableColumnSensitivities")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateTableColumnSensitivitiesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.UpdateTableColumnSensitivities(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling UpdateTableColumnSensitivities. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveUpdateTableColumnSensitivitiesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateTableColumnSensitivities")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateTableColumnSensitivitiesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.UpdateTableColumnSensitivities(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling UpdateTableColumnSensitivities. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveDeregisterProducer(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeregisterProducerJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeregisterProducerProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveDeregisterProducerJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeregisterProducer")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeregisterRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.DeregisterProducer(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling DeregisterProducer. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveDeregisterProducerProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeregisterProducer")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeregisterRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.DeregisterProducer(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling DeregisterProducer. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveDeregisterDag(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeregisterDagJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeregisterDagProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveDeregisterDagJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeregisterDag")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeregisterRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.DeregisterDag(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling DeregisterDag. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveDeregisterDagProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeregisterDag")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeregisterRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.DeregisterDag(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling DeregisterDag. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveRegisterDag(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRegisterDagJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRegisterDagProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveRegisterDagJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RegisterDag")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Dag)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.RegisterDag(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling RegisterDag. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveRegisterDagProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RegisterDag")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(Dag)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.RegisterDag(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling RegisterDag. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveQueryTap(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveQueryTapJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveQueryTapProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveQueryTapJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "QueryTap")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(QueryTapRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueryTapResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.QueryTap(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueryTapResponse and nil error while calling QueryTap. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveQueryTapProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "QueryTap")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(QueryTapRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueryTapResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.QueryTap(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueryTapResponse and nil error while calling QueryTap. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveExecTap(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveExecTapJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveExecTapProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveExecTapJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ExecTap")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ExecTapRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ExecTapResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.ExecTap(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ExecTapResponse and nil error while calling ExecTap. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveExecTapProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ExecTap")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ExecTapRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ExecTapResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.ExecTap(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ExecTapResponse and nil error while calling ExecTap. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveListApplications(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListApplicationsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListApplicationsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveListApplicationsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListApplications")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListApplicationsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListApplicationsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.ListApplications(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListApplicationsResponse and nil error while calling ListApplications. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveListApplicationsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListApplications")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListApplicationsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListApplicationsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.ListApplications(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListApplicationsResponse and nil error while calling ListApplications. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveCreateVpcEndpoint(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateVpcEndpointJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateVpcEndpointProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveCreateVpcEndpointJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateVpcEndpoint")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(VpcEndpointRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *VpcEndpointResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.CreateVpcEndpoint(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *VpcEndpointResponse and nil error while calling CreateVpcEndpoint. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveCreateVpcEndpointProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateVpcEndpoint")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(VpcEndpointRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *VpcEndpointResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.CreateVpcEndpoint(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *VpcEndpointResponse and nil error while calling CreateVpcEndpoint. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveUpdateVpcEndpoint(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateVpcEndpointJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateVpcEndpointProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveUpdateVpcEndpointJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateVpcEndpoint")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(VpcEndpointRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *VpcEndpointResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.UpdateVpcEndpoint(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *VpcEndpointResponse and nil error while calling UpdateVpcEndpoint. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveUpdateVpcEndpointProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateVpcEndpoint")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(VpcEndpointRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *VpcEndpointResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.UpdateVpcEndpoint(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *VpcEndpointResponse and nil error while calling UpdateVpcEndpoint. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveDeleteVpcEndpoint(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteVpcEndpointJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteVpcEndpointProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveDeleteVpcEndpointJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteVpcEndpoint")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(VpcEndpointRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.DeleteVpcEndpoint(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling DeleteVpcEndpoint. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveDeleteVpcEndpointProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteVpcEndpoint")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(VpcEndpointRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.DeleteVpcEndpoint(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling DeleteVpcEndpoint. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveMigrateDirty(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveMigrateDirtyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveMigrateDirtyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveMigrateDirtyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "MigrateDirty")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(MigrateDirtyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Job
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.MigrateDirty(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Job and nil error while calling MigrateDirty. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveMigrateDirtyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "MigrateDirty")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(MigrateDirtyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Job
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.MigrateDirty(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Job and nil error while calling MigrateDirty. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveUpdatePartition(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdatePartitionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdatePartitionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveUpdatePartitionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdatePartition")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdatePartitionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.UpdatePartition(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling UpdatePartition. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveUpdatePartitionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdatePartition")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdatePartitionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.UpdatePartition(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling UpdatePartition. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveReportRecordsWritten(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveReportRecordsWrittenJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveReportRecordsWrittenProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveReportRecordsWrittenJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ReportRecordsWritten")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ReportRecordsWrittenRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.ReportRecordsWritten(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling ReportRecordsWritten. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveReportRecordsWrittenProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ReportRecordsWritten")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ReportRecordsWrittenRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.ReportRecordsWritten(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling ReportRecordsWritten. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveIncrementTableNumRows(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveIncrementTableNumRowsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveIncrementTableNumRowsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveIncrementTableNumRowsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IncrementTableNumRows")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(IncrementTableNumRowsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.IncrementTableNumRows(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling IncrementTableNumRows. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveIncrementTableNumRowsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IncrementTableNumRows")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(IncrementTableNumRowsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.IncrementTableNumRows(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling IncrementTableNumRows. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveCheckSubscriptionStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCheckSubscriptionStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCheckSubscriptionStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveCheckSubscriptionStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CheckSubscriptionStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CheckSubscriptionStatusRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CheckSubscriptionStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.CheckSubscriptionStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CheckSubscriptionStatusResponse and nil error while calling CheckSubscriptionStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveCheckSubscriptionStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CheckSubscriptionStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CheckSubscriptionStatusRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CheckSubscriptionStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.CheckSubscriptionStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CheckSubscriptionStatusResponse and nil error while calling CheckSubscriptionStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveCopySubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCopySubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCopySubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveCopySubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CopySubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CopySubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CopySubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.CopySubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CopySubscriptionsResponse and nil error while calling CopySubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveCopySubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CopySubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CopySubscriptionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CopySubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.CopySubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CopySubscriptionsResponse and nil error while calling CopySubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveGetView(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetViewJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetViewProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchTahoeAPIServiceServer) serveGetViewJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetView")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetViewRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetViewResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.GetView(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetViewResponse and nil error while calling GetView. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) serveGetViewProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetView")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetViewRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetViewResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchTahoeAPIService.GetView(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetViewResponse and nil error while calling GetView. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchTahoeAPIServiceServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchTahoeAPIServiceServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchTahoeAPIServiceServer) PathPrefix() string {
	return TwitchTahoeAPIServicePathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 6990 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x7d, 0x4d, 0x6c, 0x23, 0xc9,
	0x75, 0xb0, 0x9a, 0x14, 0x45, 0xf2, 0x91, 0xa2, 0x5a, 0x25, 0x69, 0x86, 0xc3, 0xfd, 0x9b, 0xed,
	0xb5, 0xbd, 0xe3, 0xb1, 0x57, 0xb3, 0x2b, 0xed, 0x7e, 0xb6, 0x77, 0x76, 0xed, 0xa5, 0x48, 0xce,
	0x88, 0x33, 0x14, 0xc5, 0x69, 0x52, 0xf3, 0x63, 0x7f, 0xfe, 0x7a, 0x5b, 0x64, 0x49, 0xd3, 0x2b,
	0xb2, 0xbb, 0xb7, 0xbb, 0x29, 0x8d, 0xd6, 0xfe, 0x1c, 0xdb, 0x31, 0xf2, 0x07, 0x27, 0xb1, 0x03,
	0x24, 0x31, 0x60, 0x24, 0x70, 0x82, 0x9c, 0x12, 0xe4, 0x60, 0x20, 0x70, 0x90, 0x63, 0x80, 0xc0,
	0x80, 0x81, 0x1c, 0x82, 0x1c, 0x02, 0x9f, 0x92, 0x43, 0x7c, 0x70, 0x8e, 0x46, 0x90, 0x43, 0x0e,
	0x09, 0x82, 0xfa, 0xe9, 0x66, 0x35, 0x49, 0x49, 0xd3, 0x14, 0xb5, 0xeb, 0x5c, 0x04, 0xf6, 0xab,
	0xaa, 0x57, 0xaf, 0x5e, 0x55, 0xbd, 0x7a, 0x7f, 0x55, 0x82, 0xcf, 0xb5, 0xad, 0x0e, 0x5e, 0x7d,
	0xaf, 0xef, 0x7a, 0x86, 0xb9, 0xea, 0x1d, 0xde, 0xd0, 0x7b, 0x1f, 0x98, 0x37, 0x5a, 0x47, 0x86,
	0xd7, 0x7e, 0xdc, 0xd2, 0x1f, 0x5b, 0xb8, 0xd8, 0xa8, 0xd6, 0xf4, 0xde, 0x6e, 0x47, 0x6f, 0x1d,
	0x19, 0x8e, 0x7d, 0xc3, 0x23, 0x7f, 0x57, 0x6d, 0xc7, 0xf2, 0x2c, 0xf4, 0x29, 0x8f, 0x56, 0x5b,
	0xdd, 0xeb, 0x77, 0x3d, 0xcb, 0x5c, 0xc5, 0x4f, 0xf4, 0x9e, 0xdd, 0xc5, 0xab, 0x0c, 0xea, 0x91,
	0xc6, 0xba, 0x6d, 0xb8, 0xd8, 0x39, 0x34, 0xda, 0xb8, 0xf0, 0xcc, 0xbe, 0x65, 0xed, 0x77, 0xf1,
	0x0d, 0xda, 0x74, 0xb7, 0xbf, 0x77, 0x03, 0xf7, 0x6c, 0xef, 0x98, 0x61, 0x2a, 0xbc, 0x30, 0x5c,
	0xe8, 0x19, 0x3d, 0xec, 0x7a, 0x7a, 0x8f, 0x77, 0xa5, 0xfc, 0x54, 0x82, 0xcb, 0x2a, 0xde, 0x37,
	0x5c, 0x0f, 0x3b, 0x0d, 0xc7, 0xea, 0xf4, 0xdb, 0xd8, 0x51, 0xf1, 0xfb, 0x7d, 0xec, 0x7a, 0xe8,
	0x93, 0x20, 0xeb, 0xb6, 0xdd, 0x35, 0xda, 0xba, 0x67, 0x58, 0xa6, 0x66, 0xea, 0x3d, 0x9c, 0x97,
	0xae, 0x4a, 0xd7, 0xd2, 0xea, 0x82, 0x00, 0xaf, 0xeb, 0x3d, 0x8c, 0x9e, 0x81, 0xf4, 0xae, 0x61,
	0x76, 0xba, 0x58, 0x33, 0x3a, 0xf9, 0x18, 0xad, 0x93, 0x62, 0x80, 0x6a, 0x07, 0x7d, 0x1c, 0x72,
	0xb6, 0x63, 0x98, 0x6d, 0xc3, 0xd6, 0xbb, 0x9a, 0x63, 0x75, 0x71, 0x3e, 0x4e, 0x6b, 0xcc, 0x07,
	0x50, 0xd5, 0xea, 0x62, 0x74, 0x0d, 0x64, 0x77, 0x5d, 0x73, 0xad, 0xbe, 0xd3, 0xc6, 0xda, 0x6e,
	0xbf, 0x7d, 0x80, 0xbd, 0xfc, 0x2c, 0xad, 0x98, 0x73, 0xd7, 0x9b, 0x14, 0xbc, 0x41, 0xa1, 0xe8,
	0x63, 0x90, 0xe3, 0xd5, 0x0e, 0x7a, 0xae, 0xa6, 0x3b, 0x66, 0x3e, 0x41, 0xeb, 0x65, 0x19, 0xf4,
	0x6e, 0xcf, 0x2d, 0x3a, 0xa6, 0xf2, 0x93, 0x04, 0xa4, 0xfc, 0x21, 0xa1, 0x1c, 0xc4, 0x8c, 0x4e,
	0x1e, 0xd1, 0x6a, 0x31, 0xa3, 0xf3, 0x61, 0x8f, 0xed, 0x0a, 0xa4, 0x0c, 0xbd, 0xc7, 0x2a, 0xb0,
	0x31, 0x25, 0x0d, 0xbd, 0x47, 0x8b, 0x6e, 0x42, 0xa6, 0xed, 0x60, 0xdd, 0xc3, 0x1a, 0x99, 0x1b,
	0x3a, 0x92, 0xcc, 0x5a, 0x61, 0x95, 0x4d, 0xdc, 0xaa, 0x3f, 0x71, 0xab, 0x2d, 0x7f, 0xe2, 0x54,
	0x60, 0xd5, 0x09, 0x00, 0x5d, 0x85, 0xac, 0xbb, 0xae, 0x19, 0xa6, 0xdd, 0xf7, 0xb4, 0xbe, 0x63,
	0xe4, 0xe7, 0x28, 0x6e, 0x70, 0xd7, 0xab, 0x04, 0xb4, 0xe3, 0x18, 0xe8, 0x39, 0x00, 0xd7, 0xd3,
	0xdb, 0x07, 0x6c, 0x88, 0x29, 0x5a, 0x9e, 0xa6, 0x10, 0x3a, 0xb8, 0x4b, 0x30, 0xe7, 0xb6, 0x1f,
	0xe3, 0x9e, 0x9e, 0x4f, 0xd3, 0x22, 0xfe, 0x45, 0x59, 0xbc, 0xae, 0x75, 0xb0, 0xeb, 0xf9, 0x53,
	0x01, 0x9c, 0xc5, 0xeb, 0x65, 0xec, 0x7a, 0x7c, 0x22, 0x3e, 0x3d, 0x66, 0xca, 0x32, 0xa4, 0xde,
	0x46, 0x2c, 0x2f, 0x8d, 0x4c, 0xdb, 0xb5, 0x91, 0x69, 0xcb, 0x06, 0x75, 0x43, 0x53, 0x87, 0x10,
	0xcc, 0x1e, 0xe0, 0x63, 0x37, 0x3f, 0x7f, 0x35, 0x7e, 0x2d, 0xad, 0xd2, 0xdf, 0xe8, 0x3a, 0x2c,
	0xee, 0xea, 0xed, 0x83, 0xbe, 0xad, 0x09, 0xe3, 0xc9, 0xb1, 0x29, 0x63, 0x05, 0xcd, 0x60, 0x54,
	0x6c, 0x29, 0xf1, 0xea, 0x9c, 0xae, 0x05, 0x7f, 0x29, 0x6d, 0x50, 0x30, 0xa7, 0x29, 0x0f, 0x89,
	0x76, 0x17, 0xeb, 0x66, 0x7e, 0xf1, 0xaa, 0x74, 0x2d, 0x45, 0x49, 0x61, 0x00, 0xf4, 0x00, 0x92,
	0x8f, 0x8f, 0xf7, 0x0d, 0x6c, 0xe2, 0xfc, 0xd2, 0x55, 0xe9, 0x5a, 0x6e, 0xed, 0xed, 0xd5, 0x08,
	0xdb, 0x72, 0xd5, 0x5f, 0x79, 0xab, 0x9b, 0x0c, 0x89, 0xea, 0x63, 0x53, 0xd6, 0x20, 0xc9, 0x61,
	0x28, 0x0d, 0x89, 0x72, 0x55, 0x6d, 0x3d, 0x92, 0x67, 0xd0, 0x22, 0xcc, 0xd3, 0x9f, 0xc5, 0x7a,
	0xb9, 0x54, 0xab, 0x14, 0xeb, 0xb2, 0x44, 0x4a, 0xd9, 0xcf, 0x98, 0xf2, 0xb7, 0x12, 0x5c, 0xae,
	0x19, 0xae, 0x57, 0x1c, 0xac, 0x4d, 0xd7, 0xdf, 0xa6, 0x16, 0xa4, 0x74, 0xdb, 0xd6, 0xbc, 0x63,
	0x9b, 0x2d, 0xe1, 0xdc, 0x5a, 0x2b, 0x12, 0xa5, 0x27, 0xe0, 0x5d, 0x15, 0x60, 0xad, 0x63, 0x1b,
	0xab, 0x49, 0xdd, 0xb6, 0xc9, 0x0f, 0xe5, 0x0d, 0x58, 0x18, 0x2a, 0x43, 0x19, 0x48, 0xee, 0xd4,
	0xef, 0xd6, 0xb7, 0x1f, 0xd4, 0xe5, 0x19, 0x94, 0x85, 0x54, 0x43, 0xdd, 0x2e, 0xef, 0x94, 0x2a,
	0xaa, 0x2c, 0xa1, 0x24, 0xc4, 0x5b, 0xc5, 0x86, 0x1c, 0x53, 0x6a, 0x90, 0x1f, 0xed, 0xca, 0xb5,
	0x2d, 0xd3, 0xc5, 0xe8, 0x59, 0x48, 0xdb, 0x9c, 0x61, 0x6e, 0x5e, 0xa2, 0xb3, 0x3e, 0x00, 0x90,
	0xe5, 0xe0, 0xe9, 0xb6, 0x9b, 0x8f, 0xb1, 0xe5, 0x40, 0x7e, 0x2b, 0xaf, 0x80, 0x7c, 0xaf, 0x8f,
	0x9d, 0xe3, 0xb2, 0xbe, 0x1f, 0x70, 0xe2, 0x0a, 0xa4, 0x3a, 0xfa, 0xbe, 0xb8, 0x99, 0x93, 0x1d,
	0x7d, 0x9f, 0xac, 0x08, 0xe5, 0x1f, 0xe3, 0x20, 0x97, 0xac, 0x6e, 0xbf, 0x67, 0x96, 0xf1, 0x9e,
	0x61, 0x1a, 0xa4, 0x7b, 0x82, 0x57, 0xa8, 0x4b, 0x7f, 0xa3, 0xff, 0x0b, 0xb3, 0x94, 0x93, 0x31,
	0xca, 0xc9, 0xcd, 0x48, 0x9c, 0x1c, 0xee, 0x80, 0x03, 0x28, 0xf7, 0x28, 0x56, 0xf4, 0x3e, 0x64,
	0x5c, 0x6c, 0xba, 0x86, 0x67, 0x1c, 0x1a, 0xde, 0x31, 0x95, 0x15, 0xb9, 0xb5, 0xed, 0x69, 0x74,
	0xd2, 0x1c, 0xa0, 0x55, 0xc5, 0x3e, 0x94, 0x2f, 0x02, 0x0c, 0xc8, 0x40, 0x00, 0x73, 0xcd, 0x96,
	0x5a, 0xad, 0xdf, 0x96, 0x67, 0xc8, 0xcc, 0x54, 0xeb, 0x2d, 0x59, 0x42, 0x29, 0x98, 0xad, 0x6d,
	0xd7, 0x6f, 0xcb, 0x31, 0x52, 0x5c, 0xde, 0xde, 0xd9, 0xa8, 0x55, 0xe4, 0x38, 0x81, 0x6e, 0x6c,
	0x6f, 0xd7, 0xe4, 0x59, 0x34, 0x0f, 0xe9, 0x56, 0x75, 0xab, 0xd2, 0x6c, 0x15, 0xb7, 0x1a, 0x72,
	0x82, 0x14, 0x94, 0x8b, 0xad, 0x8a, 0x3c, 0xa7, 0xfc, 0x7f, 0x58, 0x1c, 0xe9, 0x9d, 0x14, 0xd7,
	0xb7, 0xeb, 0x15, 0x79, 0x86, 0x60, 0xdb, 0x69, 0x56, 0xd4, 0x6a, 0x59, 0x96, 0xd0, 0x1c, 0xc4,
	0xaa, 0x0d, 0x39, 0x86, 0x72, 0x30, 0xd7, 0x28, 0x3e, 0xda, 0xde, 0x69, 0xc9, 0xf1, 0x42, 0x2c,
	0x25, 0x11, 0xdc, 0xcd, 0x4a, 0xb3, 0x59, 0xdd, 0xae, 0x57, 0xcb, 0xf2, 0x2c, 0x59, 0x48, 0xdb,
	0xad, 0x4d, 0xda, 0x26, 0x81, 0x64, 0x48, 0x91, 0xf6, 0xad, 0xca, 0xc3, 0x96, 0x3c, 0x47, 0x6b,
	0x67, 0x21, 0x75, 0xbf, 0x5a, 0x79, 0x40, 0xcb, 0x93, 0xca, 0x0f, 0x62, 0x90, 0x6b, 0xe9, 0xbb,
	0x5d, 0xdc, 0xd0, 0x1d, 0x8f, 0x4d, 0xe9, 0x43, 0x2e, 0x39, 0xc8, 0x1a, 0xca, 0xac, 0x95, 0x23,
	0x71, 0x36, 0x8c, 0x6a, 0xf5, 0x2e, 0x3e, 0xbe, 0xaf, 0x77, 0xfb, 0x98, 0xcb, 0x9f, 0x02, 0xa4,
	0xba, 0x16, 0x5b, 0xb7, 0xfe, 0x29, 0xe0, 0x7f, 0x93, 0x53, 0x80, 0x0a, 0x0d, 0x2d, 0xa8, 0xc1,
	0x4f, 0x01, 0x0a, 0xad, 0x71, 0x60, 0xe1, 0x7d, 0x48, 0xf9, 0x48, 0xd1, 0x36, 0xc4, 0x0f, 0xf0,
	0x31, 0x5d, 0x7a, 0x99, 0x88, 0xa2, 0x65, 0x78, 0x05, 0xa8, 0x04, 0x13, 0x5a, 0x86, 0xc4, 0x21,
	0xc1, 0xcc, 0x89, 0x63, 0x1f, 0x4a, 0x19, 0x72, 0x2a, 0xee, 0xd2, 0xee, 0x9b, 0x4c, 0xb2, 0x17,
	0x20, 0xe5, 0x70, 0x08, 0x5f, 0xf8, 0xc1, 0xb7, 0x70, 0x1a, 0xc4, 0xc4, 0xd3, 0x40, 0xf9, 0x7a,
	0x02, 0x12, 0x94, 0x3b, 0xe8, 0x1e, 0x24, 0x3c, 0xf2, 0x83, 0x13, 0x7e, 0x33, 0x12, 0xe1, 0x61,
	0x4a, 0x54, 0x86, 0x09, 0x75, 0x01, 0xb5, 0xe9, 0x88, 0xb4, 0x4e, 0x30, 0x24, 0xb6, 0xd7, 0xcf,
	0xcd, 0x98, 0xc5, 0xf6, 0x10, 0x24, 0x3c, 0x8d, 0xf1, 0x33, 0xa7, 0x31, 0x39, 0x66, 0x1a, 0xd1,
	0x97, 0x00, 0x6c, 0x7f, 0x95, 0xb8, 0xf9, 0x59, 0x4a, 0xe8, 0xcd, 0x73, 0xac, 0x34, 0x55, 0x40,
	0x87, 0xf6, 0x40, 0x66, 0x34, 0x08, 0x5d, 0xa4, 0xce, 0xdf, 0xc5, 0x02, 0x45, 0xda, 0x18, 0xf4,
	0xf3, 0x3a, 0x24, 0x1d, 0xdc, 0xc6, 0x66, 0xfb, 0xf8, 0x29, 0x54, 0x0e, 0xbf, 0xea, 0xe0, 0xb8,
	0x9c, 0x1b, 0x3e, 0x2e, 0xff, 0x1f, 0xf0, 0x23, 0x5c, 0x63, 0xeb, 0x23, 0x7d, 0xfe, 0xf5, 0x91,
	0x61, 0x08, 0xe9, 0x48, 0x94, 0xff, 0x90, 0x60, 0xf6, 0xbe, 0x81, 0x8f, 0xd0, 0x36, 0xcc, 0x1e,
	0x1a, 0xf8, 0x68, 0x1a, 0x0b, 0x90, 0x22, 0x42, 0xcf, 0x03, 0x0c, 0x16, 0x1e, 0x5f, 0xf8, 0x02,
	0x64, 0x30, 0xe6, 0xf8, 0xf0, 0x98, 0x97, 0x21, 0x41, 0x56, 0x4a, 0x97, 0xaa, 0x74, 0x29, 0x95,
	0x7d, 0xa0, 0x1b, 0xb0, 0xd4, 0xc1, 0x5d, 0x4c, 0xf5, 0x4a, 0x01, 0x31, 0x53, 0x51, 0x91, 0x5f,
	0x24, 0x1c, 0x43, 0xcf, 0x40, 0xda, 0xe9, 0x77, 0x31, 0x3b, 0xb7, 0xe6, 0xf8, 0x96, 0xec, 0x77,
	0x31, 0x3d, 0xb8, 0xfe, 0x3c, 0x0e, 0xd9, 0x8a, 0xe9, 0x18, 0xed, 0xc7, 0xb8, 0x43, 0xc7, 0xff,
	0x00, 0x52, 0xaa, 0xb8, 0x7f, 0xcf, 0xc9, 0x83, 0x00, 0x19, 0xe1, 0x43, 0x79, 0x84, 0x0f, 0x02,
	0x99, 0x6b, 0xb0, 0xfc, 0xc0, 0x72, 0x0e, 0x74, 0xc7, 0xea, 0x9b, 0x1d, 0xa1, 0x26, 0xdb, 0x45,
	0x63, 0xcb, 0x90, 0x06, 0xd9, 0x32, 0xb6, 0xb1, 0xd9, 0xc1, 0x66, 0xdb, 0xc0, 0x93, 0x6d, 0x96,
	0x21, 0x82, 0x43, 0x08, 0xc9, 0x14, 0x6c, 0x1f, 0x99, 0xd8, 0xe1, 0xec, 0x65, 0x1f, 0xe8, 0x4d,
	0x80, 0x52, 0xa0, 0x24, 0x53, 0x96, 0x9e, 0xa1, 0x52, 0x0f, 0x6a, 0x93, 0xb6, 0x5b, 0x56, 0xc7,
	0xd8, 0x3b, 0xa6, 0x6d, 0x93, 0x67, 0xb7, 0x1d, 0xd4, 0x56, 0xfe, 0x26, 0x0e, 0xf1, 0xb2, 0xbe,
	0x7f, 0x8a, 0x22, 0x82, 0xae, 0x42, 0xa6, 0x83, 0xdd, 0xb6, 0x63, 0xd8, 0x02, 0x9b, 0x45, 0x10,
	0x3a, 0x86, 0x15, 0x5b, 0x77, 0xf4, 0x1e, 0xf6, 0xb0, 0x13, 0x12, 0x89, 0xf1, 0x09, 0xce, 0xb4,
	0xb2, 0xbe, 0xbf, 0xda, 0xf0, 0xb1, 0x09, 0x92, 0x71, 0xd9, 0x1e, 0x05, 0xba, 0x85, 0xff, 0x94,
	0x60, 0x69, 0x4c, 0x6d, 0x74, 0x4f, 0x50, 0x94, 0xa2, 0x2a, 0xc2, 0x65, 0x7d, 0x3f, 0x40, 0x49,
	0x38, 0xc0, 0xf5, 0xac, 0xb3, 0xf9, 0x70, 0x8f, 0x6b, 0x62, 0xf1, 0x73, 0x76, 0x2a, 0xa8, 0x5f,
	0x05, 0x48, 0x59, 0x14, 0x79, 0xb0, 0x67, 0x83, 0x6f, 0xe5, 0x11, 0x2c, 0x0a, 0x0a, 0x25, 0xd7,
	0x4b, 0xcb, 0x30, 0xdb, 0xd1, 0xf7, 0x7d, 0x75, 0xe2, 0xd5, 0xa8, 0x34, 0xa8, 0xb4, 0xb5, 0xf2,
	0xd7, 0x12, 0xcc, 0xab, 0x7d, 0x93, 0x00, 0xc6, 0x68, 0xaa, 0xb1, 0xf0, 0x02, 0xf9, 0x22, 0x3d,
	0x5d, 0x18, 0xe9, 0xfe, 0x9c, 0xbf, 0x19, 0xa9, 0xe3, 0x3b, 0xd6, 0xee, 0x60, 0xce, 0x55, 0x01,
	0x1b, 0xba, 0x0c, 0x49, 0xdd, 0x36, 0x34, 0xa2, 0x78, 0x30, 0x2b, 0x74, 0x4e, 0xb7, 0x8d, 0xbb,
	0xf8, 0xf8, 0xce, 0x6c, 0x4a, 0x92, 0x63, 0xea, 0x88, 0x49, 0xac, 0xfc, 0x30, 0x03, 0xf1, 0x3b,
	0xd6, 0x2e, 0x5a, 0x81, 0xb9, 0xf7, 0xac, 0x5d, 0x62, 0x00, 0xb3, 0xe5, 0x9c, 0x78, 0xcf, 0xda,
	0xad, 0x76, 0x4e, 0x1b, 0xc6, 0x38, 0x03, 0x3b, 0x3e, 0xde, 0xc0, 0x7e, 0x11, 0xb2, 0x5d, 0x6b,
	0x7f, 0x70, 0xe8, 0x32, 0xd2, 0x32, 0x5d, 0x6b, 0x3f, 0x38, 0x72, 0x3f, 0x47, 0xad, 0x58, 0xc7,
	0x7b, 0x5a, 0x1b, 0x39, 0x4d, 0x6b, 0xd3, 0xfd, 0xfc, 0x05, 0x98, 0x6f, 0x5b, 0x84, 0x5b, 0xbe,
	0x85, 0x7d, 0xb6, 0x38, 0xc8, 0xfa, 0x0d, 0x28, 0x82, 0xf0, 0x84, 0x24, 0xa7, 0x3a, 0x21, 0x4d,
	0x98, 0x73, 0x3d, 0xdd, 0xeb, 0xbb, 0xd4, 0x32, 0xcf, 0x45, 0x94, 0x8c, 0x04, 0x6f, 0x93, 0x36,
	0xa7, 0x6b, 0x9c, 0xa3, 0xa2, 0x47, 0x31, 0xfd, 0xa5, 0x75, 0x0c, 0xc7, 0x3b, 0xa6, 0x56, 0xf6,
	0x39, 0x51, 0x67, 0x18, 0xc2, 0x32, 0xc1, 0x27, 0xe0, 0x67, 0xe7, 0xe2, 0xfc, 0xd4, 0xf0, 0x97,
	0xe8, 0xb1, 0x9a, 0x87, 0x64, 0x07, 0x7b, 0xba, 0xd1, 0x75, 0xb9, 0x53, 0xc2, 0xff, 0x44, 0x2f,
	0xc1, 0x3c, 0xff, 0xc9, 0x87, 0xc6, 0xec, 0xff, 0x2c, 0x07, 0x32, 0xf2, 0x84, 0x4a, 0x8c, 0xbe,
	0x85, 0x50, 0x25, 0xd6, 0xc7, 0xcb, 0xb0, 0x80, 0x9f, 0xd8, 0x86, 0xc3, 0x56, 0x27, 0x5d, 0x17,
	0x70, 0x55, 0xba, 0x16, 0x57, 0x73, 0x03, 0x30, 0x9d, 0x7d, 0xc1, 0x0d, 0x90, 0x99, 0xa6, 0x1b,
	0x80, 0x90, 0x89, 0x9f, 0xe0, 0x76, 0x9f, 0x12, 0xa0, 0x3b, 0x66, 0x5e, 0x66, 0x64, 0x06, 0xc0,
	0xa2, 0x63, 0xa2, 0x55, 0x58, 0xa2, 0x03, 0xd5, 0xc2, 0x55, 0x17, 0x69, 0xd5, 0x45, 0x5a, 0x54,
	0x11, 0xea, 0x17, 0xbe, 0x1f, 0x87, 0x74, 0xb0, 0xd2, 0x2e, 0x42, 0x6c, 0xbf, 0x08, 0x59, 0x6a,
	0x58, 0x68, 0xae, 0xe7, 0x18, 0xe6, 0x3e, 0xdf, 0xd2, 0x19, 0x0a, 0x6b, 0x52, 0x10, 0x51, 0x67,
	0x58, 0x15, 0xc3, 0x64, 0x0e, 0xbc, 0x84, 0x9a, 0xa2, 0x80, 0xaa, 0xe9, 0xa1, 0x23, 0xc8, 0xb3,
	0xc2, 0x31, 0x2a, 0x7f, 0x62, 0x1a, 0x2a, 0xff, 0x25, 0x8a, 0xbe, 0x34, 0xa2, 0xf7, 0x7f, 0x43,
	0x82, 0x02, 0xeb, 0x39, 0x50, 0xac, 0x89, 0x1c, 0xd4, 0x28, 0xcc, 0xcd, 0xcf, 0x4d, 0xd1, 0x5e,
	0xbc, 0x4c, 0x71, 0x06, 0x05, 0x3e, 0xdc, 0x55, 0x3a, 0x00, 0x83, 0x35, 0x4f, 0xcc, 0xef, 0x62,
	0xfd, 0x91, 0x3c, 0x43, 0x6c, 0xde, 0x66, 0xab, 0xa8, 0xb6, 0x2a, 0xc4, 0x4e, 0xce, 0x40, 0xf2,
	0x41, 0xb1, 0xda, 0xaa, 0x52, 0x73, 0x3c, 0x03, 0x49, 0x75, 0xa7, 0x5e, 0x27, 0x1f, 0x71, 0x62,
	0x4d, 0xdf, 0x2a, 0x56, 0x6b, 0x15, 0x6e, 0x26, 0x37, 0x77, 0x4a, 0xa5, 0x4a, 0xb3, 0x29, 0x27,
	0x88, 0x09, 0x5d, 0x2a, 0xd6, 0x4b, 0x95, 0x1a, 0x29, 0x9b, 0x53, 0xfe, 0x48, 0x82, 0xec, 0x96,
	0x6e, 0xdb, 0x86, 0xb9, 0xcf, 0x6c, 0xb6, 0x21, 0xa7, 0x83, 0x74, 0xf1, 0x4e, 0x87, 0xd3, 0x8c,
	0x65, 0xe5, 0xef, 0x24, 0xee, 0xba, 0xb9, 0x63, 0xed, 0x06, 0xae, 0x9b, 0x0b, 0x3d, 0x60, 0x06,
	0x52, 0x76, 0x76, 0x6a, 0x52, 0x56, 0xd9, 0x00, 0xb9, 0xa4, 0x9b, 0x6d, 0xdc, 0xbd, 0x63, 0xed,
	0x9e, 0x31, 0x0a, 0xe1, 0xd8, 0x8d, 0x89, 0xc7, 0x6e, 0xa0, 0x73, 0x30, 0x4e, 0x0c, 0x74, 0x8e,
	0xf7, 0xac, 0xdd, 0xc9, 0x74, 0x0e, 0x42, 0x0b, 0x6d, 0xad, 0xfc, 0x95, 0x04, 0x97, 0x76, 0xec,
	0x8e, 0xee, 0xe1, 0x3b, 0xd6, 0x2e, 0x23, 0xff, 0x0c, 0x2a, 0x07, 0x5c, 0x8a, 0x4d, 0xef, 0x2c,
	0x12, 0x64, 0x79, 0x3c, 0x2c, 0xcb, 0x97, 0x7d, 0xb3, 0x8a, 0x1b, 0x4f, 0xf4, 0x43, 0xb9, 0x02,
	0x97, 0x47, 0xa8, 0x66, 0x7c, 0x51, 0x2a, 0x90, 0xbf, 0x8d, 0x3d, 0x5f, 0xa0, 0x86, 0x87, 0xf4,
	0xf4, 0xee, 0x7c, 0xe5, 0xdf, 0x25, 0xb8, 0x32, 0x06, 0x0f, 0x67, 0xbe, 0x11, 0x30, 0x81, 0x6d,
	0x93, 0x7b, 0x91, 0x98, 0x70, 0x22, 0xde, 0x33, 0x58, 0x13, 0x0b, 0xb1, 0x46, 0xb9, 0x17, 0x92,
	0x13, 0x21, 0xdf, 0xea, 0x1c, 0xc4, 0xb6, 0xef, 0x32, 0xdf, 0x70, 0x45, 0x55, 0xb7, 0x55, 0x39,
	0x86, 0x2e, 0x01, 0x2a, 0x6d, 0x16, 0xeb, 0xb7, 0x2b, 0x5a, 0xb5, 0xae, 0x35, 0xd4, 0xed, 0xdb,
	0x2a, 0x11, 0x0b, 0x71, 0xd2, 0xae, 0x5c, 0xa9, 0x55, 0x88, 0x58, 0x99, 0x55, 0x5e, 0x85, 0x15,
	0xba, 0xd2, 0x7c, 0xf2, 0x02, 0xce, 0x09, 0x6b, 0x53, 0x0a, 0xad, 0xcd, 0x1e, 0x5c, 0x1a, 0x6e,
	0xc1, 0x79, 0xd4, 0x1c, 0x76, 0xd6, 0x66, 0xd6, 0xde, 0x98, 0xe8, 0x50, 0x14, 0x7c, 0xbc, 0xca,
	0x3f, 0x48, 0xb0, 0xc2, 0x66, 0x7e, 0x38, 0x0c, 0x75, 0x12, 0x85, 0xa7, 0x07, 0x66, 0xc6, 0x85,
	0x26, 0xe2, 0x11, 0x42, 0x13, 0xb3, 0x27, 0x84, 0x26, 0xc6, 0xad, 0xb4, 0xc4, 0xf8, 0x95, 0xb6,
	0x0a, 0x4b, 0xcc, 0xae, 0x2c, 0x36, 0xaa, 0x77, 0xf1, 0xf1, 0x99, 0x1c, 0x7f, 0x04, 0x4b, 0x2a,
	0x3e, 0xb4, 0x0e, 0x9e, 0xb2, 0x3e, 0xfa, 0x24, 0x2c, 0xf2, 0x02, 0xcd, 0xb3, 0x34, 0x87, 0x36,
	0xe5, 0x7c, 0xc8, 0xb1, 0x2a, 0x2d, 0x8b, 0x21, 0x54, 0xbe, 0x9e, 0x84, 0x4b, 0x34, 0xea, 0xb8,
	0x6d, 0x63, 0xa6, 0xdc, 0x34, 0x09, 0x76, 0xb3, 0x8d, 0x91, 0x03, 0x60, 0xf9, 0x40, 0x7f, 0x3a,
	0xd5, 0x88, 0xe7, 0xe0, 0x38, 0xc4, 0x43, 0x60, 0x55, 0xe8, 0xa5, 0xf0, 0x8b, 0x04, 0xe4, 0xc2,
	0xc5, 0xe8, 0x18, 0x92, 0x56, 0x28, 0x88, 0xf1, 0xee, 0xf4, 0x69, 0x58, 0x0d, 0x7e, 0xb1, 0x8d,
	0x68, 0xd1, 0x78, 0x06, 0xda, 0xf4, 0x7d, 0x9a, 0x31, 0x6a, 0x19, 0xac, 0x45, 0x57, 0x02, 0x7c,
	0x57, 0x66, 0x85, 0xfb, 0xa6, 0xe2, 0x14, 0xd1, 0x6b, 0x91, 0x10, 0xdd, 0x37, 0xf0, 0x11, 0xf7,
	0x48, 0xfd, 0x0a, 0xa4, 0x2d, 0x9b, 0xaf, 0x5d, 0x7e, 0x64, 0xed, 0x5e, 0x24, 0x37, 0xd8, 0x56,
	0x20, 0xb6, 0x30, 0xfb, 0xa5, 0xfc, 0xa1, 0x04, 0xf3, 0x21, 0x5e, 0x21, 0x19, 0xb2, 0x25, 0xb5,
	0x52, 0x6c, 0x55, 0xb4, 0x56, 0x71, 0xa3, 0x56, 0x91, 0x67, 0x50, 0x0e, 0xa0, 0xac, 0x6e, 0x37,
	0xf8, 0xb7, 0x84, 0x16, 0x61, 0xbe, 0x58, 0x2e, 0x6b, 0x8d, 0xa2, 0xda, 0xaa, 0xb6, 0xaa, 0xdb,
	0x75, 0x39, 0x86, 0x96, 0x41, 0x56, 0x2b, 0x5b, 0xdb, 0xf7, 0x2b, 0x02, 0x34, 0x8e, 0x16, 0x20,
	0xc3, 0x51, 0xdd, 0xaf, 0x56, 0x1e, 0xb0, 0xf0, 0x02, 0xc5, 0x44, 0x3f, 0x13, 0x28, 0x0b, 0x29,
	0x82, 0xa8, 0x5c, 0x6c, 0x15, 0xe5, 0x39, 0x1a, 0x1f, 0xd8, 0xd9, 0x68, 0x96, 0xd4, 0xea, 0x46,
	0x45, 0x4e, 0x12, 0x53, 0x7a, 0x61, 0x88, 0xee, 0xb0, 0x80, 0x9c, 0x87, 0x74, 0x63, 0xa7, 0x15,
	0x50, 0x95, 0x85, 0x14, 0xf9, 0xa4, 0xa8, 0x7d, 0x7d, 0x4a, 0x2b, 0x17, 0x89, 0x3e, 0xb5, 0x08,
	0xf3, 0x01, 0x66, 0xad, 0xd8, 0xa8, 0xca, 0xb3, 0x28, 0x0f, 0xcb, 0xc3, 0x04, 0xd3, 0x92, 0x04,
	0x29, 0xd9, 0x69, 0x94, 0x09, 0xd1, 0xe1, 0x92, 0x39, 0xb4, 0x04, 0x0b, 0x3b, 0xf5, 0x30, 0xa2,
	0x24, 0x8d, 0xe6, 0xf9, 0x43, 0xa2, 0xa0, 0x94, 0xf2, 0x3d, 0x09, 0xae, 0xb4, 0x74, 0xfb, 0x84,
	0x5d, 0xd8, 0x81, 0x0c, 0x99, 0x72, 0xfe, 0xc9, 0x1d, 0x7b, 0xa5, 0x29, 0x4c, 0x3a, 0xd9, 0x77,
	0x41, 0x2f, 0x2b, 0x30, 0xe7, 0xe9, 0xf6, 0x40, 0x5c, 0x26, 0x3c, 0xdd, 0xae, 0x76, 0x94, 0x9f,
	0x4a, 0xb0, 0x4c, 0x65, 0xbd, 0xef, 0x6a, 0xf3, 0x45, 0x4f, 0x93, 0xd4, 0x77, 0xf6, 0xb1, 0x37,
	0x0d, 0x4f, 0x23, 0x47, 0x85, 0x0e, 0x20, 0xc3, 0x7e, 0x69, 0x42, 0xa0, 0xed, 0x4e, 0x24, 0xcc,
	0xbe, 0x43, 0xd4, 0xef, 0x21, 0xe8, 0x8a, 0xee, 0x6b, 0x60, 0xe8, 0x69, 0xac, 0xf2, 0x67, 0x29,
	0x90, 0x87, 0x6b, 0x13, 0x23, 0x86, 0x58, 0xf8, 0x56, 0xdf, 0xec, 0x08, 0x62, 0x35, 0xe3, 0xc3,
	0x88, 0x6c, 0xb5, 0x60, 0xde, 0x8f, 0x8a, 0x5c, 0x14, 0x99, 0x59, 0x47, 0xf8, 0x42, 0x0f, 0x84,
	0xb0, 0x4c, 0x7c, 0x0a, 0x6e, 0xdd, 0x20, 0xa6, 0x33, 0x3e, 0xbc, 0x32, 0xfb, 0x21, 0x84, 0x57,
	0x12, 0x43, 0xe1, 0x95, 0x5e, 0x28, 0x6e, 0xc2, 0x2c, 0xae, 0xad, 0xf3, 0x31, 0x74, 0x10, 0xd0,
	0xa8, 0x98, 0x9e, 0x73, 0x1c, 0x8a, 0xa4, 0x08, 0x11, 0x8e, 0xe4, 0xd3, 0x47, 0x38, 0xc2, 0xd1,
	0x80, 0xd4, 0x48, 0x34, 0x40, 0x83, 0x6c, 0x47, 0xf4, 0x68, 0xa7, 0xa7, 0xe0, 0xd1, 0xee, 0x0c,
	0x79, 0xb4, 0x2d, 0xea, 0xd1, 0x66, 0x09, 0x17, 0xec, 0x63, 0x38, 0x4b, 0x24, 0x13, 0x29, 0x4b,
	0xe4, 0x26, 0x64, 0x7a, 0xd4, 0x49, 0xcd, 0x1a, 0x67, 0xcf, 0x6e, 0xdc, 0x0b, 0x7c, 0xda, 0x03,
	0x3d, 0x7d, 0x5e, 0xd0, 0xd3, 0xc7, 0x84, 0xca, 0x72, 0xe3, 0x42, 0x65, 0x41, 0x84, 0x64, 0xe1,
	0x29, 0x22, 0x24, 0xf2, 0x49, 0x11, 0x92, 0xc2, 0x07, 0xb0, 0x30, 0x34, 0xd3, 0x48, 0x1e, 0xc4,
	0x4f, 0xd3, 0x2c, 0x00, 0x7a, 0x4f, 0x0c, 0x80, 0x9e, 0x33, 0x5c, 0xc6, 0x30, 0xbd, 0x19, 0xfb,
	0xac, 0xa4, 0xbc, 0x04, 0x59, 0x71, 0xdb, 0x12, 0xcd, 0xdb, 0x3f, 0x02, 0x53, 0x30, 0x4b, 0x0f,
	0x16, 0x49, 0xf1, 0xb8, 0x7a, 0x3d, 0x10, 0xa0, 0x5c, 0x57, 0xfe, 0x12, 0xa4, 0xfd, 0x9d, 0xe8,
	0x2b, 0x57, 0x6f, 0x9f, 0x6b, 0xc9, 0xab, 0x03, 0x7c, 0xca, 0x8f, 0x24, 0xc8, 0xdd, 0xc6, 0x1e,
	0xd5, 0x1c, 0x2e, 0x52, 0x62, 0x6f, 0x43, 0x8a, 0x1c, 0x1b, 0x82, 0x1c, 0x7c, 0x3d, 0x22, 0x73,
	0x6d, 0x96, 0x41, 0xe2, 0xb1, 0x1f, 0xca, 0xbb, 0xb0, 0x10, 0xd0, 0xcd, 0x19, 0xb5, 0x15, 0x0a,
	0xeb, 0x7d, 0x6e, 0x22, 0x1e, 0x0d, 0x54, 0x28, 0x05, 0x81, 0x5c, 0x33, 0x5c, 0xda, 0x85, 0x6f,
	0xea, 0x28, 0x7b, 0xb0, 0x28, 0xc0, 0x78, 0xbf, 0x64, 0xd5, 0x10, 0x00, 0x9f, 0x9c, 0xf3, 0x05,
	0xb4, 0x29, 0x26, 0xe5, 0x9b, 0x29, 0xc8, 0x35, 0xfa, 0xa1, 0x69, 0x39, 0x51, 0x87, 0xf7, 0xa3,
	0x99, 0xb1, 0x8b, 0x89, 0x66, 0xc6, 0xcf, 0x94, 0x5f, 0xb3, 0xd3, 0x96, 0x5f, 0x06, 0x64, 0x09,
	0x21, 0xdc, 0xc1, 0xe7, 0x7b, 0xf5, 0x6e, 0x45, 0x33, 0x10, 0x43, 0xdc, 0xa3, 0xaa, 0x31, 0x3b,
	0x7c, 0xd4, 0xcc, 0x61, 0xf0, 0xdb, 0x45, 0x2f, 0x40, 0x06, 0x3f, 0x69, 0x77, 0xfb, 0x1d, 0xac,
	0x75, 0x0f, 0x5d, 0x16, 0x93, 0x56, 0x81, 0x83, 0x6a, 0x87, 0x2e, 0xfa, 0x14, 0x2c, 0xfa, 0x15,
	0x5c, 0xdc, 0xb6, 0xcc, 0x8e, 0xee, 0xb0, 0xc3, 0x20, 0xa5, 0xca, 0xbc, 0xa0, 0xe9, 0xc3, 0x07,
	0xb2, 0x2a, 0xf5, 0x14, 0xb2, 0x2a, 0x7d, 0xa2, 0xac, 0xfa, 0xd6, 0x2c, 0xc0, 0x80, 0x60, 0xf4,
	0x12, 0xcc, 0x5b, 0x8e, 0xb1, 0x6f, 0x98, 0x7a, 0x57, 0x74, 0x4b, 0x64, 0x7d, 0x20, 0x75, 0x50,
	0x5d, 0x81, 0x94, 0x89, 0x8f, 0x42, 0x6e, 0x2e, 0x13, 0x1f, 0xd1, 0xa2, 0xd7, 0x21, 0x65, 0x74,
	0xb0, 0xe9, 0xf9, 0xe9, 0x42, 0x99, 0xb5, 0x4b, 0x23, 0x82, 0xbb, 0xd2, 0xb3, 0xbd, 0xe3, 0xcd,
	0x19, 0x35, 0xa8, 0x89, 0xde, 0x80, 0x4b, 0x9e, 0xa5, 0x1d, 0xea, 0x4e, 0xfb, 0xb1, 0xee, 0x68,
	0x47, 0x86, 0xf7, 0x58, 0xeb, 0x62, 0x73, 0xdf, 0x7b, 0xcc, 0x1c, 0xb2, 0x9b, 0x33, 0xea, 0x92,
	0x67, 0xdd, 0x67, 0xc5, 0x0f, 0x0c, 0xef, 0x71, 0x8d, 0x16, 0xa2, 0x1b, 0x30, 0xe7, 0x59, 0xd4,
	0x6f, 0x9b, 0x38, 0xa3, 0xab, 0x84, 0x67, 0x55, 0x4d, 0x0f, 0xbd, 0x06, 0x49, 0xcf, 0xd2, 0xba,
	0x96, 0xb9, 0xcf, 0xc3, 0x2a, 0x27, 0xb7, 0x98, 0xf3, 0xac, 0x9a, 0x65, 0xee, 0xa3, 0x37, 0x20,
	0xed, 0x59, 0x5a, 0xc7, 0xea, 0x13, 0x8b, 0x2b, 0x79, 0xd6, 0x88, 0x3c, 0xab, 0x4c, 0x6b, 0xf2,
	0x9e, 0x76, 0x2d, 0x8b, 0xcd, 0xcf, 0x19, 0x3d, 0x6d, 0x58, 0x56, 0x17, 0xdd, 0x84, 0xac, 0x67,
	0x69, 0x41, 0xc6, 0x2b, 0x4f, 0x49, 0x38, 0xb9, 0x5d, 0xc6, 0xb3, 0x82, 0x23, 0x90, 0xf7, 0xd7,
	0xd1, 0x3d, 0x16, 0x18, 0x38, 0xa3, 0xbf, 0xb2, 0xee, 0xe1, 0x8d, 0x0c, 0xa4, 0x3d, 0x47, 0x37,
	0xdd, 0x3d, 0xcb, 0xe9, 0x29, 0x5f, 0x81, 0x85, 0xb2, 0x63, 0xd9, 0x1f, 0x89, 0x10, 0x50, 0xbe,
	0x13, 0x87, 0x85, 0x46, 0xdf, 0x63, 0xb6, 0xe9, 0x59, 0xbd, 0x4f, 0xcf, 0xfc, 0xdd, 0xe6, 0xf1,
	0x86, 0x29, 0xe8, 0xaf, 0x2c, 0xda, 0xf0, 0xe1, 0xea, 0xae, 0xe1, 0xbc, 0x9e, 0xc4, 0x54, 0xf3,
	0x7a, 0x94, 0x7f, 0x8d, 0xd3, 0x43, 0xa1, 0xac, 0x7b, 0xfa, 0x99, 0x33, 0x72, 0x2f, 0x3c, 0x23,
	0xd3, 0x48, 0xb2, 0x3a, 0x84, 0xe5, 0xb1, 0x71, 0x8f, 0xf8, 0x14, 0xe3, 0x1e, 0xc8, 0x1e, 0x09,
	0x79, 0xa0, 0xeb, 0xb0, 0x18, 0x24, 0x28, 0x0f, 0x05, 0x78, 0x17, 0x78, 0x96, 0x72, 0xa0, 0x2c,
	0x6e, 0x02, 0xea, 0xe9, 0x4f, 0xc8, 0x9e, 0xd3, 0x85, 0x5d, 0x7b, 0x76, 0xb0, 0x57, 0xee, 0xe9,
	0x4f, 0x08, 0x5f, 0x07, 0x9b, 0xb7, 0x05, 0xb3, 0x3d, 0xab, 0xc3, 0x42, 0xbd, 0xb9, 0xb5, 0x77,
	0xa2, 0x9e, 0x3d, 0xc2, 0x24, 0xad, 0x6e, 0x59, 0x1d, 0xac, 0x52, 0x6c, 0xca, 0x8b, 0x30, 0x4b,
	0xbe, 0xd0, 0x3c, 0xa4, 0xb7, 0xef, 0x57, 0xd4, 0x07, 0x6a, 0xb5, 0xc5, 0xb3, 0x1c, 0x8b, 0x8d,
	0x46, 0xa5, 0x5e, 0x96, 0x25, 0xe5, 0x1a, 0xdd, 0x77, 0xac, 0x3d, 0x57, 0x30, 0xc6, 0x7b, 0xdb,
	0x95, 0x9f, 0x48, 0xb0, 0xd8, 0xb2, 0xfa, 0xed, 0xc7, 0x4f, 0xb7, 0x49, 0x2f, 0x60, 0x49, 0x8c,
	0x67, 0x77, 0x3c, 0x3a, 0xbb, 0x95, 0x5f, 0x48, 0x70, 0x49, 0xc5, 0x3d, 0xeb, 0x50, 0x58, 0xfb,
	0x1f, 0xc1, 0x80, 0x0e, 0x20, 0x37, 0x58, 0xe3, 0x86, 0xb9, 0x67, 0x4d, 0x75, 0x75, 0xcf, 0x07,
	0xb8, 0xab, 0xe6, 0x9e, 0xa5, 0xfc, 0x3c, 0x07, 0xf1, 0x96, 0x6e, 0xf3, 0x8b, 0x05, 0x52, 0x70,
	0xb1, 0xe0, 0x0a, 0xd3, 0x95, 0xc5, 0xa3, 0xdc, 0xd3, 0xed, 0xd1, 0x8b, 0x04, 0xf1, 0x21, 0x7f,
	0xf5, 0x73, 0x00, 0xdd, 0x8e, 0x6e, 0x6b, 0x7d, 0x17, 0x3b, 0x4c, 0xc4, 0xa5, 0xd5, 0x34, 0x81,
	0xec, 0x10, 0x00, 0x51, 0x75, 0x68, 0xf1, 0xbe, 0x63, 0xf5, 0x6d, 0x26, 0x9c, 0xd2, 0x2a, 0x6d,
	0x71, 0x9b, 0x42, 0xd0, 0x35, 0x90, 0x69, 0x05, 0xbd, 0xd3, 0x33, 0x4c, 0x8e, 0x65, 0x8e, 0xd6,
	0xca, 0x11, 0x78, 0x91, 0x80, 0x19, 0xaa, 0xeb, 0xb0, 0x28, 0xd4, 0xe4, 0x08, 0x93, 0xb4, 0xea,
	0x42, 0x50, 0x95, 0x63, 0x7d, 0x08, 0xa9, 0xce, 0x2e, 0xc7, 0x96, 0x9a, 0x40, 0xec, 0xb6, 0x74,
	0x7b, 0xb5, 0xbc, 0x4b, 0xfb, 0x65, 0x06, 0x7a, 0xb2, 0xc3, 0xbe, 0xd0, 0xc7, 0x20, 0xa7, 0x1f,
	0xb9, 0x9a, 0xde, 0x6e, 0x5b, 0x7d, 0xd3, 0x23, 0x1c, 0xc9, 0x32, 0xc5, 0x48, 0x3f, 0x72, 0x8b,
	0x0c, 0x38, 0xf6, 0x7a, 0xc5, 0xfc, 0xb8, 0xeb, 0x15, 0x1f, 0x83, 0x9c, 0x17, 0x8c, 0x88, 0x56,
	0xe3, 0x89, 0x01, 0x1e, 0x1f, 0xce, 0xb8, 0x9b, 0x16, 0x0b, 0x91, 0x6c, 0xe8, 0x4d, 0x40, 0x5d,
	0xdd, 0xf5, 0x34, 0x6a, 0x19, 0x1b, 0xb8, 0xc3, 0x70, 0xc8, 0x67, 0xef, 0x16, 0xd2, 0x6a, 0x8b,
	0x37, 0xa2, 0x98, 0xae, 0x40, 0x8a, 0xdd, 0x60, 0x30, 0x3a, 0xf9, 0x3c, 0x5b, 0x21, 0xf4, 0x9b,
	0x2d, 0x02, 0xe1, 0x72, 0xc3, 0xe2, 0xf0, 0x65, 0x0d, 0x1d, 0xe6, 0xdd, 0xfe, 0x6e, 0x90, 0x21,
	0xe5, 0xe6, 0xd1, 0xf9, 0x95, 0xf7, 0x30, 0x46, 0xf4, 0x22, 0x64, 0xb1, 0xd9, 0xb1, 0x2d, 0xc3,
	0xf4, 0xb4, 0x8e, 0xe9, 0xd2, 0xab, 0x0f, 0x69, 0x35, 0xe3, 0xc3, 0xca, 0xa6, 0x8b, 0xd6, 0x60,
	0x25, 0xa8, 0xc2, 0x91, 0x32, 0x7a, 0x9f, 0xa1, 0x75, 0x97, 0xfc, 0xc2, 0x26, 0x2b, 0xa3, 0x94,
	0x2f, 0x41, 0x42, 0xff, 0x80, 0x0c, 0xf8, 0x59, 0x96, 0x6a, 0xaf, 0x7f, 0x50, 0xed, 0xa0, 0x57,
	0x61, 0xd9, 0xc1, 0x1d, 0xf7, 0xb1, 0xb1, 0x47, 0x10, 0xb5, 0x1d, 0xec, 0x31, 0x3c, 0x97, 0x99,
	0x6e, 0xed, 0x97, 0x35, 0x69, 0x91, 0x7f, 0xaf, 0x83, 0x8a, 0x2b, 0xbd, 0xdd, 0xc6, 0xae, 0xcb,
	0x66, 0x7a, 0x99, 0x05, 0x3c, 0x08, 0xbc, 0x48, 0xc1, 0x74, 0xae, 0xf7, 0x60, 0xde, 0x30, 0x5d,
	0x4f, 0x37, 0xdb, 0x98, 0xd9, 0xad, 0x2b, 0xf4, 0x28, 0x28, 0x46, 0x64, 0x15, 0xa3, 0xa0, 0xca,
	0x31, 0x31, 0xb7, 0x9d, 0x21, 0x7c, 0x91, 0x19, 0x33, 0xad, 0x0e, 0xd6, 0xe8, 0x82, 0xcd, 0x5f,
	0xa2, 0xd9, 0x0e, 0x69, 0x02, 0x29, 0x11, 0x00, 0xca, 0x43, 0xd2, 0xee, 0x3b, 0xb6, 0xe5, 0xe2,
	0xfc, 0x15, 0x36, 0xd5, 0xfc, 0x13, 0x35, 0x20, 0xe1, 0x7a, 0x44, 0xbb, 0x2c, 0x50, 0xc2, 0xde,
	0x8c, 0xbc, 0xad, 0x6a, 0xc6, 0x1e, 0x6e, 0x1f, 0xb7, 0x89, 0xf6, 0x45, 0x11, 0x85, 0xac, 0xf4,
	0xe7, 0xa6, 0x60, 0xa5, 0xa3, 0x67, 0x21, 0x7d, 0x64, 0x39, 0x07, 0x54, 0x42, 0xe4, 0x9f, 0x67,
	0x8b, 0x31, 0x00, 0xa0, 0xaf, 0xc0, 0x0a, 0xb5, 0x90, 0x34, 0x6a, 0xed, 0x05, 0x09, 0xac, 0x6e,
	0xfe, 0x45, 0xba, 0x28, 0x37, 0xa3, 0x0f, 0x88, 0x60, 0xa3, 0xfa, 0x32, 0xcf, 0x7d, 0xe5, 0x22,
	0x03, 0x75, 0x47, 0x0a, 0xd0, 0x2a, 0x2c, 0x05, 0x4b, 0xa7, 0xdd, 0xed, 0xbb, 0x1e, 0x76, 0xc8,
	0xea, 0x52, 0x58, 0x5e, 0x8c, 0x5f, 0x54, 0x62, 0x25, 0xd5, 0x4e, 0xe1, 0x31, 0x64, 0x1a, 0xd8,
	0xe9, 0x19, 0xae, 0x4b, 0x57, 0xf9, 0x23, 0xc8, 0xd8, 0x83, 0x4f, 0x6a, 0xfa, 0xe7, 0xd6, 0x3e,
	0x13, 0x4d, 0x4d, 0x08, 0xda, 0xab, 0x22, 0xae, 0xc2, 0x13, 0xc8, 0x8a, 0x02, 0x6f, 0x8c, 0x9f,
	0x4a, 0x0d, 0xfb, 0xa9, 0xde, 0x8a, 0xcc, 0x28, 0x61, 0x24, 0x82, 0xa3, 0xaa, 0xf0, 0x4d, 0x09,
	0x2e, 0x9f, 0xc0, 0xc3, 0x69, 0x7b, 0xcb, 0x46, 0xfc, 0x1e, 0x81, 0xb7, 0xec, 0x16, 0xa4, 0x83,
	0x85, 0x89, 0xb2, 0x90, 0xa2, 0x91, 0x1e, 0x76, 0xdd, 0x44, 0x48, 0x66, 0x91, 0xc4, 0xe0, 0x74,
	0x0c, 0x2d, 0xc2, 0x3c, 0x8f, 0x08, 0xf1, 0x04, 0x97, 0xf8, 0x9d, 0xd9, 0xd4, 0x0b, 0xf2, 0xd5,
	0x3b, 0xb3, 0xa9, 0xab, 0xf2, 0x8b, 0xca, 0x1f, 0x48, 0xf0, 0x82, 0x87, 0x7b, 0xb6, 0xe5, 0xe8,
	0xce, 0xb1, 0x46, 0x4f, 0x0d, 0x2a, 0xe8, 0xdb, 0x0e, 0xa6, 0xf6, 0xae, 0xde, 0x75, 0x91, 0x02,
	0xf3, 0x5c, 0x28, 0x10, 0xe5, 0x36, 0x38, 0x91, 0x33, 0x0c, 0x78, 0x17, 0x1f, 0x57, 0x3b, 0x54,
	0x17, 0x65, 0x62, 0x66, 0x50, 0x95, 0x9f, 0xd1, 0x0b, 0xac, 0xa0, 0xe8, 0xd7, 0x26, 0x66, 0xbb,
	0x8b, 0x29, 0x8f, 0x35, 0xcf, 0x3a, 0xc0, 0xbe, 0x27, 0x25, 0xcb, 0x81, 0x2d, 0x02, 0x53, 0xfe,
	0x3b, 0x01, 0x32, 0xcf, 0x1c, 0xd6, 0x6d, 0x5f, 0xe3, 0x39, 0x02, 0x99, 0x10, 0x2b, 0x52, 0xc7,
	0x9d, 0x5a, 0xb5, 0x48, 0x3c, 0x3e, 0x63, 0xc4, 0xea, 0x02, 0xa9, 0x50, 0x12, 0x58, 0x30, 0xa9,
	0xe6, 0xb1, 0x0c, 0x09, 0x51, 0xe9, 0x60, 0x1f, 0xe8, 0x12, 0xcc, 0x85, 0x74, 0x0d, 0xfe, 0x45,
	0x14, 0x91, 0x51, 0x15, 0x03, 0xf4, 0x81, 0x7a, 0xf1, 0x22, 0x64, 0xc7, 0x68, 0x16, 0xac, 0x11,
	0xd7, 0x2a, 0x46, 0x84, 0x73, 0xea, 0xc3, 0x10, 0xce, 0xe9, 0x61, 0xe1, 0x3c, 0xaa, 0x82, 0xc0,
	0x18, 0x15, 0xe4, 0x5d, 0x48, 0x1d, 0xda, 0x6d, 0xa6, 0x4f, 0x32, 0xb7, 0x7b, 0x25, 0x9a, 0xe5,
	0x39, 0xb4, 0x40, 0x56, 0xef, 0x37, 0x4a, 0x44, 0x83, 0x54, 0x93, 0x87, 0x76, 0x9b, 0xfc, 0x10,
	0x0f, 0x89, 0x6c, 0xf8, 0x90, 0x10, 0x45, 0xfa, 0xfc, 0x14, 0x44, 0x7a, 0x61, 0x0b, 0x92, 0xbc,
	0x7b, 0xa2, 0xb8, 0xea, 0x1f, 0xf8, 0x8a, 0xab, 0xfe, 0x01, 0x59, 0x23, 0x6e, 0x7f, 0xd7, 0xc4,
	0x9e, 0x90, 0x4d, 0xc1, 0x00, 0xd5, 0x0e, 0x31, 0x62, 0x28, 0x13, 0xfc, 0xd5, 0x93, 0x20, 0xb4,
	0x77, 0x94, 0x07, 0xb0, 0x28, 0x0c, 0x8f, 0x1b, 0x3c, 0x1b, 0x10, 0xf7, 0x74, 0x9b, 0xaf, 0xf9,
	0x57, 0xa3, 0xd2, 0xab, 0x92, 0xc6, 0xca, 0x27, 0x60, 0xfe, 0x36, 0xf6, 0x84, 0x5d, 0x35, 0x88,
	0x5c, 0x4a, 0x62, 0xe4, 0xb2, 0x45, 0x1d, 0xe0, 0xd3, 0xee, 0xfd, 0xd3, 0xb0, 0xc4, 0xb0, 0x8e,
	0xe4, 0x4d, 0x8d, 0xa3, 0xe1, 0xdf, 0x24, 0x58, 0x0e, 0x57, 0xe7, 0xa4, 0x74, 0x86, 0x72, 0x89,
	0x6a, 0x51, 0x73, 0x89, 0x46, 0x50, 0x7e, 0xe4, 0x69, 0x44, 0xef, 0xc0, 0x42, 0xcd, 0x70, 0x09,
	0x61, 0x01, 0x57, 0x5e, 0x01, 0x64, 0x98, 0xcc, 0xc7, 0xea, 0x59, 0xbd, 0x5d, 0xd7, 0xb3, 0x4c,
	0xcc, 0x46, 0x9c, 0x52, 0x17, 0x79, 0x49, 0x2b, 0x28, 0x50, 0x1e, 0x32, 0xc7, 0x3c, 0xc3, 0x30,
	0xc8, 0x78, 0xa3, 0xf7, 0x3b, 0x27, 0xc9, 0x78, 0x23, 0x93, 0xc6, 0x6e, 0x84, 0xfe, 0x38, 0x06,
	0x32, 0xcb, 0x20, 0xfa, 0x65, 0x90, 0xc6, 0xe3, 0x43, 0xed, 0x67, 0xda, 0x80, 0x82, 0xbc, 0x9a,
	0x1d, 0x96, 0x57, 0x23, 0x62, 0x33, 0x71, 0x21, 0x62, 0x53, 0x59, 0x82, 0x45, 0x81, 0x8f, 0x3c,
	0xfb, 0xee, 0x4f, 0x25, 0x90, 0xcb, 0x98, 0x26, 0xc5, 0xff, 0xd2, 0x72, 0x97, 0x50, 0x2e, 0xd0,
	0xc8, 0x29, 0xa7, 0x3e, 0x19, 0x67, 0x1f, 0x8f, 0x95, 0x26, 0xa1, 0xe6, 0x08, 0xe4, 0x41, 0x4d,
	0xde, 0xfa, 0x5f, 0x24, 0x40, 0x3e, 0xcf, 0x1a, 0x8e, 0x65, 0x63, 0xc7, 0x33, 0x30, 0xd5, 0x37,
	0x08, 0x06, 0x6a, 0x8d, 0x50, 0x33, 0x84, 0xeb, 0x1b, 0x9e, 0x6e, 0x53, 0xef, 0x0f, 0xb1, 0x41,
	0x5e, 0x85, 0x65, 0x22, 0x34, 0x87, 0x8d, 0x25, 0xde, 0x27, 0x3a, 0xb4, 0xdb, 0x95, 0xb0, 0xa9,
	0x34, 0x30, 0x93, 0xe2, 0x82, 0x99, 0x24, 0xea, 0xba, 0xbe, 0xfe, 0xe2, 0x27, 0xa8, 0x0d, 0x74,
	0x5d, 0x66, 0x25, 0xf1, 0x9c, 0xf1, 0x71, 0xba, 0x71, 0xfa, 0x04, 0xdd, 0x58, 0x79, 0x15, 0xe4,
	0xa2, 0xf7, 0x18, 0x9b, 0xba, 0x30, 0xbc, 0x90, 0xea, 0x2f, 0x0d, 0xa9, 0xfe, 0xca, 0x6f, 0xc4,
	0x09, 0x4f, 0xd8, 0xa3, 0x11, 0x02, 0x57, 0x45, 0x05, 0x44, 0x3a, 0x45, 0x01, 0x19, 0x4e, 0xd5,
	0x13, 0xce, 0xbf, 0x78, 0xf8, 0xfc, 0x1b, 0xb5, 0xeb, 0x67, 0xc7, 0xd8, 0xf5, 0xa2, 0x41, 0x9d,
	0x08, 0x1b, 0xd4, 0x7b, 0x90, 0x0b, 0x78, 0x61, 0x3b, 0x96, 0xed, 0xf2, 0x30, 0xc5, 0x17, 0x26,
	0xda, 0x33, 0x03, 0x06, 0xa9, 0xf3, 0x8e, 0x00, 0x73, 0xd1, 0xbb, 0x90, 0xd5, 0x29, 0x0f, 0x79,
	0x2f, 0xc9, 0x09, 0xae, 0xf5, 0x0e, 0x4f, 0x82, 0x9a, 0xd1, 0x03, 0x88, 0xb8, 0xe2, 0x53, 0xe2,
	0x92, 0xa5, 0x39, 0x83, 0xc2, 0x4c, 0x4c, 0xf1, 0x14, 0x7c, 0x05, 0x96, 0xcb, 0xd8, 0x19, 0x9d,
	0xe6, 0x13, 0x8e, 0xc1, 0xcb, 0xb0, 0x32, 0x54, 0x9d, 0xef, 0xa0, 0xdf, 0x95, 0x20, 0xd9, 0x62,
	0x7e, 0xac, 0x13, 0xda, 0x06, 0x17, 0xf1, 0x63, 0xc2, 0x45, 0xfc, 0x21, 0x1b, 0x2d, 0x3e, 0x3d,
	0x1b, 0x4d, 0x79, 0x17, 0x96, 0x03, 0xb5, 0x85, 0x90, 0xe5, 0x8f, 0x6c, 0x13, 0x66, 0x89, 0x56,
	0xcb, 0xd9, 0x16, 0x59, 0xd5, 0xa2, 0xa8, 0x28, 0x06, 0x65, 0x1d, 0x56, 0x86, 0x7a, 0xe0, 0x13,
	0x53, 0x80, 0x94, 0xad, 0xbb, 0xee, 0x91, 0xe5, 0xf8, 0x2c, 0x08, 0xbe, 0x89, 0xda, 0xc1, 0x8f,
	0x46, 0xaa, 0x49, 0x9f, 0xc1, 0xef, 0x5d, 0x58, 0x0e, 0xd7, 0xe6, 0x3d, 0xdc, 0xf1, 0xd5, 0x79,
	0x76, 0x9a, 0x4e, 0x36, 0x0a, 0x86, 0x82, 0x30, 0x2a, 0x38, 0x09, 0x2e, 0x86, 0x51, 0x97, 0xfd,
	0xac, 0xdf, 0x21, 0x46, 0x91, 0xae, 0x03, 0x51, 0x7e, 0x61, 0x5d, 0x0f, 0xf5, 0xc0, 0xbb, 0xde,
	0x87, 0x67, 0x54, 0xec, 0x62, 0x9f, 0xb5, 0x0d, 0x3e, 0x3f, 0xd3, 0xa7, 0xe0, 0x4d, 0x78, 0x76,
	0x7c, 0x47, 0x4f, 0xb1, 0x58, 0x7e, 0x28, 0x41, 0xb6, 0x29, 0xb8, 0xee, 0x2e, 0x26, 0xf3, 0xe3,
	0xa5, 0xc0, 0xe3, 0xb8, 0xcb, 0x4e, 0x91, 0x18, 0x37, 0x83, 0x03, 0x60, 0xb5, 0x83, 0x5e, 0x86,
	0x05, 0xa1, 0x92, 0x70, 0x11, 0x23, 0x37, 0x00, 0xd3, 0x84, 0xe8, 0xaf, 0x81, 0xdc, 0xf4, 0x21,
	0xa7, 0xaf, 0x6e, 0x61, 0x34, 0xb1, 0xa9, 0x8d, 0x86, 0xa8, 0x07, 0x42, 0xff, 0x7c, 0xb6, 0xd7,
	0xd9, 0xb3, 0x24, 0x22, 0x2f, 0xc5, 0xe4, 0x78, 0x46, 0x9c, 0xff, 0x28, 0xc9, 0x1c, 0xa5, 0xce,
	0x55, 0xbe, 0x0a, 0x57, 0xc6, 0x34, 0xe2, 0xd3, 0xa6, 0x0d, 0xbb, 0x69, 0xd9, 0x4e, 0x8c, 0x96,
	0xd3, 0x22, 0xa2, 0x1e, 0x72, 0xd2, 0x2a, 0x5f, 0x97, 0x00, 0xed, 0x98, 0xee, 0x47, 0xc9, 0xca,
	0x15, 0x58, 0x0a, 0x51, 0xc0, 0x99, 0xf9, 0x73, 0x09, 0x3e, 0xee, 0xef, 0xe7, 0xdd, 0x2e, 0x1e,
	0xbe, 0x25, 0x44, 0x4e, 0x35, 0x4e, 0xec, 0xff, 0xf6, 0x87, 0x24, 0x94, 0x97, 0x89, 0xae, 0xe9,
	0x9f, 0x77, 0xfe, 0xa8, 0xc6, 0xbc, 0x28, 0xa3, 0x7c, 0x1e, 0x16, 0x68, 0x6e, 0xd8, 0x99, 0x47,
	0x28, 0x5a, 0x86, 0xc4, 0xfb, 0xa4, 0xa6, 0xaf, 0x95, 0xd2, 0x0f, 0xe5, 0x3e, 0xbf, 0x2e, 0x25,
	0x9e, 0xef, 0x79, 0x48, 0xfa, 0xf9, 0x35, 0x6c, 0x61, 0xfa, 0x9f, 0x84, 0x02, 0xc7, 0x3a, 0x0a,
	0xde, 0xca, 0x21, 0xbf, 0x09, 0x5e, 0xec, 0x38, 0x96, 0xe3, 0x1b, 0xef, 0xf4, 0x43, 0xd1, 0x20,
	0x57, 0x79, 0x82, 0xdb, 0x67, 0x93, 0xf5, 0x3c, 0x8d, 0x4a, 0x78, 0xb8, 0x87, 0x4d, 0xcf, 0x47,
	0x2c, 0x40, 0xd0, 0x25, 0x98, 0x6b, 0x5b, 0xbd, 0x9e, 0xc1, 0x2e, 0x58, 0xa4, 0x54, 0xfe, 0xa5,
	0xfc, 0x7a, 0x1c, 0x16, 0x82, 0x1e, 0x38, 0xe1, 0x5f, 0x86, 0xa4, 0x83, 0xdd, 0x7e, 0xd7, 0xf3,
	0x77, 0x45, 0xb4, 0x1c, 0xe7, 0x21, 0x74, 0xab, 0x2a, 0xc5, 0xa5, 0xfa, 0x38, 0xa9, 0x0a, 0xfa,
	0x44, 0x63, 0x83, 0xf5, 0x7d, 0x60, 0x4f, 0x2a, 0xe4, 0x93, 0x27, 0xfd, 0xf6, 0x0c, 0x4f, 0x13,
	0x79, 0x91, 0x61, 0x30, 0x5a, 0xa5, 0xf0, 0x4f, 0x12, 0xcc, 0x31, 0x8c, 0x34, 0x9c, 0xa6, 0xbb,
	0x9e, 0x66, 0x98, 0x2e, 0x76, 0x3c, 0xdc, 0xf1, 0x99, 0x12, 0x57, 0x73, 0x04, 0x5e, 0xe5, 0x60,
	0xa6, 0x9e, 0x87, 0x6b, 0x8a, 0xbd, 0x2f, 0x8a, 0x95, 0x19, 0x1d, 0x2f, 0xc1, 0x3c, 0x99, 0x14,
	0x4d, 0xdf, 0xdb, 0xc3, 0x6d, 0x0f, 0x33, 0x5d, 0x3f, 0xae, 0x66, 0x09, 0xb0, 0xc8, 0x61, 0x54,
	0x87, 0x17, 0x2b, 0x71, 0xa4, 0xbe, 0xce, 0x2f, 0x54, 0x65, 0x48, 0x9f, 0x03, 0xc0, 0x4f, 0x70,
	0x9b, 0x57, 0x63, 0x4a, 0x70, 0x9a, 0x40, 0x68, 0xb1, 0xf2, 0x17, 0x12, 0xa0, 0xfb, 0x03, 0x73,
	0xe3, 0x8c, 0xf9, 0x9e, 0x92, 0xdd, 0xf2, 0x19, 0xc8, 0x13, 0xec, 0x63, 0x43, 0x3c, 0x6c, 0x20,
	0x2b, 0x1e, 0x99, 0xca, 0xe1, 0x28, 0x8f, 0xf2, 0x0d, 0x09, 0x96, 0x42, 0xd4, 0x0e, 0x16, 0xbd,
	0xdb, 0xa7, 0x1e, 0x5a, 0xee, 0x5e, 0xf0, 0x3f, 0xd1, 0x27, 0x60, 0x21, 0x44, 0x71, 0x70, 0x50,
	0xcd, 0x0b, 0xc4, 0x56, 0x3b, 0x64, 0x56, 0x43, 0xf5, 0x3a, 0xa6, 0x7f, 0x2d, 0x2d, 0x27, 0x54,
	0x2c, 0x9b, 0xae, 0xf2, 0xf7, 0x12, 0x2c, 0x6d, 0x19, 0xfb, 0x8e, 0xee, 0x61, 0x7a, 0xab, 0xf8,
	0x02, 0xc5, 0xd6, 0x2e, 0xa4, 0x83, 0xd0, 0x32, 0x97, 0x56, 0xd3, 0x89, 0x58, 0x0f, 0xd0, 0x2a,
	0x3f, 0x0e, 0x6e, 0x03, 0x8e, 0x44, 0xe8, 0x2f, 0x60, 0x44, 0x8f, 0x46, 0x47, 0x74, 0xae, 0x3c,
	0x1a, 0x61, 0x20, 0x5f, 0x26, 0xba, 0x99, 0x6d, 0x39, 0x9e, 0x8a, 0xdb, 0x96, 0xd3, 0x71, 0x1f,
	0x38, 0x86, 0xe7, 0x61, 0xf3, 0x8c, 0xab, 0x8d, 0x2f, 0xc3, 0x82, 0xc3, 0xea, 0x6b, 0x47, 0xac,
	0x01, 0x5d, 0x1f, 0x71, 0x35, 0xe7, 0x84, 0xd0, 0x28, 0xdf, 0x96, 0xe0, 0xd9, 0xaa, 0xd9, 0x76,
	0xa8, 0x64, 0xa3, 0x54, 0xd4, 0xfb, 0x3d, 0xd5, 0x3a, 0xba, 0xc8, 0x63, 0xeb, 0x0a, 0xa4, 0xcc,
	0x7e, 0x4f, 0xe3, 0x52, 0x9b, 0x50, 0x95, 0x34, 0x59, 0xa7, 0xca, 0xf7, 0x24, 0x78, 0xbe, 0xf4,
	0x18, 0xb7, 0x0f, 0x44, 0x6d, 0xe0, 0x69, 0x9c, 0x92, 0x48, 0x83, 0xac, 0xa8, 0x33, 0x4c, 0xe3,
	0xe8, 0x0f, 0x21, 0x54, 0x7e, 0x90, 0x80, 0x17, 0x4e, 0x24, 0x8d, 0x6f, 0xd8, 0x1c, 0xc4, 0xac,
	0x03, 0xbe, 0x57, 0x63, 0xd6, 0x01, 0x72, 0xc9, 0x06, 0xee, 0xf5, 0x74, 0x7a, 0xc2, 0x91, 0x55,
	0xf1, 0x28, 0xda, 0xa9, 0x7c, 0x7a, 0x77, 0xab, 0x4d, 0x86, 0x9b, 0x27, 0x1a, 0xf0, 0x9e, 0x0a,
	0x3f, 0x8b, 0x41, 0xb2, 0xcc, 0xef, 0x9c, 0x7e, 0x1a, 0x10, 0x8d, 0x56, 0xb2, 0x67, 0xad, 0x34,
	0xfc, 0xc4, 0x70, 0x3d, 0x5f, 0x98, 0xc8, 0xa4, 0x84, 0x0d, 0xb5, 0x42, 0xe1, 0xf4, 0xae, 0x3b,
	0xcb, 0x64, 0x75, 0x1c, 0xdc, 0x66, 0xea, 0x53, 0xca, 0xcf, 0x40, 0xa5, 0x20, 0x7a, 0x3f, 0x5f,
	0xf7, 0x74, 0xad, 0xad, 0x7b, 0x7a, 0xd7, 0xda, 0xf7, 0x31, 0xb2, 0x73, 0x70, 0x91, 0x14, 0x95,
	0x58, 0x09, 0x47, 0xb9, 0x06, 0x2b, 0xf8, 0x89, 0x87, 0x1d, 0x53, 0xef, 0xb2, 0x77, 0x92, 0xfc,
	0x16, 0xec, 0x12, 0xec, 0x92, 0x5f, 0x48, 0x97, 0x1e, 0x6f, 0xf3, 0x3a, 0x5c, 0x0a, 0xda, 0x84,
	0x09, 0x4f, 0xd0, 0x46, 0xcb, 0x7e, 0x69, 0x88, 0x78, 0x13, 0x96, 0x0d, 0x93, 0x53, 0xae, 0x8d,
	0x5c, 0xbb, 0x38, 0xd7, 0x76, 0x5c, 0x0a, 0x10, 0x0f, 0x92, 0xf2, 0x0b, 0xdf, 0xa1, 0xf6, 0xc8,
	0x60, 0x02, 0xc6, 0x84, 0x1c, 0xdf, 0x0b, 0x87, 0x1c, 0x5b, 0x53, 0x9d, 0x7c, 0x3e, 0xc5, 0x62,
	0x2c, 0xf2, 0x3e, 0xe4, 0x4b, 0x96, 0x7d, 0x3c, 0x56, 0xb3, 0x7f, 0x1e, 0x32, 0x7b, 0x8e, 0xd5,
	0xd3, 0x42, 0x7b, 0x27, 0x4d, 0x40, 0x2d, 0xba, 0x7f, 0x0a, 0x34, 0x4b, 0x35, 0xe4, 0x24, 0x4c,
	0x7a, 0x16, 0x2d, 0x53, 0x9e, 0x81, 0x2b, 0x63, 0xf0, 0x32, 0x3a, 0xae, 0xff, 0x97, 0x04, 0xf2,
	0xf0, 0xdb, 0x09, 0x08, 0x41, 0xae, 0xb9, 0xae, 0x35, 0xb7, 0x77, 0xd4, 0x52, 0x45, 0x6b, 0x14,
	0x5b, 0x9b, 0xf2, 0x0c, 0xba, 0x0c, 0x4b, 0xcd, 0x75, 0xad, 0x5c, 0x69, 0xb6, 0xaa, 0xf5, 0x22,
	0xbd, 0x4f, 0x46, 0x0b, 0x24, 0xea, 0x88, 0xdf, 0xae, 0xed, 0x6c, 0xd5, 0xb5, 0x72, 0xe5, 0x56,
	0xb5, 0x4e, 0xef, 0x9a, 0x35, 0xe5, 0x18, 0x69, 0x50, 0xdf, 0xd9, 0xd2, 0x6e, 0x55, 0x6b, 0xc2,
	0x25, 0xb4, 0x26, 0x7b, 0xa8, 0xaf, 0xdc, 0xd8, 0x69, 0xca, 0xb3, 0x28, 0x07, 0x40, 0xef, 0x26,
	0x68, 0xf5, 0xe2, 0x56, 0x85, 0x3e, 0xa0, 0x97, 0x65, 0xdf, 0xcd, 0xd2, 0x66, 0x65, 0xab, 0x28,
	0xcf, 0xa1, 0x3c, 0x2c, 0x0f, 0x2e, 0xb0, 0xdd, 0xad, 0x3c, 0xd2, 0xee, 0x17, 0x6b, 0x3b, 0x95,
	0x26, 0xbb, 0xb2, 0xd6, 0x5c, 0x67, 0xf7, 0xe6, 0x18, 0x25, 0x29, 0xd2, 0xbc, 0x5c, 0x6c, 0x15,
	0x35, 0xb5, 0x52, 0xaa, 0xd4, 0x4b, 0x8f, 0xe4, 0xf4, 0xe0, 0x49, 0x4a, 0x40, 0x2b, 0xb0, 0xd8,
	0x5c, 0x17, 0x6e, 0xc3, 0xd1, 0x36, 0x99, 0xeb, 0x46, 0x78, 0xf8, 0x27, 0x3f, 0x3a, 0xf8, 0x3c,
	0x14, 0xd4, 0x4a, 0xa3, 0x52, 0x6c, 0x55, 0xca, 0xda, 0xc8, 0x78, 0xe5, 0x18, 0xba, 0x0a, 0xcf,
	0x06, 0xe5, 0x63, 0x48, 0x96, 0xe3, 0xd7, 0x7f, 0x4b, 0x82, 0xe5, 0x71, 0xee, 0xec, 0x70, 0xa8,
	0x23, 0x03, 0x49, 0xb5, 0xb8, 0xfe, 0xda, 0xff, 0x79, 0x58, 0x63, 0xf1, 0x8e, 0x72, 0x73, 0xed,
	0x61, 0x8d, 0x3f, 0x75, 0xd8, 0x5c, 0xfb, 0xec, 0xc3, 0x1a, 0xe7, 0x60, 0xe9, 0xb5, 0x9a, 0x3c,
	0x4b, 0xa1, 0xa5, 0xd7, 0x08, 0x94, 0xbd, 0x73, 0x58, 0x5a, 0xab, 0xc9, 0x73, 0x0c, 0x4a, 0xeb,
	0x26, 0x09, 0x0a, 0xb5, 0xb8, 0xfe, 0xb0, 0x26, 0xa7, 0x08, 0x58, 0x2d, 0xae, 0xbf, 0xfe, 0xb0,
	0x26, 0xa7, 0xaf, 0x3f, 0xa6, 0x4e, 0x2e, 0xda, 0xfd, 0x32, 0xc8, 0xad, 0x62, 0x43, 0xdd, 0xde,
	0xde, 0xd2, 0xd4, 0x4a, 0xb9, 0xb9, 0x59, 0xbd, 0xd5, 0x92, 0x67, 0x08, 0x33, 0x37, 0x1e, 0x6d,
	0x0f, 0x20, 0x12, 0x99, 0x2d, 0x02, 0x29, 0xb6, 0x36, 0x2b, 0xf5, 0xa2, 0x1c, 0x23, 0xab, 0xc4,
	0x6f, 0xc7, 0x61, 0xf4, 0x92, 0xa2, 0x0f, 0x6b, 0x36, 0x8a, 0xea, 0x5d, 0x79, 0xf6, 0x7a, 0x1d,
	0x60, 0xe0, 0xd8, 0x22, 0xab, 0x85, 0x8f, 0x55, 0x6b, 0x54, 0xd4, 0xad, 0x2a, 0x7d, 0x4a, 0x91,
	0xdd, 0x83, 0x54, 0x2b, 0xc5, 0xb2, 0xb6, 0x5d, 0xaf, 0x3d, 0x62, 0x7d, 0xd1, 0x4f, 0x96, 0xb4,
	0x18, 0x23, 0xa3, 0x28, 0x96, 0xb7, 0xaa, 0x75, 0x39, 0xbe, 0xf6, 0xcf, 0x37, 0x61, 0x25, 0xfc,
	0x2e, 0xb1, 0xaf, 0xd6, 0x7d, 0x57, 0x02, 0x79, 0xf8, 0x71, 0x60, 0x54, 0x8e, 0x78, 0x86, 0x8c,
	0x7d, 0x5b, 0xb8, 0x30, 0xd9, 0x85, 0x71, 0x65, 0x06, 0xfd, 0x99, 0x04, 0x8b, 0x23, 0xd7, 0xec,
	0x51, 0xe5, 0xbc, 0xd7, 0xf4, 0x19, 0x55, 0xb7, 0xa6, 0x73, 0xdb, 0x5f, 0x99, 0x41, 0xdf, 0x97,
	0x20, 0x17, 0xbe, 0x3e, 0x8f, 0x36, 0x22, 0x21, 0x1f, 0x7b, 0x5b, 0xbf, 0x50, 0x3a, 0x17, 0x8e,
	0x80, 0xba, 0xdf, 0x96, 0x20, 0x17, 0xbe, 0x6c, 0x1f, 0x91, 0xba, 0xb1, 0x37, 0xf5, 0x27, 0x9f,
	0xd4, 0xef, 0x4a, 0xbe, 0x47, 0xd6, 0x07, 0xb2, 0x2b, 0xf0, 0xe8, 0x9d, 0x09, 0x42, 0xed, 0xa1,
	0xdb, 0xf3, 0x93, 0xd3, 0xe4, 0x10, 0xe1, 0x72, 0x68, 0x1d, 0x9c, 0x8f, 0xa4, 0x31, 0x17, 0xfa,
	0x0b, 0x27, 0xdc, 0x24, 0x50, 0x66, 0xd0, 0xb7, 0x25, 0x48, 0x07, 0x8f, 0x90, 0xa1, 0xb7, 0xa3,
	0x4f, 0xb6, 0xf0, 0x1a, 0x6e, 0xe1, 0xf3, 0x93, 0x36, 0x0f, 0x96, 0xc9, 0x13, 0x98, 0x63, 0xcf,
	0x96, 0xa1, 0x68, 0xe9, 0x69, 0xa1, 0xb7, 0xce, 0x0a, 0x91, 0x5f, 0x30, 0x11, 0x19, 0x71, 0xc7,
	0xda, 0x9d, 0x88, 0x11, 0xc2, 0xdb, 0x32, 0x93, 0x30, 0x42, 0x7c, 0x90, 0x45, 0x99, 0x41, 0x7f,
	0x2c, 0xc1, 0xc2, 0xd0, 0xb3, 0x24, 0xa8, 0x34, 0xc1, 0x86, 0x19, 0x7e, 0x8a, 0xa5, 0x50, 0x3e,
	0x1f, 0x92, 0x80, 0xc0, 0x0e, 0xa4, 0x83, 0xc7, 0x68, 0x22, 0xb2, 0x6b, 0xf8, 0x11, 0x9b, 0x53,
	0x96, 0xa7, 0x0d, 0x0b, 0x43, 0x69, 0xde, 0x11, 0xb9, 0x30, 0x3e, 0x49, 0xfc, 0x8c, 0x0d, 0x11,
	0x04, 0x52, 0xa2, 0x0e, 0x6c, 0x28, 0xf1, 0x26, 0xe2, 0x3a, 0x18, 0x49, 0x6c, 0x51, 0x66, 0xd0,
	0xef, 0x4b, 0x90, 0x15, 0xf3, 0x32, 0x22, 0x0a, 0x83, 0x31, 0x49, 0x25, 0x85, 0xe2, 0xb9, 0x93,
	0x42, 0x94, 0x19, 0xf4, 0xab, 0x12, 0xcc, 0xb1, 0xa2, 0x88, 0x3b, 0x35, 0x94, 0x64, 0x53, 0xb8,
	0x39, 0x51, 0xdb, 0x80, 0x8a, 0xdf, 0x94, 0x20, 0xe5, 0xe7, 0x76, 0xa0, 0xb7, 0x22, 0xbf, 0x41,
	0x2e, 0x24, 0x95, 0x14, 0xde, 0x9e, 0xb0, 0x75, 0x40, 0x0b, 0x59, 0x38, 0x41, 0x60, 0x29, 0xe2,
	0xc2, 0x19, 0x4e, 0x22, 0x89, 0xb8, 0x70, 0x46, 0x73, 0x27, 0x18, 0x39, 0x41, 0xb0, 0x29, 0x22,
	0x39, 0xc3, 0x59, 0x17, 0x11, 0xc9, 0x19, 0x4d, 0x88, 0x60, 0x33, 0xe5, 0x67, 0x3a, 0x44, 0x9c,
	0xa9, 0xa1, 0x54, 0x8a, 0x88, 0x33, 0x35, 0x92, 0x5e, 0x31, 0x83, 0x7e, 0x4f, 0x82, 0x8c, 0x10,
	0xc2, 0x46, 0x5f, 0x98, 0x48, 0xbf, 0x14, 0x28, 0x7a, 0x67, 0x72, 0x04, 0x01, 0x51, 0xdf, 0x93,
	0x60, 0x3e, 0x14, 0xcd, 0x46, 0xc5, 0x88, 0x4c, 0x1f, 0x0d, 0x9c, 0x17, 0x36, 0xce, 0x83, 0x22,
	0x44, 0x5a, 0x28, 0xb6, 0x1c, 0x91, 0xb4, 0x71, 0x91, 0xef, 0x88, 0xa4, 0x8d, 0x0d, 0x6d, 0x73,
	0xf1, 0x28, 0xc6, 0xa4, 0x23, 0x8a, 0xc7, 0x31, 0xc1, 0xef, 0x88, 0xe2, 0x71, 0x5c, 0x40, 0x3c,
	0x98, 0x4d, 0x21, 0xd4, 0x1b, 0x79, 0x36, 0x47, 0x03, 0xd1, 0x91, 0x67, 0x73, 0x5c, 0xa4, 0x99,
	0x91, 0x16, 0x0a, 0x80, 0x47, 0x24, 0x6d, 0x5c, 0x78, 0xbe, 0xb0, 0x71, 0x1e, 0x14, 0x01, 0x69,
	0x7f, 0x49, 0xcd, 0xeb, 0xd1, 0xf0, 0x34, 0xda, 0x8c, 0xb8, 0xc1, 0x4e, 0x0c, 0xa5, 0x17, 0xaa,
	0x53, 0xc0, 0x14, 0x92, 0xb1, 0x41, 0x78, 0x37, 0xa2, 0x8c, 0x1d, 0x0e, 0x4b, 0x47, 0x94, 0xb1,
	0xa3, 0x51, 0x65, 0x26, 0xd7, 0x84, 0x10, 0x69, 0x44, 0xb9, 0x36, 0x1a, 0xde, 0x8d, 0x28, 0xd7,
	0xc6, 0x45, 0x67, 0x99, 0xf5, 0x3c, 0x12, 0xb8, 0x8e, 0x68, 0x3d, 0x9f, 0x14, 0x2d, 0x8f, 0x68,
	0x3d, 0x9f, 0x18, 0x3f, 0x57, 0x66, 0xd0, 0xbb, 0x90, 0xe4, 0x4f, 0x00, 0xa0, 0x9b, 0xe7, 0x78,
	0x38, 0xe0, 0x14, 0xc5, 0x72, 0x17, 0x52, 0xfe, 0xf5, 0xec, 0x88, 0x07, 0xe0, 0xd0, 0xad, 0xee,
	0xd3, 0xfb, 0xf0, 0x2f, 0x61, 0x47, 0x3e, 0x64, 0x43, 0x77, 0xb7, 0x4f, 0xe9, 0xe3, 0xd7, 0x24,
	0xca, 0xaa, 0xb2, 0xee, 0xe9, 0xd1, 0x59, 0x25, 0xdc, 0x73, 0x2d, 0xbc, 0x35, 0x59, 0xe3, 0x60,
	0xca, 0xf6, 0x00, 0x06, 0xd7, 0x59, 0x51, 0xb4, 0xed, 0x33, 0x72, 0x0f, 0xf6, 0x94, 0x01, 0x13,
	0x81, 0x19, 0x7a, 0x6a, 0x25, 0xa2, 0xc0, 0x1c, 0xf7, 0xce, 0x55, 0x61, 0xe3, 0x3c, 0x28, 0x42,
	0x02, 0x28, 0x78, 0x60, 0x04, 0x45, 0x57, 0x61, 0xc5, 0xc7, 0x4a, 0x22, 0x0a, 0xa0, 0x91, 0x77,
	0x4d, 0x94, 0x19, 0xf4, 0x35, 0x78, 0xae, 0x81, 0x9d, 0x3d, 0xcb, 0xe9, 0x9d, 0xf0, 0xe6, 0xd8,
	0x34, 0x9e, 0x17, 0x3b, 0x65, 0xa6, 0xbe, 0x25, 0xc1, 0xd5, 0x80, 0x80, 0x93, 0xde, 0x3d, 0xbb,
	0x15, 0xf9, 0x3e, 0x43, 0x54, 0x32, 0x7e, 0x47, 0x82, 0xe7, 0x4f, 0x4f, 0x49, 0x41, 0xea, 0x44,
	0xe7, 0xe5, 0xa9, 0xf9, 0x2d, 0xa7, 0x10, 0x64, 0x02, 0x1a, 0xe8, 0x76, 0x81, 0xff, 0xed, 0xf3,
	0x13, 0x2a, 0x87, 0x67, 0xf7, 0x67, 0x88, 0xaa, 0x6c, 0x59, 0xdf, 0xbf, 0xc0, 0xae, 0x1e, 0x0d,
	0x54, 0x79, 0xd2, 0x51, 0xe4, 0xf7, 0xf2, 0x4f, 0x41, 0x4d, 0x4c, 0x16, 0x3f, 0x0d, 0x26, 0xa2,
	0x34, 0x1d, 0xca, 0xbe, 0x29, 0xbc, 0x3d, 0x61, 0xeb, 0x60, 0x67, 0x11, 0xa1, 0xcb, 0x33, 0x51,
	0x22, 0x0a, 0xdd, 0x70, 0xc2, 0x4d, 0x44, 0xa1, 0x3b, 0x94, 0xfc, 0xa2, 0xcc, 0xa0, 0x3f, 0x91,
	0xd8, 0x6d, 0x0a, 0xf1, 0x7f, 0x6a, 0x45, 0x74, 0xd0, 0x9f, 0xf0, 0xdf, 0xbf, 0x0a, 0x95, 0x73,
	0x62, 0x11, 0x35, 0x5c, 0x7e, 0x49, 0x48, 0xc8, 0xe9, 0x88, 0xa8, 0x0d, 0x8d, 0xe6, 0xae, 0x44,
	0xd4, 0x86, 0xc6, 0xa4, 0x93, 0x70, 0xd2, 0xd8, 0x6e, 0xfe, 0xa5, 0x23, 0xcd, 0xf4, 0x6f, 0x32,
	0x4c, 0x95, 0xb2, 0x53, 0x85, 0x75, 0x56, 0xcc, 0x77, 0x89, 0x68, 0xba, 0x8d, 0x49, 0x95, 0x99,
	0xc8, 0xef, 0x6b, 0xfb, 0x7e, 0xd6, 0x49, 0x3d, 0x8c, 0xe3, 0x93, 0x5c, 0x4e, 0x19, 0xf8, 0x07,
	0xc4, 0xc8, 0x19, 0x4d, 0x28, 0x89, 0x6c, 0xe4, 0x9c, 0x98, 0x93, 0x72, 0x4a, 0xdf, 0x5f, 0x85,
	0x95, 0xb1, 0xc9, 0x26, 0x28, 0x9a, 0x5d, 0x74, 0x5a, 0xc2, 0xca, 0x29, 0xbd, 0xff, 0x48, 0x82,
	0xcb, 0x27, 0x44, 0xd5, 0xd1, 0xdd, 0xe9, 0xc4, 0xe6, 0x19, 0x09, 0xb5, 0x69, 0x06, 0xfa, 0xb9,
	0x11, 0x33, 0x12, 0x80, 0x8f, 0x68, 0xc4, 0x9c, 0x94, 0x18, 0x10, 0xd1, 0x88, 0x39, 0x31, 0x0f,
	0x80, 0x9f, 0x12, 0xfc, 0x95, 0x3b, 0x14, 0xd9, 0xb3, 0x2a, 0x5a, 0x18, 0x6f, 0x4d, 0xd6, 0xd8,
	0x27, 0x64, 0xe3, 0xc6, 0x17, 0x5f, 0x89, 0xf4, 0xbf, 0x68, 0x77, 0xe7, 0xe8, 0x5a, 0x59, 0xff,
	0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd1, 0x94, 0xf7, 0xde, 0xc3, 0x76, 0x00, 0x00,
}
