TwitchTelemetry Circuit Metrics
===============================

This Go package implements a TwitchTelemetry metrics collector for github.com/cep21/circuit (Go3p-Github-Cep21-Circuit - 2.x).

It is largely based on code.justin.tv/hygienic/taggingcircuitsmetrics which implements similar functionality but with StatsD.

### Usage

```golang
var reporter telemetry.SampleReporter
[...]
statCommandFactory := circuitmetrics.CommandFactory{
    Reporter: reporter,
}
manager := circuit.Manager{
    DefaultCircuitProperties: []circuit.CommandPropertiesConstructor{
        statCommandFactory.CommandProperties,
    },
}
concurrencyCollector := statCommandFactory.ConcurrencyCollector(&manager)
// Could also set any other options in concurrencyCollector.Opts here
go concurrencyCollector.Start()
defer func(cc *circuitmetrics.ConcurrencyCollector) {
    err := cc.Close()
	if err != nil {
		// Log
	}
}(concurrencyCollector)
```

You can also add metrics for different combinations of circuit outcomes by changing the CommandFactory construction.

```golang
// The Average metric of `Rollup_CircuitAlarm` will effectivity be
//   number of (failures + timeouts + shortCircuits + concurrencyLimitRejects) / 
//   number of (failures + timeouts + shortCircuits + concurrencyLimitRejects + successes)
// eg with 1 failure, 3 timeouts, 0 short circuits, 0 concurrency limit rejects, and 96 successes
// there would be 96 `0.0` samples and 4 `1.0` samples resulting in an average of `0.04` aka 4%
statCommandFactory := circuitmetrics.CommandFactory{
    Reporter: *s.reporter,
    AdditionalMetricRollups: []AdditionalMetricRollup{
        {
            RollupName: "CircuitAlarm",
            ReportOnes: []circuitmetrics.Outcome{
                circuitmetrics.Failure,
                circuitmetrics.Timeout,
                circuitmetrics.ShortCircuit,
                circuitmetrics.ConcurrencyLimitReject,
            },
            ReportZeroes: []circuitmetrics.Outcome{
                circuitmetrics.Success,
            },
        },
    },
}
```
