package poller

import (
	"testing"

	. "github.com/smartystreets/goconvey/convey"

	"code.justin.tv/amzn/TwitchTelemetry"
)

func TestGoStatsPollingJob(t *testing.T) {
	Convey("Given a GoStatsPollingJob", t, func() {
		gspj := &GoStatsPollingJob{}

		Convey("Then the last seen data should start at 0", func() {
			So(gspj.lastFrees, ShouldEqual, 0)
			So(gspj.lastMallocs, ShouldEqual, 0)
			So(gspj.lastNumGC, ShouldEqual, 0)
			So(gspj.lastPauseTotalNs, ShouldEqual, 0)
			So(gspj.lastTotalAlloc, ShouldEqual, 0)
		})

		Convey("When Fetch happens", func() {
			fetchSamples, err := gspj.Fetch()

			Convey("Then there should be no error", func() {
				So(err, ShouldBeNil)
			})

			Convey("Then there should be 8 samples", func() {
				So(fetchSamples[0].MetricID.Name, ShouldEqual, "FreesPerSec")
				So(fetchSamples[1].MetricID.Name, ShouldEqual, "MallocsPerSec")
				So(fetchSamples[2].MetricID.Name, ShouldEqual, "NumGCPerSec")
				So(fetchSamples[3].MetricID.Name, ShouldEqual, "PauseTotalSecPerSec")
				So(fetchSamples[4].MetricID.Name, ShouldEqual, "TotalAllocPerSec")
				So(fetchSamples[5].MetricID.Name, ShouldEqual, "HeapObjects")
				So(fetchSamples[6].MetricID.Name, ShouldEqual, "HeapAlloc")
				So(fetchSamples[7].MetricID.Name, ShouldEqual, "NumGoroutines")
			})

			// This could change, but it's fine for now
			Convey("Then each sample's Unit is set to 'Count'", func() {
				So(fetchSamples[0].Unit, ShouldEqual, telemetry.UnitCount)
				So(fetchSamples[1].Unit, ShouldEqual, telemetry.UnitCount)
				So(fetchSamples[2].Unit, ShouldEqual, telemetry.UnitCount)
				So(fetchSamples[3].Unit, ShouldEqual, telemetry.UnitCount)
				So(fetchSamples[4].Unit, ShouldEqual, telemetry.UnitCount)
				So(fetchSamples[5].Unit, ShouldEqual, telemetry.UnitCount)
				So(fetchSamples[6].Unit, ShouldEqual, telemetry.UnitCount)
				So(fetchSamples[7].Unit, ShouldEqual, telemetry.UnitCount)
			})

		})
	})
}
