package agent

import (
	"testing"

	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	. "github.com/smartystreets/goconvey/convey"
)

func TestBaseLoadSample(t *testing.T) {
	Convey("Given a sample created using baseLoadSample", t, func() {
		sample := baseLoadSample("CoolLoadMetric", float64(12.34))
		Convey("Then the name should be correct", func() {
			So(sample.MetricID.Name, ShouldEqual, "CoolLoadMetric")
		})
		Convey("Then the unit should be correct", func() {
			So(sample.Unit, ShouldEqual, telemetry.UnitCount)
		})
		Convey("Then the value should be correct", func() {
			So(sample.Value, ShouldEqual, float64(12.34))
		})
	})
}
