package agent

import (
	"testing"

	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	. "github.com/smartystreets/goconvey/convey"
)

func TestBaseMemorySample(t *testing.T) {
	Convey("Given a sample created using baseMemSample", t, func() {
		sample := baseMemorySample("CoolMemMetricBytes", float64(33.33))
		Convey("Then the name should be correct", func() {
			So(sample.MetricID.Name, ShouldEqual, "CoolMemMetricBytes")
		})
		Convey("Then the unit should be correct", func() {
			So(sample.Unit, ShouldEqual, telemetry.UnitBytes)
		})
		Convey("Then the value should be correct", func() {
			So(sample.Value, ShouldEqual, float64(33.33))
		})
	})
}
