package main

import (
	"bytes"
	"encoding/json"
)

// RawTitleData contains data for a title from the translation file
type RawTitleData struct {
	Name          string
	FallbackTitle string
	TitleVariants map[string]string
}

// RawTranslationData contains all of the translation data received from Smartling for a specific language
type RawTranslationData struct {
	Titles []RawTitleData
}

// UnmarshalTranslationFile unmarshals bytes from a translation file into TranslationData
func UnmarshalTranslationFile(bytes []byte) (RawTranslationData, error) {
	var data RawTranslationData
	err := json.Unmarshal(bytes, &data)
	return data, err
}

// MarshalTranslationData converts translation data into bytes
func MarshalTranslationData(data RawTranslationData) ([]byte, error) {
	var buffer bytes.Buffer
	encoder := json.NewEncoder(&buffer)
	encoder.SetEscapeHTML(false)
	encoder.SetIndent("", "    ")
	err := encoder.Encode(data)
	if err != nil {
		return nil, err
	}
	return buffer.Bytes(), nil
}
