package main

import (
	"io/ioutil"
	"os"
	"path"
	"strings"

	"gopkg.in/urfave/cli.v1"
)

func initCommand() cli.Command {
	return cli.Command{
		Name:      "initialize",
		ShortName: "init",
		Usage:     "This will initialize a directory with cli dependencies",
		Action:    initAction,
	}
}

func initAction(c *cli.Context) error {
	// Create a folder called `localization` for localizations
	err := os.Mkdir(localizationFolderUri, dirWriteMode)
	if err != nil {
		return err
	}

	// Create a config template
	configPath := path.Join(localizationFolderUri, configJsonUri)
	configTemplate := generateConfigTemplate()
	err = ioutil.WriteFile(configPath, configTemplate, fileWriteMode)
	if err != nil {
		return err
	}

	// Create a titles template
	titlesPath := path.Join(localizationFolderUri, titlesJsonUri)
	titlesTemplate := generateTitlesTemplate()
	err = ioutil.WriteFile(titlesPath, titlesTemplate, fileWriteMode)
	if err != nil {
		return err
	}

	// Create the directory to store json translations
	translationFolderPath := path.Join(localizationFolderUri, translationsFolderUri)
	err = os.Mkdir(translationFolderPath, dirWriteMode)
	if err != nil {
		return err
	}

	return nil
}

func generateConfigTemplate() []byte {
	configTemplate := strings.Join([]string{
		"{",
		"\t\"SmartlingUserID\": \"\",",
		"\t\"SmartlingProjectID\": \"\",",
		"\t\"SmartlingFileURI\": \"\",",
		"\t\"AwsAccountID\": \"\",",
		"\t\"AwsAccountRole\": \"\",",
		"\t\"SandstormRoleArn\": \"\",",
		"\t\"SandstormSecretTokenName\": \"\"",
		"}",
		"",
	}, "\n")

	return []byte(configTemplate)
}

func generateTitlesTemplate() []byte {
	titlesTemplate := strings.Join([]string{
		"{",
		"\t\"smartling\": {",
		"\t\t\"translate_paths\": [",
		"\t\t\t{",
		"\t\t\t\t\"path\": \"Titles/TitleVariants/*\",",
		"\t\t\t\t\"key\": [\"/Titles/Name\", \"{*}\"],",
		"\t\t\t\t\"instruction\": \"Titles/TranslationNote\"",
		"\t\t\t},",
		"\t\t\t{",
		"\t\t\t\t\"path\": \"Titles/FallbackTitle\",",
		"\t\t\t\t\"key\": [\"/Titles/Name\", \"{*}\"],",
		"\t\t\t\t\"instruction\": \"Titles/TranslationNote\"",
		"\t\t\t}",
		"\t\t],",
		"\t\t\"plurals_detection\": \"on\",",
		"\t\t\"string_format\": \"icu\",",
		"\t\t\"placeholder_format_custom\": [\"<.*?>\", \"\\\\{.*?\\\\}\"]",
		"\t},",
		"\t\"Titles\": [",
		"\t\t{",
		"\t\t\t\"Name\": \"\",",
		"\t\t\t\"FallbackTitle\": \"\",",
		"\t\t\t\"TitleVariants\": {",
		"\t\t\t\t\"Default\": \"\"",
		"\t\t\t},",
		"\t\t\t\"TranslationNote\": \"\"",
		"\t\t}",
		"\t]",
		"}",
		"",
	}, "\n")

	return []byte(titlesTemplate)
}
