package main

import (
	"log"
	"os"

	"gopkg.in/urfave/cli.v1"
)

func main() {
	app := &cli.App{
		Name:                 "twitch-title-cli",
		Usage:                "Manage the upload and download of localized titles at Twitch",
		EnableBashCompletion: true,
		Commands: []cli.Command{
			initCommand(),
			uploadCommand(),
			downloadCommand(),
		},
	}

	err := app.Run(os.Args)
	if err != nil {
		log.Fatal(err)
	}
}
