package main

import (
	"fmt"
	"io/ioutil"

	smartling "github.com/Smartling/api-sdk-go"
	"gopkg.in/urfave/cli.v1"
)

func uploadCommand() cli.Command {
	return cli.Command{
		Name:      "upload",
		ShortName: "up",
		Usage:     "This will upload titles to Smartling",
		Action:    uploadAction,
	}
}

func uploadAction(c *cli.Context) error {
	// Load in the config from the cli context
	config, err := LoadConfig(c)
	if err != nil {
		return err
	}

	// Read the titles that will be sent to smartling
	titleBytes, err := ioutil.ReadFile(titlesJsonUri)
	if err != nil {
		return cli.NewExitError(fmt.Sprintf("failed to read the titles file: %s", err.Error()), 1)
	}

	err = uploadTitleTranslationFile(config, titleBytes)
	if err != nil {
		return cli.NewExitError(fmt.Sprintf("failed to upload the titles file: %s", err.Error()), 1)
	}

	fmt.Println("Done upload!")

	return nil
}

// uploadTitleTranslationFile uploads the titles file to Smartling
func uploadTitleTranslationFile(c *TwitchTitleCliConfig, titleBytes []byte) (err error) {
	// Create a Smartling API client
	secretToken, err := GetSandstormSecret(c.AwsAccountID, c.AwsAccountRole, c.SandstormRoleArn, c.SandstormSecretTokenName)
	if err != nil {
		return err
	}
	smartlingApiClient := smartling.NewClient(c.SmartlingUserID, secretToken)

	// Build the upload request
	uploadRequest := smartling.FileUploadRequest{
		FileURIRequest: smartling.FileURIRequest{
			FileURI: c.SmartlingFileURI,
		},
		File:     titleBytes,
		FileType: smartling.FileTypeJSON,
	}

	// Upload the
	uploadResult, err := smartlingApiClient.UploadFile(c.SmartlingProjectID, uploadRequest)
	if uploadResult != nil && err == nil {
		fmt.Println(fmt.Sprintf("Uploaded %d strings to Smartling", uploadResult.StringCount))
	}
	return err
}
