package main

import (
	"fmt"
	"time"

	titles "code.justin.tv/amzn/TwitchTitles"
	"code.justin.tv/amzn/TwitchTitles/titles-example/localization"
)

func main() {
	title, err := localization.LocalizedTitleMap.GetTitle(&titles.TitleMapGetParams{
		Languages:   []string{"en-US"},
		TitleName:   "SimilarStreamerMostWatched",
		VariantName: "Default",
		TitlePlaceholders: titles.PlaceholderMap{
			titles.StreamPlaceholder: []titles.TwitchTitleTokenPlaceholder{
				{ID: "106064402"},
			},
		},
	})
	if err != nil {
		fmt.Println(err)
	}

	printTitle(title)

	pluralTitle, err := localization.LocalizedTitleMap.GetTitle(&titles.TitleMapGetParams{
		Languages:   []string{"en-US"},
		TitleName:   "PluralTitle",
		VariantName: "Default",
		TitlePlaceholders: titles.PlaceholderMap{
			titles.NumberPlaceholder: []titles.TwitchTitleTokenPlaceholder{
				{Value: 1},
			},
		},
	})
	if err != nil {
		fmt.Println(err)
	}

	printTitle(pluralTitle)
}

func printTitle(title *titles.TwitchTitle) {
	fmt.Printf("Name: %s\t", title.Name)
	fmt.Printf("Fallback Title: %s\t", title.FallbackLocalizedTitle)
	fmt.Printf("Title: ")
	for _, token := range title.LocalizedTitleTokens {
		switch token.TokenType {
		case titles.TEXT_TOKEN_TYPE:
			fmt.Printf("%s", token.TextToken.Text)
		case titles.CATEGORY_TOKEN_TYPE:
			fallthrough
		case titles.STREAM_TOKEN_TYPE:
			fallthrough
		case titles.TAG_TOKEN_TYPE:
			fmt.Printf("{%s}", token.PlaceholderToken.ID)
		case titles.NUMBER_TOKEN_TYPE:
			fmt.Printf("%d", token.PlaceholderToken.Value)
		case titles.DATE_TOKEN_TYPE:
			fmt.Printf("%s", time.Unix(token.PlaceholderToken.Value, 0).String())
		}
	}
	fmt.Println()
}
