// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchVODCollectionsTwirp/twirp.proto

package TwitchVODCollectionsTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// ==============================
// TwitchVODCollections Interface
// ==============================

type TwitchVODCollections interface {
	GetPrice(context.Context, *GetPriceRequest) (*Price, error)

	UpdatePrice(context.Context, *UpdatePriceRequest) (*Price, error)
}

// ====================================
// TwitchVODCollections Protobuf Client
// ====================================

type twitchVODCollectionsProtobufClient struct {
	client HTTPClient
	urls   [2]string
	opts   twirp.ClientOptions
}

// NewTwitchVODCollectionsProtobufClient creates a Protobuf client that implements the TwitchVODCollections interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchVODCollectionsProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchVODCollections {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchVODCollectionsPathPrefix
	urls := [2]string{
		prefix + "GetPrice",
		prefix + "UpdatePrice",
	}

	return &twitchVODCollectionsProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchVODCollectionsProtobufClient) GetPrice(ctx context.Context, in *GetPriceRequest) (*Price, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvodcollections")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVODCollections")
	ctx = ctxsetters.WithMethodName(ctx, "GetPrice")
	out := new(Price)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVODCollectionsProtobufClient) UpdatePrice(ctx context.Context, in *UpdatePriceRequest) (*Price, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvodcollections")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVODCollections")
	ctx = ctxsetters.WithMethodName(ctx, "UpdatePrice")
	out := new(Price)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ================================
// TwitchVODCollections JSON Client
// ================================

type twitchVODCollectionsJSONClient struct {
	client HTTPClient
	urls   [2]string
	opts   twirp.ClientOptions
}

// NewTwitchVODCollectionsJSONClient creates a JSON client that implements the TwitchVODCollections interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchVODCollectionsJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchVODCollections {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchVODCollectionsPathPrefix
	urls := [2]string{
		prefix + "GetPrice",
		prefix + "UpdatePrice",
	}

	return &twitchVODCollectionsJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchVODCollectionsJSONClient) GetPrice(ctx context.Context, in *GetPriceRequest) (*Price, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvodcollections")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVODCollections")
	ctx = ctxsetters.WithMethodName(ctx, "GetPrice")
	out := new(Price)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVODCollectionsJSONClient) UpdatePrice(ctx context.Context, in *UpdatePriceRequest) (*Price, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvodcollections")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVODCollections")
	ctx = ctxsetters.WithMethodName(ctx, "UpdatePrice")
	out := new(Price)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ===================================
// TwitchVODCollections Server Handler
// ===================================

type twitchVODCollectionsServer struct {
	TwitchVODCollections
	hooks *twirp.ServerHooks
}

func NewTwitchVODCollectionsServer(svc TwitchVODCollections, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchVODCollectionsServer{
		TwitchVODCollections: svc,
		hooks:                hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchVODCollectionsServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchVODCollectionsPathPrefix is used for all URL paths on a twirp TwitchVODCollections server.
// Requests are always: POST TwitchVODCollectionsPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchVODCollectionsPathPrefix = "/twirp/twitch.fulton.example.twitchvodcollections.TwitchVODCollections/"

func (s *twitchVODCollectionsServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvodcollections")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVODCollections")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.example.twitchvodcollections.TwitchVODCollections/GetPrice":
		s.serveGetPrice(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchvodcollections.TwitchVODCollections/UpdatePrice":
		s.serveUpdatePrice(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchVODCollectionsServer) serveGetPrice(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPriceJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPriceProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVODCollectionsServer) serveGetPriceJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPrice")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetPriceRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Price
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVODCollections.GetPrice(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Price and nil error while calling GetPrice. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVODCollectionsServer) serveGetPriceProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPrice")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetPriceRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Price
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVODCollections.GetPrice(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Price and nil error while calling GetPrice. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVODCollectionsServer) serveUpdatePrice(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdatePriceJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdatePriceProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVODCollectionsServer) serveUpdatePriceJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdatePrice")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdatePriceRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Price
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVODCollections.UpdatePrice(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Price and nil error while calling UpdatePrice. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVODCollectionsServer) serveUpdatePriceProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdatePrice")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdatePriceRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Price
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVODCollections.UpdatePrice(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Price and nil error while calling UpdatePrice. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVODCollectionsServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor1, 0
}

func (s *twitchVODCollectionsServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchVODCollectionsServer) PathPrefix() string {
	return TwitchVODCollectionsPathPrefix
}

var twirpFileDescriptor1 = []byte{
	// 247 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe2, 0xb2, 0x4c, 0xce, 0x4f, 0x49,
	0xd5, 0xcb, 0x2a, 0x2d, 0x2e, 0xc9, 0xcc, 0xd3, 0x2b, 0x29, 0xd3, 0x4f, 0xcc, 0xad, 0xca, 0xd3,
	0x0f, 0x29, 0xcf, 0x2c, 0x49, 0xce, 0x08, 0xf3, 0x77, 0x71, 0xce, 0xcf, 0xc9, 0x49, 0x4d, 0x2e,
	0xc9, 0xcc, 0xcf, 0x2b, 0x0e, 0x29, 0xcf, 0x2c, 0x2a, 0xd0, 0x2f, 0x01, 0x91, 0x7a, 0x05, 0x45,
	0xf9, 0x25, 0xf9, 0x42, 0x5a, 0x25, 0x60, 0x65, 0x7a, 0x69, 0xa5, 0x39, 0x25, 0xf9, 0x79, 0x7a,
	0xa9, 0x15, 0x89, 0xb9, 0x05, 0x39, 0xa9, 0x7a, 0x10, 0xd1, 0xb2, 0xfc, 0x94, 0x64, 0x84, 0x66,
	0x25, 0x6b, 0x2e, 0xd6, 0x80, 0xa2, 0xcc, 0xe4, 0x54, 0x21, 0x19, 0x2e, 0xce, 0xb2, 0xd4, 0xf4,
	0xd4, 0x92, 0xc4, 0xa4, 0x9c, 0x54, 0x09, 0x46, 0x05, 0x46, 0x0d, 0xce, 0x20, 0x84, 0x80, 0x90,
	0x08, 0x17, 0x6b, 0x01, 0x48, 0x99, 0x04, 0x93, 0x02, 0xa3, 0x06, 0x6b, 0x10, 0x84, 0xa3, 0xa4,
	0xcf, 0xc5, 0xef, 0x9e, 0x5a, 0x02, 0xd6, 0x1f, 0x94, 0x5a, 0x58, 0x9a, 0x5a, 0x5c, 0x82, 0xdf,
	0x18, 0x25, 0x0f, 0x2e, 0xa1, 0xd0, 0x82, 0x94, 0xc4, 0x92, 0x54, 0xe2, 0xf5, 0x60, 0xb7, 0xda,
	0x68, 0x2a, 0x13, 0x97, 0x08, 0xb6, 0xd0, 0x10, 0xaa, 0xe2, 0xe2, 0x80, 0xb9, 0x49, 0xc8, 0x5a,
	0x8f, 0xf8, 0x90, 0xd0, 0x43, 0xf3, 0x89, 0x94, 0x21, 0x29, 0x9a, 0x21, 0xf6, 0x35, 0x30, 0x72,
	0x71, 0x23, 0xf9, 0x4f, 0xc8, 0x8e, 0x14, 0x23, 0x30, 0x03, 0x86, 0x0c, 0x27, 0x38, 0xe9, 0x47,
	0xe9, 0x92, 0x94, 0x70, 0x92, 0xd8, 0xc0, 0x69, 0xc6, 0x18, 0x10, 0x00, 0x00, 0xff, 0xff, 0x0c,
	0x2d, 0x0a, 0x2b, 0x70, 0x02, 0x00, 0x00,
}
