#What?
This package provides an Access Log library for Twirp services via Twirp's `ServerHooks`. It can sample requests and
log arbitrary information.
 
#How to use? 
- In Brazil `Config` file, add the package to your dependencies using `TwitchVXAccessLog = 1.0;`
- In Cloudformation create a CW log group for you access logs, e.g.
```  
ServiceAccessLogGroup:
  Properties:
    LogGroupName: { "Fn::Sub": "/aws/ecs/${ServiceName}-AccessLog-${ResourcePrefix}" }
    RetentionInDays: 90
  Type: AWS::Logs::LogGroup
``` 
and export the log group name to your service environment, e.g.
```
Environment
  - Name: ACCESS_LOG_LOGGROUP
    Value:
      Ref: ServiceAccessLogGroup
```
- In `main.go`, initialize access logger struct (assuming there is already a circuit from cep21/circuit)
```
accessLogger, err := accesslog.New(bs.Logger, circuitsManager.MustCreateCircuit(
    "accesslog_circuit",
    circuit.Config{
        Execution: circuit.ExecutionConfig{
            Timeout: time.Second * 9,
        },
    }),
    accesslog.Configs{
        LogGroupName: os.Getenv("ACCESS_LOG_LOGGROUP"),
        SampleRate:   0.01,
    })
```
- add access log server hook to twirp server
```
twirpMiddleware := twirp.ChainHooks(
    ...
    accessLogger.ServerHooks(),
)
```
now you should see access logs created in the log group you defined
- By default, the library doesn't log a lot of information, but you can use `WithRequestBody()` and `WithResponseBody()` 
to add the request/response body to the log and use various `Trace` methods to add arbitrary ints/floats/strings. e.g.
```
accesslog.SetRequestBody(ctx, req)
accesslog.SetTraceInt(ctx, "my_trace_int", 2)
```
 
#Publishing the version to Twitch/live
This library is automatically published to Twitch/live via https://pipelines.amazon.com/pipelines/TwitchVXAccessLogCDK

### Questions? Suggestions?
contact @sam.zhao