package lib

import (
	"time"
)

type contextKey int

const (
	// keys used in twirp hooks
	accessLogErrKey contextKey = iota
	requestTimeKey
)

// Message contains everything that can be logged.
type Message struct {
	// when this message is created
	MsgTime time.Time `json:"msg_time,omitempty"`
	// host name
	Hostname string `json:"hostname,omitempty"`

	// Twirp method
	Method string `json:"method,omitempty"`
	// HTTP status code
	StatusCode string `json:"status_code,omitempty"`
	// AWS X-Ray trace header if exists
	TraceID string `json:"trace_id,omitempty"`
	// how long the request takes
	DurationMS int64 `json:"duration_ms"`
	// error string
	Error string `json:"error,omitempty"`
	// when the request is received
	ReceivedTime time.Time `json:"received_time,omitempty"`

	// custom defined data
	TraceStrings map[string]string  `json:"trace_strings,omitempty"`
	TraceInts    map[string]int64   `json:"trace_ints,omitempty"`
	TraceFloats  map[string]float64 `json:"trace_floats,omitempty"`
}
