// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchVXGraphDBECSTwirp/twirp.proto

package TwitchVXGraphDBECSTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// ============================
// TwitchVXGraphDBECS Interface
// ============================

// GraphDB allows creation of nodes and edges inside a generic graph database
type TwitchVXGraphDBECS interface {
	// EdgeGet returns an association between two entities.  Returns nil if no assoc exists
	// SLO@100ms
	EdgeGet(context.Context, *EdgeGetRequest) (*EdgeGetResponse, error)

	// EdgeCreate creates an association only if one does not exist.  If one did exist, returns nil.
	// SLO@150ms
	EdgeCreate(context.Context, *EdgeCreateRequest) (*EdgeCreateResponse, error)

	// EdgeUpdate updates the values of an association only if does exist.  Returns the new value.
	// If one did not exist or the version did not match, returns nil.
	// version is an optional argument used as an optimistic lock to ensure
	// that no other processes Updated the Edge since it was retrieved.
	// Resolving conflicts is left to the caller.
	// The caller can retry the update operation by re-fetching the item (EdgeGet) to retrieve the new version
	// before calling EdgeUpdate again.
	// SLO@150ms
	EdgeUpdate(context.Context, *EdgeUpdateRequest) (*EdgeUpdateResponse, error)

	// EdgeCount counts the assocs from a source.
	// SLO@100ms
	EdgeCount(context.Context, *EdgeCountRequest) (*EdgeCountResponse, error)

	// EdgeDelete removes an association between two entities.
	// Returns the removed entity, otherwise returns nil if it did not exist or if the version did not match.
	// version is an optional argument used as an optimistic lock to ensure
	// that no other processes Updated the Edge since it was retrieved.
	// Resolving conflicts is left to the caller.
	// The caller can retry the delete operation by re-fetching the item (EdgeGet) to retrieve the new version
	// before calling EdgeDelete again.
	// SLO@150ms
	EdgeDelete(context.Context, *EdgeDeleteRequest) (*EdgeDeleteResponse, error)

	// EdgeList lists the assocs from an entity.
	// May consume one read unit, may consume more
	// SLO@200ms
	EdgeList(context.Context, *EdgeListRequest) (*EdgeListResponse, error)

	// BulkEdgeUpdate updates the values of associations from a source node with a given edge type
	// Limit must be <= 2000
	// SLO@60000ms
	BulkEdgeUpdate(context.Context, *BulkEdgeUpdateRequest) (*BulkEdgeUpdateResponse, error)

	// BulkEdgeDelete deletes associations from a source node with a given edge type
	// Limit must be <= 2000
	// SLO@60000ms
	BulkEdgeDelete(context.Context, *BulkEdgeDeleteRequest) (*BulkEdgeDeleteResponse, error)
}

// ==================================
// TwitchVXGraphDBECS Protobuf Client
// ==================================

type twitchVXGraphDBECSProtobufClient struct {
	client HTTPClient
	urls   [8]string
	opts   twirp.ClientOptions
}

// NewTwitchVXGraphDBECSProtobufClient creates a Protobuf client that implements the TwitchVXGraphDBECS interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchVXGraphDBECSProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchVXGraphDBECS {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchVXGraphDBECSPathPrefix
	urls := [8]string{
		prefix + "EdgeGet",
		prefix + "EdgeCreate",
		prefix + "EdgeUpdate",
		prefix + "EdgeCount",
		prefix + "EdgeDelete",
		prefix + "EdgeList",
		prefix + "BulkEdgeUpdate",
		prefix + "BulkEdgeDelete",
	}

	return &twitchVXGraphDBECSProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchVXGraphDBECSProtobufClient) EdgeGet(ctx context.Context, in *EdgeGetRequest) (*EdgeGetResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchvxgraphdbecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXGraphDBECS")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeGet")
	out := new(EdgeGetResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXGraphDBECSProtobufClient) EdgeCreate(ctx context.Context, in *EdgeCreateRequest) (*EdgeCreateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchvxgraphdbecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXGraphDBECS")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCreate")
	out := new(EdgeCreateResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXGraphDBECSProtobufClient) EdgeUpdate(ctx context.Context, in *EdgeUpdateRequest) (*EdgeUpdateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchvxgraphdbecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXGraphDBECS")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdate")
	out := new(EdgeUpdateResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXGraphDBECSProtobufClient) EdgeCount(ctx context.Context, in *EdgeCountRequest) (*EdgeCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchvxgraphdbecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXGraphDBECS")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCount")
	out := new(EdgeCountResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXGraphDBECSProtobufClient) EdgeDelete(ctx context.Context, in *EdgeDeleteRequest) (*EdgeDeleteResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchvxgraphdbecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXGraphDBECS")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeDelete")
	out := new(EdgeDeleteResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXGraphDBECSProtobufClient) EdgeList(ctx context.Context, in *EdgeListRequest) (*EdgeListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchvxgraphdbecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXGraphDBECS")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeList")
	out := new(EdgeListResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXGraphDBECSProtobufClient) BulkEdgeUpdate(ctx context.Context, in *BulkEdgeUpdateRequest) (*BulkEdgeUpdateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchvxgraphdbecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXGraphDBECS")
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeUpdate")
	out := new(BulkEdgeUpdateResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXGraphDBECSProtobufClient) BulkEdgeDelete(ctx context.Context, in *BulkEdgeDeleteRequest) (*BulkEdgeDeleteResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchvxgraphdbecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXGraphDBECS")
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeDelete")
	out := new(BulkEdgeDeleteResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==============================
// TwitchVXGraphDBECS JSON Client
// ==============================

type twitchVXGraphDBECSJSONClient struct {
	client HTTPClient
	urls   [8]string
	opts   twirp.ClientOptions
}

// NewTwitchVXGraphDBECSJSONClient creates a JSON client that implements the TwitchVXGraphDBECS interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchVXGraphDBECSJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchVXGraphDBECS {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchVXGraphDBECSPathPrefix
	urls := [8]string{
		prefix + "EdgeGet",
		prefix + "EdgeCreate",
		prefix + "EdgeUpdate",
		prefix + "EdgeCount",
		prefix + "EdgeDelete",
		prefix + "EdgeList",
		prefix + "BulkEdgeUpdate",
		prefix + "BulkEdgeDelete",
	}

	return &twitchVXGraphDBECSJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchVXGraphDBECSJSONClient) EdgeGet(ctx context.Context, in *EdgeGetRequest) (*EdgeGetResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchvxgraphdbecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXGraphDBECS")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeGet")
	out := new(EdgeGetResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXGraphDBECSJSONClient) EdgeCreate(ctx context.Context, in *EdgeCreateRequest) (*EdgeCreateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchvxgraphdbecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXGraphDBECS")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCreate")
	out := new(EdgeCreateResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXGraphDBECSJSONClient) EdgeUpdate(ctx context.Context, in *EdgeUpdateRequest) (*EdgeUpdateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchvxgraphdbecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXGraphDBECS")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdate")
	out := new(EdgeUpdateResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXGraphDBECSJSONClient) EdgeCount(ctx context.Context, in *EdgeCountRequest) (*EdgeCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchvxgraphdbecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXGraphDBECS")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCount")
	out := new(EdgeCountResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXGraphDBECSJSONClient) EdgeDelete(ctx context.Context, in *EdgeDeleteRequest) (*EdgeDeleteResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchvxgraphdbecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXGraphDBECS")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeDelete")
	out := new(EdgeDeleteResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXGraphDBECSJSONClient) EdgeList(ctx context.Context, in *EdgeListRequest) (*EdgeListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchvxgraphdbecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXGraphDBECS")
	ctx = ctxsetters.WithMethodName(ctx, "EdgeList")
	out := new(EdgeListResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXGraphDBECSJSONClient) BulkEdgeUpdate(ctx context.Context, in *BulkEdgeUpdateRequest) (*BulkEdgeUpdateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchvxgraphdbecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXGraphDBECS")
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeUpdate")
	out := new(BulkEdgeUpdateResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXGraphDBECSJSONClient) BulkEdgeDelete(ctx context.Context, in *BulkEdgeDeleteRequest) (*BulkEdgeDeleteResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchvxgraphdbecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXGraphDBECS")
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeDelete")
	out := new(BulkEdgeDeleteResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =================================
// TwitchVXGraphDBECS Server Handler
// =================================

type twitchVXGraphDBECSServer struct {
	TwitchVXGraphDBECS
	hooks *twirp.ServerHooks
}

func NewTwitchVXGraphDBECSServer(svc TwitchVXGraphDBECS, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchVXGraphDBECSServer{
		TwitchVXGraphDBECS: svc,
		hooks:              hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchVXGraphDBECSServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchVXGraphDBECSPathPrefix is used for all URL paths on a twirp TwitchVXGraphDBECS server.
// Requests are always: POST TwitchVXGraphDBECSPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchVXGraphDBECSPathPrefix = "/twirp/twitchvxgraphdbecs.TwitchVXGraphDBECS/"

func (s *twitchVXGraphDBECSServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitchvxgraphdbecs")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXGraphDBECS")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitchvxgraphdbecs.TwitchVXGraphDBECS/EdgeGet":
		s.serveEdgeGet(ctx, resp, req)
		return
	case "/twirp/twitchvxgraphdbecs.TwitchVXGraphDBECS/EdgeCreate":
		s.serveEdgeCreate(ctx, resp, req)
		return
	case "/twirp/twitchvxgraphdbecs.TwitchVXGraphDBECS/EdgeUpdate":
		s.serveEdgeUpdate(ctx, resp, req)
		return
	case "/twirp/twitchvxgraphdbecs.TwitchVXGraphDBECS/EdgeCount":
		s.serveEdgeCount(ctx, resp, req)
		return
	case "/twirp/twitchvxgraphdbecs.TwitchVXGraphDBECS/EdgeDelete":
		s.serveEdgeDelete(ctx, resp, req)
		return
	case "/twirp/twitchvxgraphdbecs.TwitchVXGraphDBECS/EdgeList":
		s.serveEdgeList(ctx, resp, req)
		return
	case "/twirp/twitchvxgraphdbecs.TwitchVXGraphDBECS/BulkEdgeUpdate":
		s.serveBulkEdgeUpdate(ctx, resp, req)
		return
	case "/twirp/twitchvxgraphdbecs.TwitchVXGraphDBECS/BulkEdgeDelete":
		s.serveBulkEdgeDelete(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchVXGraphDBECSServer) serveEdgeGet(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEdgeGetJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEdgeGetProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVXGraphDBECSServer) serveEdgeGetJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeGet")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EdgeGetRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *EdgeGetResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXGraphDBECS.EdgeGet(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeGetResponse and nil error while calling EdgeGet. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXGraphDBECSServer) serveEdgeGetProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeGet")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(EdgeGetRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *EdgeGetResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXGraphDBECS.EdgeGet(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeGetResponse and nil error while calling EdgeGet. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXGraphDBECSServer) serveEdgeCreate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEdgeCreateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEdgeCreateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVXGraphDBECSServer) serveEdgeCreateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCreate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EdgeCreateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *EdgeCreateResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXGraphDBECS.EdgeCreate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeCreateResponse and nil error while calling EdgeCreate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXGraphDBECSServer) serveEdgeCreateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCreate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(EdgeCreateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *EdgeCreateResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXGraphDBECS.EdgeCreate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeCreateResponse and nil error while calling EdgeCreate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXGraphDBECSServer) serveEdgeUpdate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEdgeUpdateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEdgeUpdateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVXGraphDBECSServer) serveEdgeUpdateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EdgeUpdateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *EdgeUpdateResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXGraphDBECS.EdgeUpdate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeUpdateResponse and nil error while calling EdgeUpdate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXGraphDBECSServer) serveEdgeUpdateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeUpdate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(EdgeUpdateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *EdgeUpdateResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXGraphDBECS.EdgeUpdate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeUpdateResponse and nil error while calling EdgeUpdate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXGraphDBECSServer) serveEdgeCount(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEdgeCountJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEdgeCountProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVXGraphDBECSServer) serveEdgeCountJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EdgeCountRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *EdgeCountResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXGraphDBECS.EdgeCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeCountResponse and nil error while calling EdgeCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXGraphDBECSServer) serveEdgeCountProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(EdgeCountRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *EdgeCountResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXGraphDBECS.EdgeCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeCountResponse and nil error while calling EdgeCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXGraphDBECSServer) serveEdgeDelete(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEdgeDeleteJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEdgeDeleteProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVXGraphDBECSServer) serveEdgeDeleteJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeDelete")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EdgeDeleteRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *EdgeDeleteResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXGraphDBECS.EdgeDelete(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeDeleteResponse and nil error while calling EdgeDelete. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXGraphDBECSServer) serveEdgeDeleteProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeDelete")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(EdgeDeleteRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *EdgeDeleteResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXGraphDBECS.EdgeDelete(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeDeleteResponse and nil error while calling EdgeDelete. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXGraphDBECSServer) serveEdgeList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEdgeListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEdgeListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVXGraphDBECSServer) serveEdgeListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EdgeListRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *EdgeListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXGraphDBECS.EdgeList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeListResponse and nil error while calling EdgeList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXGraphDBECSServer) serveEdgeListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EdgeList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(EdgeListRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *EdgeListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXGraphDBECS.EdgeList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EdgeListResponse and nil error while calling EdgeList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXGraphDBECSServer) serveBulkEdgeUpdate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBulkEdgeUpdateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBulkEdgeUpdateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVXGraphDBECSServer) serveBulkEdgeUpdateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeUpdate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BulkEdgeUpdateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BulkEdgeUpdateResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXGraphDBECS.BulkEdgeUpdate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkEdgeUpdateResponse and nil error while calling BulkEdgeUpdate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXGraphDBECSServer) serveBulkEdgeUpdateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeUpdate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(BulkEdgeUpdateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BulkEdgeUpdateResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXGraphDBECS.BulkEdgeUpdate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkEdgeUpdateResponse and nil error while calling BulkEdgeUpdate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXGraphDBECSServer) serveBulkEdgeDelete(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBulkEdgeDeleteJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBulkEdgeDeleteProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVXGraphDBECSServer) serveBulkEdgeDeleteJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeDelete")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BulkEdgeDeleteRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BulkEdgeDeleteResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXGraphDBECS.BulkEdgeDelete(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkEdgeDeleteResponse and nil error while calling BulkEdgeDelete. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXGraphDBECSServer) serveBulkEdgeDeleteProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkEdgeDelete")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(BulkEdgeDeleteRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BulkEdgeDeleteResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXGraphDBECS.BulkEdgeDelete(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkEdgeDeleteResponse and nil error while calling BulkEdgeDelete. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXGraphDBECSServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor1, 0
}

func (s *twitchVXGraphDBECSServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchVXGraphDBECSServer) PathPrefix() string {
	return TwitchVXGraphDBECSPathPrefix
}

var twirpFileDescriptor1 = []byte{
	// 1093 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x57, 0xdb, 0x6e, 0x1b, 0x45,
	0x18, 0xce, 0x1e, 0x5c, 0xdb, 0x7f, 0xda, 0xd4, 0x8c, 0xda, 0x68, 0xd9, 0x4a, 0x10, 0x4d, 0x9b,
	0x28, 0x0d, 0x65, 0x2d, 0x05, 0xa4, 0x1e, 0x54, 0x90, 0xe2, 0x83, 0x0a, 0x28, 0x02, 0xb4, 0x31,
	0x05, 0x55, 0xaa, 0xd2, 0xb5, 0x77, 0xea, 0x2c, 0xb5, 0x77, 0xcc, 0xee, 0xd8, 0x6e, 0xb8, 0xe2,
	0x19, 0x8a, 0xc4, 0x15, 0xaf, 0xc0, 0x73, 0xf0, 0x44, 0xdc, 0xa3, 0x39, 0xac, 0xbd, 0x76, 0x76,
	0xed, 0xd8, 0x29, 0xdc, 0x58, 0x9e, 0xd1, 0xf7, 0xfd, 0xe7, 0x6f, 0x66, 0x16, 0x1e, 0x76, 0xa8,
	0x4f, 0x9c, 0x9f, 0x87, 0x31, 0x0b, 0x42, 0x87, 0x8d, 0xaa, 0x5e, 0xff, 0xd7, 0xb0, 0xda, 0x1a,
	0x07, 0xac, 0x73, 0xf6, 0xfc, 0xa7, 0x67, 0x91, 0x37, 0x38, 0x6b, 0xd4, 0x9a, 0xf5, 0x93, 0xd6,
	0x38, 0x88, 0x06, 0x55, 0xc6, 0x7f, 0x9d, 0x41, 0x44, 0x19, 0x45, 0x88, 0x09, 0xd0, 0xe8, 0x6d,
	0x97, 0x83, 0xfc, 0x36, 0xe9, 0xc4, 0xf6, 0xc7, 0x5d, 0x4a, 0xbb, 0x3d, 0x52, 0x15, 0x88, 0xf6,
	0xf0, 0x75, 0x95, 0x05, 0x7d, 0x12, 0x33, 0xaf, 0xaf, 0x48, 0xf8, 0x00, 0xcc, 0x6f, 0xa9, 0x4f,
	0x10, 0x02, 0x93, 0x9d, 0x0f, 0x88, 0xa5, 0xed, 0x68, 0xfb, 0x65, 0x57, 0xfc, 0x47, 0x5b, 0xa0,
	0x07, 0xbe, 0xa5, 0x8b, 0x1d, 0x3d, 0xf0, 0x71, 0x04, 0x66, 0xd3, 0xef, 0x12, 0xf4, 0x00, 0xcc,
	0xd7, 0x11, 0xed, 0x0b, 0xec, 0xe6, 0xa1, 0xe5, 0x5c, 0xf4, 0xeb, 0x70, 0x9b, 0xae, 0x40, 0xa1,
	0x7d, 0xd0, 0x19, 0x15, 0x56, 0x16, 0x61, 0x75, 0x9e, 0x80, 0x8a, 0xc1, 0x98, 0xc6, 0x80, 0xbf,
	0x84, 0x2d, 0xee, 0xf3, 0x19, 0x61, 0x2e, 0xf9, 0x65, 0x48, 0x62, 0xc6, 0xbd, 0x13, 0xbf, 0x4b,
	0x16, 0x79, 0xe7, 0x0c, 0x57, 0xa0, 0xf0, 0x3f, 0x06, 0x14, 0x1b, 0x1e, 0xf3, 0x6a, 0x5e, 0x17,
	0x3d, 0x06, 0x33, 0x08, 0x59, 0x6c, 0x69, 0x3b, 0xc6, 0xfe, 0xe6, 0xe1, 0x6e, 0x16, 0x53, 0x41,
	0x9d, 0xaf, 0x43, 0x16, 0x37, 0x43, 0x16, 0x9d, 0xbb, 0x82, 0x82, 0x9e, 0x42, 0xa1, 0x4d, 0x69,
	0x2f, 0xb6, 0x74, 0xc1, 0xdd, 0x5b, 0xc4, 0xad, 0x71, 0xa0, 0x24, 0x4b, 0x12, 0xaa, 0x41, 0x31,
	0x66, 0x51, 0x10, 0x76, 0x63, 0xcb, 0x10, 0xfc, 0xfd, 0x45, 0xfc, 0x13, 0x09, 0x95, 0x16, 0x12,
	0x22, 0xb7, 0xe1, 0xd3, 0x61, 0xbb, 0x47, 0x62, 0xcb, 0x5c, 0x6e, 0xa3, 0x21, 0xa1, 0xca, 0x86,
	0x22, 0xda, 0x0f, 0xa1, 0x3c, 0x49, 0x0c, 0x55, 0xc0, 0x78, 0x43, 0xce, 0x55, 0xc3, 0xf9, 0x5f,
	0x74, 0x0b, 0x0a, 0x23, 0xaf, 0x37, 0x24, 0xa2, 0x59, 0x86, 0x2b, 0x17, 0x4f, 0xf4, 0x47, 0x9a,
	0xfd, 0x08, 0x60, 0x9a, 0xd5, 0x32, 0x66, 0x29, 0xcd, 0x7c, 0x02, 0xd7, 0xd3, 0xf9, 0x2c, 0xe3,
	0x96, 0xe7, 0xb8, 0xe9, 0x3c, 0x96, 0x71, 0xb5, 0x14, 0x17, 0xff, 0xad, 0x81, 0xc9, 0x8b, 0x81,
	0x1e, 0x03, 0x74, 0x22, 0xe2, 0x31, 0xe2, 0x9f, 0x7a, 0x4c, 0x0d, 0x8d, 0xed, 0x48, 0x59, 0x38,
	0x89, 0x2c, 0x9c, 0x56, 0x22, 0x0b, 0xb7, 0xac, 0xd0, 0x47, 0x8c, 0x53, 0x87, 0x03, 0x3f, 0xa1,
	0xea, 0xcb, 0xa9, 0x0a, 0x7d, 0xc4, 0x90, 0x05, 0xc5, 0x11, 0x89, 0xe2, 0x80, 0x86, 0x62, 0x9a,
	0x0d, 0x37, 0x59, 0xa2, 0x2a, 0x98, 0xbe, 0xc7, 0x3c, 0xcb, 0x14, 0xe6, 0xee, 0x2c, 0x68, 0xa2,
	0x2b, 0x80, 0xf8, 0x0c, 0xe0, 0x98, 0x7a, 0x3e, 0xf1, 0x13, 0xed, 0x5d, 0x7e, 0xfa, 0x39, 0x3a,
	0xe5, 0xcc, 0xca, 0x73, 0xa6, 0x3c, 0x35, 0xe1, 0xe6, 0x44, 0x6b, 0xf1, 0x80, 0x86, 0x31, 0x41,
	0x87, 0x33, 0xee, 0x3e, 0xca, 0x32, 0x30, 0x0d, 0x4e, 0x49, 0xee, 0x2f, 0x0d, 0x3e, 0xe0, 0xcb,
	0xba, 0x28, 0xe4, 0x5a, 0xb2, 0x9d, 0x54, 0x49, 0xbf, 0x64, 0x95, 0xe6, 0xda, 0x6c, 0xac, 0xd0,
	0x66, 0xfc, 0x15, 0xa0, 0x74, 0xb8, 0x57, 0xc8, 0xfc, 0x18, 0x6e, 0xf2, 0x74, 0x83, 0x88, 0xf8,
	0xcf, 0x55, 0xbb, 0x67, 0x67, 0x48, 0x5b, 0x61, 0x86, 0xf0, 0xef, 0xba, 0xac, 0xe3, 0x0f, 0x62,
	0xe7, 0x7f, 0xaa, 0xe3, 0x2e, 0x6c, 0xd1, 0x11, 0x89, 0xc6, 0x51, 0xc0, 0xc8, 0xa9, 0xa0, 0x1a,
	0x42, 0xd2, 0x37, 0x26, 0xbb, 0x19, 0xaa, 0x32, 0x57, 0x51, 0xd5, 0x17, 0x53, 0x69, 0x14, 0x04,
	0xef, 0x6e, 0x56, 0x54, 0x73, 0x75, 0x9c, 0xe8, 0x27, 0xe9, 0x56, 0x52, 0x94, 0x2b, 0x74, 0xeb,
	0x25, 0x54, 0x44, 0xdf, 0xe9, 0x30, 0x4c, 0x5f, 0x2e, 0x2b, 0x5c, 0x6d, 0x77, 0xa0, 0xcc, 0x2d,
	0x9d, 0x8a, 0x5b, 0x4b, 0x1e, 0x5f, 0x25, 0xbe, 0xd1, 0xe2, 0x37, 0xd7, 0x7d, 0xa5, 0x02, 0x69,
	0x5e, 0xc5, 0x79, 0x0b, 0x0a, 0x1d, 0xbe, 0x21, 0x1c, 0x18, 0xae, 0x5c, 0xe0, 0x57, 0x70, 0x7b,
	0x9a, 0x13, 0x27, 0xaf, 0xd7, 0xec, 0x0f, 0xa1, 0x14, 0x92, 0x71, 0x3a, 0x9a, 0x62, 0x48, 0xc6,
	0x22, 0x98, 0x63, 0xd8, 0x9e, 0xf7, 0x70, 0x85, 0xca, 0xfd, 0xa6, 0x14, 0xde, 0x20, 0x3d, 0xb2,
	0xee, 0x64, 0xa6, 0xc6, 0x40, 0x5f, 0x7f, 0x0c, 0x92, 0x08, 0xae, 0x90, 0xcc, 0x1f, 0x1a, 0x5c,
	0xff, 0xde, 0xeb, 0x12, 0x3f, 0xc9, 0x63, 0x1b, 0xae, 0x75, 0x86, 0x51, 0x4c, 0x23, 0x75, 0xd3,
	0xa8, 0x15, 0xef, 0x5d, 0x2f, 0xe8, 0x07, 0x2c, 0xb9, 0x1e, 0xc5, 0x82, 0xbf, 0x0c, 0x68, 0xe4,
	0x93, 0x48, 0xe8, 0x64, 0x2b, 0xfb, 0x65, 0x90, 0x36, 0xef, 0x7c, 0xc7, 0xd1, 0xae, 0x24, 0x61,
	0x1b, 0x0a, 0x62, 0x8d, 0x8a, 0x60, 0x1c, 0x9d, 0xd4, 0x2b, 0x1b, 0xa8, 0x04, 0x66, 0xa3, 0x79,
	0x52, 0xaf, 0x68, 0xf8, 0x9d, 0x26, 0xcf, 0xe3, 0xe3, 0x20, 0xfe, 0x0f, 0xe6, 0x13, 0x7d, 0x0e,
	0xe6, 0xc0, 0xeb, 0x12, 0x75, 0x56, 0xee, 0x2c, 0x8b, 0xdb, 0x15, 0x68, 0xfc, 0x0a, 0x90, 0xac,
	0x60, 0x5d, 0x14, 0x45, 0xdd, 0x4a, 0x6b, 0xd4, 0x3d, 0x55, 0x66, 0x3d, 0x5d, 0x66, 0x1c, 0x4a,
	0x59, 0xca, 0xac, 0x55, 0x5f, 0xf3, 0x5a, 0xf2, 0x14, 0x0a, 0xdc, 0x56, 0xf2, 0xac, 0xda, 0xcb,
	0x77, 0x9c, 0x0e, 0xd7, 0x95, 0xa4, 0x6f, 0xcc, 0x92, 0x5e, 0x31, 0xf0, 0x9f, 0x1a, 0xdc, 0xae,
	0x0d, 0x7b, 0x6f, 0x32, 0x8f, 0xda, 0xf7, 0x55, 0x6c, 0x0c, 0x37, 0xb8, 0x34, 0xa7, 0x00, 0xf9,
	0xc6, 0xdd, 0x0c, 0xc9, 0xb8, 0x99, 0x60, 0x26, 0xf3, 0xc5, 0x8f, 0xd3, 0x82, 0x9a, 0x2f, 0xfc,
	0x00, 0xb6, 0xe7, 0xa3, 0x53, 0x45, 0x41, 0x60, 0xf6, 0x69, 0x24, 0x8b, 0x5e, 0x72, 0xc5, 0x7f,
	0xfc, 0x76, 0x9a, 0xcb, 0x05, 0x71, 0xbe, 0xaf, 0x5c, 0x26, 0x71, 0x1a, 0x39, 0x71, 0xce, 0x89,
	0x32, 0x23, 0xce, 0xc3, 0x77, 0xd7, 0x00, 0x5d, 0xfc, 0xa6, 0x41, 0x2d, 0x28, 0xaa, 0x17, 0x08,
	0xc2, 0x79, 0xe7, 0xc7, 0xf4, 0x53, 0xc0, 0xbe, 0xbb, 0x10, 0x23, 0xdd, 0xe3, 0x0d, 0xf4, 0x12,
	0x60, 0x7a, 0xc1, 0xa3, 0xdd, 0x3c, 0xd2, 0xcc, 0x7b, 0xc5, 0xde, 0x5b, 0x06, 0x9b, 0x37, 0x2f,
	0xbb, 0x93, 0x6f, 0x7e, 0x66, 0xb6, 0xf2, 0xcd, 0xcf, 0x36, 0x19, 0x6f, 0xa0, 0x17, 0x50, 0x9e,
	0xdc, 0x23, 0xe8, 0x5e, 0x6e, 0x54, 0xa9, 0x5b, 0xcc, 0xde, 0x5d, 0x82, 0x9a, 0x0f, 0x5d, 0x36,
	0x2c, 0x3f, 0xf4, 0x99, 0x51, 0xca, 0x0f, 0x7d, 0xb6, 0xef, 0x78, 0x03, 0xfd, 0x08, 0xa5, 0x44,
	0xca, 0x28, 0xb7, 0x57, 0xa9, 0xe3, 0xcd, 0xbe, 0xb7, 0x18, 0x34, 0x31, 0x1c, 0xc0, 0xd6, 0xac,
	0x28, 0xd0, 0xfd, 0x2c, 0x66, 0xa6, 0xac, 0xed, 0x83, 0xcb, 0x40, 0xb3, 0x5c, 0xa9, 0x32, 0x2d,
	0x74, 0x35, 0x5b, 0xaa, 0x83, 0xcb, 0x40, 0x13, 0x57, 0xb5, 0x4f, 0x5f, 0x7c, 0xb2, 0xc2, 0xb7,
	0x7f, 0xfb, 0x9a, 0x78, 0x67, 0x7d, 0xf6, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf3, 0x72, 0x58,
	0x71, 0x31, 0x10, 0x00, 0x00,
}
