// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchVXModelRegistryLambdaTwirp/twirp.proto

/*
Package TwitchVXModelRegistryLambdaTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchVXModelRegistryLambdaTwirp/model_metadata_schema.proto
	code.justin.tv/amzn/TwitchVXModelRegistryLambdaTwirp/twirp.proto
*/
package TwitchVXModelRegistryLambdaTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ===============================
// TwitchVXModelRegistry Interface
// ===============================

type TwitchVXModelRegistry interface {
	// Register the metadata for a model instance
	RegisterModel(context.Context, *RegisterModelRequest) (*RegisterModelResponse, error)

	// Fetch the metadata for a model instance
	GetModel(context.Context, *GetModelRequest) (*GetModelResponse, error)

	// Update the metadata for an existing model instance, only update or append the fields in the metadata
	UpdateModel(context.Context, *UpdateModelRequest) (*UpdateModelResponse, error)

	// Ask model registry to start replacing the old instance with the new one
	RolloutModel(context.Context, *RolloutModelRequest) (*RolloutModelResponse, error)

	// Get the most current rollout entry for model families since the clients are polling model families periodically
	GetAvailableModels(context.Context, *GetAvailableModelsRequest) (*GetAvailableModelsResponse, error)
}

// =====================================
// TwitchVXModelRegistry Protobuf Client
// =====================================

type twitchVXModelRegistryProtobufClient struct {
	client HTTPClient
	urls   [5]string
	opts   twirp.ClientOptions
}

// NewTwitchVXModelRegistryProtobufClient creates a Protobuf client that implements the TwitchVXModelRegistry interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchVXModelRegistryProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchVXModelRegistry {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchVXModelRegistryPathPrefix
	urls := [5]string{
		prefix + "RegisterModel",
		prefix + "GetModel",
		prefix + "UpdateModel",
		prefix + "RolloutModel",
		prefix + "GetAvailableModels",
	}

	return &twitchVXModelRegistryProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchVXModelRegistryProtobufClient) RegisterModel(ctx context.Context, in *RegisterModelRequest) (*RegisterModelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvxmodelregistry")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXModelRegistry")
	ctx = ctxsetters.WithMethodName(ctx, "RegisterModel")
	out := new(RegisterModelResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXModelRegistryProtobufClient) GetModel(ctx context.Context, in *GetModelRequest) (*GetModelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvxmodelregistry")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXModelRegistry")
	ctx = ctxsetters.WithMethodName(ctx, "GetModel")
	out := new(GetModelResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXModelRegistryProtobufClient) UpdateModel(ctx context.Context, in *UpdateModelRequest) (*UpdateModelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvxmodelregistry")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXModelRegistry")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateModel")
	out := new(UpdateModelResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXModelRegistryProtobufClient) RolloutModel(ctx context.Context, in *RolloutModelRequest) (*RolloutModelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvxmodelregistry")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXModelRegistry")
	ctx = ctxsetters.WithMethodName(ctx, "RolloutModel")
	out := new(RolloutModelResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXModelRegistryProtobufClient) GetAvailableModels(ctx context.Context, in *GetAvailableModelsRequest) (*GetAvailableModelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvxmodelregistry")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXModelRegistry")
	ctx = ctxsetters.WithMethodName(ctx, "GetAvailableModels")
	out := new(GetAvailableModelsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =================================
// TwitchVXModelRegistry JSON Client
// =================================

type twitchVXModelRegistryJSONClient struct {
	client HTTPClient
	urls   [5]string
	opts   twirp.ClientOptions
}

// NewTwitchVXModelRegistryJSONClient creates a JSON client that implements the TwitchVXModelRegistry interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchVXModelRegistryJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchVXModelRegistry {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchVXModelRegistryPathPrefix
	urls := [5]string{
		prefix + "RegisterModel",
		prefix + "GetModel",
		prefix + "UpdateModel",
		prefix + "RolloutModel",
		prefix + "GetAvailableModels",
	}

	return &twitchVXModelRegistryJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchVXModelRegistryJSONClient) RegisterModel(ctx context.Context, in *RegisterModelRequest) (*RegisterModelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvxmodelregistry")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXModelRegistry")
	ctx = ctxsetters.WithMethodName(ctx, "RegisterModel")
	out := new(RegisterModelResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXModelRegistryJSONClient) GetModel(ctx context.Context, in *GetModelRequest) (*GetModelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvxmodelregistry")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXModelRegistry")
	ctx = ctxsetters.WithMethodName(ctx, "GetModel")
	out := new(GetModelResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXModelRegistryJSONClient) UpdateModel(ctx context.Context, in *UpdateModelRequest) (*UpdateModelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvxmodelregistry")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXModelRegistry")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateModel")
	out := new(UpdateModelResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXModelRegistryJSONClient) RolloutModel(ctx context.Context, in *RolloutModelRequest) (*RolloutModelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvxmodelregistry")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXModelRegistry")
	ctx = ctxsetters.WithMethodName(ctx, "RolloutModel")
	out := new(RolloutModelResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVXModelRegistryJSONClient) GetAvailableModels(ctx context.Context, in *GetAvailableModelsRequest) (*GetAvailableModelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvxmodelregistry")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXModelRegistry")
	ctx = ctxsetters.WithMethodName(ctx, "GetAvailableModels")
	out := new(GetAvailableModelsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ====================================
// TwitchVXModelRegistry Server Handler
// ====================================

type twitchVXModelRegistryServer struct {
	TwitchVXModelRegistry
	hooks *twirp.ServerHooks
}

func NewTwitchVXModelRegistryServer(svc TwitchVXModelRegistry, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchVXModelRegistryServer{
		TwitchVXModelRegistry: svc,
		hooks:                 hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchVXModelRegistryServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchVXModelRegistryPathPrefix is used for all URL paths on a twirp TwitchVXModelRegistry server.
// Requests are always: POST TwitchVXModelRegistryPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchVXModelRegistryPathPrefix = "/twirp/twitch.fulton.example.twitchvxmodelregistry.TwitchVXModelRegistry/"

func (s *twitchVXModelRegistryServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvxmodelregistry")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVXModelRegistry")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.example.twitchvxmodelregistry.TwitchVXModelRegistry/RegisterModel":
		s.serveRegisterModel(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchvxmodelregistry.TwitchVXModelRegistry/GetModel":
		s.serveGetModel(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchvxmodelregistry.TwitchVXModelRegistry/UpdateModel":
		s.serveUpdateModel(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchvxmodelregistry.TwitchVXModelRegistry/RolloutModel":
		s.serveRolloutModel(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchvxmodelregistry.TwitchVXModelRegistry/GetAvailableModels":
		s.serveGetAvailableModels(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchVXModelRegistryServer) serveRegisterModel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRegisterModelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRegisterModelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVXModelRegistryServer) serveRegisterModelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RegisterModel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RegisterModelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RegisterModelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXModelRegistry.RegisterModel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RegisterModelResponse and nil error while calling RegisterModel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXModelRegistryServer) serveRegisterModelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RegisterModel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RegisterModelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RegisterModelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXModelRegistry.RegisterModel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RegisterModelResponse and nil error while calling RegisterModel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXModelRegistryServer) serveGetModel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetModelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetModelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVXModelRegistryServer) serveGetModelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetModel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetModelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetModelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXModelRegistry.GetModel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetModelResponse and nil error while calling GetModel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXModelRegistryServer) serveGetModelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetModel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetModelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetModelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXModelRegistry.GetModel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetModelResponse and nil error while calling GetModel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXModelRegistryServer) serveUpdateModel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateModelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateModelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVXModelRegistryServer) serveUpdateModelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateModel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateModelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateModelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXModelRegistry.UpdateModel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateModelResponse and nil error while calling UpdateModel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXModelRegistryServer) serveUpdateModelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateModel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateModelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateModelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXModelRegistry.UpdateModel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateModelResponse and nil error while calling UpdateModel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXModelRegistryServer) serveRolloutModel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRolloutModelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRolloutModelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVXModelRegistryServer) serveRolloutModelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RolloutModel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RolloutModelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RolloutModelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXModelRegistry.RolloutModel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RolloutModelResponse and nil error while calling RolloutModel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXModelRegistryServer) serveRolloutModelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RolloutModel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RolloutModelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RolloutModelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXModelRegistry.RolloutModel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RolloutModelResponse and nil error while calling RolloutModel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXModelRegistryServer) serveGetAvailableModels(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAvailableModelsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAvailableModelsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVXModelRegistryServer) serveGetAvailableModelsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAvailableModels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAvailableModelsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAvailableModelsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXModelRegistry.GetAvailableModels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAvailableModelsResponse and nil error while calling GetAvailableModels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXModelRegistryServer) serveGetAvailableModelsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAvailableModels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetAvailableModelsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAvailableModelsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVXModelRegistry.GetAvailableModels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAvailableModelsResponse and nil error while calling GetAvailableModels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVXModelRegistryServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchVXModelRegistryServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchVXModelRegistryServer) PathPrefix() string {
	return TwitchVXModelRegistryPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1839 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x59, 0x4f, 0x73, 0x1b, 0x49,
	0x15, 0xcf, 0x48, 0xfe, 0x13, 0x3d, 0x49, 0xf6, 0xb8, 0x63, 0x3b, 0x8a, 0x36, 0xb0, 0x66, 0xb6,
	0xa0, 0x82, 0x97, 0x92, 0xab, 0x9c, 0x00, 0x4b, 0x8a, 0xec, 0x46, 0x91, 0xc6, 0x8e, 0x16, 0x59,
	0xf2, 0xb6, 0x64, 0x93, 0x40, 0xd5, 0x4e, 0x75, 0x34, 0x2d, 0x65, 0xb2, 0xf3, 0x47, 0xee, 0x69,
	0x29, 0x36, 0x47, 0x0e, 0xcb, 0x01, 0x0e, 0x54, 0x51, 0xc5, 0x85, 0x13, 0x07, 0xe0, 0xce, 0x91,
	0x0f, 0xc0, 0x17, 0xe0, 0x44, 0x51, 0xc5, 0x85, 0x2f, 0x42, 0x75, 0x4f, 0x8f, 0x34, 0x92, 0x4c,
	0x15, 0xa3, 0xf8, 0x90, 0x8b, 0x4b, 0xfd, 0x7a, 0xe6, 0xf7, 0x7e, 0xfd, 0xba, 0xdf, 0xef, 0xbd,
	0x69, 0xc3, 0xd3, 0x5e, 0x60, 0xd3, 0xca, 0x9b, 0x51, 0xc8, 0x1d, 0xbf, 0xc2, 0xc7, 0x07, 0xc4,
	0xfb, 0x85, 0x7f, 0xd0, 0x7d, 0xeb, 0xf0, 0xde, 0xeb, 0xf3, 0x17, 0x27, 0x81, 0x4d, 0x5d, 0x4c,
	0x07, 0x4e, 0xc8, 0xd9, 0x55, 0x93, 0x78, 0xaf, 0x6c, 0xd2, 0x7d, 0xeb, 0xb0, 0xe1, 0x01, 0x17,
	0x7f, 0x2b, 0x43, 0x16, 0xf0, 0x00, 0x7d, 0xcc, 0xe5, 0xd3, 0x95, 0xfe, 0xc8, 0xe5, 0x81, 0x5f,
	0xa1, 0x97, 0xc4, 0x1b, 0xba, 0xb4, 0x12, 0x59, 0xc7, 0x97, 0x9e, 0xc0, 0x60, 0x0a, 0xa3, 0xfc,
	0xe1, 0x20, 0x08, 0x06, 0x2e, 0x3d, 0x90, 0xaf, 0xbe, 0x1a, 0xf5, 0x0f, 0xb8, 0xe3, 0xd1, 0x90,
	0x13, 0x4f, 0xa1, 0x19, 0xff, 0xc8, 0xc0, 0x96, 0x74, 0x7b, 0x44, 0x3c, 0xc7, 0xbd, 0xaa, 0x05,
	0x7e, 0xdf, 0x19, 0x20, 0x0f, 0xb6, 0x5c, 0xa7, 0x4f, 0xad, 0xde, 0x55, 0xcf, 0xa5, 0x56, 0x4f,
	0x1a, 0x4b, 0xda, 0x9e, 0xf6, 0x20, 0x7f, 0x58, 0xad, 0xa4, 0xf0, 0x5f, 0x91, 0xd0, 0x4d, 0xa7,
	0x4f, 0x6b, 0x02, 0x29, 0x42, 0xc7, 0x9b, 0xee, 0xac, 0x01, 0x7d, 0x09, 0x45, 0x9b, 0x0e, 0xdd,
	0xe0, 0xca, 0xe2, 0x84, 0x0d, 0x28, 0x2f, 0x65, 0xf6, 0xb4, 0x07, 0x1b, 0x87, 0x3f, 0x4a, 0xe5,
	0xaa, 0x2e, 0x11, 0xba, 0x12, 0x00, 0x17, 0xec, 0xc4, 0x08, 0x05, 0xb0, 0x35, 0x26, 0xae, 0x63,
	0x13, 0xee, 0x04, 0x7e, 0xbc, 0x9c, 0xac, 0x5c, 0xce, 0xb3, 0xf4, 0xcb, 0x39, 0x9f, 0x40, 0xa9,
	0xf5, 0xe8, 0xe3, 0x39, 0x8b, 0xc1, 0x60, 0xe7, 0xda, 0x47, 0xd1, 0x4b, 0xc8, 0x87, 0xbd, 0xd7,
	0xd4, 0x23, 0x96, 0x4f, 0x3c, 0x2a, 0x43, 0xba, 0x71, 0xf8, 0x49, 0x7a, 0x0e, 0x1d, 0x09, 0x82,
	0x21, 0x02, 0x6b, 0x11, 0x8f, 0x1a, 0xff, 0xd4, 0x60, 0xfb, 0xba, 0x70, 0x23, 0x02, 0x1b, 0x2c,
	0x70, 0xdd, 0x60, 0xc4, 0x67, 0x77, 0xf2, 0x71, 0x2a, 0xb7, 0x38, 0x82, 0x50, 0x4b, 0x2e, 0xb2,
	0xe4, 0x50, 0x6c, 0x20, 0xa3, 0xdc, 0x61, 0x93, 0xb3, 0x92, 0x91, 0x1e, 0xd2, 0x6d, 0x20, 0x96,
	0x08, 0xca, 0x41, 0x81, 0x25, 0x46, 0xc6, 0x00, 0x8a, 0x33, 0xfe, 0xd1, 0x77, 0x41, 0x8f, 0xd7,
	0x64, 0x8f, 0x98, 0x8c, 0xb0, 0x5c, 0x55, 0x16, 0x6f, 0x2a, 0x7b, 0x5d, 0x99, 0xd1, 0xc7, 0xb0,
	0x15, 0x3f, 0xea, 0xf8, 0x3d, 0x46, 0x3d, 0xea, 0x47, 0x07, 0x2c, 0x8b, 0x63, 0x8c, 0x46, 0x6c,
	0x37, 0x18, 0x14, 0x92, 0x34, 0xd0, 0xa7, 0x70, 0xdf, 0x23, 0x97, 0x96, 0x1f, 0xf8, 0xd6, 0x90,
	0x05, 0xb6, 0x25, 0x19, 0x5b, 0x8e, 0x1f, 0x72, 0xe2, 0xf7, 0x68, 0xa8, 0x7c, 0x96, 0x3c, 0x72,
	0xd9, 0x0a, 0xfc, 0x53, 0x16, 0xd8, 0x72, 0x07, 0x1a, 0xf1, 0x3c, 0x32, 0xa0, 0x18, 0x5e, 0x84,
	0xd6, 0xc5, 0x88, 0x8e, 0xa8, 0x35, 0x62, 0xae, 0x74, 0x9c, 0xc3, 0xf9, 0xf0, 0x22, 0xfc, 0x42,
	0xd8, 0xce, 0x98, 0x6b, 0xfc, 0x32, 0x0b, 0xdb, 0x51, 0xd2, 0x53, 0xa6, 0x14, 0xe0, 0x62, 0x44,
	0x43, 0x8e, 0xbe, 0x05, 0x85, 0xc8, 0x5f, 0x5f, 0xe6, 0xa6, 0x74, 0x96, 0xc3, 0x79, 0x6f, 0x9a,
	0xae, 0xe8, 0x43, 0xc8, 0xc7, 0x64, 0x2c, 0xc7, 0x56, 0xe8, 0x10, 0x9b, 0x1a, 0x36, 0x6a, 0xc1,
	0x6d, 0x8f, 0x72, 0x62, 0x13, 0x4e, 0xd4, 0x89, 0x3f, 0x4c, 0x7f, 0xda, 0xf0, 0x04, 0x03, 0xf9,
	0x70, 0x27, 0xc9, 0x29, 0xde, 0xef, 0x15, 0x09, 0xfd, 0x69, 0x7a, 0xe8, 0xa4, 0xec, 0xe0, 0x2d,
	0x6f, 0x41, 0x89, 0xfa, 0x10, 0x19, 0x65, 0xf8, 0x47, 0x3d, 0xca, 0xc4, 0x32, 0x57, 0x65, 0xda,
	0x3c, 0x4e, 0xef, 0xed, 0x54, 0x81, 0xe0, 0x4d, 0x2f, 0x39, 0x6c, 0xd8, 0xc6, 0x1f, 0xb3, 0xb0,
	0x2a, 0x1f, 0x41, 0x2f, 0x20, 0x8a, 0xb0, 0x15, 0x72, 0xc2, 0xe3, 0x14, 0xfd, 0xe1, 0x12, 0x29,
	0x2a, 0x5e, 0xc7, 0xe0, 0x4d, 0x7e, 0x23, 0x1b, 0x36, 0xe8, 0x25, 0x67, 0xc4, 0x9a, 0xec, 0x48,
	0x94, 0x26, 0x4f, 0x52, 0x81, 0x9f, 0x2a, 0x29, 0x3f, 0x51, 0x20, 0xb8, 0x28, 0x41, 0xe3, 0x21,
	0x7a, 0x03, 0x5b, 0x91, 0xf8, 0x89, 0x03, 0x3d, 0x2b, 0x76, 0x4f, 0x96, 0x10, 0x54, 0x81, 0x12,
	0xeb, 0x9c, 0x3d, 0x67, 0x41, 0x2e, 0xdc, 0x75, 0xfc, 0x3e, 0x65, 0x54, 0x9c, 0xbf, 0x3e, 0x25,
	0x7c, 0xc4, 0xa8, 0xe5, 0x3a, 0x21, 0x0f, 0x4b, 0x2b, 0x7b, 0xd9, 0x07, 0xf9, 0xc3, 0x47, 0xa9,
	0x3c, 0x1e, 0x45, 0x08, 0x78, 0x67, 0x02, 0xaa, 0x2c, 0x4d, 0x01, 0x69, 0x7c, 0x07, 0xf4, 0xf9,
	0xc5, 0x23, 0x04, 0x2b, 0x32, 0x92, 0x62, 0x9b, 0x0a, 0x58, 0xfe, 0x36, 0xfe, 0xa0, 0x81, 0x3e,
	0x4f, 0x1e, 0x7d, 0xad, 0xc1, 0x07, 0x21, 0x19, 0x50, 0x8f, 0x7c, 0x45, 0x99, 0xb5, 0x18, 0xa1,
	0x48, 0x13, 0x8f, 0x52, 0xf1, 0xed, 0x90, 0x01, 0x3d, 0x11, 0x78, 0x0b, 0xa1, 0xba, 0x37, 0x71,
	0x35, 0x3f, 0x65, 0xfc, 0x5b, 0x83, 0x7b, 0xff, 0xf3, 0x45, 0xf4, 0x25, 0x00, 0x19, 0x3a, 0xb3,
	0xa4, 0x3e, 0x5b, 0x8e, 0x54, 0xf5, 0xb4, 0xa1, 0xd8, 0xe4, 0xc8, 0xd0, 0x51, 0xf8, 0xf7, 0xe0,
	0x36, 0x0b, 0x5c, 0x6a, 0x11, 0xe6, 0x2b, 0xb5, 0x58, 0x17, 0xe3, 0x2a, 0xf3, 0x85, 0xdc, 0x8c,
	0x09, 0x73, 0x88, 0xcf, 0xa3, 0xe2, 0x94, 0x8d, 0xe4, 0x46, 0xd9, 0x44, 0x8d, 0x41, 0x1f, 0x41,
	0x91, 0xfa, 0xf6, 0x30, 0x70, 0xe2, 0x67, 0x56, 0xe5, 0x33, 0x85, 0xd8, 0x28, 0x0b, 0xd1, 0x5f,
	0xb2, 0x80, 0x16, 0x49, 0xa0, 0xfd, 0x38, 0x93, 0xc3, 0x87, 0x96, 0x1b, 0xf4, 0xa6, 0x9a, 0x9d,
	0x53, 0xd9, 0xd8, 0x79, 0xd8, 0x54, 0x66, 0xe1, 0xa7, 0x17, 0xf8, 0x9c, 0x38, 0x3e, 0x65, 0x09,
	0xd9, 0x2c, 0x4c, 0x8c, 0x67, 0xcc, 0x45, 0x63, 0x41, 0x66, 0x6c, 0x49, 0x7e, 0xaf, 0x5c, 0x1a,
	0x96, 0xb2, 0xf2, 0xc8, 0x7d, 0xf1, 0x8e, 0xd1, 0xaa, 0x98, 0xfe, 0xf8, 0x3c, 0xc6, 0x34, 0x7d,
	0xce, 0xae, 0xc4, 0xfa, 0xa6, 0x26, 0xf4, 0x3d, 0x40, 0xf4, 0x92, 0xf6, 0x46, 0xb2, 0x99, 0x98,
	0x04, 0x73, 0x45, 0x32, 0xd4, 0x27, 0x33, 0x58, 0x45, 0xf5, 0x23, 0x28, 0x4e, 0x14, 0x9a, 0x5f,
	0x0d, 0x27, 0x21, 0x8b, 0x8d, 0xdd, 0xab, 0x21, 0x45, 0x8f, 0x60, 0xd7, 0xf1, 0x1d, 0xee, 0x90,
	0x69, 0x6d, 0xb1, 0x7a, 0xc1, 0xc8, 0xe7, 0xa5, 0x35, 0x59, 0x60, 0xb6, 0xd5, 0x6c, 0x5c, 0x58,
	0x6a, 0x62, 0xae, 0xfc, 0x19, 0x6c, 0x2d, 0x70, 0x45, 0x3a, 0x64, 0xbf, 0xa2, 0x71, 0xad, 0x10,
	0x3f, 0xd1, 0x36, 0xac, 0x8e, 0x89, 0x3b, 0xa2, 0x2a, 0x88, 0xd1, 0xe0, 0x71, 0xe6, 0x13, 0xcd,
	0xf8, 0x8f, 0x06, 0xeb, 0x2a, 0xc3, 0xd0, 0x1b, 0x28, 0xfa, 0x81, 0xdf, 0x0f, 0xe3, 0x34, 0x56,
	0x67, 0xaf, 0x96, 0x2a, 0x9a, 0xad, 0xc0, 0x57, 0x78, 0x1d, 0x1e, 0xb0, 0x38, 0x7b, 0x9f, 0xdf,
	0xc2, 0x05, 0x89, 0x1d, 0xfb, 0x22, 0x00, 0x09, 0x47, 0x91, 0x08, 0x3e, 0x5d, 0x46, 0x29, 0xe6,
	0xbc, 0xe4, 0x26, 0x2e, 0x9e, 0xe5, 0x60, 0x5d, 0xe1, 0x1b, 0x7d, 0xd8, 0xbd, 0x9e, 0x17, 0x6a,
	0x26, 0xc4, 0x23, 0x9f, 0xb2, 0x0d, 0x53, 0x18, 0x75, 0xa1, 0xc0, 0x91, 0xec, 0xfc, 0x4d, 0x83,
	0x3b, 0xd7, 0x79, 0xf9, 0x06, 0x40, 0x2c, 0x8d, 0x8e, 0xad, 0x36, 0x26, 0xa7, 0x2c, 0x0d, 0x7b,
	0x42, 0x22, 0x73, 0x13, 0x24, 0x50, 0x09, 0xd6, 0xc7, 0x94, 0x85, 0x22, 0xb7, 0x44, 0xfe, 0xae,
	0xe2, 0x78, 0x88, 0xee, 0x43, 0x4e, 0xa4, 0x6c, 0x38, 0x24, 0x3d, 0xaa, 0x4e, 0xeb, 0xd4, 0x60,
	0x70, 0xc8, 0x27, 0xc0, 0x84, 0x16, 0xc4, 0x9c, 0x27, 0x8d, 0x6a, 0x0e, 0xe7, 0x95, 0x4d, 0x6a,
	0x81, 0x6c, 0x3d, 0x86, 0x23, 0x6e, 0x05, 0xcc, 0xa6, 0x4c, 0x75, 0x54, 0x20, 0x4d, 0x6d, 0x61,
	0x91, 0xed, 0x0b, 0x19, 0x0e, 0xa9, 0x6d, 0x45, 0xc7, 0x4f, 0xe9, 0x49, 0x64, 0x3b, 0x17, 0x26,
	0xe3, 0x2e, 0xec, 0xcc, 0x75, 0x3e, 0xe1, 0x30, 0xf0, 0x43, 0x6a, 0xbc, 0x85, 0xcd, 0x63, 0xca,
	0x6f, 0xbc, 0x1b, 0xda, 0x83, 0x3c, 0xf5, 0xc7, 0x0e, 0x0b, 0x7c, 0xd9, 0x05, 0x2a, 0x46, 0x09,
	0x93, 0xf1, 0x67, 0x0d, 0xf4, 0xa9, 0xe7, 0x88, 0xcd, 0xfb, 0xd8, 0x88, 0x19, 0x7f, 0xcd, 0x00,
	0x3a, 0x1b, 0xda, 0x84, 0xd3, 0xf7, 0xbe, 0x67, 0xbc, 0xb6, 0x87, 0x5b, 0xb9, 0xf1, 0x1e, 0x6e,
	0x7e, 0x77, 0x57, 0x17, 0x77, 0x77, 0x07, 0xee, 0xcc, 0xc4, 0x4c, 0x9d, 0x36, 0x1b, 0xee, 0x1d,
	0x53, 0x5e, 0x1d, 0x13, 0xc7, 0x15, 0x4a, 0x2a, 0x27, 0xc3, 0x38, 0xa2, 0xdf, 0x86, 0x8d, 0x44,
	0x44, 0x1d, 0xd9, 0xf4, 0x67, 0x1f, 0xe4, 0x70, 0x71, 0x1a, 0x53, 0x87, 0x86, 0xf3, 0xce, 0x33,
	0x8b, 0xce, 0xaf, 0xa0, 0x7c, 0x9d, 0x17, 0x75, 0xc6, 0x7e, 0x2e, 0x0b, 0xb3, 0xf8, 0x1a, 0x89,
	0x1c, 0xa4, 0x2d, 0xfb, 0x89, 0x6e, 0x5a, 0x7d, 0x2a, 0xe1, 0x09, 0xa0, 0xf1, 0x1b, 0x0d, 0xd0,
	0xe2, 0x03, 0xff, 0xcf, 0x61, 0xe9, 0xc0, 0xba, 0x42, 0x59, 0xee, 0x9b, 0x2e, 0x7a, 0x37, 0x2a,
	0xa3, 0x31, 0x92, 0xf1, 0xaf, 0x0c, 0x14, 0x92, 0x33, 0xa8, 0x06, 0x9b, 0xa4, 0xc7, 0x9d, 0x71,
	0xf4, 0x81, 0x6e, 0xc7, 0x7d, 0x77, 0xfe, 0xb0, 0x5c, 0x89, 0x2e, 0x30, 0x2a, 0xf1, 0x05, 0x46,
	0xa5, 0x1b, 0x5f, 0x60, 0xe0, 0x8d, 0xe9, 0x2b, 0x75, 0xd1, 0x5e, 0xbf, 0x86, 0xdc, 0xf4, 0xc3,
	0x2c, 0x23, 0x43, 0xf8, 0xf9, 0xd2, 0x64, 0x2b, 0x3f, 0xa5, 0xce, 0xe0, 0x35, 0xa7, 0x76, 0x5c,
	0x72, 0xf1, 0x14, 0xbc, 0x2c, 0x1a, 0xcc, 0xf9, 0xf9, 0xf9, 0xb4, 0xd2, 0x16, 0xd2, 0x6a, 0x17,
	0xd6, 0xde, 0xca, 0x97, 0x94, 0x56, 0xaa, 0xd1, 0x8d, 0x2b, 0xc3, 0xdf, 0x33, 0x70, 0x47, 0x2d,
	0xe5, 0xc6, 0xa5, 0x61, 0xf1, 0x2e, 0x21, 0x7b, 0xd3, 0x77, 0x09, 0xef, 0x8f, 0x5a, 0xec, 0xc2,
	0xf6, 0x6c, 0x1c, 0xa3, 0x54, 0xdd, 0xff, 0x3e, 0x14, 0x92, 0x97, 0x4d, 0x28, 0x0f, 0xeb, 0x75,
	0xf3, 0xa8, 0x7a, 0xd6, 0xec, 0xea, 0xb7, 0x50, 0x09, 0xb6, 0x3b, 0xd5, 0x63, 0xf3, 0xa4, 0xfa,
	0x13, 0x13, 0x5b, 0x75, 0xf3, 0xb4, 0xd9, 0x7e, 0x79, 0x62, 0xb6, 0xba, 0xba, 0xb6, 0xff, 0xb5,
	0x06, 0xc5, 0x19, 0x4e, 0xe8, 0x9b, 0x50, 0x3e, 0x69, 0xd7, 0xcd, 0xa6, 0x75, 0x8a, 0xdb, 0xf5,
	0xb3, 0x9a, 0x89, 0xad, 0xb3, 0x56, 0xe7, 0xd4, 0xac, 0x35, 0x8e, 0x1a, 0x66, 0x5d, 0xbf, 0x85,
	0xca, 0xb0, 0x3b, 0x37, 0x7f, 0xfe, 0xc2, 0xaa, 0x55, 0x4f, 0x1a, 0xba, 0x86, 0xee, 0x43, 0x69,
	0x71, 0xae, 0x63, 0x56, 0x71, 0xed, 0xb9, 0x9e, 0x41, 0x1f, 0xc0, 0xdd, 0xc5, 0xd9, 0x56, 0xbb,
	0xdb, 0x38, 0xd2, 0xb3, 0xfb, 0x1e, 0xe4, 0x13, 0x97, 0x48, 0x53, 0xa4, 0x4e, 0xed, 0xb9, 0x79,
	0x52, 0x9d, 0xe3, 0xb0, 0x07, 0xf7, 0x67, 0x66, 0x3f, 0xef, 0xb4, 0x5b, 0x56, 0xbd, 0x51, 0xeb,
	0x36, 0xda, 0xad, 0x2a, 0x7e, 0xa9, 0x6b, 0xd3, 0x55, 0xa8, 0x27, 0x14, 0x47, 0x4b, 0x1a, 0xf5,
	0xcc, 0xfe, 0x05, 0xc0, 0xf4, 0x83, 0x58, 0x04, 0xab, 0x86, 0xcd, 0x6a, 0x57, 0x82, 0xe7, 0x61,
	0xbd, 0x8b, 0xab, 0x8d, 0x96, 0x59, 0xd7, 0x35, 0x54, 0x84, 0xdc, 0x79, 0xb5, 0xd9, 0xa8, 0xcb,
	0xb9, 0x0c, 0x2a, 0xc0, 0xed, 0x28, 0x7c, 0x66, 0x5d, 0xcf, 0xa2, 0x0d, 0x00, 0xdc, 0x6e, 0x36,
	0x1b, 0xad, 0xe3, 0xf6, 0x59, 0x57, 0x5f, 0x41, 0x9b, 0x90, 0x3f, 0x6d, 0x77, 0xba, 0xc2, 0x26,
	0x0c, 0xab, 0x02, 0x0a, 0x9b, 0xdd, 0x06, 0x36, 0xeb, 0xfa, 0xda, 0xe1, 0xaf, 0xd7, 0x60, 0xe7,
	0xda, 0x4b, 0x55, 0xf4, 0x7b, 0x0d, 0x8a, 0x33, 0x2d, 0x07, 0xaa, 0xa6, 0xbc, 0xa4, 0x5a, 0xbc,
	0xa8, 0x29, 0x3f, 0x7b, 0x17, 0x08, 0xa5, 0xff, 0xbf, 0xd2, 0xe0, 0x76, 0xdc, 0x78, 0xa0, 0x1f,
	0xa7, 0x02, 0x9c, 0xeb, 0x94, 0xca, 0x4f, 0x96, 0x7c, 0x5b, 0x31, 0xf9, 0xad, 0x06, 0xf9, 0x44,
	0x95, 0x44, 0xe9, 0xea, 0xd0, 0x62, 0x4f, 0x52, 0x7e, 0xba, 0x3c, 0x80, 0xa2, 0xf4, 0x3b, 0x6d,
	0x52, 0x30, 0x22, 0x4e, 0x4f, 0x97, 0xd1, 0x9b, 0x19, 0x52, 0xd5, 0x77, 0x40, 0x50, 0xac, 0xfe,
	0xa4, 0x01, 0x5a, 0xac, 0xe8, 0xe8, 0x28, 0x6d, 0xf8, 0xaf, 0x6f, 0x3c, 0xca, 0xc7, 0xef, 0x8c,
	0x13, 0xf1, 0x7c, 0xf6, 0x83, 0x9f, 0x3d, 0x5a, 0xe6, 0xbf, 0x0e, 0xaf, 0xd6, 0x64, 0xd1, 0x7d,
	0xf8, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xc2, 0xc9, 0x27, 0x9a, 0xb4, 0x18, 0x00, 0x00,
}
