// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchVaderLambdaTwirp/twirp.proto

/*
Package TwitchVaderLambdaTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchVaderLambdaTwirp/twirp.proto
*/
package TwitchVaderLambdaTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// =====================
// TwitchVader Interface
// =====================

type TwitchVader interface {
	GetChannelSettings(context.Context, *GetChannelSettingsRequest) (*GetChannelSettingsResponse, error)

	SetChannelSettings(context.Context, *SetChannelSettingsRequest) (*SetChannelSettingsResponse, error)

	GetCCPEChannelIds(context.Context, *GetCCPEChannelIdsRequest) (*GetCCPEChannelIdsResponse, error)

	GetChannelPropertiesTableEntry(context.Context, *GetChannelPropertiesTableEntryRequest) (*GetChannelPropertiesTableEntryResponse, error)

	SetChannelPropertiesTableEntry(context.Context, *SetChannelPropertiesTableEntryRequest) (*SetChannelPropertiesTableEntryResponse, error)

	SnoozeNextAd(context.Context, *SnoozeNextAdRequest) (*SnoozeNextAdResponse, error)
}

// ===========================
// TwitchVader Protobuf Client
// ===========================

type twitchVaderProtobufClient struct {
	client HTTPClient
	urls   [6]string
	opts   twirp.ClientOptions
}

// NewTwitchVaderProtobufClient creates a Protobuf client that implements the TwitchVader interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchVaderProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchVader {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchVaderPathPrefix
	urls := [6]string{
		prefix + "GetChannelSettings",
		prefix + "SetChannelSettings",
		prefix + "GetCCPEChannelIds",
		prefix + "GetChannelPropertiesTableEntry",
		prefix + "SetChannelPropertiesTableEntry",
		prefix + "SnoozeNextAd",
	}

	return &twitchVaderProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchVaderProtobufClient) GetChannelSettings(ctx context.Context, in *GetChannelSettingsRequest) (*GetChannelSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvader")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVader")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSettings")
	out := new(GetChannelSettingsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVaderProtobufClient) SetChannelSettings(ctx context.Context, in *SetChannelSettingsRequest) (*SetChannelSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvader")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVader")
	ctx = ctxsetters.WithMethodName(ctx, "SetChannelSettings")
	out := new(SetChannelSettingsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVaderProtobufClient) GetCCPEChannelIds(ctx context.Context, in *GetCCPEChannelIdsRequest) (*GetCCPEChannelIdsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvader")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVader")
	ctx = ctxsetters.WithMethodName(ctx, "GetCCPEChannelIds")
	out := new(GetCCPEChannelIdsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVaderProtobufClient) GetChannelPropertiesTableEntry(ctx context.Context, in *GetChannelPropertiesTableEntryRequest) (*GetChannelPropertiesTableEntryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvader")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVader")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelPropertiesTableEntry")
	out := new(GetChannelPropertiesTableEntryResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVaderProtobufClient) SetChannelPropertiesTableEntry(ctx context.Context, in *SetChannelPropertiesTableEntryRequest) (*SetChannelPropertiesTableEntryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvader")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVader")
	ctx = ctxsetters.WithMethodName(ctx, "SetChannelPropertiesTableEntry")
	out := new(SetChannelPropertiesTableEntryResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVaderProtobufClient) SnoozeNextAd(ctx context.Context, in *SnoozeNextAdRequest) (*SnoozeNextAdResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvader")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVader")
	ctx = ctxsetters.WithMethodName(ctx, "SnoozeNextAd")
	out := new(SnoozeNextAdResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =======================
// TwitchVader JSON Client
// =======================

type twitchVaderJSONClient struct {
	client HTTPClient
	urls   [6]string
	opts   twirp.ClientOptions
}

// NewTwitchVaderJSONClient creates a JSON client that implements the TwitchVader interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchVaderJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchVader {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchVaderPathPrefix
	urls := [6]string{
		prefix + "GetChannelSettings",
		prefix + "SetChannelSettings",
		prefix + "GetCCPEChannelIds",
		prefix + "GetChannelPropertiesTableEntry",
		prefix + "SetChannelPropertiesTableEntry",
		prefix + "SnoozeNextAd",
	}

	return &twitchVaderJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchVaderJSONClient) GetChannelSettings(ctx context.Context, in *GetChannelSettingsRequest) (*GetChannelSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvader")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVader")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSettings")
	out := new(GetChannelSettingsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVaderJSONClient) SetChannelSettings(ctx context.Context, in *SetChannelSettingsRequest) (*SetChannelSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvader")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVader")
	ctx = ctxsetters.WithMethodName(ctx, "SetChannelSettings")
	out := new(SetChannelSettingsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVaderJSONClient) GetCCPEChannelIds(ctx context.Context, in *GetCCPEChannelIdsRequest) (*GetCCPEChannelIdsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvader")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVader")
	ctx = ctxsetters.WithMethodName(ctx, "GetCCPEChannelIds")
	out := new(GetCCPEChannelIdsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVaderJSONClient) GetChannelPropertiesTableEntry(ctx context.Context, in *GetChannelPropertiesTableEntryRequest) (*GetChannelPropertiesTableEntryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvader")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVader")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelPropertiesTableEntry")
	out := new(GetChannelPropertiesTableEntryResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVaderJSONClient) SetChannelPropertiesTableEntry(ctx context.Context, in *SetChannelPropertiesTableEntryRequest) (*SetChannelPropertiesTableEntryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvader")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVader")
	ctx = ctxsetters.WithMethodName(ctx, "SetChannelPropertiesTableEntry")
	out := new(SetChannelPropertiesTableEntryResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVaderJSONClient) SnoozeNextAd(ctx context.Context, in *SnoozeNextAdRequest) (*SnoozeNextAdResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvader")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVader")
	ctx = ctxsetters.WithMethodName(ctx, "SnoozeNextAd")
	out := new(SnoozeNextAdResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==========================
// TwitchVader Server Handler
// ==========================

type twitchVaderServer struct {
	TwitchVader
	hooks *twirp.ServerHooks
}

func NewTwitchVaderServer(svc TwitchVader, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchVaderServer{
		TwitchVader: svc,
		hooks:       hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchVaderServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchVaderPathPrefix is used for all URL paths on a twirp TwitchVader server.
// Requests are always: POST TwitchVaderPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchVaderPathPrefix = "/twirp/twitch.fulton.example.twitchvader.TwitchVader/"

func (s *twitchVaderServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchvader")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVader")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.example.twitchvader.TwitchVader/GetChannelSettings":
		s.serveGetChannelSettings(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchvader.TwitchVader/SetChannelSettings":
		s.serveSetChannelSettings(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchvader.TwitchVader/GetCCPEChannelIds":
		s.serveGetCCPEChannelIds(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchvader.TwitchVader/GetChannelPropertiesTableEntry":
		s.serveGetChannelPropertiesTableEntry(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchvader.TwitchVader/SetChannelPropertiesTableEntry":
		s.serveSetChannelPropertiesTableEntry(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchvader.TwitchVader/SnoozeNextAd":
		s.serveSnoozeNextAd(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchVaderServer) serveGetChannelSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVaderServer) serveGetChannelSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetChannelSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetChannelSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVader.GetChannelSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSettingsResponse and nil error while calling GetChannelSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVaderServer) serveGetChannelSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetChannelSettingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetChannelSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVader.GetChannelSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSettingsResponse and nil error while calling GetChannelSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVaderServer) serveSetChannelSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetChannelSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetChannelSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVaderServer) serveSetChannelSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetChannelSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetChannelSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetChannelSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVader.SetChannelSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetChannelSettingsResponse and nil error while calling SetChannelSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVaderServer) serveSetChannelSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetChannelSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetChannelSettingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetChannelSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVader.SetChannelSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetChannelSettingsResponse and nil error while calling SetChannelSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVaderServer) serveGetCCPEChannelIds(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCCPEChannelIdsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCCPEChannelIdsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVaderServer) serveGetCCPEChannelIdsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCCPEChannelIds")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCCPEChannelIdsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCCPEChannelIdsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVader.GetCCPEChannelIds(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCCPEChannelIdsResponse and nil error while calling GetCCPEChannelIds. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVaderServer) serveGetCCPEChannelIdsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCCPEChannelIds")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetCCPEChannelIdsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCCPEChannelIdsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVader.GetCCPEChannelIds(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCCPEChannelIdsResponse and nil error while calling GetCCPEChannelIds. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVaderServer) serveGetChannelPropertiesTableEntry(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelPropertiesTableEntryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelPropertiesTableEntryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVaderServer) serveGetChannelPropertiesTableEntryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelPropertiesTableEntry")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetChannelPropertiesTableEntryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetChannelPropertiesTableEntryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVader.GetChannelPropertiesTableEntry(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelPropertiesTableEntryResponse and nil error while calling GetChannelPropertiesTableEntry. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVaderServer) serveGetChannelPropertiesTableEntryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelPropertiesTableEntry")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetChannelPropertiesTableEntryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetChannelPropertiesTableEntryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVader.GetChannelPropertiesTableEntry(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelPropertiesTableEntryResponse and nil error while calling GetChannelPropertiesTableEntry. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVaderServer) serveSetChannelPropertiesTableEntry(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetChannelPropertiesTableEntryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetChannelPropertiesTableEntryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVaderServer) serveSetChannelPropertiesTableEntryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetChannelPropertiesTableEntry")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetChannelPropertiesTableEntryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetChannelPropertiesTableEntryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVader.SetChannelPropertiesTableEntry(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetChannelPropertiesTableEntryResponse and nil error while calling SetChannelPropertiesTableEntry. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVaderServer) serveSetChannelPropertiesTableEntryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetChannelPropertiesTableEntry")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetChannelPropertiesTableEntryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetChannelPropertiesTableEntryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVader.SetChannelPropertiesTableEntry(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetChannelPropertiesTableEntryResponse and nil error while calling SetChannelPropertiesTableEntry. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVaderServer) serveSnoozeNextAd(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSnoozeNextAdJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSnoozeNextAdProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVaderServer) serveSnoozeNextAdJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SnoozeNextAd")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SnoozeNextAdRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SnoozeNextAdResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVader.SnoozeNextAd(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SnoozeNextAdResponse and nil error while calling SnoozeNextAd. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVaderServer) serveSnoozeNextAdProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SnoozeNextAd")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SnoozeNextAdRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SnoozeNextAdResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVader.SnoozeNextAd(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SnoozeNextAdResponse and nil error while calling SnoozeNextAd. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVaderServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchVaderServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchVaderServer) PathPrefix() string {
	return TwitchVaderPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1580 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x58, 0x5b, 0x6f, 0xdb, 0x46,
	0x16, 0x86, 0x2c, 0xcb, 0x97, 0x23, 0xd9, 0xb2, 0x69, 0x27, 0x66, 0xe4, 0x6c, 0x62, 0x6b, 0xe3,
	0xac, 0xbd, 0x58, 0xc8, 0x80, 0x83, 0x64, 0x81, 0x5d, 0x6f, 0x80, 0xf8, 0x92, 0xb5, 0x82, 0xb8,
	0x35, 0x24, 0x27, 0x0f, 0x05, 0x5a, 0x62, 0xc4, 0x19, 0x5b, 0x6c, 0x78, 0xcb, 0xcc, 0xd0, 0x96,
	0x93, 0x87, 0x3e, 0xb6, 0x4f, 0x05, 0xfa, 0x4b, 0xfa, 0x54, 0xf4, 0x17, 0xf4, 0x87, 0xb4, 0xbf,
	0xa4, 0x98, 0x0b, 0x29, 0x4a, 0xa2, 0x2c, 0xc5, 0x49, 0xd1, 0xbe, 0x18, 0xe6, 0x39, 0xdf, 0x7c,
	0x73, 0x2e, 0x73, 0xbe, 0xa1, 0x08, 0x4f, 0xec, 0x00, 0x93, 0xda, 0xd7, 0x11, 0xe3, 0x8e, 0x5f,
	0xe3, 0x17, 0xdb, 0xc8, 0x7b, 0xe7, 0x6f, 0x9f, 0x5e, 0x3a, 0xdc, 0x6e, 0xbf, 0x46, 0x98, 0xd0,
	0x97, 0xc8, 0x6b, 0x61, 0x74, 0x7a, 0xe9, 0xd0, 0x70, 0x9b, 0x8b, 0xbf, 0xb5, 0x90, 0x06, 0x3c,
	0x30, 0xd6, 0xb9, 0xc4, 0xd4, 0xce, 0x22, 0x97, 0x07, 0x7e, 0x8d, 0x74, 0x90, 0x17, 0xba, 0xa4,
	0xa6, 0xac, 0x17, 0x62, 0x65, 0xe5, 0xde, 0x79, 0x10, 0x9c, 0xbb, 0x64, 0x5b, 0x2e, 0x68, 0x45,
	0x67, 0xdb, 0x97, 0x14, 0x85, 0x21, 0xa1, 0x4c, 0x51, 0x54, 0x5f, 0xc1, 0xdd, 0xfd, 0xc0, 0xf3,
	0x08, 0xb5, 0x1d, 0xe4, 0xd6, 0x0f, 0x0e, 0x08, 0x8e, 0x42, 0x72, 0x8a, 0x5a, 0x2e, 0x39, 0xf4,
	0x39, 0xbd, 0x32, 0xfe, 0x0e, 0x73, 0x76, 0xe2, 0xb7, 0x1c, 0x6c, 0xe6, 0xd6, 0x72, 0x9b, 0xb3,
	0x8d, 0x52, 0xd7, 0x58, 0xc7, 0xc6, 0x02, 0xe4, 0x39, 0x77, 0xcd, 0x89, 0xb5, 0xdc, 0x66, 0xbe,
	0x21, 0xfe, 0xad, 0xbe, 0x86, 0x95, 0x97, 0x2f, 0x0f, 0x2f, 0x88, 0xcf, 0x07, 0x18, 0xb7, 0x60,
	0xd1, 0x75, 0x2d, 0x22, 0x7c, 0x96, 0x87, 0x1f, 0x5b, 0x6d, 0xc4, 0xda, 0x9a, 0x75, 0xde, 0x75,
	0xe5, 0x9a, 0x63, 0xfc, 0xf8, 0x08, 0xb1, 0x76, 0x06, 0xef, 0x2f, 0xd3, 0xb0, 0xba, 0xdf, 0x46,
	0xbe, 0x4f, 0xdc, 0x13, 0x1a, 0x84, 0x84, 0x72, 0x87, 0xb0, 0x14, 0xf9, 0x01, 0xdc, 0xc7, 0xc4,
	0x67, 0x0e, 0xbf, 0xb2, 0x38, 0xa2, 0xe7, 0x84, 0x5b, 0x9e, 0xe3, 0x47, 0x9c, 0x30, 0x2b, 0x24,
	0xd4, 0x6a, 0x07, 0x11, 0x95, 0x5b, 0x15, 0x1a, 0xab, 0x1a, 0x76, 0x2a, 0x51, 0xc7, 0x0a, 0x74,
	0x42, 0xe8, 0x51, 0x10, 0x51, 0xe3, 0x6f, 0x00, 0xb6, 0xda, 0x44, 0x64, 0x3c, 0x21, 0x63, 0x9b,
	0xd5, 0x96, 0x3a, 0x36, 0x6e, 0xc1, 0x94, 0xc3, 0x2c, 0xdb, 0x0e, 0xcd, 0xfc, 0x5a, 0x6e, 0x73,
	0xa6, 0x51, 0x70, 0xd8, 0xbe, 0x1d, 0x1a, 0x5b, 0xb0, 0x40, 0xfc, 0xb3, 0x80, 0xda, 0xc4, 0xb2,
	0x03, 0x9f, 0x53, 0x64, 0x73, 0x73, 0x52, 0x02, 0xca, 0xda, 0xbe, 0xaf, 0xcd, 0xc6, 0x0a, 0x4c,
	0xdb, 0x76, 0x68, 0x39, 0xb8, 0x63, 0x16, 0x24, 0xfb, 0x94, 0x6d, 0x87, 0x75, 0xdc, 0x31, 0x1e,
	0xc0, 0xbc, 0x70, 0x30, 0x8e, 0x28, 0xb7, 0xb8, 0xe3, 0x11, 0x73, 0x4a, 0x26, 0x5f, 0xb2, 0xed,
	0xb0, 0x29, 0x8c, 0xa7, 0x8e, 0x47, 0x8c, 0x35, 0x10, 0xcf, 0x16, 0xf1, 0xb1, 0xc2, 0x4c, 0x4b,
	0x0c, 0xd8, 0x76, 0x78, 0xe8, 0x63, 0x89, 0xd8, 0x84, 0x05, 0x16, 0xd1, 0x73, 0x92, 0x66, 0x9a,
	0x91, 0xa8, 0x79, 0x69, 0xef, 0x72, 0x3d, 0x00, 0x65, 0xe9, 0xb2, 0xcd, 0xaa, 0x1d, 0xa5, 0x35,
	0xe6, 0xfb, 0x1c, 0x36, 0x14, 0x6a, 0x54, 0x75, 0x41, 0x56, 0x77, 0x4d, 0x82, 0x0f, 0xae, 0x29,
	0x71, 0x0d, 0x96, 0x10, 0xb6, 0x98, 0xdd, 0x26, 0x38, 0x72, 0xc5, 0xe6, 0xa2, 0x87, 0xd8, 0x2c,
	0xca, 0x7a, 0x2d, 0x22, 0xdc, 0xd4, 0x9e, 0x43, 0xe5, 0x10, 0x78, 0xe6, 0x07, 0xc1, 0x3b, 0x62,
	0x51, 0x72, 0x46, 0x09, 0x6b, 0xab, 0x58, 0x4b, 0x32, 0xd6, 0x45, 0xe5, 0x6a, 0x28, 0x8f, 0x0c,
	0xf8, 0x3e, 0x14, 0x35, 0xbe, 0x85, 0xfc, 0x37, 0xe6, 0x9c, 0x0c, 0x0b, 0x94, 0x69, 0x0f, 0xf9,
	0x6f, 0x8c, 0x75, 0x28, 0xa9, 0x27, 0x66, 0x45, 0x8c, 0x60, 0x73, 0x5e, 0x22, 0xf4, 0x22, 0xf6,
	0x8a, 0x11, 0x2c, 0x38, 0x70, 0x44, 0x2d, 0x46, 0xec, 0xc0, 0xc7, 0xcc, 0x2c, 0x2b, 0x0e, 0x1c,
	0xd1, 0xa6, 0xb2, 0x08, 0x8e, 0x33, 0x4a, 0xde, 0x26, 0x88, 0x05, 0xc5, 0x21, 0x6c, 0x31, 0x44,
	0xc4, 0x21, 0x5b, 0x80, 0x89, 0x8b, 0xae, 0xcc, 0x45, 0x1d, 0x87, 0x30, 0x1d, 0x08, 0x8b, 0x18,
	0x30, 0x4a, 0x3c, 0xc7, 0xc7, 0x84, 0xaa, 0x94, 0x0c, 0x09, 0x29, 0xc5, 0x46, 0x99, 0xcd, 0x16,
	0x2c, 0x24, 0xa0, 0xb8, 0x54, 0x4b, 0xea, 0x68, 0xc5, 0xf6, 0xb8, 0x50, 0x6b, 0x50, 0x42, 0x9e,
	0x75, 0xc6, 0x23, 0x62, 0x31, 0x42, 0x7c, 0x73, 0x59, 0xc2, 0x00, 0x79, 0xcf, 0x79, 0x44, 0x9a,
	0x84, 0xf8, 0x46, 0x15, 0xe6, 0x90, 0x67, 0x39, 0x3e, 0xa7, 0x81, 0x82, 0xdc, 0x92, 0x90, 0x22,
	0xf2, 0xea, 0xc2, 0x26, 0x31, 0xa2, 0xdc, 0xba, 0x03, 0x34, 0x45, 0x76, 0x5b, 0xb5, 0x27, 0x71,
	0x25, 0x9c, 0xa2, 0x9d, 0x82, 0x93, 0x71, 0xe4, 0xba, 0x56, 0x1c, 0x93, 0xb9, 0xa2, 0xda, 0x23,
	0x98, 0xa5, 0xa7, 0xa1, 0x1d, 0xd5, 0x5f, 0xf3, 0xc9, 0x1c, 0x37, 0x39, 0x25, 0xc8, 0x13, 0x87,
	0x22, 0x35, 0xc7, 0xbd, 0x13, 0x98, 0xeb, 0x9f, 0xc0, 0x7f, 0x40, 0x59, 0xd7, 0xdc, 0x22, 0x2e,
	0x0a, 0x45, 0xff, 0x26, 0x64, 0xd9, 0xe6, 0xb5, 0xf9, 0x50, 0x59, 0xc5, 0x1c, 0xf0, 0x80, 0x23,
	0xd7, 0x12, 0x87, 0x4d, 0x77, 0x29, 0xaf, 0x90, 0xd2, 0xfe, 0x0c, 0xc7, 0x8d, 0xaa, 0xc1, 0x92,
	0x8b, 0x18, 0xb7, 0xda, 0x04, 0x51, 0xde, 0x22, 0x48, 0x0f, 0xcd, 0xa4, 0xca, 0x40, 0xb8, 0x8e,
	0x62, 0x4f, 0x32, 0x37, 0x32, 0x72, 0x2b, 0x0a, 0x15, 0xb4, 0xa0, 0xe7, 0x46, 0x5a, 0x5f, 0x85,
	0x12, 0xf5, 0x18, 0x56, 0x5a, 0x41, 0xe4, 0xf3, 0x2b, 0xab, 0x15, 0x20, 0x8a, 0x07, 0x07, 0x7b,
	0x59, 0xb9, 0xf7, 0x84, 0xb7, 0x3b, 0x94, 0xeb, 0x50, 0x4a, 0x2f, 0x93, 0x03, 0x3e, 0xd3, 0x28,
	0xa6, 0xb0, 0xc6, 0x43, 0x28, 0x5f, 0x22, 0x6e, 0xb7, 0xad, 0x10, 0x51, 0x31, 0x8f, 0xdc, 0xd5,
	0x03, 0x3e, 0x27, 0xcd, 0x27, 0xc2, 0x7a, 0xca, 0x5d, 0x71, 0x00, 0x53, 0x38, 0x39, 0xdc, 0x33,
	0x0d, 0xe8, 0x62, 0x44, 0xe2, 0x8e, 0xef, 0x70, 0x21, 0xef, 0x3a, 0xa1, 0x64, 0x90, 0x67, 0x1a,
	0x8b, 0xda, 0xd5, 0x6d, 0x92, 0xa8, 0x7d, 0x3c, 0xf5, 0x71, 0xed, 0x8b, 0xaa, 0xa2, 0xda, 0xac,
	0x6b, 0x5f, 0xfd, 0x71, 0x06, 0xca, 0x71, 0x8f, 0x09, 0xe7, 0x8e, 0x7f, 0xce, 0x8c, 0x0d, 0x98,
	0xef, 0x55, 0x10, 0x2d, 0xc7, 0x73, 0x3d, 0x72, 0x9c, 0x29, 0xa5, 0x13, 0xd9, 0x52, 0x3a, 0x44,
	0x8c, 0xb3, 0x1a, 0x3f, 0x99, 0xd9, 0xf8, 0x8c, 0x7c, 0x0a, 0x59, 0xf9, 0xf4, 0x9d, 0xc9, 0xa9,
	0xfe, 0x33, 0x39, 0x44, 0xd1, 0xa6, 0x87, 0x29, 0x5a, 0x05, 0x66, 0x70, 0x44, 0x11, 0x77, 0x02,
	0x5f, 0x76, 0xae, 0xd0, 0x48, 0x9e, 0x85, 0xcf, 0xf1, 0x39, 0xa1, 0x17, 0xc8, 0x95, 0x1d, 0x2b,
	0x34, 0x92, 0xe7, 0x7e, 0x45, 0x81, 0xd1, 0x8a, 0x52, 0x1c, 0x53, 0x51, 0x4a, 0xd9, 0x8a, 0x32,
	0x44, 0x7a, 0xe7, 0xc6, 0x94, 0xde, 0xf9, 0x91, 0xd2, 0x5b, 0x1e, 0x94, 0xde, 0x87, 0x50, 0x4e,
	0x71, 0x58, 0x1e, 0xea, 0x68, 0x71, 0x9d, 0xeb, 0xf2, 0x1c, 0xa3, 0x8e, 0x14, 0x02, 0x85, 0x4b,
	0x6a, 0xb9, 0xa8, 0x85, 0x40, 0x9a, 0x0f, 0xe2, 0x8a, 0xae, 0x43, 0x29, 0xae, 0xa0, 0xb8, 0xb4,
	0xb4, 0xca, 0x16, 0x63, 0xdb, 0xb1, 0xd3, 0x07, 0x41, 0x1d, 0x29, 0xb0, 0x69, 0x08, 0xea, 0x08,
	0x48, 0xbc, 0x8f, 0x64, 0x59, 0x56, 0x90, 0xd8, 0xa6, 0x59, 0xba, 0x10, 0xd4, 0x91, 0xe2, 0x9a,
	0x86, 0xa0, 0x8e, 0x4c, 0xae, 0xdb, 0x41, 0x49, 0x74, 0x5b, 0x27, 0x97, 0x74, 0x51, 0x50, 0xf5,
	0xe3, 0x50, 0x47, 0x0a, 0x6a, 0x2f, 0x4e, 0x45, 0x95, 0xf4, 0x52, 0x80, 0x4c, 0xb5, 0x65, 0x6c,
	0x13, 0x90, 0xfe, 0x5b, 0xe1, 0xce, 0xe8, 0x5b, 0xa1, 0x32, 0xf6, 0xad, 0xb0, 0xfa, 0x81, 0xb7,
	0xc2, 0xdd, 0x61, 0xb7, 0xc2, 0x7f, 0xe0, 0xce, 0xff, 0x09, 0xef, 0xd3, 0x8c, 0x06, 0x79, 0x1b,
	0x11, 0xc6, 0x47, 0x5c, 0x09, 0xd5, 0xf7, 0x50, 0xc9, 0x5a, 0xcb, 0xc2, 0xc0, 0x67, 0xc4, 0xf8,
	0x12, 0x16, 0xe2, 0xc5, 0x4c, 0xfb, 0x24, 0x45, 0x71, 0x67, 0xa7, 0x36, 0xf2, 0x25, 0xba, 0xd6,
	0xcf, 0x5a, 0xb6, 0x7b, 0x0d, 0xd5, 0xdf, 0x26, 0xe1, 0x4e, 0xf3, 0x86, 0x91, 0x1b, 0x2f, 0xb2,
	0x85, 0x63, 0x42, 0x86, 0x57, 0xa9, 0xa9, 0x17, 0xf8, 0x5a, 0xfc, 0x02, 0x5f, 0xdb, 0x0b, 0x02,
	0xf7, 0x35, 0x72, 0x23, 0x32, 0x44, 0x54, 0x12, 0xe1, 0xc8, 0xf7, 0x09, 0x47, 0x5a, 0x70, 0x26,
	0xfb, 0x04, 0x67, 0xb7, 0x57, 0x54, 0x0a, 0x72, 0xef, 0xd5, 0x81, 0xbd, 0xeb, 0x3e, 0x7f, 0xb4,
	0xa3, 0x36, 0x4f, 0x2b, 0xce, 0x61, 0x86, 0x98, 0x4c, 0x8d, 0x0c, 0x7f, 0x40, 0x68, 0x06, 0x84,
	0x4b, 0xbd, 0xd7, 0xf6, 0x0a, 0xd7, 0x6e, 0xc6, 0x49, 0xbe, 0x7e, 0x9f, 0xf4, 0x29, 0x7f, 0x9a,
	0x75, 0xca, 0xaf, 0x5f, 0xde, 0x33, 0x01, 0x2f, 0x86, 0x4f, 0xc0, 0x88, 0x5e, 0x7d, 0xfc, 0x74,
	0xbc, 0x87, 0x4a, 0xf3, 0x4f, 0x3b, 0xe1, 0x15, 0x30, 0xc5, 0x78, 0xed, 0x9f, 0x1c, 0xee, 0xc7,
	0x07, 0x37, 0x3e, 0xdf, 0xd5, 0x5d, 0x35, 0xb6, 0x7d, 0x3e, 0x1d, 0xd7, 0x7d, 0x28, 0x76, 0x0f,
	0xbf, 0x08, 0x29, 0xbf, 0x39, 0xdb, 0x80, 0xe4, 0xf4, 0xb3, 0xea, 0x73, 0xd8, 0xe8, 0x0e, 0x6e,
	0xd6, 0x8f, 0xba, 0x31, 0x05, 0xe0, 0xbb, 0x1c, 0x3c, 0x1c, 0x45, 0xa4, 0x63, 0xfa, 0x0a, 0x20,
	0x4c, 0xfc, 0xba, 0x4a, 0x4f, 0xc7, 0xaf, 0x52, 0x26, 0x77, 0x8a, 0xb1, 0xfa, 0x6d, 0x0e, 0x36,
	0x9a, 0x63, 0xe5, 0xf4, 0x47, 0x47, 0x22, 0x8a, 0xd2, 0xfc, 0x6b, 0x14, 0xe5, 0x02, 0x96, 0x9a,
	0xf2, 0x4e, 0xfe, 0x8c, 0x74, 0xf8, 0x33, 0x3c, 0xa6, 0x38, 0x66, 0x5c, 0xf0, 0x13, 0x99, 0x17,
	0xfc, 0x0a, 0x4c, 0x47, 0x8c, 0x50, 0x41, 0x92, 0x57, 0x3f, 0xa9, 0xc5, 0x63, 0x1d, 0x57, 0x9f,
	0xc1, 0x72, 0xef, 0xbe, 0x3a, 0xdf, 0x2d, 0x58, 0x50, 0x14, 0xb8, 0x4b, 0xad, 0x5e, 0x46, 0xf5,
	0x8e, 0x38, 0xe6, 0xde, 0xf9, 0x79, 0x1a, 0x8a, 0xa9, 0xcf, 0x31, 0xc6, 0x0f, 0x39, 0x30, 0x06,
	0x2f, 0x1b, 0x63, 0x77, 0x8c, 0x6a, 0x0d, 0xbd, 0xdf, 0x2a, 0xff, 0xbb, 0xe1, 0x6a, 0x9d, 0x8e,
	0x88, 0xa9, 0x79, 0xb3, 0x98, 0x9a, 0x1f, 0x15, 0xd3, 0x35, 0x9a, 0xf4, 0x7d, 0x0e, 0x16, 0x07,
	0x94, 0xc1, 0xf8, 0xef, 0x98, 0x89, 0x66, 0x69, 0x4d, 0x65, 0xf7, 0x66, 0x8b, 0x75, 0x40, 0x3f,
	0xe5, 0xe0, 0xde, 0xf5, 0x1a, 0x61, 0x1c, 0x7d, 0x50, 0x1b, 0xae, 0x99, 0xed, 0x4a, 0xfd, 0x13,
	0x30, 0xa5, 0xe2, 0x6e, 0x7e, 0x7c, 0xdc, 0xcd, 0x4f, 0x16, 0xf7, 0x98, 0x9a, 0xf2, 0x0d, 0x94,
	0xd2, 0xb3, 0x67, 0x3c, 0x19, 0x87, 0x7a, 0x50, 0x24, 0x2a, 0xff, 0xfe, 0xe0, 0x75, 0x2a, 0x80,
	0xbd, 0x7f, 0x7d, 0xf1, 0xcf, 0xf1, 0xbf, 0xad, 0xb6, 0xa6, 0xe4, 0xc5, 0xfd, 0xe8, 0xf7, 0x00,
	0x00, 0x00, 0xff, 0xff, 0x10, 0x39, 0x5f, 0x0e, 0x90, 0x15, 0x00, 0x00,
}
