// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchVoyagerTwirp/twirp.proto

/*
Package TwitchVoyagerTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchVoyagerTwirp/twirp.proto
*/
package TwitchVoyagerTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// =======================
// TwitchVoyager Interface
// =======================

type TwitchVoyager interface {
	ListUserExpiredSubscriptions(context.Context, *ListUserExpiredSubscriptionsRequest) (*ListUserExpiredSubscriptionsResponse, error)

	ListUserSubscriptions(context.Context, *ListUserSubscriptionsRequest) (*ListUserSubscriptionsResponse, error)

	GetUserSubscriptions(context.Context, *GetUserSubscriptionsRequest) (*GetUserSubscriptionsResponse, error)

	GetUserSubscriptionsWithPaymentsData(context.Context, *GetUserSubscriptionsWithPaymentsDataRequest) (*GetUserSubscriptionsWithPaymentsDataResponse, error)

	GetUserProductSubscriptions(context.Context, *GetUserProductSubscriptionsRequest) (*GetUserProductSubscriptionsResponse, error)

	GetUserProductSubscriptionsWithPaymentsData(context.Context, *GetUserProductSubscriptionsWithPaymentsDataRequest) (*GetUserProductSubscriptionsWithPaymentsDataResponse, error)

	GetUserChannelSubscription(context.Context, *GetUserChannelSubscriptionRequest) (*GetUserChannelSubscriptionResponse, error)

	GetUserChannelSubscriptionWithPaymentsData(context.Context, *GetUserChannelSubscriptionWithPaymentsDataRequest) (*GetUserChannelSubscriptionWithPaymentsDataResponse, error)

	GetChannelSubscriptions(context.Context, *GetChannelSubscriptionsRequest) (*GetChannelSubscriptionsResponse, error)

	GetChannelSubscriptionsAfterTime(context.Context, *GetChannelSubscriptionsAfterTimeRequest) (*GetChannelSubscriptionsAfterTimeResponse, error)

	GetPendingSubscriptionInfo(context.Context, *GetPendingSubscriptionInfoRequest) (*GetPendingSubscriptionInfoResponse, error)

	GetSubscriberCount(context.Context, *GetSubscriberCountRequest) (*GetSubscriberCountResponse, error)

	GrantAdminSubscription(context.Context, *GrantAdminSubscriptionRequest) (*GrantAdminSubscriptionResponse, error)

	OnboardChannel(context.Context, *OnboardChannelRequest) (*OnboardChannelResponse, error)

	OffboardChannel(context.Context, *OffboardChannelRequest) (*OffboardChannelResponse, error)

	SendUserNoticeWithSubEvent(context.Context, *SendUserNoticeWithSubEventRequest) (*SendUserNoticeWithSubEventResponse, error)

	CreateSubEvent(context.Context, *CreateSubEventRequest) (*CreateSubEventResponse, error)
}

// =============================
// TwitchVoyager Protobuf Client
// =============================

type twitchVoyagerProtobufClient struct {
	client HTTPClient
	urls   [17]string
	opts   twirp.ClientOptions
}

// NewTwitchVoyagerProtobufClient creates a Protobuf client that implements the TwitchVoyager interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchVoyagerProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchVoyager {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchVoyagerPathPrefix
	urls := [17]string{
		prefix + "ListUserExpiredSubscriptions",
		prefix + "ListUserSubscriptions",
		prefix + "GetUserSubscriptions",
		prefix + "GetUserSubscriptionsWithPaymentsData",
		prefix + "GetUserProductSubscriptions",
		prefix + "GetUserProductSubscriptionsWithPaymentsData",
		prefix + "GetUserChannelSubscription",
		prefix + "GetUserChannelSubscriptionWithPaymentsData",
		prefix + "GetChannelSubscriptions",
		prefix + "GetChannelSubscriptionsAfterTime",
		prefix + "GetPendingSubscriptionInfo",
		prefix + "GetSubscriberCount",
		prefix + "GrantAdminSubscription",
		prefix + "OnboardChannel",
		prefix + "OffboardChannel",
		prefix + "SendUserNoticeWithSubEvent",
		prefix + "CreateSubEvent",
	}

	return &twitchVoyagerProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchVoyagerProtobufClient) ListUserExpiredSubscriptions(ctx context.Context, in *ListUserExpiredSubscriptionsRequest) (*ListUserExpiredSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "ListUserExpiredSubscriptions")
	out := new(ListUserExpiredSubscriptionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) ListUserSubscriptions(ctx context.Context, in *ListUserSubscriptionsRequest) (*ListUserSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "ListUserSubscriptions")
	out := new(ListUserSubscriptionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GetUserSubscriptions(ctx context.Context, in *GetUserSubscriptionsRequest) (*GetUserSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserSubscriptions")
	out := new(GetUserSubscriptionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GetUserSubscriptionsWithPaymentsData(ctx context.Context, in *GetUserSubscriptionsWithPaymentsDataRequest) (*GetUserSubscriptionsWithPaymentsDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserSubscriptionsWithPaymentsData")
	out := new(GetUserSubscriptionsWithPaymentsDataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GetUserProductSubscriptions(ctx context.Context, in *GetUserProductSubscriptionsRequest) (*GetUserProductSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserProductSubscriptions")
	out := new(GetUserProductSubscriptionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GetUserProductSubscriptionsWithPaymentsData(ctx context.Context, in *GetUserProductSubscriptionsWithPaymentsDataRequest) (*GetUserProductSubscriptionsWithPaymentsDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserProductSubscriptionsWithPaymentsData")
	out := new(GetUserProductSubscriptionsWithPaymentsDataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GetUserChannelSubscription(ctx context.Context, in *GetUserChannelSubscriptionRequest) (*GetUserChannelSubscriptionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserChannelSubscription")
	out := new(GetUserChannelSubscriptionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GetUserChannelSubscriptionWithPaymentsData(ctx context.Context, in *GetUserChannelSubscriptionWithPaymentsDataRequest) (*GetUserChannelSubscriptionWithPaymentsDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserChannelSubscriptionWithPaymentsData")
	out := new(GetUserChannelSubscriptionWithPaymentsDataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GetChannelSubscriptions(ctx context.Context, in *GetChannelSubscriptionsRequest) (*GetChannelSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSubscriptions")
	out := new(GetChannelSubscriptionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GetChannelSubscriptionsAfterTime(ctx context.Context, in *GetChannelSubscriptionsAfterTimeRequest) (*GetChannelSubscriptionsAfterTimeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSubscriptionsAfterTime")
	out := new(GetChannelSubscriptionsAfterTimeResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GetPendingSubscriptionInfo(ctx context.Context, in *GetPendingSubscriptionInfoRequest) (*GetPendingSubscriptionInfoResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetPendingSubscriptionInfo")
	out := new(GetPendingSubscriptionInfoResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GetSubscriberCount(ctx context.Context, in *GetSubscriberCountRequest) (*GetSubscriberCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetSubscriberCount")
	out := new(GetSubscriberCountResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GrantAdminSubscription(ctx context.Context, in *GrantAdminSubscriptionRequest) (*GrantAdminSubscriptionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GrantAdminSubscription")
	out := new(GrantAdminSubscriptionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) OnboardChannel(ctx context.Context, in *OnboardChannelRequest) (*OnboardChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "OnboardChannel")
	out := new(OnboardChannelResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) OffboardChannel(ctx context.Context, in *OffboardChannelRequest) (*OffboardChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "OffboardChannel")
	out := new(OffboardChannelResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) SendUserNoticeWithSubEvent(ctx context.Context, in *SendUserNoticeWithSubEventRequest) (*SendUserNoticeWithSubEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "SendUserNoticeWithSubEvent")
	out := new(SendUserNoticeWithSubEventResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) CreateSubEvent(ctx context.Context, in *CreateSubEventRequest) (*CreateSubEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "CreateSubEvent")
	out := new(CreateSubEventResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =========================
// TwitchVoyager JSON Client
// =========================

type twitchVoyagerJSONClient struct {
	client HTTPClient
	urls   [17]string
	opts   twirp.ClientOptions
}

// NewTwitchVoyagerJSONClient creates a JSON client that implements the TwitchVoyager interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchVoyagerJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchVoyager {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchVoyagerPathPrefix
	urls := [17]string{
		prefix + "ListUserExpiredSubscriptions",
		prefix + "ListUserSubscriptions",
		prefix + "GetUserSubscriptions",
		prefix + "GetUserSubscriptionsWithPaymentsData",
		prefix + "GetUserProductSubscriptions",
		prefix + "GetUserProductSubscriptionsWithPaymentsData",
		prefix + "GetUserChannelSubscription",
		prefix + "GetUserChannelSubscriptionWithPaymentsData",
		prefix + "GetChannelSubscriptions",
		prefix + "GetChannelSubscriptionsAfterTime",
		prefix + "GetPendingSubscriptionInfo",
		prefix + "GetSubscriberCount",
		prefix + "GrantAdminSubscription",
		prefix + "OnboardChannel",
		prefix + "OffboardChannel",
		prefix + "SendUserNoticeWithSubEvent",
		prefix + "CreateSubEvent",
	}

	return &twitchVoyagerJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchVoyagerJSONClient) ListUserExpiredSubscriptions(ctx context.Context, in *ListUserExpiredSubscriptionsRequest) (*ListUserExpiredSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "ListUserExpiredSubscriptions")
	out := new(ListUserExpiredSubscriptionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) ListUserSubscriptions(ctx context.Context, in *ListUserSubscriptionsRequest) (*ListUserSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "ListUserSubscriptions")
	out := new(ListUserSubscriptionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GetUserSubscriptions(ctx context.Context, in *GetUserSubscriptionsRequest) (*GetUserSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserSubscriptions")
	out := new(GetUserSubscriptionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GetUserSubscriptionsWithPaymentsData(ctx context.Context, in *GetUserSubscriptionsWithPaymentsDataRequest) (*GetUserSubscriptionsWithPaymentsDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserSubscriptionsWithPaymentsData")
	out := new(GetUserSubscriptionsWithPaymentsDataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GetUserProductSubscriptions(ctx context.Context, in *GetUserProductSubscriptionsRequest) (*GetUserProductSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserProductSubscriptions")
	out := new(GetUserProductSubscriptionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GetUserProductSubscriptionsWithPaymentsData(ctx context.Context, in *GetUserProductSubscriptionsWithPaymentsDataRequest) (*GetUserProductSubscriptionsWithPaymentsDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserProductSubscriptionsWithPaymentsData")
	out := new(GetUserProductSubscriptionsWithPaymentsDataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GetUserChannelSubscription(ctx context.Context, in *GetUserChannelSubscriptionRequest) (*GetUserChannelSubscriptionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserChannelSubscription")
	out := new(GetUserChannelSubscriptionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GetUserChannelSubscriptionWithPaymentsData(ctx context.Context, in *GetUserChannelSubscriptionWithPaymentsDataRequest) (*GetUserChannelSubscriptionWithPaymentsDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserChannelSubscriptionWithPaymentsData")
	out := new(GetUserChannelSubscriptionWithPaymentsDataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GetChannelSubscriptions(ctx context.Context, in *GetChannelSubscriptionsRequest) (*GetChannelSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSubscriptions")
	out := new(GetChannelSubscriptionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GetChannelSubscriptionsAfterTime(ctx context.Context, in *GetChannelSubscriptionsAfterTimeRequest) (*GetChannelSubscriptionsAfterTimeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSubscriptionsAfterTime")
	out := new(GetChannelSubscriptionsAfterTimeResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GetPendingSubscriptionInfo(ctx context.Context, in *GetPendingSubscriptionInfoRequest) (*GetPendingSubscriptionInfoResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetPendingSubscriptionInfo")
	out := new(GetPendingSubscriptionInfoResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GetSubscriberCount(ctx context.Context, in *GetSubscriberCountRequest) (*GetSubscriberCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetSubscriberCount")
	out := new(GetSubscriberCountResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GrantAdminSubscription(ctx context.Context, in *GrantAdminSubscriptionRequest) (*GrantAdminSubscriptionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GrantAdminSubscription")
	out := new(GrantAdminSubscriptionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) OnboardChannel(ctx context.Context, in *OnboardChannelRequest) (*OnboardChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "OnboardChannel")
	out := new(OnboardChannelResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) OffboardChannel(ctx context.Context, in *OffboardChannelRequest) (*OffboardChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "OffboardChannel")
	out := new(OffboardChannelResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) SendUserNoticeWithSubEvent(ctx context.Context, in *SendUserNoticeWithSubEventRequest) (*SendUserNoticeWithSubEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "SendUserNoticeWithSubEvent")
	out := new(SendUserNoticeWithSubEventResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) CreateSubEvent(ctx context.Context, in *CreateSubEventRequest) (*CreateSubEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "CreateSubEvent")
	out := new(CreateSubEventResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ============================
// TwitchVoyager Server Handler
// ============================

type twitchVoyagerServer struct {
	TwitchVoyager
	hooks *twirp.ServerHooks
}

func NewTwitchVoyagerServer(svc TwitchVoyager, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchVoyagerServer{
		TwitchVoyager: svc,
		hooks:         hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchVoyagerServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchVoyagerPathPrefix is used for all URL paths on a twirp TwitchVoyager server.
// Requests are always: POST TwitchVoyagerPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchVoyagerPathPrefix = "/twirp/twitch.voyager.TwitchVoyager/"

func (s *twitchVoyagerServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.voyager.TwitchVoyager/ListUserExpiredSubscriptions":
		s.serveListUserExpiredSubscriptions(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/ListUserSubscriptions":
		s.serveListUserSubscriptions(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GetUserSubscriptions":
		s.serveGetUserSubscriptions(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GetUserSubscriptionsWithPaymentsData":
		s.serveGetUserSubscriptionsWithPaymentsData(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GetUserProductSubscriptions":
		s.serveGetUserProductSubscriptions(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GetUserProductSubscriptionsWithPaymentsData":
		s.serveGetUserProductSubscriptionsWithPaymentsData(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GetUserChannelSubscription":
		s.serveGetUserChannelSubscription(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GetUserChannelSubscriptionWithPaymentsData":
		s.serveGetUserChannelSubscriptionWithPaymentsData(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GetChannelSubscriptions":
		s.serveGetChannelSubscriptions(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GetChannelSubscriptionsAfterTime":
		s.serveGetChannelSubscriptionsAfterTime(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GetPendingSubscriptionInfo":
		s.serveGetPendingSubscriptionInfo(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GetSubscriberCount":
		s.serveGetSubscriberCount(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GrantAdminSubscription":
		s.serveGrantAdminSubscription(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/OnboardChannel":
		s.serveOnboardChannel(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/OffboardChannel":
		s.serveOffboardChannel(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/SendUserNoticeWithSubEvent":
		s.serveSendUserNoticeWithSubEvent(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/CreateSubEvent":
		s.serveCreateSubEvent(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchVoyagerServer) serveListUserExpiredSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListUserExpiredSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListUserExpiredSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveListUserExpiredSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListUserExpiredSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListUserExpiredSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListUserExpiredSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.ListUserExpiredSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUserExpiredSubscriptionsResponse and nil error while calling ListUserExpiredSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveListUserExpiredSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListUserExpiredSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListUserExpiredSubscriptionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListUserExpiredSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.ListUserExpiredSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUserExpiredSubscriptionsResponse and nil error while calling ListUserExpiredSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveListUserSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListUserSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListUserSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveListUserSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListUserSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListUserSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListUserSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.ListUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUserSubscriptionsResponse and nil error while calling ListUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveListUserSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListUserSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListUserSubscriptionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListUserSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.ListUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUserSubscriptionsResponse and nil error while calling ListUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGetUserSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSubscriptionsResponse and nil error while calling GetUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetUserSubscriptionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSubscriptionsResponse and nil error while calling GetUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserSubscriptionsWithPaymentsData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserSubscriptionsWithPaymentsDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserSubscriptionsWithPaymentsDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGetUserSubscriptionsWithPaymentsDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserSubscriptionsWithPaymentsData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserSubscriptionsWithPaymentsDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserSubscriptionsWithPaymentsDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserSubscriptionsWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSubscriptionsWithPaymentsDataResponse and nil error while calling GetUserSubscriptionsWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserSubscriptionsWithPaymentsDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserSubscriptionsWithPaymentsData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetUserSubscriptionsWithPaymentsDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserSubscriptionsWithPaymentsDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserSubscriptionsWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSubscriptionsWithPaymentsDataResponse and nil error while calling GetUserSubscriptionsWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserProductSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserProductSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserProductSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGetUserProductSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserProductSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserProductSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserProductSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserProductSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserProductSubscriptionsResponse and nil error while calling GetUserProductSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserProductSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserProductSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetUserProductSubscriptionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserProductSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserProductSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserProductSubscriptionsResponse and nil error while calling GetUserProductSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserProductSubscriptionsWithPaymentsData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserProductSubscriptionsWithPaymentsDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserProductSubscriptionsWithPaymentsDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGetUserProductSubscriptionsWithPaymentsDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserProductSubscriptionsWithPaymentsData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserProductSubscriptionsWithPaymentsDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserProductSubscriptionsWithPaymentsDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserProductSubscriptionsWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserProductSubscriptionsWithPaymentsDataResponse and nil error while calling GetUserProductSubscriptionsWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserProductSubscriptionsWithPaymentsDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserProductSubscriptionsWithPaymentsData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetUserProductSubscriptionsWithPaymentsDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserProductSubscriptionsWithPaymentsDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserProductSubscriptionsWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserProductSubscriptionsWithPaymentsDataResponse and nil error while calling GetUserProductSubscriptionsWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserChannelSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserChannelSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserChannelSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGetUserChannelSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserChannelSubscription")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserChannelSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserChannelSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionResponse and nil error while calling GetUserChannelSubscription. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserChannelSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserChannelSubscription")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetUserChannelSubscriptionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserChannelSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionResponse and nil error while calling GetUserChannelSubscription. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserChannelSubscriptionWithPaymentsData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserChannelSubscriptionWithPaymentsDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserChannelSubscriptionWithPaymentsDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGetUserChannelSubscriptionWithPaymentsDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserChannelSubscriptionWithPaymentsData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserChannelSubscriptionWithPaymentsDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionWithPaymentsDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserChannelSubscriptionWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionWithPaymentsDataResponse and nil error while calling GetUserChannelSubscriptionWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserChannelSubscriptionWithPaymentsDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserChannelSubscriptionWithPaymentsData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetUserChannelSubscriptionWithPaymentsDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionWithPaymentsDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserChannelSubscriptionWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionWithPaymentsDataResponse and nil error while calling GetUserChannelSubscriptionWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetChannelSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGetChannelSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetChannelSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetChannelSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetChannelSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSubscriptionsResponse and nil error while calling GetChannelSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetChannelSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetChannelSubscriptionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetChannelSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetChannelSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSubscriptionsResponse and nil error while calling GetChannelSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetChannelSubscriptionsAfterTime(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelSubscriptionsAfterTimeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelSubscriptionsAfterTimeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGetChannelSubscriptionsAfterTimeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSubscriptionsAfterTime")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetChannelSubscriptionsAfterTimeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetChannelSubscriptionsAfterTimeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetChannelSubscriptionsAfterTime(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSubscriptionsAfterTimeResponse and nil error while calling GetChannelSubscriptionsAfterTime. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetChannelSubscriptionsAfterTimeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSubscriptionsAfterTime")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetChannelSubscriptionsAfterTimeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetChannelSubscriptionsAfterTimeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetChannelSubscriptionsAfterTime(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSubscriptionsAfterTimeResponse and nil error while calling GetChannelSubscriptionsAfterTime. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetPendingSubscriptionInfo(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPendingSubscriptionInfoJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPendingSubscriptionInfoProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGetPendingSubscriptionInfoJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPendingSubscriptionInfo")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetPendingSubscriptionInfoRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetPendingSubscriptionInfoResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetPendingSubscriptionInfo(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPendingSubscriptionInfoResponse and nil error while calling GetPendingSubscriptionInfo. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetPendingSubscriptionInfoProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPendingSubscriptionInfo")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetPendingSubscriptionInfoRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetPendingSubscriptionInfoResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetPendingSubscriptionInfo(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPendingSubscriptionInfoResponse and nil error while calling GetPendingSubscriptionInfo. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetSubscriberCount(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetSubscriberCountJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSubscriberCountProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGetSubscriberCountJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSubscriberCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetSubscriberCountRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetSubscriberCountResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSubscriberCountResponse and nil error while calling GetSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetSubscriberCountProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSubscriberCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetSubscriberCountRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetSubscriberCountResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSubscriberCountResponse and nil error while calling GetSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGrantAdminSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGrantAdminSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGrantAdminSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGrantAdminSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GrantAdminSubscription")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GrantAdminSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GrantAdminSubscriptionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GrantAdminSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GrantAdminSubscriptionResponse and nil error while calling GrantAdminSubscription. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGrantAdminSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GrantAdminSubscription")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GrantAdminSubscriptionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GrantAdminSubscriptionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GrantAdminSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GrantAdminSubscriptionResponse and nil error while calling GrantAdminSubscription. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveOnboardChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveOnboardChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveOnboardChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveOnboardChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OnboardChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(OnboardChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *OnboardChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.OnboardChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OnboardChannelResponse and nil error while calling OnboardChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveOnboardChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OnboardChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(OnboardChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *OnboardChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.OnboardChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OnboardChannelResponse and nil error while calling OnboardChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveOffboardChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveOffboardChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveOffboardChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveOffboardChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OffboardChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(OffboardChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *OffboardChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.OffboardChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OffboardChannelResponse and nil error while calling OffboardChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveOffboardChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OffboardChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(OffboardChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *OffboardChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.OffboardChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OffboardChannelResponse and nil error while calling OffboardChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveSendUserNoticeWithSubEvent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSendUserNoticeWithSubEventJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSendUserNoticeWithSubEventProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveSendUserNoticeWithSubEventJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SendUserNoticeWithSubEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SendUserNoticeWithSubEventRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SendUserNoticeWithSubEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.SendUserNoticeWithSubEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendUserNoticeWithSubEventResponse and nil error while calling SendUserNoticeWithSubEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveSendUserNoticeWithSubEventProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SendUserNoticeWithSubEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SendUserNoticeWithSubEventRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SendUserNoticeWithSubEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.SendUserNoticeWithSubEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendUserNoticeWithSubEventResponse and nil error while calling SendUserNoticeWithSubEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveCreateSubEvent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateSubEventJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateSubEventProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveCreateSubEventJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateSubEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateSubEventRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateSubEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.CreateSubEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateSubEventResponse and nil error while calling CreateSubEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveCreateSubEventProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateSubEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateSubEventRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateSubEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.CreateSubEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateSubEventResponse and nil error while calling CreateSubEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchVoyagerServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchVoyagerServer) PathPrefix() string {
	return TwitchVoyagerPathPrefix
}

// =====================
// UserNotices Interface
// =====================

type UserNotices interface {
	LoadGoalsForSubEvent(context.Context, *UserNoticeStep) (*UserNoticeStep, error)

	MergeAndSendUserNotice(context.Context, *UserNoticeStep) (*UserNoticeStep, error)
}

// ===========================
// UserNotices Protobuf Client
// ===========================

type userNoticesProtobufClient struct {
	client HTTPClient
	urls   [2]string
	opts   twirp.ClientOptions
}

// NewUserNoticesProtobufClient creates a Protobuf client that implements the UserNotices interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewUserNoticesProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) UserNotices {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + UserNoticesPathPrefix
	urls := [2]string{
		prefix + "LoadGoalsForSubEvent",
		prefix + "MergeAndSendUserNotice",
	}

	return &userNoticesProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *userNoticesProtobufClient) LoadGoalsForSubEvent(ctx context.Context, in *UserNoticeStep) (*UserNoticeStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "UserNotices")
	ctx = ctxsetters.WithMethodName(ctx, "LoadGoalsForSubEvent")
	out := new(UserNoticeStep)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *userNoticesProtobufClient) MergeAndSendUserNotice(ctx context.Context, in *UserNoticeStep) (*UserNoticeStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "UserNotices")
	ctx = ctxsetters.WithMethodName(ctx, "MergeAndSendUserNotice")
	out := new(UserNoticeStep)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =======================
// UserNotices JSON Client
// =======================

type userNoticesJSONClient struct {
	client HTTPClient
	urls   [2]string
	opts   twirp.ClientOptions
}

// NewUserNoticesJSONClient creates a JSON client that implements the UserNotices interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewUserNoticesJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) UserNotices {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + UserNoticesPathPrefix
	urls := [2]string{
		prefix + "LoadGoalsForSubEvent",
		prefix + "MergeAndSendUserNotice",
	}

	return &userNoticesJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *userNoticesJSONClient) LoadGoalsForSubEvent(ctx context.Context, in *UserNoticeStep) (*UserNoticeStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "UserNotices")
	ctx = ctxsetters.WithMethodName(ctx, "LoadGoalsForSubEvent")
	out := new(UserNoticeStep)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *userNoticesJSONClient) MergeAndSendUserNotice(ctx context.Context, in *UserNoticeStep) (*UserNoticeStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "UserNotices")
	ctx = ctxsetters.WithMethodName(ctx, "MergeAndSendUserNotice")
	out := new(UserNoticeStep)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==========================
// UserNotices Server Handler
// ==========================

type userNoticesServer struct {
	UserNotices
	hooks *twirp.ServerHooks
}

func NewUserNoticesServer(svc UserNotices, hooks *twirp.ServerHooks) TwirpServer {
	return &userNoticesServer{
		UserNotices: svc,
		hooks:       hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *userNoticesServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// UserNoticesPathPrefix is used for all URL paths on a twirp UserNotices server.
// Requests are always: POST UserNoticesPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const UserNoticesPathPrefix = "/twirp/twitch.voyager.UserNotices/"

func (s *userNoticesServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "UserNotices")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.voyager.UserNotices/LoadGoalsForSubEvent":
		s.serveLoadGoalsForSubEvent(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.UserNotices/MergeAndSendUserNotice":
		s.serveMergeAndSendUserNotice(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *userNoticesServer) serveLoadGoalsForSubEvent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveLoadGoalsForSubEventJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveLoadGoalsForSubEventProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *userNoticesServer) serveLoadGoalsForSubEventJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "LoadGoalsForSubEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UserNoticeStep)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UserNoticeStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.UserNotices.LoadGoalsForSubEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UserNoticeStep and nil error while calling LoadGoalsForSubEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *userNoticesServer) serveLoadGoalsForSubEventProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "LoadGoalsForSubEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UserNoticeStep)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UserNoticeStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.UserNotices.LoadGoalsForSubEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UserNoticeStep and nil error while calling LoadGoalsForSubEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *userNoticesServer) serveMergeAndSendUserNotice(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveMergeAndSendUserNoticeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveMergeAndSendUserNoticeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *userNoticesServer) serveMergeAndSendUserNoticeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "MergeAndSendUserNotice")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UserNoticeStep)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UserNoticeStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.UserNotices.MergeAndSendUserNotice(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UserNoticeStep and nil error while calling MergeAndSendUserNotice. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *userNoticesServer) serveMergeAndSendUserNoticeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "MergeAndSendUserNotice")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UserNoticeStep)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UserNoticeStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.UserNotices.MergeAndSendUserNotice(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UserNoticeStep and nil error while calling MergeAndSendUserNotice. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *userNoticesServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 1
}

func (s *userNoticesServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *userNoticesServer) PathPrefix() string {
	return UserNoticesPathPrefix
}

// ===========================
// ChannelOnboarding Interface
// ===========================

type ChannelOnboarding interface {
	GetLegacyProducts(context.Context, *Onboarding) (*Onboarding, error)

	SetupEmotes(context.Context, *Onboarding) (*Onboarding, error)

	SetupProducts(context.Context, *Onboarding) (*Onboarding, error)

	SetupRevenueConfigs(context.Context, *Onboarding) (*Onboarding, error)

	EntitleStreamer(context.Context, *Onboarding) (*Onboarding, error)

	ActivateProducts(context.Context, *Onboarding) (*Onboarding, error)
}

// =================================
// ChannelOnboarding Protobuf Client
// =================================

type channelOnboardingProtobufClient struct {
	client HTTPClient
	urls   [6]string
	opts   twirp.ClientOptions
}

// NewChannelOnboardingProtobufClient creates a Protobuf client that implements the ChannelOnboarding interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewChannelOnboardingProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) ChannelOnboarding {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + ChannelOnboardingPathPrefix
	urls := [6]string{
		prefix + "GetLegacyProducts",
		prefix + "SetupEmotes",
		prefix + "SetupProducts",
		prefix + "SetupRevenueConfigs",
		prefix + "EntitleStreamer",
		prefix + "ActivateProducts",
	}

	return &channelOnboardingProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *channelOnboardingProtobufClient) GetLegacyProducts(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyProducts")
	out := new(Onboarding)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOnboardingProtobufClient) SetupEmotes(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "SetupEmotes")
	out := new(Onboarding)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOnboardingProtobufClient) SetupProducts(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "SetupProducts")
	out := new(Onboarding)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOnboardingProtobufClient) SetupRevenueConfigs(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "SetupRevenueConfigs")
	out := new(Onboarding)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOnboardingProtobufClient) EntitleStreamer(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "EntitleStreamer")
	out := new(Onboarding)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOnboardingProtobufClient) ActivateProducts(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "ActivateProducts")
	out := new(Onboarding)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =============================
// ChannelOnboarding JSON Client
// =============================

type channelOnboardingJSONClient struct {
	client HTTPClient
	urls   [6]string
	opts   twirp.ClientOptions
}

// NewChannelOnboardingJSONClient creates a JSON client that implements the ChannelOnboarding interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewChannelOnboardingJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) ChannelOnboarding {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + ChannelOnboardingPathPrefix
	urls := [6]string{
		prefix + "GetLegacyProducts",
		prefix + "SetupEmotes",
		prefix + "SetupProducts",
		prefix + "SetupRevenueConfigs",
		prefix + "EntitleStreamer",
		prefix + "ActivateProducts",
	}

	return &channelOnboardingJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *channelOnboardingJSONClient) GetLegacyProducts(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyProducts")
	out := new(Onboarding)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOnboardingJSONClient) SetupEmotes(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "SetupEmotes")
	out := new(Onboarding)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOnboardingJSONClient) SetupProducts(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "SetupProducts")
	out := new(Onboarding)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOnboardingJSONClient) SetupRevenueConfigs(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "SetupRevenueConfigs")
	out := new(Onboarding)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOnboardingJSONClient) EntitleStreamer(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "EntitleStreamer")
	out := new(Onboarding)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOnboardingJSONClient) ActivateProducts(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "ActivateProducts")
	out := new(Onboarding)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ================================
// ChannelOnboarding Server Handler
// ================================

type channelOnboardingServer struct {
	ChannelOnboarding
	hooks *twirp.ServerHooks
}

func NewChannelOnboardingServer(svc ChannelOnboarding, hooks *twirp.ServerHooks) TwirpServer {
	return &channelOnboardingServer{
		ChannelOnboarding: svc,
		hooks:             hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *channelOnboardingServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// ChannelOnboardingPathPrefix is used for all URL paths on a twirp ChannelOnboarding server.
// Requests are always: POST ChannelOnboardingPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const ChannelOnboardingPathPrefix = "/twirp/twitch.voyager.ChannelOnboarding/"

func (s *channelOnboardingServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.voyager.ChannelOnboarding/GetLegacyProducts":
		s.serveGetLegacyProducts(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.ChannelOnboarding/SetupEmotes":
		s.serveSetupEmotes(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.ChannelOnboarding/SetupProducts":
		s.serveSetupProducts(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.ChannelOnboarding/SetupRevenueConfigs":
		s.serveSetupRevenueConfigs(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.ChannelOnboarding/EntitleStreamer":
		s.serveEntitleStreamer(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.ChannelOnboarding/ActivateProducts":
		s.serveActivateProducts(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *channelOnboardingServer) serveGetLegacyProducts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetLegacyProductsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetLegacyProductsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *channelOnboardingServer) serveGetLegacyProductsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyProducts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Onboarding)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.GetLegacyProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling GetLegacyProducts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) serveGetLegacyProductsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyProducts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(Onboarding)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.GetLegacyProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling GetLegacyProducts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) serveSetupEmotes(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetupEmotesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetupEmotesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *channelOnboardingServer) serveSetupEmotesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetupEmotes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Onboarding)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.SetupEmotes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling SetupEmotes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) serveSetupEmotesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetupEmotes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(Onboarding)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.SetupEmotes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling SetupEmotes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) serveSetupProducts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetupProductsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetupProductsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *channelOnboardingServer) serveSetupProductsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetupProducts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Onboarding)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.SetupProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling SetupProducts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) serveSetupProductsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetupProducts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(Onboarding)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.SetupProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling SetupProducts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) serveSetupRevenueConfigs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetupRevenueConfigsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetupRevenueConfigsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *channelOnboardingServer) serveSetupRevenueConfigsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetupRevenueConfigs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Onboarding)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.SetupRevenueConfigs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling SetupRevenueConfigs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) serveSetupRevenueConfigsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetupRevenueConfigs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(Onboarding)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.SetupRevenueConfigs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling SetupRevenueConfigs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) serveEntitleStreamer(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEntitleStreamerJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEntitleStreamerProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *channelOnboardingServer) serveEntitleStreamerJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EntitleStreamer")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Onboarding)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.EntitleStreamer(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling EntitleStreamer. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) serveEntitleStreamerProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EntitleStreamer")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(Onboarding)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.EntitleStreamer(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling EntitleStreamer. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) serveActivateProducts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveActivateProductsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveActivateProductsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *channelOnboardingServer) serveActivateProductsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ActivateProducts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Onboarding)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.ActivateProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling ActivateProducts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) serveActivateProductsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ActivateProducts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(Onboarding)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.ActivateProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling ActivateProducts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 2
}

func (s *channelOnboardingServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *channelOnboardingServer) PathPrefix() string {
	return ChannelOnboardingPathPrefix
}

// =====================
// Fulfillment Interface
// =====================

type Fulfillment interface {
	FulfillEmotes(context.Context, *FulfillmentStep) (*FulfillmentStep, error)

	FulfillTenure(context.Context, *FulfillmentStep) (*FulfillmentStep, error)

	FulfillChatNotification(context.Context, *FulfillmentStep) (*FulfillmentStep, error)

	PublishFulfillmentSuccess(context.Context, *FulfillmentStep) (*FulfillmentStep, error)

	FulfillPubsub(context.Context, *FulfillmentStep) (*FulfillmentStep, error)

	PublishNotificationEvent(context.Context, *FulfillmentStep) (*FulfillmentStep, error)

	ScheduleExpirationEvent(context.Context, *FulfillmentStep) (*FulfillmentStep, error)
}

// ===========================
// Fulfillment Protobuf Client
// ===========================

type fulfillmentProtobufClient struct {
	client HTTPClient
	urls   [7]string
	opts   twirp.ClientOptions
}

// NewFulfillmentProtobufClient creates a Protobuf client that implements the Fulfillment interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewFulfillmentProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) Fulfillment {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + FulfillmentPathPrefix
	urls := [7]string{
		prefix + "FulfillEmotes",
		prefix + "FulfillTenure",
		prefix + "FulfillChatNotification",
		prefix + "PublishFulfillmentSuccess",
		prefix + "FulfillPubsub",
		prefix + "PublishNotificationEvent",
		prefix + "ScheduleExpirationEvent",
	}

	return &fulfillmentProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *fulfillmentProtobufClient) FulfillEmotes(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "FulfillEmotes")
	out := new(FulfillmentStep)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *fulfillmentProtobufClient) FulfillTenure(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "FulfillTenure")
	out := new(FulfillmentStep)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *fulfillmentProtobufClient) FulfillChatNotification(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "FulfillChatNotification")
	out := new(FulfillmentStep)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *fulfillmentProtobufClient) PublishFulfillmentSuccess(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "PublishFulfillmentSuccess")
	out := new(FulfillmentStep)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *fulfillmentProtobufClient) FulfillPubsub(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "FulfillPubsub")
	out := new(FulfillmentStep)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *fulfillmentProtobufClient) PublishNotificationEvent(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "PublishNotificationEvent")
	out := new(FulfillmentStep)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *fulfillmentProtobufClient) ScheduleExpirationEvent(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "ScheduleExpirationEvent")
	out := new(FulfillmentStep)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =======================
// Fulfillment JSON Client
// =======================

type fulfillmentJSONClient struct {
	client HTTPClient
	urls   [7]string
	opts   twirp.ClientOptions
}

// NewFulfillmentJSONClient creates a JSON client that implements the Fulfillment interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewFulfillmentJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) Fulfillment {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + FulfillmentPathPrefix
	urls := [7]string{
		prefix + "FulfillEmotes",
		prefix + "FulfillTenure",
		prefix + "FulfillChatNotification",
		prefix + "PublishFulfillmentSuccess",
		prefix + "FulfillPubsub",
		prefix + "PublishNotificationEvent",
		prefix + "ScheduleExpirationEvent",
	}

	return &fulfillmentJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *fulfillmentJSONClient) FulfillEmotes(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "FulfillEmotes")
	out := new(FulfillmentStep)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *fulfillmentJSONClient) FulfillTenure(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "FulfillTenure")
	out := new(FulfillmentStep)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *fulfillmentJSONClient) FulfillChatNotification(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "FulfillChatNotification")
	out := new(FulfillmentStep)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *fulfillmentJSONClient) PublishFulfillmentSuccess(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "PublishFulfillmentSuccess")
	out := new(FulfillmentStep)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *fulfillmentJSONClient) FulfillPubsub(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "FulfillPubsub")
	out := new(FulfillmentStep)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *fulfillmentJSONClient) PublishNotificationEvent(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "PublishNotificationEvent")
	out := new(FulfillmentStep)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *fulfillmentJSONClient) ScheduleExpirationEvent(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "ScheduleExpirationEvent")
	out := new(FulfillmentStep)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==========================
// Fulfillment Server Handler
// ==========================

type fulfillmentServer struct {
	Fulfillment
	hooks *twirp.ServerHooks
}

func NewFulfillmentServer(svc Fulfillment, hooks *twirp.ServerHooks) TwirpServer {
	return &fulfillmentServer{
		Fulfillment: svc,
		hooks:       hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *fulfillmentServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// FulfillmentPathPrefix is used for all URL paths on a twirp Fulfillment server.
// Requests are always: POST FulfillmentPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const FulfillmentPathPrefix = "/twirp/twitch.voyager.Fulfillment/"

func (s *fulfillmentServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.voyager.Fulfillment/FulfillEmotes":
		s.serveFulfillEmotes(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.Fulfillment/FulfillTenure":
		s.serveFulfillTenure(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.Fulfillment/FulfillChatNotification":
		s.serveFulfillChatNotification(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.Fulfillment/PublishFulfillmentSuccess":
		s.servePublishFulfillmentSuccess(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.Fulfillment/FulfillPubsub":
		s.serveFulfillPubsub(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.Fulfillment/PublishNotificationEvent":
		s.servePublishNotificationEvent(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.Fulfillment/ScheduleExpirationEvent":
		s.serveScheduleExpirationEvent(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *fulfillmentServer) serveFulfillEmotes(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveFulfillEmotesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFulfillEmotesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *fulfillmentServer) serveFulfillEmotesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FulfillEmotes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FulfillmentStep)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.FulfillEmotes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling FulfillEmotes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) serveFulfillEmotesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FulfillEmotes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(FulfillmentStep)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.FulfillEmotes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling FulfillEmotes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) serveFulfillTenure(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveFulfillTenureJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFulfillTenureProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *fulfillmentServer) serveFulfillTenureJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FulfillTenure")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FulfillmentStep)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.FulfillTenure(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling FulfillTenure. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) serveFulfillTenureProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FulfillTenure")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(FulfillmentStep)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.FulfillTenure(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling FulfillTenure. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) serveFulfillChatNotification(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveFulfillChatNotificationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFulfillChatNotificationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *fulfillmentServer) serveFulfillChatNotificationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FulfillChatNotification")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FulfillmentStep)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.FulfillChatNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling FulfillChatNotification. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) serveFulfillChatNotificationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FulfillChatNotification")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(FulfillmentStep)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.FulfillChatNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling FulfillChatNotification. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) servePublishFulfillmentSuccess(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePublishFulfillmentSuccessJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePublishFulfillmentSuccessProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *fulfillmentServer) servePublishFulfillmentSuccessJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PublishFulfillmentSuccess")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FulfillmentStep)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.PublishFulfillmentSuccess(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling PublishFulfillmentSuccess. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) servePublishFulfillmentSuccessProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PublishFulfillmentSuccess")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(FulfillmentStep)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.PublishFulfillmentSuccess(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling PublishFulfillmentSuccess. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) serveFulfillPubsub(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveFulfillPubsubJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFulfillPubsubProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *fulfillmentServer) serveFulfillPubsubJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FulfillPubsub")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FulfillmentStep)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.FulfillPubsub(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling FulfillPubsub. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) serveFulfillPubsubProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FulfillPubsub")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(FulfillmentStep)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.FulfillPubsub(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling FulfillPubsub. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) servePublishNotificationEvent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePublishNotificationEventJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePublishNotificationEventProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *fulfillmentServer) servePublishNotificationEventJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PublishNotificationEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FulfillmentStep)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.PublishNotificationEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling PublishNotificationEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) servePublishNotificationEventProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PublishNotificationEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(FulfillmentStep)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.PublishNotificationEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling PublishNotificationEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) serveScheduleExpirationEvent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveScheduleExpirationEventJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveScheduleExpirationEventProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *fulfillmentServer) serveScheduleExpirationEventJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ScheduleExpirationEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FulfillmentStep)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.ScheduleExpirationEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling ScheduleExpirationEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) serveScheduleExpirationEventProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ScheduleExpirationEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(FulfillmentStep)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.ScheduleExpirationEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling ScheduleExpirationEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 3
}

func (s *fulfillmentServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *fulfillmentServer) PathPrefix() string {
	return FulfillmentPathPrefix
}

// ============================
// ChannelOffboarding Interface
// ============================

type ChannelOffboarding interface {
	HandlePrefix(context.Context, *Offboarding) (*Offboarding, error)

	DowngradeProducts(context.Context, *Offboarding) (*Offboarding, error)

	DowngradeRevenueConfigs(context.Context, *Offboarding) (*Offboarding, error)

	DeactivateStreamerEntitlement(context.Context, *Offboarding) (*Offboarding, error)
}

// ==================================
// ChannelOffboarding Protobuf Client
// ==================================

type channelOffboardingProtobufClient struct {
	client HTTPClient
	urls   [4]string
	opts   twirp.ClientOptions
}

// NewChannelOffboardingProtobufClient creates a Protobuf client that implements the ChannelOffboarding interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewChannelOffboardingProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) ChannelOffboarding {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + ChannelOffboardingPathPrefix
	urls := [4]string{
		prefix + "HandlePrefix",
		prefix + "DowngradeProducts",
		prefix + "DowngradeRevenueConfigs",
		prefix + "DeactivateStreamerEntitlement",
	}

	return &channelOffboardingProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *channelOffboardingProtobufClient) HandlePrefix(ctx context.Context, in *Offboarding) (*Offboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOffboarding")
	ctx = ctxsetters.WithMethodName(ctx, "HandlePrefix")
	out := new(Offboarding)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOffboardingProtobufClient) DowngradeProducts(ctx context.Context, in *Offboarding) (*Offboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOffboarding")
	ctx = ctxsetters.WithMethodName(ctx, "DowngradeProducts")
	out := new(Offboarding)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOffboardingProtobufClient) DowngradeRevenueConfigs(ctx context.Context, in *Offboarding) (*Offboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOffboarding")
	ctx = ctxsetters.WithMethodName(ctx, "DowngradeRevenueConfigs")
	out := new(Offboarding)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOffboardingProtobufClient) DeactivateStreamerEntitlement(ctx context.Context, in *Offboarding) (*Offboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOffboarding")
	ctx = ctxsetters.WithMethodName(ctx, "DeactivateStreamerEntitlement")
	out := new(Offboarding)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==============================
// ChannelOffboarding JSON Client
// ==============================

type channelOffboardingJSONClient struct {
	client HTTPClient
	urls   [4]string
	opts   twirp.ClientOptions
}

// NewChannelOffboardingJSONClient creates a JSON client that implements the ChannelOffboarding interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewChannelOffboardingJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) ChannelOffboarding {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + ChannelOffboardingPathPrefix
	urls := [4]string{
		prefix + "HandlePrefix",
		prefix + "DowngradeProducts",
		prefix + "DowngradeRevenueConfigs",
		prefix + "DeactivateStreamerEntitlement",
	}

	return &channelOffboardingJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *channelOffboardingJSONClient) HandlePrefix(ctx context.Context, in *Offboarding) (*Offboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOffboarding")
	ctx = ctxsetters.WithMethodName(ctx, "HandlePrefix")
	out := new(Offboarding)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOffboardingJSONClient) DowngradeProducts(ctx context.Context, in *Offboarding) (*Offboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOffboarding")
	ctx = ctxsetters.WithMethodName(ctx, "DowngradeProducts")
	out := new(Offboarding)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOffboardingJSONClient) DowngradeRevenueConfigs(ctx context.Context, in *Offboarding) (*Offboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOffboarding")
	ctx = ctxsetters.WithMethodName(ctx, "DowngradeRevenueConfigs")
	out := new(Offboarding)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOffboardingJSONClient) DeactivateStreamerEntitlement(ctx context.Context, in *Offboarding) (*Offboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOffboarding")
	ctx = ctxsetters.WithMethodName(ctx, "DeactivateStreamerEntitlement")
	out := new(Offboarding)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =================================
// ChannelOffboarding Server Handler
// =================================

type channelOffboardingServer struct {
	ChannelOffboarding
	hooks *twirp.ServerHooks
}

func NewChannelOffboardingServer(svc ChannelOffboarding, hooks *twirp.ServerHooks) TwirpServer {
	return &channelOffboardingServer{
		ChannelOffboarding: svc,
		hooks:              hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *channelOffboardingServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// ChannelOffboardingPathPrefix is used for all URL paths on a twirp ChannelOffboarding server.
// Requests are always: POST ChannelOffboardingPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const ChannelOffboardingPathPrefix = "/twirp/twitch.voyager.ChannelOffboarding/"

func (s *channelOffboardingServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOffboarding")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.voyager.ChannelOffboarding/HandlePrefix":
		s.serveHandlePrefix(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.ChannelOffboarding/DowngradeProducts":
		s.serveDowngradeProducts(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.ChannelOffboarding/DowngradeRevenueConfigs":
		s.serveDowngradeRevenueConfigs(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.ChannelOffboarding/DeactivateStreamerEntitlement":
		s.serveDeactivateStreamerEntitlement(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *channelOffboardingServer) serveHandlePrefix(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHandlePrefixJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHandlePrefixProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *channelOffboardingServer) serveHandlePrefixJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HandlePrefix")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Offboarding)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Offboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOffboarding.HandlePrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Offboarding and nil error while calling HandlePrefix. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOffboardingServer) serveHandlePrefixProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HandlePrefix")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(Offboarding)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Offboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOffboarding.HandlePrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Offboarding and nil error while calling HandlePrefix. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOffboardingServer) serveDowngradeProducts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDowngradeProductsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDowngradeProductsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *channelOffboardingServer) serveDowngradeProductsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DowngradeProducts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Offboarding)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Offboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOffboarding.DowngradeProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Offboarding and nil error while calling DowngradeProducts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOffboardingServer) serveDowngradeProductsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DowngradeProducts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(Offboarding)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Offboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOffboarding.DowngradeProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Offboarding and nil error while calling DowngradeProducts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOffboardingServer) serveDowngradeRevenueConfigs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDowngradeRevenueConfigsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDowngradeRevenueConfigsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *channelOffboardingServer) serveDowngradeRevenueConfigsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DowngradeRevenueConfigs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Offboarding)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Offboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOffboarding.DowngradeRevenueConfigs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Offboarding and nil error while calling DowngradeRevenueConfigs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOffboardingServer) serveDowngradeRevenueConfigsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DowngradeRevenueConfigs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(Offboarding)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Offboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOffboarding.DowngradeRevenueConfigs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Offboarding and nil error while calling DowngradeRevenueConfigs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOffboardingServer) serveDeactivateStreamerEntitlement(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeactivateStreamerEntitlementJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeactivateStreamerEntitlementProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *channelOffboardingServer) serveDeactivateStreamerEntitlementJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeactivateStreamerEntitlement")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Offboarding)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Offboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOffboarding.DeactivateStreamerEntitlement(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Offboarding and nil error while calling DeactivateStreamerEntitlement. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOffboardingServer) serveDeactivateStreamerEntitlementProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeactivateStreamerEntitlement")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(Offboarding)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Offboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOffboarding.DeactivateStreamerEntitlement(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Offboarding and nil error while calling DeactivateStreamerEntitlement. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOffboardingServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 4
}

func (s *channelOffboardingServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *channelOffboardingServer) PathPrefix() string {
	return ChannelOffboardingPathPrefix
}

// ===============================
// UpdateSubscriberCount Interface
// ===============================

type UpdateSubscriberCount interface {
	IncrementSubscriberCount(context.Context, *UpdateSubscriberCountRequest) (*UpdateSubscriberCountResponse, error)

	DecrementSubscriberCount(context.Context, *UpdateSubscriberCountRequest) (*UpdateSubscriberCountResponse, error)

	ResetSubscriberCount(context.Context, *ResetSubscriberCountRequest) (*ResetSubscriberCountResponse, error)

	HasIdempotencyKey(context.Context, *HasIdempotencyKeyRequest) (*HasIdempotencyKeyResponse, error)
}

// =====================================
// UpdateSubscriberCount Protobuf Client
// =====================================

type updateSubscriberCountProtobufClient struct {
	client HTTPClient
	urls   [4]string
	opts   twirp.ClientOptions
}

// NewUpdateSubscriberCountProtobufClient creates a Protobuf client that implements the UpdateSubscriberCount interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewUpdateSubscriberCountProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) UpdateSubscriberCount {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + UpdateSubscriberCountPathPrefix
	urls := [4]string{
		prefix + "IncrementSubscriberCount",
		prefix + "DecrementSubscriberCount",
		prefix + "ResetSubscriberCount",
		prefix + "HasIdempotencyKey",
	}

	return &updateSubscriberCountProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *updateSubscriberCountProtobufClient) IncrementSubscriberCount(ctx context.Context, in *UpdateSubscriberCountRequest) (*UpdateSubscriberCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "UpdateSubscriberCount")
	ctx = ctxsetters.WithMethodName(ctx, "IncrementSubscriberCount")
	out := new(UpdateSubscriberCountResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *updateSubscriberCountProtobufClient) DecrementSubscriberCount(ctx context.Context, in *UpdateSubscriberCountRequest) (*UpdateSubscriberCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "UpdateSubscriberCount")
	ctx = ctxsetters.WithMethodName(ctx, "DecrementSubscriberCount")
	out := new(UpdateSubscriberCountResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *updateSubscriberCountProtobufClient) ResetSubscriberCount(ctx context.Context, in *ResetSubscriberCountRequest) (*ResetSubscriberCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "UpdateSubscriberCount")
	ctx = ctxsetters.WithMethodName(ctx, "ResetSubscriberCount")
	out := new(ResetSubscriberCountResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *updateSubscriberCountProtobufClient) HasIdempotencyKey(ctx context.Context, in *HasIdempotencyKeyRequest) (*HasIdempotencyKeyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "UpdateSubscriberCount")
	ctx = ctxsetters.WithMethodName(ctx, "HasIdempotencyKey")
	out := new(HasIdempotencyKeyResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =================================
// UpdateSubscriberCount JSON Client
// =================================

type updateSubscriberCountJSONClient struct {
	client HTTPClient
	urls   [4]string
	opts   twirp.ClientOptions
}

// NewUpdateSubscriberCountJSONClient creates a JSON client that implements the UpdateSubscriberCount interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewUpdateSubscriberCountJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) UpdateSubscriberCount {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + UpdateSubscriberCountPathPrefix
	urls := [4]string{
		prefix + "IncrementSubscriberCount",
		prefix + "DecrementSubscriberCount",
		prefix + "ResetSubscriberCount",
		prefix + "HasIdempotencyKey",
	}

	return &updateSubscriberCountJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *updateSubscriberCountJSONClient) IncrementSubscriberCount(ctx context.Context, in *UpdateSubscriberCountRequest) (*UpdateSubscriberCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "UpdateSubscriberCount")
	ctx = ctxsetters.WithMethodName(ctx, "IncrementSubscriberCount")
	out := new(UpdateSubscriberCountResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *updateSubscriberCountJSONClient) DecrementSubscriberCount(ctx context.Context, in *UpdateSubscriberCountRequest) (*UpdateSubscriberCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "UpdateSubscriberCount")
	ctx = ctxsetters.WithMethodName(ctx, "DecrementSubscriberCount")
	out := new(UpdateSubscriberCountResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *updateSubscriberCountJSONClient) ResetSubscriberCount(ctx context.Context, in *ResetSubscriberCountRequest) (*ResetSubscriberCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "UpdateSubscriberCount")
	ctx = ctxsetters.WithMethodName(ctx, "ResetSubscriberCount")
	out := new(ResetSubscriberCountResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *updateSubscriberCountJSONClient) HasIdempotencyKey(ctx context.Context, in *HasIdempotencyKeyRequest) (*HasIdempotencyKeyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "UpdateSubscriberCount")
	ctx = ctxsetters.WithMethodName(ctx, "HasIdempotencyKey")
	out := new(HasIdempotencyKeyResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ====================================
// UpdateSubscriberCount Server Handler
// ====================================

type updateSubscriberCountServer struct {
	UpdateSubscriberCount
	hooks *twirp.ServerHooks
}

func NewUpdateSubscriberCountServer(svc UpdateSubscriberCount, hooks *twirp.ServerHooks) TwirpServer {
	return &updateSubscriberCountServer{
		UpdateSubscriberCount: svc,
		hooks:                 hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *updateSubscriberCountServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// UpdateSubscriberCountPathPrefix is used for all URL paths on a twirp UpdateSubscriberCount server.
// Requests are always: POST UpdateSubscriberCountPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const UpdateSubscriberCountPathPrefix = "/twirp/twitch.voyager.UpdateSubscriberCount/"

func (s *updateSubscriberCountServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "UpdateSubscriberCount")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.voyager.UpdateSubscriberCount/IncrementSubscriberCount":
		s.serveIncrementSubscriberCount(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.UpdateSubscriberCount/DecrementSubscriberCount":
		s.serveDecrementSubscriberCount(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.UpdateSubscriberCount/ResetSubscriberCount":
		s.serveResetSubscriberCount(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.UpdateSubscriberCount/HasIdempotencyKey":
		s.serveHasIdempotencyKey(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *updateSubscriberCountServer) serveIncrementSubscriberCount(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveIncrementSubscriberCountJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveIncrementSubscriberCountProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *updateSubscriberCountServer) serveIncrementSubscriberCountJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IncrementSubscriberCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateSubscriberCountRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateSubscriberCountResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.UpdateSubscriberCount.IncrementSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSubscriberCountResponse and nil error while calling IncrementSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *updateSubscriberCountServer) serveIncrementSubscriberCountProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IncrementSubscriberCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateSubscriberCountRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateSubscriberCountResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.UpdateSubscriberCount.IncrementSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSubscriberCountResponse and nil error while calling IncrementSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *updateSubscriberCountServer) serveDecrementSubscriberCount(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDecrementSubscriberCountJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDecrementSubscriberCountProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *updateSubscriberCountServer) serveDecrementSubscriberCountJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DecrementSubscriberCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateSubscriberCountRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateSubscriberCountResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.UpdateSubscriberCount.DecrementSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSubscriberCountResponse and nil error while calling DecrementSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *updateSubscriberCountServer) serveDecrementSubscriberCountProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DecrementSubscriberCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateSubscriberCountRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateSubscriberCountResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.UpdateSubscriberCount.DecrementSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSubscriberCountResponse and nil error while calling DecrementSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *updateSubscriberCountServer) serveResetSubscriberCount(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveResetSubscriberCountJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveResetSubscriberCountProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *updateSubscriberCountServer) serveResetSubscriberCountJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ResetSubscriberCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ResetSubscriberCountRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ResetSubscriberCountResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.UpdateSubscriberCount.ResetSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ResetSubscriberCountResponse and nil error while calling ResetSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *updateSubscriberCountServer) serveResetSubscriberCountProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ResetSubscriberCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ResetSubscriberCountRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ResetSubscriberCountResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.UpdateSubscriberCount.ResetSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ResetSubscriberCountResponse and nil error while calling ResetSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *updateSubscriberCountServer) serveHasIdempotencyKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHasIdempotencyKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHasIdempotencyKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *updateSubscriberCountServer) serveHasIdempotencyKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HasIdempotencyKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HasIdempotencyKeyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *HasIdempotencyKeyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.UpdateSubscriberCount.HasIdempotencyKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HasIdempotencyKeyResponse and nil error while calling HasIdempotencyKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *updateSubscriberCountServer) serveHasIdempotencyKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HasIdempotencyKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(HasIdempotencyKeyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *HasIdempotencyKeyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.UpdateSubscriberCount.HasIdempotencyKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HasIdempotencyKeyResponse and nil error while calling HasIdempotencyKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *updateSubscriberCountServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 5
}

func (s *updateSubscriberCountServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *updateSubscriberCountServer) PathPrefix() string {
	return UpdateSubscriberCountPathPrefix
}

// ================================
// TwitchVoyagerSelfServe Interface
// ================================

type TwitchVoyagerSelfServe interface {
	FixUserChannelBenefits(context.Context, *FixUserChannelBenefitsRequest) (*FixUserChannelBenefitsResponse, error)

	GetChannelAdminSubscriptions(context.Context, *GetChannelAdminSubscriptionsRequest) (*GetChannelAdminSubscriptionsResponse, error)
}

// ======================================
// TwitchVoyagerSelfServe Protobuf Client
// ======================================

type twitchVoyagerSelfServeProtobufClient struct {
	client HTTPClient
	urls   [2]string
	opts   twirp.ClientOptions
}

// NewTwitchVoyagerSelfServeProtobufClient creates a Protobuf client that implements the TwitchVoyagerSelfServe interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchVoyagerSelfServeProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchVoyagerSelfServe {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchVoyagerSelfServePathPrefix
	urls := [2]string{
		prefix + "FixUserChannelBenefits",
		prefix + "GetChannelAdminSubscriptions",
	}

	return &twitchVoyagerSelfServeProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchVoyagerSelfServeProtobufClient) FixUserChannelBenefits(ctx context.Context, in *FixUserChannelBenefitsRequest) (*FixUserChannelBenefitsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyagerSelfServe")
	ctx = ctxsetters.WithMethodName(ctx, "FixUserChannelBenefits")
	out := new(FixUserChannelBenefitsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerSelfServeProtobufClient) GetChannelAdminSubscriptions(ctx context.Context, in *GetChannelAdminSubscriptionsRequest) (*GetChannelAdminSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyagerSelfServe")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelAdminSubscriptions")
	out := new(GetChannelAdminSubscriptionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==================================
// TwitchVoyagerSelfServe JSON Client
// ==================================

type twitchVoyagerSelfServeJSONClient struct {
	client HTTPClient
	urls   [2]string
	opts   twirp.ClientOptions
}

// NewTwitchVoyagerSelfServeJSONClient creates a JSON client that implements the TwitchVoyagerSelfServe interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchVoyagerSelfServeJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchVoyagerSelfServe {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchVoyagerSelfServePathPrefix
	urls := [2]string{
		prefix + "FixUserChannelBenefits",
		prefix + "GetChannelAdminSubscriptions",
	}

	return &twitchVoyagerSelfServeJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchVoyagerSelfServeJSONClient) FixUserChannelBenefits(ctx context.Context, in *FixUserChannelBenefitsRequest) (*FixUserChannelBenefitsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyagerSelfServe")
	ctx = ctxsetters.WithMethodName(ctx, "FixUserChannelBenefits")
	out := new(FixUserChannelBenefitsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerSelfServeJSONClient) GetChannelAdminSubscriptions(ctx context.Context, in *GetChannelAdminSubscriptionsRequest) (*GetChannelAdminSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyagerSelfServe")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelAdminSubscriptions")
	out := new(GetChannelAdminSubscriptionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =====================================
// TwitchVoyagerSelfServe Server Handler
// =====================================

type twitchVoyagerSelfServeServer struct {
	TwitchVoyagerSelfServe
	hooks *twirp.ServerHooks
}

func NewTwitchVoyagerSelfServeServer(svc TwitchVoyagerSelfServe, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchVoyagerSelfServeServer{
		TwitchVoyagerSelfServe: svc,
		hooks:                  hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchVoyagerSelfServeServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchVoyagerSelfServePathPrefix is used for all URL paths on a twirp TwitchVoyagerSelfServe server.
// Requests are always: POST TwitchVoyagerSelfServePathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchVoyagerSelfServePathPrefix = "/twirp/twitch.voyager.TwitchVoyagerSelfServe/"

func (s *twitchVoyagerSelfServeServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyagerSelfServe")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.voyager.TwitchVoyagerSelfServe/FixUserChannelBenefits":
		s.serveFixUserChannelBenefits(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyagerSelfServe/GetChannelAdminSubscriptions":
		s.serveGetChannelAdminSubscriptions(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchVoyagerSelfServeServer) serveFixUserChannelBenefits(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveFixUserChannelBenefitsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFixUserChannelBenefitsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerSelfServeServer) serveFixUserChannelBenefitsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FixUserChannelBenefits")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FixUserChannelBenefitsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FixUserChannelBenefitsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyagerSelfServe.FixUserChannelBenefits(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FixUserChannelBenefitsResponse and nil error while calling FixUserChannelBenefits. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerSelfServeServer) serveFixUserChannelBenefitsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FixUserChannelBenefits")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(FixUserChannelBenefitsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FixUserChannelBenefitsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyagerSelfServe.FixUserChannelBenefits(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FixUserChannelBenefitsResponse and nil error while calling FixUserChannelBenefits. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerSelfServeServer) serveGetChannelAdminSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelAdminSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelAdminSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerSelfServeServer) serveGetChannelAdminSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelAdminSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetChannelAdminSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetChannelAdminSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyagerSelfServe.GetChannelAdminSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelAdminSubscriptionsResponse and nil error while calling GetChannelAdminSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerSelfServeServer) serveGetChannelAdminSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelAdminSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetChannelAdminSubscriptionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetChannelAdminSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyagerSelfServe.GetChannelAdminSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelAdminSubscriptionsResponse and nil error while calling GetChannelAdminSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerSelfServeServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 6
}

func (s *twitchVoyagerSelfServeServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchVoyagerSelfServeServer) PathPrefix() string {
	return TwitchVoyagerSelfServePathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 4096 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x3c, 0xcf, 0x6f, 0xdb, 0x58,
	0x7a, 0x43, 0x49, 0xb6, 0xa5, 0x4f, 0xb6, 0x4c, 0xbf, 0xf8, 0x87, 0xa2, 0xfc, 0x72, 0x98, 0x99,
	0x24, 0xe3, 0xc9, 0x38, 0x33, 0x72, 0xba, 0xb3, 0x3b, 0x53, 0x2c, 0x46, 0x96, 0x68, 0x87, 0x1b,
	0x59, 0x52, 0x29, 0x3a, 0xd9, 0xec, 0xb4, 0x25, 0x68, 0xf1, 0xc9, 0xe6, 0x46, 0xa6, 0x34, 0x24,
	0x95, 0xc4, 0x83, 0x02, 0x05, 0x76, 0xdb, 0x01, 0x16, 0x2d, 0xd0, 0x43, 0xbb, 0x68, 0xb1, 0x40,
	0x0b, 0xec, 0xb6, 0x87, 0xde, 0xb7, 0xed, 0xa5, 0x87, 0x9e, 0xf7, 0xb2, 0x28, 0x7a, 0xe8, 0xad,
	0x40, 0x4f, 0xed, 0x3f, 0x50, 0xb4, 0xa7, 0x02, 0xc5, 0x7b, 0x7c, 0xa4, 0x48, 0x91, 0x94, 0xe4,
	0x38, 0x99, 0x05, 0xba, 0x73, 0x49, 0xc4, 0xef, 0xf7, 0x7b, 0xdf, 0xf7, 0xde, 0xfb, 0xbe, 0xf7,
	0x3e, 0x18, 0xca, 0x9d, 0xbe, 0x8e, 0xb7, 0xbf, 0x3f, 0xb4, 0x1d, 0xc3, 0xdc, 0x76, 0x9e, 0xdf,
	0xd7, 0x4e, 0xbf, 0x30, 0xef, 0x2b, 0x2f, 0x0c, 0xa7, 0x73, 0xf2, 0xb8, 0x7f, 0xa6, 0x1d, 0x63,
	0x4b, 0x79, 0x61, 0x58, 0x83, 0xfb, 0x0e, 0xf9, 0x77, 0x7b, 0x60, 0xf5, 0x9d, 0x3e, 0x2a, 0x38,
	0x14, 0xbf, 0xfd, 0xdc, 0x25, 0x28, 0xdd, 0x38, 0xee, 0xf7, 0x8f, 0x7b, 0xf8, 0x3e, 0xc5, 0x1e,
	0x0d, 0xbb, 0xf7, 0x1d, 0xe3, 0x14, 0xdb, 0x8e, 0x76, 0xca, 0x18, 0x04, 0x15, 0x16, 0x25, 0xb3,
	0x6b, 0x98, 0x86, 0x83, 0x15, 0xe3, 0x14, 0xa3, 0x1b, 0x90, 0x37, 0x6c, 0xd5, 0x60, 0xa0, 0x22,
	0xb7, 0xc9, 0xdd, 0xcd, 0xca, 0x60, 0xd8, 0x1e, 0x11, 0xda, 0x86, 0x0c, 0x91, 0x51, 0x4c, 0x6d,
	0x72, 0x77, 0xf3, 0xe5, 0xd2, 0xb6, 0xab, 0x60, 0xdb, 0x53, 0xb0, 0xad, 0x78, 0x0a, 0x64, 0x4a,
	0x27, 0xfc, 0x75, 0x06, 0x16, 0xdb, 0xc3, 0x23, 0xbb, 0x63, 0x19, 0x03, 0xc7, 0xe8, 0x9b, 0xa8,
	0x00, 0x29, 0x43, 0xa7, 0x82, 0x73, 0x72, 0xca, 0xd0, 0xd1, 0x15, 0xc8, 0xf5, 0x2d, 0xe3, 0xd8,
	0x30, 0x55, 0x43, 0xa7, 0x52, 0x73, 0x72, 0xd6, 0x05, 0x48, 0x3a, 0xda, 0x80, 0x85, 0xa1, 0x8d,
	0x2d, 0x82, 0x4a, 0x53, 0xd4, 0x3c, 0xf9, 0x94, 0x74, 0x74, 0x0d, 0xa0, 0x73, 0xa2, 0x99, 0x26,
	0xee, 0x11, 0x5c, 0x86, 0xe2, 0x72, 0x0c, 0xe2, 0xa2, 0x07, 0x56, 0x5f, 0x1f, 0x76, 0x1c, 0x82,
	0x9e, 0x73, 0xd1, 0x0c, 0x22, 0xe9, 0xe8, 0x03, 0x98, 0xb3, 0x1d, 0xcd, 0x72, 0x8a, 0xf3, 0x53,
	0x47, 0xe1, 0x12, 0xa2, 0x7b, 0x90, 0xc6, 0xa6, 0x5e, 0x5c, 0x98, 0x4a, 0x4f, 0xc8, 0xd0, 0xb7,
	0x00, 0x3a, 0x16, 0xd6, 0x1c, 0xac, 0xab, 0x9a, 0x53, 0xcc, 0x4d, 0x65, 0xca, 0x31, 0xea, 0x8a,
	0x43, 0x58, 0x87, 0x03, 0xdd, 0x63, 0x85, 0xe9, 0xac, 0x8c, 0xba, 0xe2, 0xa0, 0x07, 0x90, 0x71,
	0xce, 0x06, 0xb8, 0x98, 0xdf, 0xe4, 0xee, 0x16, 0xca, 0x9b, 0xdb, 0xe1, 0x58, 0xd8, 0x0e, 0x7a,
	0x41, 0x39, 0x1b, 0x60, 0x99, 0x52, 0xa3, 0x07, 0x90, 0x1d, 0xf4, 0x34, 0xa7, 0xdb, 0xb7, 0x4e,
	0x8b, 0x8b, 0x94, 0xb3, 0x38, 0xce, 0xd9, 0x62, 0x78, 0xd9, 0xa7, 0x44, 0x57, 0x21, 0x67, 0xd8,
	0x6d, 0x47, 0xeb, 0x3c, 0xc3, 0x7a, 0x71, 0x89, 0x46, 0xc9, 0x08, 0x80, 0xee, 0x93, 0x20, 0xc1,
	0x56, 0xb1, 0x40, 0xe5, 0x5d, 0x89, 0xc8, 0x73, 0x1d, 0xa1, 0x18, 0xd8, 0x92, 0x29, 0xa1, 0xf0,
	0x4b, 0x0e, 0x16, 0x5b, 0xda, 0xd9, 0x29, 0x36, 0x1d, 0xbb, 0xa6, 0x39, 0x5a, 0x38, 0x2a, 0xb8,
	0xb1, 0xa8, 0xb8, 0x0b, 0x3c, 0x7e, 0xe9, 0xa8, 0x83, 0xa1, 0xd5, 0x39, 0xd1, 0x6c, 0xac, 0xda,
	0xcf, 0x86, 0x2c, 0x72, 0x0a, 0xf8, 0xa5, 0xd3, 0x62, 0xe0, 0xf6, 0xb3, 0x21, 0xba, 0x05, 0x4b,
	0x86, 0xad, 0x5a, 0xb8, 0x3b, 0x34, 0x75, 0xed, 0xa8, 0x87, 0x69, 0x14, 0x65, 0xe5, 0x45, 0xc3,
	0x96, 0x7d, 0x18, 0xba, 0x0c, 0x59, 0xc3, 0x56, 0x75, 0xd3, 0xc2, 0x6e, 0x24, 0x65, 0xe5, 0x05,
	0xc3, 0xae, 0x91, 0x4f, 0xf4, 0x11, 0xe4, 0x2c, 0x6c, 0xe2, 0x17, 0x36, 0x71, 0xc6, 0xdc, 0x54,
	0x67, 0x64, 0x5d, 0xe2, 0x8a, 0x23, 0xfc, 0x8c, 0x83, 0xab, 0xc1, 0x09, 0x7f, 0x62, 0x38, 0x27,
	0xa1, 0x01, 0x7e, 0x0a, 0x8b, 0x76, 0x00, 0x4f, 0xc7, 0x98, 0x2f, 0x5f, 0x9d, 0xe4, 0x34, 0x39,
	0xc4, 0x41, 0x24, 0x0c, 0x02, 0x12, 0xd9, 0x8a, 0x8c, 0x48, 0x08, 0x6a, 0x95, 0x43, 0x1c, 0xc2,
	0x1f, 0x70, 0x50, 0xf0, 0x7c, 0xbb, 0x67, 0xf4, 0x1c, 0x6c, 0xa1, 0x6f, 0x40, 0xce, 0xf3, 0xb1,
	0x5d, 0xe4, 0x36, 0xd3, 0x13, 0xc3, 0x61, 0x44, 0x8a, 0x3e, 0x86, 0x6c, 0x7f, 0x80, 0x2d, 0xcd,
	0xe9, 0x5b, 0xd4, 0x90, 0x42, 0xf9, 0xfa, 0x38, 0x9b, 0xab, 0xa1, 0xc9, 0xa8, 0x64, 0x9f, 0x5e,
	0xf8, 0x63, 0x0e, 0xd6, 0xc7, 0x83, 0xd3, 0x37, 0x67, 0x8e, 0x04, 0xa9, 0x67, 0xca, 0xf4, 0x98,
	0x76, 0xc9, 0x2f, 0x64, 0xce, 0x1f, 0x71, 0x70, 0xab, 0x6e, 0xd8, 0xce, 0xa1, 0x8d, 0x2d, 0xf1,
	0xe5, 0xc0, 0xb0, 0xb0, 0x1e, 0x54, 0x63, 0xcb, 0xf8, 0xf3, 0x21, 0xb6, 0x9d, 0xe0, 0xde, 0xc4,
	0x85, 0xf6, 0xa6, 0x55, 0x98, 0xeb, 0x19, 0xa7, 0x86, 0x43, 0x35, 0xa7, 0x65, 0xf7, 0x03, 0xad,
	0xc3, 0x7c, 0x67, 0x68, 0xd9, 0x7d, 0xcb, 0xdb, 0xc9, 0xdc, 0xaf, 0xb1, 0xad, 0x2a, 0x33, 0xb6,
	0x55, 0x09, 0x3f, 0xe0, 0xe0, 0xed, 0xc9, 0xd6, 0xd8, 0x83, 0xbe, 0x69, 0x63, 0xb4, 0x0b, 0x4b,
	0xc1, 0xf0, 0x70, 0xa7, 0x6c, 0x5a, 0x44, 0x85, 0x59, 0x02, 0x36, 0xa6, 0x82, 0x36, 0x0a, 0xff,
	0xc3, 0xc1, 0x55, 0xcf, 0x88, 0x37, 0x39, 0x17, 0xfb, 0x90, 0x27, 0xfe, 0x53, 0xbb, 0xd4, 0x37,
	0x74, 0x32, 0xf2, 0xe5, 0xdb, 0xd3, 0x9c, 0xee, 0x7a, 0x52, 0x06, 0x67, 0x14, 0x37, 0xfb, 0xb0,
	0xec, 0xc5, 0xa6, 0x27, 0xcc, 0x5d, 0xbd, 0xd7, 0x93, 0x82, 0x99, 0x09, 0x29, 0x0c, 0x42, 0xdf,
	0x24, 0x18, 0xae, 0x25, 0x8c, 0x9c, 0xcd, 0xbb, 0x1c, 0x3f, 0xef, 0xf7, 0x26, 0x59, 0x3d, 0xbe,
	0x1b, 0xcc, 0xea, 0x87, 0xff, 0xe6, 0xe0, 0xca, 0x3e, 0xfe, 0x35, 0x74, 0xc3, 0x17, 0x70, 0x35,
	0x7e, 0xdc, 0x5f, 0x41, 0xf0, 0x7f, 0x99, 0x82, 0xf7, 0xe2, 0x94, 0x47, 0x9c, 0xf8, 0xff, 0xdd,
	0x09, 0x3f, 0xe1, 0xe0, 0xde, 0x6c, 0x13, 0xf1, 0x2b, 0x58, 0x1a, 0xbf, 0x0b, 0x02, 0xb3, 0x8d,
	0x65, 0x17, 0xe7, 0x5b, 0x20, 0x37, 0x20, 0x3f, 0xda, 0x85, 0xed, 0x62, 0x6a, 0x33, 0x7d, 0x37,
	0x27, 0x83, 0xbf, 0x0d, 0xdb, 0x82, 0x01, 0xb7, 0x26, 0xca, 0x7f, 0x7d, 0x81, 0x28, 0x98, 0x50,
	0x9e, 0xa0, 0xea, 0xdc, 0x61, 0x37, 0x75, 0x68, 0x3f, 0xe2, 0x60, 0xe7, 0x5c, 0x0a, 0xdf, 0x9c,
	0x7b, 0x85, 0xcf, 0xe0, 0x26, 0x33, 0xa5, 0xea, 0x26, 0xf3, 0xa1, 0x89, 0x9a, 0x36, 0xd4, 0x70,
	0x55, 0x90, 0x1a, 0xab, 0x0a, 0x84, 0xae, 0x1f, 0x23, 0xb1, 0xc2, 0xd9, 0xb0, 0x2e, 0x9c, 0x99,
	0x09, 0xcf, 0xe0, 0xc3, 0x64, 0x3d, 0xe7, 0xf6, 0xdf, 0x94, 0x41, 0x7d, 0xc9, 0xf9, 0xe1, 0x32,
	0x93, 0x36, 0x36, 0xca, 0x56, 0xec, 0x28, 0xcf, 0xe7, 0xbb, 0xf0, 0xa8, 0x7f, 0xc2, 0xc1, 0xf5,
	0x7d, 0xec, 0xc4, 0x18, 0xe1, 0x2f, 0xbf, 0xf0, 0x50, 0xb8, 0xf1, 0xaa, 0xed, 0x7c, 0x1b, 0xe4,
	0x7b, 0x30, 0xd7, 0xb7, 0x74, 0xb6, 0x35, 0x16, 0xca, 0x6b, 0xe3, 0xa6, 0x37, 0x09, 0x52, 0x76,
	0x69, 0x84, 0xbf, 0xe1, 0xe0, 0x46, 0xa2, 0x71, 0x6f, 0xfe, 0x10, 0x41, 0xef, 0x40, 0xc1, 0xc2,
	0xcf, 0xb1, 0x65, 0x63, 0x35, 0x34, 0x98, 0x25, 0x06, 0xad, 0xfa, 0x89, 0xd6, 0x9d, 0x04, 0x33,
	0x2b, 0x5d, 0x07, 0x5b, 0xa4, 0xd4, 0x78, 0x23, 0x93, 0xf9, 0x2d, 0x00, 0x8d, 0x28, 0x50, 0x69,
	0x71, 0x9f, 0x99, 0x5e, 0x76, 0x6a, 0x9e, 0x39, 0xa8, 0x06, 0xd7, 0xdd, 0x63, 0x45, 0xed, 0x68,
	0x66, 0x07, 0xf7, 0x7a, 0x58, 0x57, 0xc3, 0xf3, 0x38, 0x47, 0x8b, 0xaa, 0xab, 0x2e, 0x55, 0xd5,
	0x23, 0x0a, 0x8d, 0x4e, 0xf8, 0x5b, 0x0e, 0xee, 0x4e, 0x1f, 0xf9, 0x57, 0xe0, 0xa9, 0x4d, 0xc8,
	0x9f, 0x68, 0x76, 0x83, 0x14, 0x92, 0xda, 0xb1, 0x57, 0x30, 0x06, 0x41, 0xc2, 0x53, 0xb8, 0xbc,
	0x8f, 0xbd, 0x3d, 0xf2, 0x08, 0x5b, 0xd5, 0xfe, 0xd0, 0x74, 0x66, 0xf4, 0x4a, 0x38, 0xdb, 0x4f,
	0x8d, 0x67, 0xfb, 0xfb, 0x50, 0x8a, 0x13, 0xcd, 0x86, 0xfd, 0x2e, 0xf0, 0xb6, 0x8f, 0x52, 0x3b,
	0x04, 0x47, 0x35, 0xa4, 0xe5, 0x65, 0x3b, 0xcc, 0x22, 0x74, 0x61, 0x39, 0x38, 0xf8, 0x47, 0xf8,
	0x2c, 0x79, 0x83, 0x99, 0x78, 0x03, 0x13, 0x36, 0x38, 0x3d, 0x6e, 0xf0, 0x3f, 0xa6, 0x60, 0xa3,
	0x85, 0x4d, 0xdd, 0x30, 0x8f, 0x83, 0xfa, 0x24, 0xb3, 0xdb, 0x8f, 0xdc, 0xf4, 0x7c, 0x0c, 0xd9,
	0x23, 0x52, 0xae, 0x3f, 0xc3, 0x67, 0xac, 0x58, 0xbd, 0x31, 0xc9, 0x61, 0x8f, 0xf0, 0x99, 0xbc,
	0x40, 0x18, 0x88, 0xf1, 0x9f, 0x42, 0x7e, 0x38, 0x38, 0xb6, 0x34, 0xdd, 0x65, 0x4f, 0xcf, 0xc6,
	0x0e, 0x8c, 0x87, 0x48, 0xf0, 0xef, 0x7c, 0x32, 0xb3, 0xde, 0xf9, 0x78, 0xb7, 0x18, 0x73, 0x33,
	0xde, 0x62, 0x50, 0x86, 0xb3, 0x01, 0xa6, 0xb7, 0x4a, 0x31, 0x0c, 0x87, 0xae, 0x31, 0xa3, 0xbb,
	0x17, 0xe1, 0x73, 0x7a, 0xda, 0x25, 0xcc, 0x9f, 0x17, 0x51, 0x75, 0x58, 0x09, 0x46, 0x2e, 0x19,
	0xbf, 0x17, 0xf0, 0x53, 0x27, 0x80, 0xb7, 0xc3, 0x00, 0x9b, 0x14, 0x34, 0xc2, 0x24, 0x9d, 0x2c,
	0xd4, 0x30, 0x94, 0x06, 0x2e, 0x49, 0x68, 0x2d, 0xab, 0x86, 0xd9, 0xed, 0x7b, 0xda, 0xef, 0x44,
	0x66, 0x24, 0x41, 0x68, 0x71, 0x10, 0x8f, 0xb0, 0x85, 0xdf, 0x83, 0x6b, 0xfb, 0x96, 0x66, 0x3a,
	0x15, 0xfd, 0xd4, 0x30, 0xcf, 0x7b, 0xd4, 0x4f, 0x58, 0x48, 0xec, 0xe2, 0x47, 0xd7, 0xac, 0x67,
	0x3d, 0x6d, 0x68, 0x76, 0x4e, 0x46, 0x17, 0x3f, 0x35, 0x1f, 0x26, 0x6c, 0xc2, 0xf5, 0x24, 0xed,
	0xee, 0x34, 0x08, 0x3f, 0xe6, 0x60, 0xad, 0x69, 0x1e, 0xf5, 0x35, 0x4b, 0x67, 0x3b, 0xd3, 0x8c,
	0xeb, 0xfc, 0x3e, 0x64, 0xac, 0x7e, 0x0f, 0xb3, 0xcb, 0x87, 0x48, 0x28, 0x30, 0x61, 0x6e, 0x28,
	0x10, 0x42, 0x74, 0x0f, 0x90, 0x63, 0x74, 0x9e, 0x61, 0x47, 0x0d, 0x26, 0x6b, 0x69, 0x9a, 0xac,
	0xf1, 0x2e, 0xa6, 0x35, 0x4a, 0xd9, 0x8a, 0xb0, 0x3e, 0x6e, 0x16, 0xb3, 0xf8, 0x04, 0xd6, 0x9b,
	0xdd, 0xee, 0x57, 0x60, 0xb1, 0x70, 0x19, 0x36, 0x22, 0x9a, 0x98, 0x11, 0xff, 0xce, 0xc1, 0xc2,
	0x2e, 0x36, 0x71, 0xd7, 0x70, 0x22, 0xbb, 0xc0, 0x47, 0x6c, 0x91, 0xb8, 0x7a, 0x6e, 0x8d, 0xeb,
	0x61, 0x6c, 0xde, 0xff, 0x81, 0x8b, 0xca, 0x1b, 0x90, 0xc7, 0x2f, 0x1d, 0x6c, 0x99, 0x5a, 0xe0,
	0xce, 0x17, 0x3c, 0x90, 0xa4, 0x0b, 0x18, 0xf2, 0x01, 0x2e, 0x94, 0x85, 0x4c, 0xa3, 0xd9, 0x10,
	0xf9, 0xb7, 0xd0, 0x25, 0x58, 0xae, 0x3e, 0xac, 0x34, 0x1a, 0x62, 0x5d, 0xad, 0xd4, 0xd4, 0x3d,
	0x59, 0x14, 0x79, 0x0e, 0xf1, 0xb0, 0xd8, 0x3e, 0xdc, 0x55, 0x9b, 0x8d, 0xfa, 0x53, 0xf5, 0x71,
	0xb3, 0xc6, 0xa7, 0xd0, 0x12, 0xe4, 0xc4, 0x83, 0xa6, 0x22, 0xaa, 0x6d, 0x51, 0xe1, 0xd3, 0x68,
	0x1d, 0x50, 0xa5, 0x21, 0x1d, 0x54, 0x14, 0xb1, 0xa6, 0x8e, 0xe0, 0x99, 0xef, 0x64, 0xb2, 0x69,
	0x3e, 0x23, 0xfc, 0x15, 0x07, 0x0b, 0xcc, 0x21, 0x91, 0x21, 0x7a, 0x1b, 0x47, 0x6a, 0xd6, 0x8d,
	0x63, 0x07, 0xb2, 0x47, 0xae, 0xe5, 0xae, 0xcb, 0xf3, 0xe5, 0x8d, 0x84, 0x79, 0x91, 0x7d, 0x42,
	0xe2, 0x4f, 0xfb, 0xa4, 0x6f, 0x39, 0xaa, 0xa9, 0xb1, 0x23, 0x3b, 0x27, 0xe7, 0x28, 0xa4, 0xa1,
	0x9d, 0x62, 0xe1, 0xe7, 0x19, 0x00, 0x16, 0x23, 0x86, 0x79, 0x3c, 0xcd, 0xfb, 0xdf, 0x86, 0x45,
	0x0f, 0x1d, 0xf0, 0xce, 0xc4, 0x28, 0xc8, 0x77, 0x46, 0x1f, 0x64, 0x04, 0x2c, 0x6e, 0x13, 0x47,
	0xc0, 0x86, 0x2d, 0xfb, 0x84, 0x68, 0x07, 0x32, 0xb6, 0x83, 0x07, 0x2c, 0x81, 0x8b, 0x6c, 0x66,
	0x23, 0xeb, 0xb7, 0xdb, 0x0e, 0x1e, 0xc8, 0x94, 0x98, 0x9c, 0x56, 0xc7, 0x56, 0x7f, 0x38, 0xa0,
	0xeb, 0x63, 0x8e, 0xae, 0x8f, 0x2c, 0x05, 0x48, 0xba, 0x9d, 0xb0, 0x8a, 0xe6, 0xe3, 0x57, 0x11,
	0xfa, 0x14, 0x96, 0x7b, 0xf8, 0x58, 0xeb, 0x9c, 0xa9, 0xbe, 0xed, 0x0b, 0x93, 0x6d, 0x2f, 0xb8,
	0xf4, 0x2d, 0x6f, 0x04, 0xbf, 0x01, 0x1b, 0x9a, 0x69, 0x9c, 0xd2, 0xeb, 0x7a, 0x7c, 0xda, 0x77,
	0xb0, 0xea, 0xd9, 0x56, 0xcc, 0xd2, 0x29, 0x5e, 0xf5, 0xd0, 0x22, 0xc1, 0xee, 0xbb, 0x76, 0x0a,
	0x7f, 0xce, 0x41, 0x86, 0x0c, 0x29, 0x10, 0xa3, 0x24, 0x1c, 0x45, 0xe5, 0xb0, 0xe5, 0x86, 0x5a,
	0x9b, 0xe7, 0x10, 0x82, 0x82, 0x0b, 0x69, 0xc9, 0xcd, 0xda, 0x61, 0x55, 0x69, 0xf3, 0x69, 0x74,
	0x19, 0xd6, 0x5c, 0x98, 0x2c, 0x3e, 0x16, 0x1b, 0x87, 0xa2, 0x5a, 0x6d, 0x36, 0xf6, 0xa4, 0xfd,
	0x36, 0x9f, 0x41, 0xab, 0xc0, 0x8b, 0x0d, 0x45, 0x52, 0xea, 0xa2, 0xda, 0x56, 0x64, 0xb1, 0x72,
	0x20, 0xca, 0xfc, 0x1c, 0xda, 0x80, 0x4b, 0xfb, 0xa2, 0xa2, 0xd6, 0xc5, 0xfd, 0x4a, 0xf5, 0xe9,
	0x48, 0xd2, 0x3c, 0x5a, 0x83, 0x95, 0x4a, 0x55, 0x91, 0x1e, 0x57, 0x14, 0x71, 0x04, 0x5e, 0x10,
	0x7e, 0x31, 0x07, 0xcb, 0x7b, 0xc3, 0x5e, 0xd7, 0xe8, 0xf5, 0x48, 0x9e, 0x4f, 0x8d, 0x0c, 0x6f,
	0xb5, 0xdc, 0xf8, 0x56, 0x1b, 0xd8, 0xa2, 0x53, 0xc9, 0x79, 0x45, 0x7a, 0x2c, 0xaf, 0xb8, 0x09,
	0x8b, 0xde, 0xfd, 0xbd, 0x35, 0x5a, 0xce, 0x79, 0x1f, 0x26, 0xe9, 0x24, 0x67, 0xee, 0x8e, 0x4c,
	0x19, 0x3d, 0xe4, 0x2c, 0x05, 0xa0, 0x92, 0x8e, 0x4a, 0x90, 0x35, 0x4c, 0x07, 0x5b, 0xcf, 0xb5,
	0x1e, 0x3d, 0x79, 0xe7, 0x64, 0xff, 0x1b, 0x7d, 0x02, 0x59, 0x7b, 0x78, 0xe4, 0x86, 0xf4, 0xc2,
	0x8c, 0xcf, 0x22, 0x0b, 0xf6, 0xf0, 0x48, 0x19, 0x7f, 0x19, 0xc9, 0xce, 0xfc, 0x32, 0xe2, 0xe7,
	0x19, 0xb9, 0x59, 0xf3, 0x8c, 0x6d, 0xf7, 0x6d, 0x09, 0xe2, 0xeb, 0xcc, 0xe0, 0xf3, 0x9c, 0xfb,
	0xba, 0x14, 0x39, 0xdb, 0xf2, 0xd1, 0xb3, 0x6d, 0x6c, 0xbd, 0x2f, 0x8e, 0xaf, 0xf7, 0x2b, 0x90,
	0x23, 0xab, 0xc9, 0xdd, 0x3b, 0x96, 0x5c, 0xdf, 0x10, 0x00, 0xd9, 0x3a, 0x50, 0x05, 0x96, 0xbc,
	0x19, 0x54, 0x87, 0xa6, 0xe1, 0xb0, 0x77, 0x9c, 0x18, 0xd3, 0x5c, 0xa2, 0x43, 0xd3, 0x70, 0xe4,
	0x45, 0x23, 0xf0, 0x85, 0x0e, 0xc6, 0x33, 0xf4, 0xe5, 0xf8, 0x94, 0x21, 0x18, 0x6b, 0x13, 0x92,
	0xf5, 0x1d, 0x76, 0x68, 0xf0, 0xf1, 0x3b, 0x45, 0x40, 0x4a, 0x20, 0xbb, 0xfa, 0xfb, 0x39, 0xd8,
	0x48, 0x90, 0xff, 0xf5, 0x2b, 0xe4, 0xd7, 0xaf, 0x90, 0xd1, 0x63, 0x58, 0x04, 0x7e, 0xa0, 0x19,
	0xba, 0x1a, 0xac, 0x34, 0x96, 0xe9, 0xd8, 0xa3, 0xcc, 0x9a, 0xa1, 0xb3, 0x7c, 0x5e, 0x2e, 0x0c,
	0x46, 0x1f, 0xa4, 0xd2, 0xf8, 0x36, 0x2c, 0xba, 0xa1, 0xa3, 0xf5, 0xa8, 0x08, 0x7e, 0xba, 0x88,
	0xbc, 0xc7, 0xf0, 0x08, 0x9f, 0x09, 0x3f, 0xe3, 0x20, 0x1f, 0x40, 0x4e, 0x7e, 0x0b, 0x4d, 0xdc,
	0x7d, 0x27, 0x17, 0x6e, 0xc4, 0x48, 0x6f, 0x98, 0xd4, 0x5d, 0x99, 0xe9, 0x35, 0x8b, 0x57, 0x81,
	0x91, 0x0f, 0xe1, 0x17, 0x29, 0xc8, 0x7b, 0xe9, 0xdf, 0x0c, 0xf9, 0xc5, 0xb9, 0xf3, 0xe1, 0x57,
	0x4a, 0x28, 0x1e, 0x84, 0x12, 0x8a, 0x48, 0xec, 0x05, 0xec, 0x0d, 0x64, 0x14, 0xc2, 0xef, 0x47,
	0x0e, 0xe3, 0x15, 0x58, 0x7a, 0x58, 0x69, 0xd4, 0xea, 0xe4, 0x68, 0x14, 0xf7, 0xa4, 0xef, 0xf2,
	0x1c, 0xc9, 0x06, 0x6b, 0xcd, 0x27, 0x8d, 0x7d, 0xb9, 0x52, 0x0b, 0x1c, 0x98, 0x29, 0x74, 0x0d,
	0x2e, 0x8f, 0xe0, 0xe3, 0xa7, 0x72, 0x1a, 0xdd, 0x82, 0x1b, 0x35, 0xd1, 0x3f, 0x68, 0xbd, 0x83,
	0x59, 0x65, 0x27, 0xf5, 0x81, 0xd8, 0x50, 0xf8, 0x8c, 0xf0, 0x87, 0x1c, 0x5c, 0x3d, 0xa4, 0x0b,
	0xe8, 0x4d, 0x5c, 0x2a, 0xa0, 0x3b, 0xb0, 0x6c, 0xe8, 0xf8, 0x74, 0xd0, 0x77, 0xb0, 0xd9, 0x39,
	0xf3, 0xeb, 0xe7, 0x9c, 0x5c, 0x08, 0x80, 0x49, 0xe0, 0xdd, 0x80, 0x6b, 0x09, 0x66, 0xb0, 0xbc,
	0xfe, 0x33, 0xb8, 0x22, 0x63, 0xfb, 0x0d, 0xdd, 0x7d, 0x5c, 0x87, 0xab, 0xf1, 0xc2, 0x99, 0xf2,
	0x2a, 0x14, 0x1f, 0x6a, 0xb6, 0x14, 0x32, 0xd9, 0xd3, 0x1c, 0x33, 0x44, 0x2e, 0x76, 0x88, 0x0f,
	0xe0, 0x72, 0x8c, 0x10, 0x56, 0xf4, 0x6e, 0xc0, 0xc2, 0x89, 0x66, 0xfb, 0xdc, 0x59, 0x79, 0xfe,
	0x44, 0xb3, 0x09, 0xd7, 0x13, 0xb8, 0xb6, 0x67, 0xbc, 0x0c, 0x5c, 0xb1, 0xb2, 0x6c, 0xdc, 0xbe,
	0xe8, 0xe5, 0xed, 0x26, 0x5c, 0x4f, 0x12, 0xcc, 0x46, 0x5d, 0xa3, 0xef, 0x0e, 0x0c, 0x1b, 0x29,
	0x54, 0x67, 0xbc, 0x59, 0x15, 0xbe, 0x0f, 0x6f, 0x4f, 0x96, 0xf2, 0x1a, 0x9f, 0x2f, 0xfe, 0x33,
	0x05, 0x40, 0x46, 0xd4, 0xe8, 0x3b, 0x46, 0x07, 0x47, 0x4e, 0xda, 0xb1, 0x0d, 0x2b, 0x9d, 0x30,
	0x55, 0x69, 0x8a, 0x0b, 0x44, 0x0f, 0x82, 0xcc, 0x51, 0x5f, 0x3f, 0x63, 0xa7, 0x2c, 0xfd, 0x4d,
	0x92, 0x48, 0x1d, 0x77, 0xb5, 0x61, 0xcf, 0x51, 0x29, 0xce, 0x3d, 0x62, 0xf3, 0x0c, 0xb6, 0x4b,
	0x48, 0xae, 0x01, 0x9c, 0x62, 0xdb, 0xd6, 0x8e, 0x31, 0x91, 0x3a, 0xef, 0x4e, 0x0c, 0x83, 0x48,
	0x3a, 0x52, 0xa0, 0xe0, 0xa1, 0x07, 0x9a, 0xa5, 0x9d, 0x7a, 0x15, 0xc0, 0xfb, 0x91, 0x8d, 0xd0,
	0x1f, 0xd1, 0xf6, 0x81, 0xcb, 0xd0, 0xa2, 0xf4, 0xa2, 0xe9, 0x58, 0x67, 0xf2, 0xd2, 0x69, 0x10,
	0x16, 0xcd, 0xd0, 0xb2, 0xd1, 0x0c, 0xad, 0xf4, 0x29, 0xa0, 0xa8, 0x24, 0xc4, 0x43, 0x7a, 0x14,
	0xbd, 0xe4, 0x27, 0x5a, 0x85, 0xb9, 0xe7, 0x5a, 0x6f, 0x88, 0x59, 0xf4, 0xb8, 0x1f, 0x1f, 0xa7,
	0xbe, 0xc9, 0x09, 0x7f, 0xc6, 0xc1, 0xcd, 0x36, 0x36, 0xf5, 0x91, 0x6d, 0x4f, 0x0c, 0xe7, 0xa4,
	0x3d, 0x3c, 0x12, 0x9f, 0xe3, 0xd1, 0xaa, 0xfc, 0x04, 0xf2, 0x74, 0xc2, 0x4d, 0x4a, 0xc1, 0x2e,
	0xfa, 0x4b, 0xc9, 0xe3, 0x93, 0x61, 0x38, 0xf2, 0x5e, 0xd9, 0x6b, 0xc0, 0x48, 0xd1, 0x06, 0x8c,
	0xb8, 0x40, 0xa0, 0xca, 0x02, 0xcd, 0x17, 0x42, 0x15, 0x84, 0x49, 0x56, 0xb1, 0x50, 0xbb, 0x06,
	0x60, 0xe1, 0x0e, 0x36, 0x06, 0xc1, 0xaa, 0x82, 0x41, 0x24, 0x5d, 0xf8, 0x2f, 0x8e, 0xf6, 0x8d,
	0x51, 0x9e, 0xfd, 0xbe, 0xd6, 0x43, 0xef, 0x03, 0xa2, 0xc3, 0xe8, 0xf4, 0x4d, 0xc7, 0x32, 0x8e,
	0x86, 0x5e, 0x7c, 0x92, 0x84, 0x7f, 0x85, 0x60, 0xaa, 0x41, 0x04, 0xda, 0x81, 0xb5, 0xce, 0xd0,
	0xb2, 0x48, 0xe1, 0x10, 0xe6, 0x48, 0x51, 0x8e, 0x55, 0x86, 0x0c, 0x33, 0x7d, 0x08, 0xab, 0x8e,
	0x66, 0x1d, 0xe3, 0x71, 0x9e, 0x34, 0xe5, 0xb9, 0xe4, 0xe2, 0xc2, 0x2c, 0xef, 0xc1, 0x4a, 0x90,
	0x76, 0x74, 0x98, 0xe6, 0x64, 0x3e, 0x88, 0xa0, 0x15, 0xc5, 0x26, 0xe4, 0x75, 0x3c, 0x7a, 0x73,
	0xf1, 0xc3, 0x75, 0xf4, 0x88, 0xf2, 0x17, 0x1c, 0xac, 0x55, 0x69, 0x1a, 0x36, 0xee, 0xc6, 0xf1,
	0x75, 0xf4, 0x41, 0xe8, 0x1e, 0x65, 0xb2, 0x63, 0xdc, 0x1c, 0xab, 0x0c, 0x99, 0xe3, 0xbe, 0xd6,
	0x63, 0x97, 0xa7, 0x89, 0x1c, 0x64, 0xb6, 0x1f, 0xbe, 0x25, 0x53, 0xda, 0xdd, 0x1c, 0x2c, 0x0c,
	0xb4, 0xb3, 0x5e, 0x5f, 0xd3, 0x85, 0x22, 0xac, 0x8f, 0x5b, 0xc6, 0xf6, 0xa8, 0x7f, 0xe6, 0xa0,
	0x30, 0xf2, 0x36, 0x3d, 0x4b, 0x2f, 0x14, 0x74, 0xa2, 0xaf, 0x94, 0x86, 0x5d, 0xbe, 0xfc, 0x5e,
	0x32, 0x23, 0xd1, 0xb6, 0xdd, 0x72, 0xa9, 0xdd, 0xb5, 0xe8, 0xf1, 0x96, 0x3e, 0xa6, 0x3d, 0x65,
	0x3e, 0xe2, 0x3c, 0x4b, 0x6b, 0xeb, 0x4f, 0x53, 0xc0, 0x8f, 0xa7, 0xaa, 0xa8, 0x04, 0xeb, 0xed,
	0xc3, 0xdd, 0x76, 0x55, 0x96, 0x5a, 0x8a, 0xd4, 0x6c, 0xa8, 0xca, 0xd3, 0x96, 0xa8, 0xb2, 0x94,
	0x21, 0x16, 0xd7, 0xaa, 0x48, 0x35, 0x9e, 0x8b, 0xc7, 0xed, 0x4b, 0x7b, 0x0a, 0x9f, 0x42, 0x57,
	0x60, 0x23, 0x86, 0x4f, 0x96, 0x0e, 0x44, 0x3e, 0x8d, 0x36, 0xe1, 0x6a, 0x02, 0x52, 0xad, 0x4b,
	0x8d, 0x47, 0x7c, 0x26, 0x9e, 0xbd, 0x52, 0x3b, 0x90, 0x1a, 0xfc, 0x1c, 0xba, 0x0b, 0x6f, 0x47,
	0x91, 0x61, 0x48, 0xf3, 0x91, 0xd8, 0xe0, 0xe7, 0xd1, 0x3b, 0x70, 0x33, 0x4a, 0x59, 0x6d, 0xd2,
	0x94, 0xa6, 0x26, 0x1e, 0x50, 0x20, 0xbf, 0xb0, 0xf5, 0x53, 0x0e, 0x16, 0x83, 0x45, 0x1f, 0xc9,
	0x8a, 0xa4, 0x86, 0x22, 0xca, 0x8f, 0x2b, 0x75, 0xf5, 0xb0, 0x21, 0x29, 0xde, 0x6c, 0x6c, 0xc0,
	0xa5, 0x30, 0xfc, 0xa0, 0xd9, 0x50, 0x1e, 0xba, 0x69, 0x54, 0x18, 0xf1, 0x54, 0xac, 0xc8, 0x7c,
	0x0a, 0xad, 0xc1, 0x4a, 0x18, 0x5e, 0xab, 0x3c, 0x75, 0xef, 0xe0, 0xc2, 0xe0, 0x27, 0xa2, 0x48,
	0x86, 0x7d, 0x19, 0xd6, 0xc2, 0xf0, 0x66, 0x43, 0x54, 0xc8, 0x9c, 0xcd, 0x6d, 0xfd, 0x90, 0x0b,
	0xdd, 0x60, 0x50, 0xc7, 0x5d, 0x86, 0xb5, 0xbd, 0xc3, 0xfa, 0x9e, 0x54, 0xaf, 0x93, 0x8c, 0x2b,
	0xe4, 0xb7, 0x2b, 0xb0, 0x11, 0x41, 0x55, 0x65, 0xb1, 0xa2, 0x88, 0x3c, 0x17, 0x8b, 0x3c, 0x6c,
	0xd5, 0x08, 0x32, 0x15, 0x8b, 0x94, 0xc5, 0xc7, 0xcd, 0x47, 0x22, 0x9f, 0xde, 0xfa, 0x01, 0x07,
	0x59, 0xaf, 0x60, 0x21, 0xe9, 0x64, 0xab, 0x5e, 0x51, 0xf6, 0x9a, 0xf2, 0x81, 0x3a, 0xba, 0xee,
	0xf1, 0x41, 0x4f, 0xc4, 0x5d, 0x9e, 0x43, 0xab, 0xc0, 0xfb, 0x90, 0x4a, 0xa3, 0x26, 0x37, 0xa5,
	0x1a, 0x9f, 0x0a, 0xd1, 0x49, 0x4d, 0x92, 0x51, 0x5e, 0x82, 0xe5, 0x11, 0xdd, 0x41, 0xe5, 0x7b,
	0xcd, 0x86, 0x7b, 0xf9, 0xe3, 0x03, 0x6b, 0x62, 0xfb, 0x91, 0xd2, 0x6c, 0xf1, 0x73, 0x5b, 0x9f,
	0x41, 0x21, 0xdc, 0xe5, 0x86, 0x8a, 0xb0, 0xba, 0x27, 0xd5, 0x15, 0x51, 0x56, 0x9b, 0x2d, 0x51,
	0xae, 0x28, 0x4d, 0xd9, 0x33, 0x68, 0x1d, 0xd0, 0x38, 0x46, 0x6a, 0xf0, 0x1c, 0xf1, 0x64, 0x84,
	0x43, 0x6a, 0xf0, 0xa9, 0xad, 0xdb, 0x30, 0x47, 0x5f, 0x58, 0xd1, 0x12, 0xe4, 0xe8, 0x0f, 0xb5,
	0xd2, 0xae, 0xf2, 0x6f, 0xa1, 0x02, 0x80, 0xfb, 0x59, 0x13, 0xdb, 0x55, 0x9e, 0xdb, 0xfa, 0x25,
	0x07, 0xf9, 0x40, 0x15, 0x41, 0x3c, 0x7d, 0xd8, 0x72, 0xd3, 0xe5, 0xa0, 0x1f, 0xde, 0x81, 0x9b,
	0x21, 0x30, 0x59, 0x1e, 0xaa, 0xd2, 0xa4, 0x4b, 0x48, 0x65, 0x18, 0x9e, 0x43, 0xb7, 0x41, 0x08,
	0x91, 0xb9, 0x8b, 0x61, 0x9c, 0x2e, 0x85, 0xee, 0xc0, 0xad, 0x10, 0x5d, 0xad, 0x21, 0x13, 0x2a,
	0x59, 0x6c, 0x1f, 0xee, 0xaa, 0xb2, 0x58, 0x3d, 0x94, 0x65, 0xa9, 0xb1, 0xcf, 0xa7, 0xd1, 0x07,
	0x70, 0x2f, 0x44, 0x38, 0x16, 0xf4, 0x11, 0xd1, 0x99, 0xad, 0x3f, 0x21, 0xe5, 0xd9, 0xa8, 0x76,
	0x24, 0x03, 0x62, 0xf5, 0x80, 0xaa, 0x48, 0xa2, 0x3f, 0xa1, 0x08, 0x0a, 0x21, 0xf0, 0x87, 0xee,
	0x95, 0x5e, 0x08, 0x56, 0xe6, 0x53, 0x11, 0xd8, 0x0e, 0x9f, 0x26, 0x93, 0x1e, 0x82, 0x55, 0x0f,
	0xdb, 0x4a, 0xf3, 0x80, 0xf9, 0x39, 0x88, 0xa8, 0x34, 0x9e, 0xf2, 0x73, 0x5b, 0x7f, 0xc7, 0x41,
	0x3e, 0x50, 0x41, 0x05, 0x0a, 0x99, 0x25, 0xc8, 0x55, 0xf6, 0xf6, 0xa4, 0xba, 0xe4, 0xc6, 0xf3,
	0x2a, 0xf0, 0x6d, 0xa5, 0xd2, 0xa8, 0x55, 0xe4, 0x9a, 0xda, 0xaa, 0xc8, 0x4a, 0x43, 0x24, 0x6b,
	0x8f, 0x44, 0x94, 0x2c, 0x1e, 0x48, 0x87, 0x07, 0x3e, 0x30, 0x4d, 0xcc, 0x72, 0xb5, 0xfa, 0x30,
	0xba, 0xea, 0x1e, 0x97, 0xbd, 0x6f, 0x75, 0xb7, 0xd2, 0x96, 0xaa, 0xd4, 0x0c, 0xf7, 0x9e, 0x31,
	0x80, 0x6a, 0xc9, 0x4d, 0x17, 0x31, 0x3f, 0xc6, 0x23, 0xd6, 0x25, 0x45, 0x74, 0x51, 0x0b, 0x5b,
	0xdf, 0x18, 0x9d, 0xf0, 0xd4, 0x6c, 0x04, 0x05, 0xe2, 0x1d, 0x52, 0x43, 0x29, 0x81, 0x59, 0x1c,
	0xc1, 0xf6, 0x9b, 0x95, 0x3a, 0xcf, 0x95, 0xff, 0x65, 0x05, 0x96, 0x42, 0x7d, 0xf0, 0xe8, 0x47,
	0x81, 0xfe, 0xc4, 0xb8, 0x26, 0x49, 0xb4, 0x33, 0x7e, 0x80, 0xcc, 0xd0, 0xe0, 0x59, 0x7a, 0x70,
	0x3e, 0x26, 0x96, 0xd7, 0x38, 0xb0, 0x16, 0xdb, 0x30, 0x88, 0xee, 0x25, 0x89, 0x8b, 0x55, 0xfe,
	0xfe, 0x8c, 0xd4, 0x4c, 0xeb, 0xe7, 0xb0, 0x1a, 0xd7, 0x9a, 0x85, 0x22, 0x27, 0xe7, 0x84, 0xf6,
	0xc1, 0xd2, 0xbd, 0xd9, 0x88, 0x99, 0xca, 0x9f, 0x72, 0xb4, 0xa8, 0x98, 0xda, 0x0e, 0x86, 0x3e,
	0x99, 0x45, 0x6c, 0x42, 0x5b, 0x4c, 0xe9, 0x37, 0x5f, 0x8d, 0x99, 0xd9, 0xf8, 0xe5, 0xa8, 0x61,
	0x32, 0xae, 0xb5, 0x09, 0x95, 0x13, 0xa4, 0x4f, 0xe8, 0x21, 0x2b, 0xed, 0x9c, 0x8b, 0x87, 0x19,
	0xf2, 0x0f, 0x9c, 0xdf, 0x44, 0x38, 0x4b, 0x8f, 0x15, 0xda, 0x3d, 0x87, 0x92, 0xa4, 0xa9, 0xab,
	0x5e, 0x48, 0x06, 0x33, 0xfc, 0x87, 0x1c, 0x6d, 0x49, 0x48, 0x68, 0x2f, 0x42, 0x1f, 0x26, 0xe8,
	0x48, 0xee, 0xde, 0x2a, 0x95, 0xcf, 0xc3, 0xc2, 0xac, 0xf8, 0x39, 0x07, 0x5b, 0xb3, 0x37, 0x39,
	0xa1, 0xca, 0xec, 0x2a, 0x92, 0x26, 0x6f, 0xf7, 0x22, 0x22, 0x98, 0xd5, 0x5f, 0xc0, 0x46, 0x42,
	0x4b, 0x0b, 0xda, 0x8e, 0x11, 0x3f, 0xa1, 0x73, 0xaa, 0x74, 0x7f, 0x66, 0x7a, 0xa6, 0xfb, 0xc7,
	0x1c, 0x6c, 0x4e, 0xeb, 0xa7, 0x41, 0x1f, 0xcd, 0x28, 0x75, 0xbc, 0xf7, 0xa8, 0xf4, 0xcd, 0xf3,
	0x33, 0x86, 0xe3, 0x29, 0xa9, 0x67, 0x24, 0x2e, 0x9e, 0x26, 0xf7, 0x47, 0xc4, 0xc6, 0xd3, 0xb4,
	0xf6, 0x86, 0x67, 0x80, 0xa2, 0x7d, 0x36, 0xe8, 0xdd, 0x18, 0x49, 0xf1, 0x57, 0x5d, 0xa5, 0xad,
	0x59, 0x48, 0x99, 0xb2, 0x17, 0xb0, 0x1e, 0xdf, 0x66, 0x80, 0x22, 0x9b, 0xfc, 0xc4, 0x66, 0x88,
	0xd2, 0xf6, 0xac, 0xe4, 0x4c, 0xb1, 0x0a, 0x85, 0x70, 0x97, 0x00, 0x7a, 0x27, 0xe1, 0x8d, 0x35,
	0xdc, 0x2a, 0x50, 0xba, 0x3d, 0x8d, 0x8c, 0x29, 0x38, 0x82, 0xe5, 0xb1, 0x16, 0x00, 0x74, 0x3b,
	0xe9, 0xd2, 0x75, 0x4c, 0xc5, 0x9d, 0xa9, 0x74, 0x81, 0x80, 0x49, 0xbe, 0x4e, 0x88, 0x06, 0xcc,
	0xd4, 0x0b, 0x91, 0x68, 0xc0, 0xcc, 0x70, 0x5b, 0xa1, 0x42, 0x21, 0x5c, 0xfc, 0x46, 0xa7, 0x32,
	0xb6, 0x6c, 0x8f, 0x4e, 0x65, 0x7c, 0x0d, 0x5d, 0xfe, 0x27, 0x92, 0x26, 0xfb, 0x36, 0xd8, 0xe8,
	0x31, 0xac, 0xd6, 0xfb, 0x9a, 0x4e, 0x8a, 0x71, 0x7b, 0xaf, 0x6f, 0xf9, 0x6a, 0xaf, 0x4f, 0x2e,
	0x85, 0x4b, 0x53, 0xf0, 0xe8, 0xbb, 0xb0, 0x7e, 0x80, 0xad, 0x63, 0x5c, 0x31, 0xf5, 0xf0, 0xb0,
	0x2f, 0x2a, 0xb9, 0xfc, 0xaf, 0x69, 0x58, 0x61, 0xce, 0x0b, 0xf4, 0x1d, 0x3c, 0x82, 0x95, 0x7d,
	0xec, 0xd4, 0xc3, 0xcf, 0xe6, 0xa5, 0xe4, 0xa7, 0xfe, 0xd2, 0x04, 0x1c, 0x12, 0x21, 0xdf, 0xc6,
	0xce, 0x70, 0x40, 0x1f, 0xd3, 0x5f, 0x5d, 0xcc, 0x3e, 0x2c, 0x51, 0x31, 0x17, 0xb6, 0xe7, 0x00,
	0x2e, 0x51, 0x41, 0x32, 0x7e, 0x8e, 0xcd, 0x21, 0xae, 0xf6, 0xcd, 0xae, 0x71, 0xfc, 0xea, 0xe2,
	0x24, 0x58, 0x16, 0x4d, 0xc7, 0x70, 0x7a, 0xb8, 0xed, 0x58, 0x58, 0x3b, 0xc5, 0xd6, 0x2b, 0x8b,
	0xfa, 0x0e, 0xf0, 0x95, 0x8e, 0x63, 0x3c, 0xd7, 0x1c, 0x7c, 0xd1, 0x51, 0x96, 0xff, 0x37, 0x03,
	0xf9, 0x40, 0x45, 0x8d, 0x7e, 0x0b, 0x96, 0xd8, 0x27, 0xf3, 0xc3, 0xa4, 0xf7, 0x58, 0x1a, 0x3a,
	0xd3, 0x08, 0x02, 0x22, 0x15, 0x6c, 0x0e, 0x2d, 0xfc, 0x1a, 0x44, 0x7e, 0xe6, 0x3f, 0xfe, 0x56,
	0x4f, 0x34, 0x87, 0xc4, 0x69, 0xd7, 0xe8, 0x68, 0x74, 0xdb, 0xbd, 0xb8, 0xf0, 0xdf, 0x81, 0xcb,
	0xad, 0xe1, 0x51, 0xcf, 0xb0, 0x4f, 0x42, 0x0f, 0xcc, 0x9d, 0x0e, 0xb6, 0x5f, 0xef, 0x74, 0xb4,
	0x86, 0x47, 0xf6, 0xf0, 0xe8, 0x35, 0x88, 0xfc, 0x6d, 0x28, 0x32, 0x8b, 0x83, 0x53, 0xe1, 0xee,
	0x29, 0xaf, 0x65, 0xb2, 0xdb, 0x9d, 0x13, 0xac, 0x0f, 0x7b, 0x98, 0x16, 0x47, 0xaf, 0x53, 0x78,
	0xf9, 0xdf, 0x52, 0x80, 0xbc, 0x8d, 0x25, 0xf0, 0xe2, 0xf8, 0x10, 0x16, 0x1f, 0x6a, 0xa6, 0xde,
	0xc3, 0x2d, 0x0b, 0x77, 0x8d, 0x97, 0xe8, 0xca, 0x84, 0xe7, 0xbe, 0xd2, 0x24, 0x24, 0x3a, 0x80,
	0x95, 0x5a, 0xff, 0x85, 0x49, 0xef, 0x28, 0xfc, 0xd5, 0xf2, 0xea, 0xe2, 0xda, 0xb0, 0xe1, 0x8b,
	0x1b, 0xdb, 0x19, 0x5e, 0x5d, 0xe8, 0x53, 0xb8, 0x56, 0xc3, 0x1a, 0x5b, 0xd2, 0xde, 0xf6, 0xc0,
	0x76, 0x0b, 0xba, 0x2a, 0x5f, 0x59, 0x74, 0xf9, 0x3f, 0xd2, 0xb0, 0x16, 0xfb, 0xee, 0x87, 0x5e,
	0x40, 0x51, 0x32, 0x3b, 0x16, 0x0e, 0xb4, 0x4f, 0xf8, 0xb8, 0x7b, 0xd1, 0xa7, 0xe2, 0xe4, 0x17,
	0xcc, 0x68, 0x39, 0x3b, 0xf1, 0xa1, 0x91, 0x28, 0xae, 0xe1, 0x5f, 0x85, 0xe2, 0xcf, 0x61, 0x35,
	0xee, 0x11, 0x32, 0x5a, 0x47, 0x4f, 0x78, 0x07, 0x8d, 0xd6, 0xd1, 0x93, 0xde, 0x35, 0xd1, 0x09,
	0xac, 0x44, 0x9e, 0x24, 0xd1, 0xdd, 0x71, 0x11, 0x49, 0x4f, 0x9f, 0xa5, 0x77, 0x67, 0xa0, 0x64,
	0x39, 0xc6, 0x5f, 0xa6, 0x60, 0x3d, 0x74, 0x71, 0xd2, 0xc6, 0xbd, 0x6e, 0x1b, 0x5b, 0xcf, 0x69,
	0x8e, 0x1a, 0xff, 0x10, 0x19, 0xcd, 0x51, 0x27, 0xbe, 0x84, 0x46, 0x73, 0xd4, 0xc9, 0xef, 0x9b,
	0xf4, 0xea, 0x66, 0xd2, 0xd3, 0x24, 0xda, 0x49, 0x2e, 0x35, 0x12, 0x9f, 0x43, 0xa3, 0x57, 0x37,
	0xb3, 0xbc, 0x7e, 0xee, 0xde, 0xfd, 0xde, 0xed, 0xd9, 0xfe, 0xe6, 0xc2, 0xd1, 0x3c, 0xed, 0x81,
	0xd9, 0xf9, 0xbf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x65, 0xb8, 0x4b, 0xaa, 0xa4, 0x41, 0x00, 0x00,
}
