// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchYodaTwirp/twirp.proto

/*
Package TwitchYodaTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchYodaTwirp/twirp.proto
*/
package TwitchYodaTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ====================
// TwitchYoda Interface
// ====================

type TwitchYoda interface {
	BatchGetContext(context.Context, *BatchGetContextRequest) (*BatchGetContextResponse, error)

	GetContext(context.Context, *GetContextRequest) (*GetContextResponse, error)

	GetChannelContext(context.Context, *GetChannelContextRequest) (*GetChannelContextResponse, error)
}

// ==========================
// TwitchYoda Protobuf Client
// ==========================

type twitchYodaProtobufClient struct {
	client HTTPClient
	urls   [3]string
	opts   twirp.ClientOptions
}

// NewTwitchYodaProtobufClient creates a Protobuf client that implements the TwitchYoda interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchYodaProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchYoda {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchYodaPathPrefix
	urls := [3]string{
		prefix + "BatchGetContext",
		prefix + "GetContext",
		prefix + "GetChannelContext",
	}

	return &twitchYodaProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchYodaProtobufClient) BatchGetContext(ctx context.Context, in *BatchGetContextRequest) (*BatchGetContextResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchyoda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchYoda")
	ctx = ctxsetters.WithMethodName(ctx, "BatchGetContext")
	out := new(BatchGetContextResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchYodaProtobufClient) GetContext(ctx context.Context, in *GetContextRequest) (*GetContextResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchyoda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchYoda")
	ctx = ctxsetters.WithMethodName(ctx, "GetContext")
	out := new(GetContextResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchYodaProtobufClient) GetChannelContext(ctx context.Context, in *GetChannelContextRequest) (*GetChannelContextResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchyoda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchYoda")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelContext")
	out := new(GetChannelContextResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ======================
// TwitchYoda JSON Client
// ======================

type twitchYodaJSONClient struct {
	client HTTPClient
	urls   [3]string
	opts   twirp.ClientOptions
}

// NewTwitchYodaJSONClient creates a JSON client that implements the TwitchYoda interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchYodaJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchYoda {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchYodaPathPrefix
	urls := [3]string{
		prefix + "BatchGetContext",
		prefix + "GetContext",
		prefix + "GetChannelContext",
	}

	return &twitchYodaJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchYodaJSONClient) BatchGetContext(ctx context.Context, in *BatchGetContextRequest) (*BatchGetContextResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchyoda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchYoda")
	ctx = ctxsetters.WithMethodName(ctx, "BatchGetContext")
	out := new(BatchGetContextResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchYodaJSONClient) GetContext(ctx context.Context, in *GetContextRequest) (*GetContextResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchyoda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchYoda")
	ctx = ctxsetters.WithMethodName(ctx, "GetContext")
	out := new(GetContextResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchYodaJSONClient) GetChannelContext(ctx context.Context, in *GetChannelContextRequest) (*GetChannelContextResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchyoda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchYoda")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelContext")
	out := new(GetChannelContextResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =========================
// TwitchYoda Server Handler
// =========================

type twitchYodaServer struct {
	TwitchYoda
	hooks *twirp.ServerHooks
}

func NewTwitchYodaServer(svc TwitchYoda, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchYodaServer{
		TwitchYoda: svc,
		hooks:      hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchYodaServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchYodaPathPrefix is used for all URL paths on a twirp TwitchYoda server.
// Requests are always: POST TwitchYodaPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchYodaPathPrefix = "/twirp/twitch.fulton.example.twitchyoda.TwitchYoda/"

func (s *twitchYodaServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchyoda")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchYoda")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.example.twitchyoda.TwitchYoda/BatchGetContext":
		s.serveBatchGetContext(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchyoda.TwitchYoda/GetContext":
		s.serveGetContext(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchyoda.TwitchYoda/GetChannelContext":
		s.serveGetChannelContext(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchYodaServer) serveBatchGetContext(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBatchGetContextJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBatchGetContextProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchYodaServer) serveBatchGetContextJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BatchGetContext")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BatchGetContextRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BatchGetContextResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchYoda.BatchGetContext(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BatchGetContextResponse and nil error while calling BatchGetContext. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchYodaServer) serveBatchGetContextProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BatchGetContext")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(BatchGetContextRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BatchGetContextResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchYoda.BatchGetContext(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BatchGetContextResponse and nil error while calling BatchGetContext. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchYodaServer) serveGetContext(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetContextJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetContextProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchYodaServer) serveGetContextJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetContext")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetContextRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetContextResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchYoda.GetContext(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetContextResponse and nil error while calling GetContext. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchYodaServer) serveGetContextProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetContext")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetContextRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetContextResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchYoda.GetContext(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetContextResponse and nil error while calling GetContext. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchYodaServer) serveGetChannelContext(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelContextJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelContextProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchYodaServer) serveGetChannelContextJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelContext")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetChannelContextRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetChannelContextResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchYoda.GetChannelContext(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelContextResponse and nil error while calling GetChannelContext. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchYodaServer) serveGetChannelContextProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelContext")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetChannelContextRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetChannelContextResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchYoda.GetChannelContext(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelContextResponse and nil error while calling GetChannelContext. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchYodaServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchYodaServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchYodaServer) PathPrefix() string {
	return TwitchYodaPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 2528 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x19, 0xcd, 0x73, 0x1b, 0x57,
	0xbd, 0x2b, 0xd9, 0x96, 0xf4, 0xd3, 0x87, 0xa5, 0x67, 0x27, 0x96, 0x9d, 0xa4, 0x75, 0x94, 0x86,
	0xba, 0x99, 0xd6, 0x69, 0xdc, 0x94, 0x86, 0xb4, 0x43, 0x91, 0xec, 0x75, 0x22, 0x90, 0x65, 0xcf,
	0x6a, 0x9d, 0xd4, 0x61, 0x98, 0x9d, 0xd5, 0xee, 0xb3, 0xb3, 0xad, 0xb4, 0x2b, 0xf6, 0xbd, 0xb5,
	0x6b, 0x86, 0x01, 0x86, 0x43, 0x2f, 0x70, 0xe6, 0xc6, 0x19, 0x66, 0x38, 0xc0, 0x91, 0x03, 0x57,
	0x2e, 0x9c, 0x19, 0xfe, 0x08, 0xfe, 0x04, 0x4e, 0xcc, 0xfb, 0xd8, 0xd5, 0xae, 0xb4, 0x8e, 0x65,
	0x0f, 0x5c, 0x3c, 0xda, 0xdf, 0xf7, 0xfb, 0x7d, 0xbf, 0x67, 0x78, 0x68, 0x79, 0x36, 0xde, 0xfc,
	0x2a, 0x20, 0xd4, 0x71, 0x37, 0xe9, 0xe9, 0x43, 0x73, 0xf8, 0x33, 0xf7, 0xa1, 0x7e, 0xe6, 0x50,
	0xeb, 0xf5, 0x91, 0x67, 0x9b, 0xfa, 0x99, 0xe3, 0x8f, 0x1e, 0x52, 0xf6, 0x77, 0x73, 0xe4, 0x7b,
	0xd4, 0x43, 0xeb, 0x94, 0x23, 0x37, 0x8f, 0x83, 0x01, 0xf5, 0xdc, 0x4d, 0xfc, 0x8d, 0x39, 0x1c,
	0x0d, 0xf0, 0xa6, 0x80, 0x9e, 0x7b, 0xb6, 0xd9, 0xf8, 0x56, 0x81, 0xe2, 0x21, 0xc1, 0xfe, 0xb6,
	0xe7, 0x52, 0xfc, 0x0d, 0x45, 0xb7, 0xa0, 0x60, 0xe3, 0x53, 0xc7, 0xc2, 0x86, 0x63, 0xd7, 0x95,
	0x75, 0x65, 0xa3, 0xa0, 0xe5, 0x05, 0xa0, 0x6d, 0xa3, 0x57, 0x50, 0x19, 0x3a, 0x6e, 0x40, 0x31,
	0x31, 0x06, 0xde, 0xc9, 0x09, 0xb6, 0xeb, 0x99, 0x75, 0x65, 0xa3, 0xb8, 0xf5, 0xf1, 0xe6, 0x65,
	0x7a, 0x36, 0x99, 0x8e, 0x3d, 0xc1, 0xdb, 0xe1, 0xac, 0x5a, 0x79, 0x18, 0xff, 0x6c, 0x9c, 0x41,
	0x6d, 0x8a, 0x06, 0xdd, 0x9f, 0x52, 0xc8, 0x4c, 0x9a, 0x9f, 0xe0, 0x45, 0x9f, 0xc1, 0xda, 0xc0,
	0x24, 0xd4, 0x08, 0x46, 0xb6, 0x49, 0xb1, 0x6d, 0x04, 0xd4, 0x32, 0xa8, 0x33, 0xc4, 0x84, 0x9a,
	0xc3, 0x11, 0xb7, 0x31, 0xab, 0xad, 0x30, 0x8a, 0x43, 0x41, 0x70, 0x48, 0x2d, 0x3d, 0x44, 0x37,
	0xfe, 0x56, 0x80, 0xca, 0xf6, 0x6b, 0xd3, 0x75, 0xf1, 0x20, 0x74, 0xc2, 0x1d, 0x00, 0x4b, 0x40,
	0xc6, 0x5e, 0x28, 0x48, 0x48, 0xdb, 0x46, 0x2f, 0xa1, 0x44, 0xa8, 0x8f, 0x4f, 0x7d, 0x83, 0x50,
	0x93, 0x62, 0xe9, 0x84, 0xc7, 0x97, 0x3b, 0x41, 0xaa, 0xe9, 0x71, 0xe6, 0x1e, 0xe3, 0xd5, 0x8a,
	0x64, 0xfc, 0x81, 0x5e, 0x41, 0xb9, 0xef, 0x05, 0x2e, 0x3d, 0xe7, 0x82, 0x03, 0x52, 0xcf, 0x72,
	0xc9, 0x9f, 0xcc, 0x2c, 0xb9, 0xc5, 0xb9, 0x7b, 0x9c, 0x59, 0x2b, 0xf5, 0x63, 0x5f, 0xe8, 0x03,
	0x40, 0x71, 0xa3, 0x0d, 0xec, 0xfb, 0x9e, 0x5f, 0x9f, 0xe3, 0x67, 0xab, 0xc6, 0x8c, 0x50, 0x19,
	0x1c, 0x6d, 0xc2, 0x52, 0xc2, 0x12, 0x49, 0x3e, 0xcf, 0xc9, 0x6b, 0x71, 0xc1, 0x82, 0xfe, 0x77,
	0x0a, 0xdc, 0x23, 0x41, 0x9f, 0x58, 0xbe, 0x33, 0xa2, 0x8e, 0xe7, 0x1a, 0xa6, 0x6d, 0x1c, 0xfb,
	0x18, 0x1b, 0x7d, 0xec, 0xe2, 0x63, 0x87, 0x86, 0x07, 0x5a, 0xe0, 0x07, 0x7a, 0x3e, 0xbb, 0xab,
	0x62, 0x32, 0x9b, 0xf6, 0xae, 0x8f, 0x71, 0x4b, 0x08, 0x94, 0x67, 0x7c, 0x87, 0xbc, 0x99, 0x00,
	0xbd, 0x84, 0xf7, 0x67, 0xb0, 0x4b, 0x1e, 0x2f, 0xc7, 0x8f, 0xf7, 0xee, 0x25, 0x32, 0xc5, 0x89,
	0xbf, 0x80, 0xdb, 0x3c, 0xe7, 0x06, 0xce, 0x29, 0x1e, 0x38, 0x2e, 0x36, 0x5e, 0x63, 0xd3, 0xa7,
	0x7d, 0x6c, 0x52, 0x9e, 0x7a, 0xf5, 0x3c, 0xcf, 0xba, 0x55, 0x46, 0xd3, 0x91, 0x24, 0xcf, 0x43,
	0x0a, 0x96, 0x7c, 0xc8, 0x86, 0x5a, 0xdf, 0x37, 0x5d, 0xdb, 0x20, 0xe6, 0x31, 0xa6, 0xe7, 0x86,
	0x6d, 0x52, 0xb3, 0x5e, 0xe0, 0xfe, 0x79, 0x32, 0x7b, 0xc0, 0x99, 0x84, 0x1e, 0x17, 0xb0, 0x63,
	0x52, 0x53, 0x5b, 0xec, 0x27, 0x01, 0xe8, 0x13, 0x58, 0x99, 0xd2, 0x22, 0x4f, 0x0b, 0xfc, 0xb4,
	0xcb, 0x13, 0x1c, 0xe2, 0x74, 0x0e, 0xdc, 0x08, 0x2b, 0x20, 0x3a, 0x20, 0x37, 0xb0, 0x78, 0xc5,
	0x8c, 0x0c, 0xcf, 0xce, 0xad, 0x5b, 0xb2, 0xa6, 0x81, 0x2c, 0xd5, 0x12, 0x2a, 0xa4, 0x75, 0x25,
	0x91, 0x6a, 0x83, 0x18, 0xa9, 0x30, 0xed, 0xbb, 0x63, 0xd3, 0x2c, 0x93, 0xe2, 0x13, 0xcf, 0x3f,
	0x37, 0xa8, 0x79, 0x42, 0xea, 0x65, 0xc6, 0xd1, 0xca, 0xd4, 0x95, 0x48, 0xcf, 0xb6, 0xc4, 0xeb,
	0xe6, 0x09, 0x41, 0x1d, 0xb8, 0x9b, 0xca, 0x67, 0xc4, 0x5a, 0x47, 0xbd, 0xc2, 0xa2, 0xc6, 0x65,
	0xdc, 0x49, 0x91, 0xd1, 0x89, 0x5a, 0x08, 0xda, 0x80, 0xaa, 0x43, 0x8c, 0x63, 0xdf, 0x0c, 0x6c,
	0x43, 0x52, 0xd6, 0x17, 0xd7, 0x95, 0x8d, 0xbc, 0x56, 0x71, 0xc8, 0x2e, 0x03, 0x4b, 0x07, 0xa0,
	0x9f, 0x40, 0x2d, 0xd4, 0xcb, 0xd5, 0x71, 0x37, 0x56, 0xb9, 0x1b, 0x1f, 0xcd, 0xec, 0x46, 0xa6,
	0x5d, 0x04, 0xd8, 0x4a, 0x02, 0x1a, 0x7f, 0x50, 0xe0, 0x46, 0xb2, 0x7d, 0x69, 0xf8, 0xa7, 0x01,
	0x26, 0x97, 0x76, 0xb1, 0x17, 0x50, 0x24, 0x41, 0xdf, 0x12, 0x3c, 0xa4, 0x9e, 0x59, 0xcf, 0x6e,
	0x54, 0xae, 0xd0, 0xc4, 0xa4, 0x32, 0xd5, 0x0d, 0x86, 0x5a, 0x5c, 0x10, 0x5a, 0x81, 0x5c, 0x40,
	0xb0, 0xcf, 0x74, 0x66, 0xb9, 0xce, 0x05, 0xf6, 0xd9, 0xb6, 0x1b, 0x7b, 0x80, 0xa6, 0x1b, 0x20,
	0x5a, 0x86, 0x79, 0x62, 0x61, 0x17, 0x4b, 0x03, 0xc5, 0x07, 0xba, 0x0b, 0xa5, 0x78, 0x47, 0x97,
	0x3d, 0xbc, 0x18, 0xeb, 0xe1, 0x8d, 0x97, 0xb0, 0x94, 0xd2, 0xf5, 0xa6, 0x38, 0x95, 0x29, 0x4e,
	0xe6, 0x18, 0xfc, 0xcd, 0xc8, 0xf1, 0x31, 0x31, 0x4c, 0x2a, 0x45, 0x17, 0x24, 0xa4, 0x49, 0x1b,
	0xcf, 0xe0, 0x3b, 0xb3, 0x75, 0x1f, 0x26, 0xc8, 0x21, 0x06, 0x76, 0xcd, 0xfe, 0x40, 0x6a, 0xca,
	0x6b, 0x05, 0x87, 0xa8, 0x02, 0xd0, 0xf8, 0x77, 0x0e, 0x6e, 0xa6, 0xd7, 0x29, 0xeb, 0xc6, 0x89,
	0xb2, 0x24, 0x96, 0xe7, 0x63, 0x39, 0xdc, 0xaa, 0xb1, 0x8a, 0xec, 0x31, 0x38, 0x1b, 0x83, 0xdc,
	0xbd, 0x2e, 0x35, 0x7c, 0x93, 0x3a, 0xee, 0x09, 0x37, 0xba, 0xa0, 0x95, 0x25, 0x54, 0xe3, 0x40,
	0xf4, 0x1e, 0x2c, 0x46, 0x99, 0x2d, 0xe9, 0x44, 0x04, 0x2a, 0x21, 0x58, 0x12, 0xfe, 0x00, 0x6e,
	0x47, 0x84, 0xa1, 0x60, 0x1b, 0x47, 0x47, 0x95, 0x53, 0x61, 0x2d, 0xa4, 0xd9, 0x16, 0x24, 0x3b,
	0x63, 0x0a, 0xf4, 0x18, 0x6e, 0xb2, 0x99, 0x61, 0x0e, 0xb1, 0x6f, 0x0c, 0x4d, 0x37, 0x30, 0x07,
	0xa1, 0x46, 0x31, 0x22, 0x96, 0x43, 0xec, 0x1e, 0x47, 0x4a, 0xbd, 0xdf, 0x87, 0x5b, 0x93, 0x5c,
	0x71, 0xb5, 0x0b, 0x9c, 0x75, 0x35, 0xc9, 0x7a, 0x91, 0xd6, 0x13, 0xcf, 0xb3, 0x59, 0xf7, 0x76,
	0x6d, 0xa6, 0x35, 0x97, 0xd4, 0xfa, 0xcc, 0xf3, 0xec, 0x9e, 0xc4, 0xa1, 0xcf, 0x61, 0x2d, 0xe2,
	0x22, 0x01, 0x19, 0x61, 0x97, 0xb0, 0x49, 0xe0, 0x63, 0x93, 0x78, 0x2e, 0xef, 0xd3, 0x05, 0xad,
	0x1e, 0x52, 0xf4, 0x22, 0x02, 0x8d, 0xe3, 0x59, 0x7b, 0x8a, 0xb8, 0x1d, 0x62, 0x8c, 0x4c, 0x9f,
	0xba, 0xd8, 0xe7, 0x8d, 0x3a, 0xaf, 0xd5, 0x42, 0x54, 0x9b, 0x1c, 0x08, 0x04, 0x7a, 0x17, 0x2a,
	0x71, 0xfa, 0x47, 0x4f, 0x78, 0x9f, 0xcd, 0x6b, 0xa5, 0x31, 0xe9, 0xa3, 0x27, 0x93, 0x54, 0x5b,
	0x8f, 0x78, 0x63, 0x4d, 0x50, 0x6d, 0x3d, 0x42, 0x4f, 0x20, 0xb2, 0xcb, 0x30, 0x03, 0xea, 0x0d,
	0x3d, 0x3b, 0xca, 0xb6, 0x12, 0xa7, 0x8f, 0xfc, 0xd1, 0x14, 0x68, 0x99, 0x7a, 0x09, 0x4f, 0x85,
	0x9c, 0x03, 0x7c, 0x8a, 0x07, 0xa2, 0x4b, 0x8e, 0x3d, 0x25, 0xf9, 0x3a, 0x0c, 0xc7, 0x12, 0x28,
	0x16, 0x1f, 0x1a, 0xf8, 0xa2, 0x21, 0xe6, 0xb5, 0xca, 0x38, 0x26, 0x0c, 0xca, 0xc4, 0x5b, 0xaf,
	0x4d, 0x6a, 0x10, 0xe6, 0x2a, 0xea, 0x9c, 0xe2, 0x30, 0x8d, 0x78, 0x0f, 0x2c, 0x68, 0xcb, 0x0c,
	0xdb, 0x0b, 0x91, 0x32, 0x7f, 0x90, 0x07, 0x65, 0x2b, 0x20, 0xd4, 0x1b, 0x32, 0x2f, 0x9a, 0x43,
	0x52, 0xaf, 0xae, 0x67, 0x37, 0x8a, 0x5b, 0x3f, 0xbc, 0xee, 0xb4, 0xdb, 0xdc, 0xe6, 0xd2, 0x0e,
	0xb8, 0x30, 0xd5, 0xa5, 0xfe, 0xb9, 0x56, 0xb2, 0x62, 0x20, 0xf4, 0x3e, 0x54, 0x87, 0x26, 0xb5,
	0x5e, 0x63, 0xdb, 0x18, 0x99, 0xd6, 0xd7, 0xe6, 0x09, 0x26, 0xf5, 0x1a, 0x37, 0x70, 0x51, 0xc2,
	0x0f, 0x24, 0x78, 0xed, 0x0b, 0xa8, 0x4d, 0x49, 0x43, 0x55, 0xc8, 0x7e, 0x8d, 0xcf, 0x65, 0x67,
	0x62, 0x3f, 0x59, 0xb7, 0x3a, 0x35, 0x07, 0x01, 0x96, 0x05, 0x28, 0x3e, 0x9e, 0x66, 0x9e, 0x28,
	0x8d, 0x7f, 0x65, 0xa2, 0x7e, 0x94, 0x18, 0x6f, 0x08, 0xe6, 0x4e, 0xcc, 0x61, 0xd8, 0xde, 0xf8,
	0x6f, 0x74, 0x0f, 0xca, 0xd1, 0x74, 0xf5, 0x4e, 0x1c, 0x57, 0x4a, 0x2b, 0x85, 0xe3, 0x91, 0xc1,
	0xd0, 0x01, 0x94, 0xa2, 0xb9, 0x71, 0x3e, 0xc2, 0xbc, 0x94, 0x2b, 0x5b, 0x1f, 0xce, 0x3e, 0x32,
	0xce, 0x47, 0x58, 0x2b, 0x5a, 0xe3, 0x0f, 0xf4, 0x0e, 0x14, 0x45, 0x1c, 0xc5, 0xbc, 0x14, 0x55,
	0x0e, 0x02, 0xc4, 0x47, 0xe4, 0x2d, 0xc8, 0x31, 0xfb, 0x58, 0xeb, 0x9e, 0x8f, 0x86, 0xe9, 0x02,
	0x03, 0xb5, 0x6d, 0x56, 0x08, 0x53, 0xf3, 0xd3, 0xb1, 0x79, 0xd1, 0x66, 0xb5, 0xda, 0xc4, 0xb4,
	0x6c, 0xdb, 0x53, 0x8d, 0x38, 0x37, 0xdd, 0x88, 0x99, 0x1f, 0x12, 0x23, 0x3c, 0x2f, 0xfd, 0x10,
	0x9b, 0xb9, 0x8d, 0x23, 0x58, 0x9c, 0x18, 0x82, 0xb3, 0xf4, 0xf8, 0x29, 0xd1, 0x99, 0x14, 0xd1,
	0xff, 0x51, 0x00, 0xf1, 0xcb, 0x4f, 0x72, 0xfd, 0x8f, 0x4d, 0x30, 0x25, 0x3e, 0xc1, 0x26, 0x26,
	0x6a, 0x66, 0x72, 0xa2, 0x8e, 0x60, 0x29, 0xb1, 0x6b, 0x26, 0x96, 0xf8, 0x2f, 0x66, 0xbb, 0x23,
	0xa5, 0x4c, 0x1e, 0xb9, 0xea, 0x22, 0x32, 0x05, 0x43, 0x4f, 0x61, 0x35, 0x45, 0x63, 0x62, 0xb7,
	0x5f, 0x99, 0x66, 0xe3, 0x7b, 0x54, 0xe3, 0xcf, 0x0a, 0xac, 0x4e, 0x1f, 0x3e, 0x5c, 0x1e, 0xae,
	0xeb, 0x83, 0x57, 0xc9, 0xad, 0x22, 0xcb, 0xb7, 0x8a, 0x27, 0x57, 0x3a, 0xfb, 0x45, 0x9b, 0x45,
	0xe3, 0x17, 0x70, 0xe7, 0x8d, 0x2e, 0x62, 0x41, 0x77, 0x88, 0x21, 0x0f, 0xdc, 0x8f, 0x46, 0x72,
	0xc9, 0x21, 0xbd, 0x08, 0xc6, 0x0e, 0x40, 0xa8, 0xe9, 0xcb, 0x35, 0x5d, 0x4e, 0x7f, 0x0e, 0xe1,
	0x6b, 0xf9, 0x2a, 0xe4, 0xb1, 0x6b, 0x0b, 0x64, 0x96, 0x23, 0x73, 0xd8, 0xb5, 0x19, 0xaa, 0xf1,
	0xf7, 0x8c, 0xb8, 0xa3, 0xee, 0xf0, 0xfb, 0xf0, 0xa5, 0xd9, 0x92, 0xb8, 0x4a, 0x67, 0x26, 0xae,
	0xd2, 0x2f, 0xf8, 0x48, 0x27, 0x6c, 0xf2, 0x26, 0xd2, 0xe4, 0xe1, 0x0c, 0xf5, 0x2d, 0xf8, 0x64,
	0x5a, 0x94, 0xad, 0xf8, 0x27, 0xfa, 0x08, 0x96, 0x93, 0x72, 0x13, 0xc9, 0x80, 0x12, 0xc4, 0x62,
	0x9f, 0x7e, 0x06, 0x39, 0xd7, 0xc1, 0x03, 0x82, 0x5d, 0x5e, 0xf4, 0xc5, 0xad, 0xf7, 0x2f, 0x37,
	0xa1, 0x2b, 0x18, 0x78, 0x7f, 0x08, 0xb9, 0xd1, 0x7b, 0x50, 0x96, 0x3f, 0xa5, 0xce, 0x85, 0xa8,
	0x87, 0x94, 0x24, 0x42, 0x64, 0xde, 0x9f, 0x14, 0xa8, 0x4f, 0xf9, 0xf1, 0xd2, 0xc4, 0x7b, 0xa3,
	0x3b, 0x8f, 0xd2, 0xd2, 0xee, 0xd3, 0xd9, 0xd2, 0x2e, 0x61, 0xc6, 0x74, 0xd6, 0x05, 0x50, 0x4e,
	0x78, 0x9c, 0xad, 0xfe, 0x23, 0xdf, 0x39, 0x35, 0xad, 0x73, 0x63, 0x60, 0x9e, 0x19, 0xee, 0xb8,
	0xbb, 0x57, 0x24, 0xbc, 0x63, 0x9e, 0x75, 0x59, 0x9f, 0xbf, 0x05, 0x05, 0x6a, 0x19, 0x84, 0xfa,
	0xe3, 0x95, 0x2d, 0x4f, 0xad, 0x1e, 0xff, 0xe6, 0x85, 0xe4, 0x63, 0xfe, 0x5e, 0x61, 0x52, 0xb9,
	0xa8, 0x15, 0x24, 0xa4, 0x49, 0x1b, 0xff, 0xcc, 0xc2, 0x92, 0x78, 0xde, 0x68, 0xbb, 0xf1, 0x07,
	0x9a, 0x0b, 0xfd, 0xb3, 0x07, 0xc5, 0x91, 0x79, 0xee, 0x05, 0x54, 0x8c, 0x0b, 0xf1, 0x28, 0xf1,
	0xc1, 0xe5, 0x2e, 0x38, 0xe0, 0x4c, 0x7c, 0x5a, 0xc0, 0x28, 0xfa, 0x8d, 0x1e, 0x40, 0x2d, 0x26,
	0x4e, 0x46, 0x54, 0x58, 0xb9, 0x38, 0x26, 0x9b, 0xed, 0x2e, 0x3c, 0x77, 0xd9, 0x5d, 0xf8, 0x00,
	0x4a, 0x34, 0xf0, 0xfb, 0x5e, 0x58, 0x0b, 0x22, 0x11, 0x67, 0x98, 0x75, 0x3a, 0xe3, 0x92, 0x95,
	0x50, 0xa4, 0xe3, 0x0f, 0xb6, 0x60, 0xc7, 0x25, 0xc6, 0x33, 0x52, 0xab, 0xc6, 0x08, 0xc5, 0x01,
	0xb6, 0xc7, 0x35, 0x90, 0xbb, 0x62, 0x0d, 0x8c, 0xf3, 0xff, 0xde, 0x64, 0xfe, 0xcb, 0x69, 0x96,
	0xc8, 0xfd, 0xdf, 0x28, 0xb0, 0x96, 0x12, 0xd6, 0x4b, 0xb3, 0x5f, 0x4f, 0xbb, 0xad, 0x6d, 0x5d,
	0x6e, 0x65, 0x5c, 0xd7, 0x74, 0x6e, 0x77, 0x01, 0xc6, 0xe1, 0x97, 0xd7, 0x99, 0x70, 0xc3, 0x8d,
	0xae, 0x33, 0xe1, 0x66, 0x7b, 0x17, 0x4a, 0x0e, 0x31, 0xcc, 0xe3, 0x63, 0x67, 0xe0, 0x84, 0xcf,
	0x5e, 0x79, 0xad, 0xe8, 0x90, 0x66, 0x08, 0x6a, 0xec, 0x41, 0x31, 0x16, 0x91, 0xd9, 0xfa, 0x71,
	0xbc, 0xe1, 0x66, 0x92, 0x0d, 0xf7, 0x2f, 0x0a, 0xe4, 0xa4, 0x9b, 0xd9, 0x1e, 0xe5, 0xd8, 0xc7,
	0x66, 0xb8, 0x47, 0xb1, 0xdf, 0x62, 0xb7, 0x8a, 0xba, 0x01, 0xff, 0x8d, 0xee, 0x4f, 0xec, 0x06,
	0xd9, 0xe8, 0x46, 0x9f, 0xd8, 0x0f, 0x1e, 0x40, 0x8d, 0x89, 0x30, 0x12, 0xb4, 0x22, 0x4f, 0x17,
	0x19, 0xa2, 0x93, 0xa4, 0x65, 0xa2, 0x93, 0xb4, 0xf3, 0x82, 0x96, 0x21, 0x62, 0xb4, 0x8d, 0x2f,
	0xe1, 0x66, 0x8b, 0xad, 0x96, 0xcf, 0x30, 0x9d, 0x08, 0xed, 0x3b, 0x50, 0x1c, 0x0f, 0x4e, 0x52,
	0x57, 0xd6, 0xb3, 0x6c, 0xfb, 0x8a, 0x26, 0x27, 0xbf, 0x4d, 0x46, 0x0d, 0x4e, 0x44, 0xb8, 0xa0,
	0x15, 0xc2, 0x0e, 0x47, 0x1a, 0xff, 0x50, 0x60, 0x65, 0x4a, 0x34, 0x19, 0xb1, 0xd6, 0x84, 0x34,
	0x28, 0xf3, 0xb4, 0x89, 0xf2, 0x43, 0xe1, 0x9b, 0xf5, 0x87, 0x33, 0xce, 0x5d, 0x29, 0xad, 0x14,
	0x8c, 0x3f, 0x08, 0xfa, 0x31, 0x54, 0xa3, 0x7d, 0x2f, 0x9e, 0x76, 0xc5, 0xad, 0x8f, 0xae, 0xfa,
	0x48, 0x10, 0xbd, 0x5a, 0x84, 0xc2, 0x1b, 0x7f, 0x9d, 0x83, 0xda, 0xb4, 0x8b, 0xae, 0xbb, 0x74,
	0xfc, 0x4a, 0x81, 0xb7, 0xc5, 0xfb, 0xb0, 0xe1, 0xb8, 0x46, 0xdc, 0x13, 0x86, 0x2f, 0x44, 0xcb,
	0xe9, 0xfa, 0xf9, 0xd5, 0x0a, 0x26, 0x69, 0x9e, 0xb6, 0x36, 0xb8, 0xb8, 0x70, 0x3d, 0x58, 0x99,
	0xf0, 0x56, 0xa4, 0x7a, 0x8e, 0xab, 0xfe, 0xf4, 0xca, 0x4e, 0x93, 0x5a, 0x6f, 0x58, 0xa9, 0x0b,
	0xda, 0xcf, 0xe1, 0xb6, 0x38, 0xe8, 0x05, 0x5a, 0x45, 0x0b, 0xfd, 0xec, 0x3a, 0x9b, 0x57, 0xa8,
	0x79, 0x35, 0xb8, 0x70, 0x3d, 0x3c, 0x87, 0x5b, 0x5c, 0xbb, 0x4c, 0xd8, 0x49, 0xe5, 0xe2, 0x99,
	0xf7, 0xe9, 0x35, 0xe6, 0x6f, 0xa8, 0xbb, 0x1e, 0x5c, 0x80, 0x69, 0xfc, 0x31, 0x0b, 0x28, 0xa5,
	0x04, 0xbe, 0x82, 0x9b, 0xe9, 0x29, 0xc0, 0x53, 0x69, 0xa6, 0x27, 0xcb, 0xb4, 0xd0, 0x2f, 0xa5,
	0xc4, 0x1c, 0x1d, 0xc1, 0xe2, 0x84, 0xdb, 0xe5, 0xb8, 0xbd, 0x7a, 0x65, 0x54, 0x92, 0xd1, 0x45,
	0xc7, 0xb0, 0x9c, 0x16, 0x56, 0x99, 0xbf, 0x8f, 0xaf, 0x15, 0x4e, 0x34, 0x1d, 0x47, 0x64, 0xc1,
	0x52, 0x4a, 0x00, 0x65, 0xae, 0x7e, 0x7c, 0x9d, 0xc0, 0xd5, 0xa6, 0x22, 0xc6, 0x86, 0x5d, 0x9d,
	0x85, 0x2a, 0x35, 0x85, 0xde, 0x50, 0x31, 0xca, 0xff, 0xa3, 0x62, 0x1a, 0xa7, 0xb0, 0x9a, 0x62,
	0x8c, 0x4c, 0x9f, 0x94, 0x90, 0x2a, 0xff, 0x9b, 0x90, 0x3e, 0xf8, 0x75, 0x26, 0x7a, 0xf8, 0x8c,
	0x2d, 0x99, 0x68, 0x05, 0x96, 0x9a, 0x9d, 0x8e, 0xb1, 0xfd, 0xbc, 0xd9, 0xed, 0xaa, 0x1d, 0x63,
	0x7b, 0xbf, 0xab, 0xab, 0x5f, 0xea, 0xd5, 0xb7, 0x50, 0x15, 0x4a, 0x3d, 0x5d, 0x53, 0x5f, 0x68,
	0x46, 0x4f, 0x6f, 0xea, 0x6a, 0x55, 0x41, 0x35, 0x28, 0xb7, 0xf6, 0x0f, 0xbb, 0xfa, 0x11, 0x87,
	0x1c, 0xf6, 0xaa, 0x19, 0xf4, 0x36, 0xac, 0xf5, 0x0e, 0x5b, 0x46, 0x73, 0xc7, 0xd8, 0xd5, 0x54,
	0xd5, 0x68, 0xa9, 0x5d, 0x75, 0xb7, 0xad, 0x87, 0xf8, 0x2c, 0xda, 0x80, 0x77, 0x43, 0xc9, 0x9d,
	0x66, 0x4f, 0x37, 0x3a, 0xed, 0x17, 0x6a, 0xa7, 0xdd, 0x55, 0x8d, 0xe7, 0x6a, 0x53, 0xd3, 0x5b,
	0x6a, 0x53, 0x37, 0xf4, 0xf6, 0x9e, 0x5a, 0x9d, 0x43, 0x77, 0x60, 0x35, 0xa4, 0x6c, 0x69, 0xcd,
	0xee, 0x8e, 0xd1, 0x6b, 0xee, 0xaa, 0xfa, 0x91, 0xb1, 0xd3, 0xd4, 0x9b, 0xd5, 0x79, 0xb4, 0x0a,
	0x37, 0x22, 0x41, 0xa1, 0x0c, 0x8e, 0x5a, 0x60, 0x86, 0x86, 0x28, 0xbd, 0xf9, 0xac, 0x57, 0xcd,
	0xa1, 0x3a, 0x2c, 0x87, 0x90, 0x5d, 0xad, 0x79, 0xb8, 0x13, 0xda, 0x93, 0x7f, 0xd0, 0x84, 0x62,
	0xec, 0x5d, 0x02, 0x15, 0x21, 0x77, 0xd8, 0xfd, 0x51, 0x77, 0xff, 0x65, 0xb7, 0xfa, 0x16, 0x2a,
	0xc0, 0x7c, 0xab, 0xd9, 0x6b, 0x6f, 0x57, 0x15, 0x54, 0x86, 0x42, 0x73, 0x77, 0xb7, 0xdd, 0x69,
	0xb3, 0x83, 0x67, 0x18, 0xd9, 0x41, 0x53, 0xd3, 0xbb, 0xaa, 0x56, 0xcd, 0x3e, 0xd8, 0x85, 0x9b,
	0xe9, 0xb7, 0x44, 0x74, 0x1b, 0xea, 0xcc, 0x95, 0x87, 0x3d, 0x55, 0x4b, 0xf1, 0x67, 0x05, 0x80,
	0xb9, 0x4a, 0x9a, 0xa2, 0x3c, 0x78, 0x0e, 0x37, 0x52, 0xd7, 0x7e, 0x74, 0x0b, 0x56, 0x22, 0x31,
	0x3b, 0xea, 0x8b, 0xf6, 0xb6, 0x1a, 0x93, 0x82, 0xa0, 0xb2, 0xbd, 0xdf, 0xed, 0xa9, 0x5d, 0x7d,
	0x2c, 0xe9, 0x97, 0x50, 0x9d, 0xdc, 0xaf, 0xd0, 0x32, 0x54, 0xc7, 0xb6, 0x44, 0xdc, 0x8b, 0x50,
	0x3c, 0x68, 0x1e, 0xed, 0x1f, 0xea, 0x86, 0x7e, 0x74, 0xc0, 0x42, 0x5a, 0x85, 0x92, 0x7e, 0xa8,
	0xb5, 0xf6, 0xc7, 0x11, 0xbd, 0x0f, 0x77, 0x39, 0xd3, 0x1b, 0xc3, 0x95, 0x65, 0x2e, 0xe9, 0xb6,
	0xd5, 0x4e, 0x4f, 0xed, 0x56, 0xe7, 0xb6, 0x7e, 0x9f, 0x05, 0x18, 0xff, 0xff, 0x17, 0x7d, 0xab,
	0xc0, 0xe2, 0xc4, 0x8a, 0x80, 0x66, 0xb8, 0x7b, 0xa7, 0x2f, 0x2c, 0x6b, 0xdf, 0xbb, 0x06, 0xa7,
	0xac, 0xa6, 0x33, 0x80, 0x98, 0x09, 0x33, 0xb4, 0x93, 0x69, 0xed, 0x8f, 0xaf, 0xc6, 0x24, 0x15,
	0xff, 0x56, 0x11, 0x7b, 0x45, 0xb2, 0xd9, 0x3d, 0x9d, 0x4d, 0x56, 0x5a, 0xd7, 0x58, 0xfb, 0xec,
	0x5a, 0xbc, 0xc2, 0x9c, 0xd6, 0xfd, 0x57, 0xf7, 0x66, 0xf8, 0x97, 0x7d, 0x7f, 0x81, 0xff, 0xb7,
	0xfe, 0xe3, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0x73, 0xbf, 0xb6, 0x34, 0xe0, 0x1f, 0x00, 0x00,
}
