# Streamlog Kinesis Client

## Assign Permissions

At the client account, the role assigned to the client should have a policy to assume roles:

```json
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": "sts:AssumeRole",
            "Resource": "*"
        }
    ]
}
```

The client role ARN is then added as a trust relationship to the streamlog-client-role in the streamlog account:
```json
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": {
        "AWS": "arn:aws:iam::<Account A>:root"
      },
      "Action": "sts:AssumeRole"
    }
  ]
}
```

## Configuring the Kinesis Writer

```go

	ctx := context.Background()
	sessionID := uuid.New()

	cfg := kswriter.Settings{
		Role:                 "arn:aws:iam::921790901904:role/streamlog-client-beta",
		Region:               "us-west-2",
		ServiceTag:           "mock-goingest",
		SessionID:            sessionID,
		KinesisStreamName:    "streamlog-beta-events",
		QueueSize:            2500,
		ErrorBufferSize:      1000,
		DrainEventQueueTimer: time.Second * 10,
		LogLevel:             "trace",   // the kwsriter package contains the log-level named constants
		Logger:               bs.Logger, // anything that implements the TwitchLogging Logger interface 
		// uses TwitchTelemetry SampleReporter or supply own Statter implementation
		Statter:              kswriter.NewCloudwatchStatter(&bs.SampleReporter),
	}

	sl, err := kswriter.New(ctx, cfg) // ctx is wrapped internally with a cancellable context
	
	sl.Close() // cancels the context and shuts down all goroutines, alternatively, cancel the parent context


```
