package kswriter

import (
	"context"
	"runtime"
	"testing"
	"time"

	v1 "code.justin.tv/amzn/streamlogclient/data/v1"
)

// TestCheckBillCount makes sure that the logic for chkBillCount is correct
func TestCheckBillCount(t *testing.T) {
	if chkBillCount(10) != false {
		t.Log("TestCheckBillCount: chkBillCount should return false with low int")
		t.Fail()
	}
	if chkBillCount(4900) != true {
		t.Log("TestCheckBillCount: chkBillCount should return true")
		t.Fail()
	}
	if chkBillCount(5100) != true {
		t.Log("TestCheckBillCount: chkBillCount should return true")
		t.Fail()
	}
}

// TestEventKinesisQErr shoves events into the eventKinesisQueue after creating
// it with a mockKinesis client that will always return an error and then checks
// to ensure that the error buffer is not empty
func TestEventKinesisQErr(t *testing.T) {
	runtime.GOMAXPROCS(2)
	testCt := 500
	cfg := Settings{
		ErrorBufferSize:      1000,
		DrainEventQueueTimer: 10 * time.Second,
		KinesisStreamName:    "KinesisStreamName",
	}
	ctx, stop := context.WithCancel(context.Background())
	defer stop()
	eh := newErrHandler(newMockKinesis(), cfg, &nopLogger{}, &NopStatter{})
	go eh.run(ctx)
	ekq := newEventKinesisQ(newMockKinesis(), cfg, eh, &nopLogger{}, &NopStatter{})
	go ekq.run(ctx)
	for i := 0; i < testCt; i++ {
		ekq.q <- &v1.Event{
			Channel:    "some_channel_name",
			SessionID:  "",
			ServiceTag: "ingest",
			Metric:     "bitrate",
			Records: []*v1.Event_Record{
				{
					Timestamp: time.Now().Unix(),
					F:         3485.2,
				},
			},
		}
	}
	// check to make sure that there are errors in the error buffer
	tick := time.NewTicker(2 * time.Second)
	defer tick.Stop()
	chk := true
	for chk == true {
		select {
		case <-eh.errBuff:
			chk = false
		case <-tick.C:
			chk = false
			t.Fail()
		}
	}
}
