package kswriter_test

import (
	"testing"

	"code.justin.tv/amzn/streamlogclient/kswriter"
)

// Streamlog is a websocket-based streamlog client.
type Streamlog interface {
	Log(channel, key string, value interface{}) error
	LogWithSessionId(sessionId, channel, key string, value interface{}) error
	SetSessionID(sessionID string)
	Close()
}

func TestStreamlogInterface(t *testing.T) {
	var _ Streamlog = &kswriter.KinesisStreamlogWriter{}
}
