package kswriter

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials/stscreds"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/kinesis"
)

// newKinesis function is a convenience function for getting a kinesis.Kinesis
func newKinesis(region, role string) (*kinesis.Kinesis, error) {
	sess, err := session.NewSession(&aws.Config{Region: aws.String(region)})
	if err != nil {
		return nil, fmt.Errorf("cannot create streamlog session: %w", err)
	}
	credentials := stscreds.NewCredentials(sess, role)
	return kinesis.New(sess, &aws.Config{Credentials: credentials}), nil
}

type minimalKinesis interface {
	PutRecordsWithContext(ctx aws.Context, input *kinesis.PutRecordsInput, opts ...request.Option) (*kinesis.PutRecordsOutput, error)
	DescribeStreamWithContext(ctx aws.Context, input *kinesis.DescribeStreamInput, opts ...request.Option) (*kinesis.DescribeStreamOutput, error)
}
