package kswriter

import (
	"time"

	telemetry "code.justin.tv/amzn/TwitchTelemetry"
)

// Statter is the interface for the  metrics implementation
type Statter interface {
	Count(s string, i int64)
	Timer(s string) func()
}

// NopStatter is the no-op statter, does nothing.
type NopStatter struct{}

func (z *NopStatter) Count(s string, i int64) {
}

func (z *NopStatter) Timer(s string) func() {
	return func() {}
}

// NewCloudwatchStatter returns a new CloudwatchStatter
func NewCloudwatchStatter(sr *telemetry.SampleReporter) *CloudwatchStatter {
	return &CloudwatchStatter{sr: sr}
}

// CloudwatchStatter is a Statter which sends metrics to cloudwatch
type CloudwatchStatter struct {
	sr *telemetry.SampleReporter
}

// Count reports cloudwatch stats
func (z *CloudwatchStatter) Count(name string, value int64) {
	z.sr.Report(name, float64(value), telemetry.UnitCount)
}

// Timer reports cloudwatch stats
// Usage: defer Timer("name")()
func (z *CloudwatchStatter) Timer(name string) func() {
	t0 := time.Now()
	return func() {
		z.sr.ReportDurationSample(name, time.Now().Sub(t0))
	}
}
