// +build integration
// Note run this test with go test --tags=integration

package kswriter_test

import (
	"context"
	"log"
	"testing"
	"time"

	"github.com/pborman/uuid"

	"code.justin.tv/amzn/streamlogclient/kswriter"
)

type stdLogLogger struct{}

func (z *stdLogLogger) Log(msg string, keyvals ...interface{}) {
	log.Printf(msg, keyvals...)
}

func TestWriter(t *testing.T) {

	ctx, cancel := context.WithCancel(context.Background())
	t.Cleanup(cancel)

	sessionID := uuid.New()

	cfg := kswriter.Settings{
		Region:               "us-west-2",
		ServiceTag:           "mock-goingest",
		SessionID:            sessionID,
		KinesisStreamName:    "streamlog-beta-events",
		QueueSize:            1,
		ErrorBufferSize:      1,
		DrainEventQueueTimer: time.Millisecond * 100,
		LogLevel:             kswriter.LogLevelTrace,
		Logger:               &stdLogLogger{},
		Statter:              &kswriter.NopStatter{},
	}

	sl, err := kswriter.New(ctx, cfg)
	if err != nil {
		t.Fatal(err)
	}

	if err := sl.Log("mock_channel", "bitrate", 5000.0); err != nil {
		t.Error(err)
	}

	time.Sleep(time.Millisecond * 1500)

	sl.Close()

}
