package streamlog

import "strings"

func New(streamlogs ...Streamlog) *MultiWriter {
	return &MultiWriter{
		streamlogs: streamlogs,
	}
}

type MultiWriter struct {
	streamlogs []Streamlog
}

func (z *MultiWriter) Log(channel, key string, value interface{}) error {
	var errs []error
	for _, s := range z.streamlogs {
		if err := s.Log(channel, key, value); err != nil {
			errs = append(errs, err)
		}
	}
	return toError(errs)
}

func (z *MultiWriter) LogWithSessionId(sessionId, channel, key string, value interface{}) error {
	var errs []error
	for _, s := range z.streamlogs {
		if err := s.LogWithSessionId(sessionId, channel, key, value); err != nil {
			errs = append(errs, err)
		}
	}
	return toError(errs)
}

func (z *MultiWriter) SetSessionID(sessionID string) {
	for _, s := range z.streamlogs {
		s.SetSessionID(sessionID)
	}
}

func (z *MultiWriter) Close() {
	for _, s := range z.streamlogs {
		s.Close()
	}
}

type multiError struct {
	errors []error
}

func (z multiError) Error() string {
	var b strings.Builder
	for i, e := range z.errors {
		if i != 0 {
			b.WriteString("\n")
		}
		b.WriteString(e.Error())
	}
	return b.String()
}

func toError(errs []error) error {
	if len(errs) == 0 {
		return nil
	} else if len(errs) == 1 {
		return errs[0]
	}
	return multiError{errors: errs}
}
