package streamlog

// nopClient is the "disabled" StreamLog client; it never connects or writes to anything.
// The default/global client is a nopClient if Init() is never called,
// and New() returns a nopClient if the WebsocketEndpoint is empty.
type nopClient struct{}

func (c nopClient) Log(_, _ string, _ interface{}) error {
	return nil
}

func (c nopClient) LogWithSessionId(_, _, _ string, _ interface{}) error {
	return nil
}

func (c nopClient) SetSessionID(_ string) {}

func (c nopClient) Close() {}
