package streamlog

var std Streamlog = &nopClient{}

// Streamlog is a streamlog client.
type Streamlog interface {
	Log(channel, key string, value interface{}) error
	LogWithSessionId(sessionId, channel, key string, value interface{}) error
	SetSessionID(sessionID string)
	Close()
}

// Init configures the default streamlog client and opens its connection.
// If the default client already has an open connection, it is first closed.
// If it is never initialized, the default client silently discards all writes.
func Init(streamlogs ...Streamlog) {
	std.Close()
	std = New(streamlogs...)
}

// SetSessionID updates the default streamlog client's Session ID for all future messages.
func SetSessionID(sessionID string) {
	std.SetSessionID(sessionID)
}

// Log using the default streamlog client.
func Log(channel string, key string, value interface{}) error {
	return std.Log(channel, key, value)
}

// LogWithSessionId logs a message using the default streamlog client using the provided
// Session ID instead of the one it was configured with.
func LogWithSessionId(channel, key, sessionId string, value interface{}) error {
	return std.LogWithSessionId(sessionId, channel, key, value)
}

// Close the default client's connection.
func Close() {
	std.Close()
	std = &nopClient{}
}
