#!/bin/bash

echo 'actions:
  1:
    action: delete_indices
    description: >-
      Delete old indices
    options:
      ignore_empty_list: True
    filters:
    - filtertype: age
      source: name
      direction: older
      timestring: '"'"'%Y.%m.%d'"'"'
      unit: days
      unit_count: '"$3"'
  2:
    action: delete_indices
    description: >-
      Delete future indices
    options:
      ignore_empty_list: True
    filters:
    - filtertype: age
      source: name
      direction: younger
      timestring: '"'"'%Y.%m.%d'"'"'
      unit: days
      unit_count: -'"$4"'' > /tmp/action_file

echo '---
client:
  hosts:
    - '"'$1'"'
  port: '"$2"'
  use_ssl: False
  timeout: 30
  master_only: False

logging:
  loglevel: INFO' > /tmp/config.yml

shift;shift;shift;shift

/usr/lib/nagios/plugins/check_ntp -H time.nist.gov -c 10 || {
  echo "Time was off by more than 10 seconds.  Aborting this run."
  exit 1
}

curator "$@" /tmp/action_file --config /tmp/config.yml
