package api

import (
	"net/http"

	"code.justin.tv/common/twitchhttp"
	"goji.io"
	"goji.io/pat"
	"golang.org/x/net/context"
)

type Server struct {
	*goji.Mux
}

func NewServer() (*Server, error) {
	server := twitchhttp.NewServer()

	s := &Server{
		server,
	}

	// Add your own endpoints here. Endpoint implementation should be defined as functions on Server.
	// For example: s.HandleFuncC(pat.Get("/my/path"), s.myEndpoint)
	// https://godoc.org/goji.io

	s.HandleFuncC(pat.Get("/"), s.EverythingIsFine)
	s.HandleFuncC(pat.Get("/health"), s.EverythingIsFine)
	return s, nil
}

func (s *Server) EverythingIsFine(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	w.Write([]byte("OK"))
}
