#!/bin/sh

while [[ $# -gt 1 ]]
do
key="$1"

case $key in
    -t|--team)
    TEAM="$2"
    shift # past argument
    ;;
    -s|--service)
    SERVICE="$2"
    shift # past argument
    ;;
    *)
    # unknown option
    ;;
esac
shift # past argument or value
done
echo TEAM = "${TEAM}"
echo SERVICE = "${SERVICE}"

if [ -z "$TEAM" ]; then
  echo "You need to supply a team prefix, such as 'web' with the -t or --team option"
  exit 1
fi

if [ -z "$SERVICE" ]; then
  echo "You need to supply a service name, such as 'MyService' with the -s or --service option"
  exit 1
fi

TEAM_LOWER=`echo $TEAM | tr '[:upper:]' '[:lower:]'`
SERVICE_LOWER=`echo $SERVICE| tr '[:upper:]' '[:lower:]'`

echo "Initializing source code"

cat main.go | sed s/TEAM/$TEAM_LOWER/g > tmp
cat tmp | sed s/SERVICE/$SERVICE_LOWER/g > main.go
cat jenkins.groovy | sed s/SERVICE/$SERVICE_LOWER/g > tmp
mv tmp jenkins.groovy

cat build.sh | sed s/TEAM/$TEAM_LOWER/g > tmp
cat tmp | sed s/SERVICE/$SERVICE_LOWER/g > build.sh
rm tmp

echo "Initializing dependencies"

go get github.com/tools/godep
godep save

# Hack to prevent golint/go vet/errcheck from checking the vendor dependencies
mv vendor _vendor
ln -s _vendor vendor
