job {
  name 'bs-go-test-build'
  using 'TEMPLATE-autobuild'
  wrappers {
    credentialsBinding {
      string 'AWS_ACCESS_KEY', 'tw-beanstalk-uploader-access-key'
      string 'AWS_SECRET_KEY', 'tw-beanstalk-uploader-secret-key'
      string 'JOB_DSL_SEED',   'job-dsl-seed'
    }
  }
  scm {
    git {
      remote {
        github 'dta/bs-go-test', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  // Bundle application version to store in S3 for Elastic Beanstalk
  steps {
    shell 'rm -rf .manta/'
    shell 'manta -v'

    shell """
  export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
  export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
  export AWS_DEFAULT_REGION=us-west-2

  cd .manta/
  zip -r ./\$GIT_COMMIT.zip ./*

  description=`git log --pretty=format:"%an - %ad: %B" --abbrev-commit -1 | cut -c 1-200`
  aws s3 cp \$GIT_COMMIT.zip s3://tw-beanstalk-uploader-artifacts/apps/bs-go-test/\$GIT_COMMIT.zip
  aws elasticbeanstalk create-application-version --no-auto-create-application --application-name bs-go-test --version-label \$GIT_COMMIT --description "\$description" --source-bundle S3Bucket=tw-beanstalk-uploader-artifacts,S3Key=apps/bs-go-test/\$GIT_COMMIT.zip
  """

    // The file shuffle is needed so I don't have to modify createPassengerArtifact
    //shell 'rm -rf * && mv .manta/* . && rm -rf .manta'
    //createPassengerArtifact 'bs-go-test', "\$GIT_COMMIT", 'tw-beanstalk-uploader-artifacts'
  }
  // Autodeploy after push to origin/master
  publishers {
    githubCommitNotifier()
    postBuildScripts {
      steps {
        conditionalSteps {
          runner('DontRun')
            condition {
              and {
                stringsMatch('\$GIT_BRANCH', 'origin/master', false)
              } {
                status('UNSTABLE', 'SUCCESS')
              }
            }
          steps {
            deployElasticBeanstalkArtifact 'bs-go-test', 'dev-jma01-env', "\$GIT_COMMIT"
          }
        }
      }
    }
  }
}
