var app = angular.module('app', ['ngRoute', 'ngCookies', 'angularMoment', 'ui.bootstrap.tabs', 'ui.bootstrap.transition', 'ui.bootstrap.progressbar', 'ui.bootstrap.modal', 'ui.bootstrap.tooltip', 'ui.bootstrap.position', 'ui.bootstrap.bindHtml', 'ui.router'])

app.factory('auth_interceptor', ['$cookies', function($cookies) {
  return {
    request: function(config) {
      config.headers['GithubAccessToken'] = $cookies.GithubAccessToken
      return config;
    }
  }
}]);

app.factory('myHttpInterceptor', ['$window', function($window) {
  $window.failed_api_calls = 0;
  $window.successful_api_calls = 0;
  return {
    'response': function(response) {
      $window.successful_api_calls++;
      return response
    },
    'responseError': function(rejection) {
      $window.failed_api_calls++;
      return rejection
    }
  }
}]);

app.config(['$urlRouterProvider', '$stateProvider', '$httpProvider', function($urlRouterProvider, $stateProvider, $httpProvider) {
  $urlRouterProvider.otherwise("/home")
  $httpProvider.interceptors.push('myHttpInterceptor')

  $stateProvider
    .state('login', {
      url: '/login',
      template: '<a href="/authorize">log in</a>',
      controller: function() {}
    })
    .state('home', {
      abstract: true,
      url: "/home",
      templateUrl: "templates/home.html",
      controller: 'home',
      resolve: {
        config_resolve: ['config', '$cookies', '$location', function(config, $cookies, $location) {
          if ($cookies.GithubAccessToken == null) {
            $location.path('/login')
          } else {
            return config.load()
          }
        }],
        my_repos: ['config_resolve', 'repos', function(config_resolve, repos) {
          return repos.load_my_repos()
        }]
      }
    })
    .state('home.history', {
      url: "",
      templateUrl: "templates/home/history.html",
      controller: 'home.history'
    })
    .state('home.org', {
      url: "/:owner",
      templateUrl: "templates/home/org.html",
      controller: 'home.org'
    })
    .state('repo', {
      url: '/:owner/:repo',
      abstract: true,
      templateUrl: 'templates/repo.html',
      controller: 'repo',
      resolve: {
        config_resolve: ['config', '$cookies', '$location', function(config, $cookies, $location) {
          if ($cookies.GithubAccessToken == null) {
            $location.path('/login')
          } else {
            return config.load()
          }
        }],
        settings: ['config_resolve', '$stateParams', 'repos', function(config_resolve, $stateParams, repos) {
          return repos.load_settings($stateParams.owner, $stateParams.repo)
        }]
      }
    })
    .state('repo.candidates', {
      url: '',
      templateUrl: 'templates/repo/candidates.html',
      controller: 'repo.candidates'
    })
    .state('repo.history', {
      url: '/history?env',
      templateUrl: 'templates/repo/history.html',
      controller: 'repo.history'
    })
    .state('repo.environments', {
      url: '/environments',
      templateUrl: 'templates/repo/env.html',
      controller: 'repo.environments'
    })
    .state('repo.deploy', {
      url: '/deploys/:id',
      templateUrl: 'templates/repo/deploy.html',
      controller: 'repo.deploy'
    })

    $httpProvider.interceptors.push('auth_interceptor')
}])

// hacky way to use built-in templates
app.config(function($provide) {
  $provide.decorator('tabsetDirective', function($delegate) {
    $delegate[0].templateUrl = "components/angular-ui-bootstrap/template/tabs/tabset.html";
    return $delegate;
  });
  $provide.decorator('tabDirective', function($delegate) {
    $delegate[0].templateUrl = "components/angular-ui-bootstrap/template/tabs/tab.html";
    return $delegate;
  });
  $provide.decorator('progressbarDirective', function($delegate) {
    $delegate[0].templateUrl = "components/angular-ui-bootstrap/template/progressbar/progressbar.html";
    return $delegate;
  });
  $provide.decorator('modalBackdropDirective', function($delegate) {
    $delegate[0].templateUrl = "components/angular-ui-bootstrap/template/modal/backdrop.html";
    return $delegate;
  });
  $provide.decorator('modalWindowDirective', function($delegate) {
    $delegate[0].templateUrl = "components/angular-ui-bootstrap/template/modal/window.html";
    return $delegate;
  });
  $provide.decorator('tooltipPopupDirective', function($delegate) {
    $delegate[0].templateUrl = "components/angular-ui-bootstrap/template/tooltip/tooltip-popup.html";
    return $delegate;
  });
});
