app.controller('repo.history', ['$scope', '$stateParams', '$state', 'deployments', function($scope, $stateParams, $state, deployments) {
	$scope.owner = $stateParams.owner
	$scope.repo = $stateParams.repo
	$scope.deployments = deployments

	$scope.activate = function() {
		deployments.set_repo($stateParams.owner, $stateParams.repo)
			.then(function() {
				if ($stateParams.env != null) {
					$scope.selected_history_env = $stateParams.env	
				} else {
					$scope.selected_history_env = deployments.environments[0]
				}
			})
	}
	$scope.activate()

	$scope.select_env = function() {
		$state.go('repo.history', {env: $scope.selected_history_env})
	}

	$scope.deploy_status_for = function(deploy_id) {
		classes = ["glyphicon"]
		state = "unknown"

		if (deployments.statuses[deploy_id]) {
			state = deployments.statuses[deploy_id].state		
		}

		classes.push(state)

		switch (state) {
			case "success":
				classes.push("glyphicon-ok")
				break
			case "pending":
				classes.push("glyphicon-time")
				break
			case "failure":
			case "error":
				classes.push("glyphicon-remove")
				break
			case "unknown":
				classes.push("glyphicon-question-sign")
				break	
		}

		return classes
	}
}])
