app.service('artifacts', ['$q', '$http', '$cookies', 'config', 'repos', function($q, $http, $cookies, config, repos) {
	var that = this

	this.set_repo = function(owner, repo) {
		var deferred = $q.defer()

		that.owner = owner
		that.repo = repo
		that.deployed = {}
		that.commits = {}

		that.load_deployed()
			.then(function() {
				deferred.resolve()
			})

		return deferred.promise
	}

	this.load_deployed = function() {
		var deferred = $q.defer()

		c = {
			params: {
				owner: that.owner,
				name: that.repo
			}
		}

		$http.get(config.skadi_host+"/v1/artifacts/deployed", c)
			.success(function(artifacts) {
				that.deployed = artifacts
				deferred.resolve(artifacts)
			})

		return deferred.promise
	}
}]);