app.service('config', ['$q', '$http', '$cookies', function($q, $http, $cookies) {
	var that = this

	this.skadi_host = ""
	this.owner = ""
	this.repo = ""

	this.load = function() {
		var deferred = $q.defer()

		$http.get("/config")
			.success(function(config) {
				that.skadi_host = config.skadi_host
				deferred.resolve(config)
			})

		return deferred.promise
	}

	this.write_default_config = function(owner, repo) {
		var deferred = $q.defer()

		that.owner = owner
		that.repo = repo

		$http.post(that.skadi_host+"/v1/repos/"+that.owner+"/"+that.repo+"/settings/default", null)
			.success(function() {
				deferred.resolve()
			})

		return deferred.promise
	}
}]);