

module "bs-dev" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-core-services"
  eb_application_name = "docker-eb-tf-example"
  vpc_id = "vpc-c1496ea4"
  ec2_subnet_ids = "subnet-bbce86cc,subnet-1fb69c7a,subnet-bf4221e6"
  elb_subnet_ids = "subnet-bbce86cc,subnet-1fb69c7a,subnet-bf4221e6"
  elb_loadbalancer_security_groups = "sg-708bc514,sg-b0703ed4"
  auto_scaling_lc_security_groups = "sg-708bc514,sg-b0703ed4"
  solution_stack_name = "64bit Amazon Linux 2016.09 v2.3.0 running Docker 1.11.2"
  auto_scaling_lc_keypair_name = "devtools-dta"
  auto_scaling_lc_instance_type = "t2.micro"
  owner = "devtools@twitch.tv"
  service = "dta/docker-eb-tf-example"
  env = "dev"
  associate_public_address = "false"


  env_message = "hello dev"
}

module "sandstorm-agent-role-dev" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/dta/tf_sandstorm_agent_iam.git?ref=1.0.0"

  role_name = "devtools-dev-docker-eb-tf-example"
  policy_name = "devtools-dev-docker-eb-tf-example"
}

resource "aws_iam_role_policy" "sandstorm-dev" {
  name = "sandstorm-dev"
  role = "${module.bs-dev.iam_role_id}"
  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Effect": "Allow",
      "Resource": "${module.sandstorm-agent-role-dev.role-arn}"
    },
    {
      "Sid": "Stmt1473817796000",
      "Effect": "Allow",
      "Action": "s3:GetObject",
      "Resource": "${var.sandstorm_s3_path}"
    }
  ]
}
EOF
}
