

module "bs-prod" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-core-services"
  eb_application_name = "${module.bs-app-production.beanstalk_application_name}"
  vpc_id = "vpc-0184df64"
  ec2_subnet_ids = "subnet-ebcd859c,subnet-c543209c,subnet-23b19b46"
  elb_subnet_ids = "subnet-ebcd859c,subnet-c543209c,subnet-23b19b46"
  elb_loadbalancer_security_groups = "sg-09387e6d,sg-4d3b7d29"
  auto_scaling_lc_security_groups = "sg-09387e6d,sg-4d3b7d29"
  solution_stack_name = "64bit Amazon Linux 2016.09 v2.3.0 running Docker 1.11.2"
  auto_scaling_lc_keypair_name = "devtools-dta"
  auto_scaling_lc_instance_type = "t2.medium"
  owner = "devtools@twitch.tv"
  service = "dta/eb-service-role"
  env = "prod"
  associate_public_address = "false"

  eb_environment_service_role = "${aws_iam_role.service-role.name}"
}
