/*

Package dbtrace allows a service owner to emit trace events relating to SQL
database access.

*/
package dbtrace

import (
	"code.justin.tv/common/chitin/internal/trace"
	"code.justin.tv/release/trace/pbmsg"
	"github.com/golang/protobuf/proto"
	"golang.org/x/net/context"
)

// BasicRequestHeadPrepared emits a trace event to announce that a query is
// about to be sent to the database.
func BasicRequestHeadPrepared(ctx context.Context, peer string, query string) {
	// TODO: normalize and attach query string

	// TODO: write a more fully-featured method to include details on the db
	// connection: db name, user name, etc.

	trace.SendEvent(ctx, &pbmsg.Event{
		Kind: pbmsg.Event_REQUEST_HEAD_PREPARED.Enum(),
		Extra: &pbmsg.Extra{
			Peer: proto.String(peer),
		},
	})
}

// BasicResponseHeadReceived emits a trace event to announce that a query has
// been processed by the database, and that the results (if any) are ready for
// consumption.
func BasicResponseHeadReceived(ctx context.Context) {
	// TODO: include some indication of query success when possible

	trace.SendEvent(ctx, &pbmsg.Event{
		Kind:  pbmsg.Event_RESPONSE_HEAD_RECEIVED.Enum(),
		Extra: nil,
	})
}
