package pkgpath

import (
	"os/exec"
	"testing"
)

func TestPkgpathMain(t *testing.T) {
	pkg, ok := Main()
	if have, want := pkg, "code.justin.tv/common/golibs/pkgpath/_test"; have != want {
		t.Errorf("Main(); %q != %q", have, want)
	}
	if have, want := ok, true; have != want {
		t.Errorf("Main(); %t != %t", have, want)
	}
}

func TestByRunning(t *testing.T) {
	cmd := exec.Command("go", "run", "--", "./maintest/main.go")
	out, err := cmd.CombinedOutput()
	if err != nil {
		t.Fatalf("go run maintest/main.go; err = %q", err)
	}
	if have, want := string(out), "code.justin.tv/common/golibs/pkgpath/maintest\n"; have != want {
		t.Errorf("pkgpath.Main(); %q != %q", have, want)
	}
}

func TestPkgpathCaller(t *testing.T) {
	pkg, ok := Caller(0)
	if have, want := pkg, "code.justin.tv/common/golibs/pkgpath"; have != want {
		t.Errorf("Main(); %q != %q", have, want)
	}
	if have, want := ok, true; have != want {
		t.Errorf("Main(); %t != %t", have, want)
	}
}

func TestFileImportPath(t *testing.T) {
	tests := []struct {
		file string
		path string
	}{
		{file: "/go/src/code.justin.tv/web/tmi/irc/irc.go",
			path: "code.justin.tv/web/tmi/irc"},
		{file: "/go/src/code.justin.tv/web/owl/Godeps/_workspace/src/github.com/kisielk/errcheck/main.go",
			path: "github.com/kisielk/errcheck"},
		{file: "code.justin.tv/common/chitin/_test/generated.go",
			path: "code.justin.tv/common/chitin/_test"},
		{file: "/tmp/runme.go",
			path: "main"},
	}

	for _, tt := range tests {
		if have, want := fileImportPath(tt.file), tt.path; have != want {
			t.Errorf("fileImportPath(%q); %q != %q", tt.file, have, want)
		}
	}
}
