// Forerunner stores names in hyphenated flag value.
// Example:
//
// github-oauth-token
//
// These are helper functions to convert from GoCamelCase style and
// ENV_UNDERSCORE style to flag-style.
package config

import (
	"regexp"
	"strings"
)

var camelCaseRE = regexp.MustCompile(`([A-Z])+`)

func ConvertFlagToEnvName(in string) string {
	return strings.Replace(strings.ToUpper(in), "-", "_", -1)
}

func ConvertGoName(str string) string {
	str = camelCaseRE.ReplaceAllStringFunc(str,
		func(in string) string {
			return "-" + strings.ToLower(in)
		},
	)
	// Remove any leading '-':
	return strings.Trim(str, "-")
}
