package libforerunner

import "testing"

func mustSetupForerunner(t *testing.T, opts *Options) *Forerunner {
	fr, err := Init(opts)
	if err != nil {
		t.Fatalf("Unable to init libforerunner: %v", err)
	}

	return fr
}

// TestNoInterchange tests whether the libforerunner can Init if there is no
// interchange set.
func TestNoInterchange(t *testing.T) {
	type testStruct struct {
		Val1 string
	}

	ts := &testStruct{"foobar"}

	fr, err := Init(&Options{
		DefaultConfig: ts,
	})
	if err != nil {
		t.Fatalf("Error Initalizing libforerunner: %v", err)
	}

	ts2 := &testStruct{}

	if err := fr.GetConfig(ts2); err != nil {
		t.Fatalf("Error getting config: %v", err)
	}

	if ts2.Val1 != ts.Val1 {
		t.Errorf("Default value not loaded into ts2. Got %q; want %q", ts2.Val1, ts2.Val1)
	}
}

func TestGetConfig(t *testing.T) {
}

func TestWrite(t *testing.T) {
}

func TestPrint(t *testing.T) {
}
