package main

import (
	"bytes"
	"fmt"
	"log"

	"code.justin.tv/release/forge/internal/terraform"
)

func main() {
	version, commit, err := terraform.Version()
	if err != nil {
		log.Fatalf("Terraform doesn't exist: %#v", err)
	}

	log.Printf("Testing terraform %v %v", version, commit)

	t, err := terraform.New(
		"application-data/forge/devel-test",
		bytes.NewBufferString(`
provider "consul" {
	scheme = "http"
    address = "consul.internal.justin.tv:80"
    datacenter = "sfo01"
}


resource "consul_keys" "skadi-settings" {
    key {
        name = "consul-prefix"
        path = "settings/skadi/staging/consul-prefix"
        default = "application-data/skadi/dev/"
    }
}
	
	`))

	if err != nil {
		log.Fatal(err)
	}

	plan, err := t.Plan()
	if err != nil {
		log.Fatal(err)
	}

	fmt.Print(plan)
}
