package terraform

import "testing"

func TestParseVersion(t *testing.T) {
	type testCase struct {
		Input   string
		Version string
		Commit  string
	}

	for _, c := range []testCase{
		{`Terraform v0.5.3-dev (db095e2bca13ba102345084117a698b94b5cab71+CHANGES)`, "v0.5.3-dev", "db095e2bca13ba102345084117a698b94b5cab71+CHANGES"},
		{`Terraform v0.5.3-dev (db095e2bca13ba102345084117a698b94b5cab71+CHANGES)`, "v0.5.3-dev", "db095e2bca13ba102345084117a698b94b5cab71+CHANGES"},
		{"Terraform v0.5.3 (db095e2bca13ba102345084117a698b94b5cab71)\nfoo\nbar", "v0.5.3", "db095e2bca13ba102345084117a698b94b5cab71"},
		{`Terraform v0.5.3

		`, "v0.5.3", "official"},
	} {
		version, commit, err := parseVersion([]byte(c.Input))
		if err != nil {
			t.Errorf("parseVersion(%q) = err: %v", c.Input, err)
			continue
		}

		if c.Version != version || c.Commit != commit {
			t.Errorf("parseVersion(%q) = %q, %q; want %q, %q", c.Input, version, commit, c.Version, c.Commit)
		}
	}
}
