module "base" {
    source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//base"
}

variable env {}
variable owner {}
variable count {
  default = "1"
}

variable dev_avail {
    default {
        zone0 = "subnet-d4a423b1"
        zone1 = "subnet-67ad0810"
        zone2 = "subnet-894ab1d0"
        # Hack to make this work with larger counts
        zone3  = "subnet-d4a423b1"
        zone4  = "subnet-67ad0810"
        zone5  = "subnet-894ab1d0"
        zone6  = "subnet-d4a423b1"
        zone7  = "subnet-67ad0810"
        zone8  = "subnet-894ab1d0"
        zone9  = "subnet-d4a423b1"
        zone10 = "subnet-67ad0810"
        zone11 = "subnet-894ab1d0"
        zone12 = "subnet-d4a423b1"
        zone13 = "subnet-67ad0810"
        zone14 = "subnet-894ab1d0"
        zone15 = "subnet-d4a423b1"
        zone16 = "subnet-67ad0810"
        zone17 = "subnet-894ab1d0"
        zone18 = "subnet-d4a423b1"
        zone19 = "subnet-67ad0810"
        zone20 = "subnet-894ab1d0"
    }
}

################
# Forge Server #
################

module "forge-instance" {
    source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//puppet_instance"
    hostname_prefix = "${var.env}-forge"
    cluster = "forge"
    owner = "${var.owner}"
    facts = "app_env=${var.env}"
}

######
# DB #
######

resource "aws_db_subnet_group" "forge" {
	name = "forge-${var.env}"
	description = "DB subnet for forge; env: '${var.env}'"

	subnet_ids = ["${var.dev_avail.zone0}", "${var.dev_avail.zone1}", "${var.dev_avail.zone2}"]
} 

resource "aws_db_instance" "forge" {
	identifier = "forge-${var.env}"
	allocated_storage = 5
	engine = "postgres"
	engine_version = "9.3.5"
	instance_class = "db.t2.medium"
	multi_az = true
	name = "forge"
	port = 5432
	username = "forge"
	password = "XXXXXXXXXX"
	vpc_security_group_ids = ["${module.base.dev_twitch_security_group}"]
	db_subnet_group_name = "${aws_db_subnet_group.forge.name}"
	parameter_group_name = "default.postgres9.3"
}

##################################
# Register environment in consul #
##################################

resource "consul_keys" "forge-env" {
    datacenter = "sfo01"
    key {
        name = "env-registration"
        path = "dynamic-envs/release/forge/${var.env.name}"
        value = "{}"
        delete = true
    }
}

###############################
# Configure the App in Consul #
###############################

resource "consul_keys" "forge-db-password" {
    datacenter = "us-west2"
    key {
        name = "forge-db-password"
        path = "settings/forge/${var.env.name}/pg-conn-info"
        value = "host=${aws_db_instance.forge.address} port=5432 user=forge password=XXXXXXXXXX"
        delete = true
    }
}

##########
# Output #
##########

output "url" {
  value = "http://${module.forge-instance.fqdn}:8080/"
}
