#!/bin/sh
set -x
set -e

HOSTNAME="$(hostname)"
export DEBIAN_FRONTEND=noninteractive

sleep 10

# Datadog Repo
apt-key adv --keyserver keyserver.ubuntu.com --recv-keys C7A7DA52
cat <<EOF > /etc/apt/sources.list.d/datadog.list
deb https://apt.datadoghq.com/ stable main
EOF

# Docker Repo
curl -fsSL https://download.docker.com/linux/ubuntu/gpg | apt-key add -
cat <<EOF > /etc/apt/sources.list.d/docker.list
deb [arch=amd64] https://download.docker.com/linux/ubuntu $(lsb_release -cs) stable
EOF


apt-get update -qq
apt-get upgrade -y -qq

# works around an issue with twitch-mgdbagent installation.
touch /etc/libuser.conf && chmod 0644 /etc/libuser.conf

apt-get install -y -qq --no-install-recommends \
  datadog-agent=1:5.15.0-1 \
  docker-ce=17.09.0~ce-0~ubuntu \
  jenkins-utils=1.14.20170920205439-1 \
  linux-headers-virtual \
  linux-image-extra-virtual

# Allow datadog-agent to collect docker metrics.
adduser dd-agent docker

# Allow shared user to access docker without having to sudo.
adduser ubuntu docker

cat <<EOF > /etc/docker/daemon.json
{
  "graph": "/mnt/docker",
  "log-driver": "journald",
  "storage-driver": "overlay2"
}
EOF

cat <<EOF > /etc/docker-gc-exclude
ubuntu:[^ ]\+
release_jenkins/[^ ]\+:[^ ]\+
centos:[^ ]\+
devtools/.*:latest
manta/.*:latest
EOF

cat <<EOF > /etc/docker-gc-exclude-containers
jenkins_\(slave\|master\)
EOF

cat <<EOF > /etc/cron.daily/docker-gc
#!/bin/bash
docker run --rm -v /var/run/docker.sock:/var/run/docker.sock -v /etc/docker-gc-exclude-containers:/etc/docker-gc-exclude-containers -v /etc/docker-gc-exclude:/etc/docker-gc-exclude -e GRACE_PERIOD_SECONDS=432000 -e FORCE_CONTAINER_REMOVAL=1 -e FORCE_IMAGE_REMOVAL=1 spotify/docker-gc
EOF

# Cache the latest jenkins docker base image to reduce jenkins first startup.
docker pull docker-registry.internal.justin.tv/release_jenkins/base:production


echo "Cleaning up..."

# Cleanup packages
apt-get autoremove -y; apt-get purge -y $(dpkg --list |grep '^rc' |awk '{print $2}')

# Set hostname back to default.
echo $HOSTNAME > /etc/hostname; hostname -F /etc/hostname
sed -i -e 's/^.*us-west2.*$//g' /etc/hosts

sed -i '/certname/d' /etc/puppet/puppet.conf

# Remove cluster facts
rm -f /etc/facter/facts.d/cluster.txt

# Remove host specific config from files
sed -i -e 's/^.*baseami.*$//' /etc/filebeat/filebeat.yml /etc/allowed_groups /etc/postfix/main.cf

# Make sure cloud-init hasn't added /mnt for the current ebs volume
sed -i -e '/^.\+\/mnt/d;/^.\*\/mnt/d' /etc/fstab
sed -i -e '/^#/!s/\s\+/\t/g' /etc/fstab

# General system clean so it looks fresh on first use
CLEANUP_LIST="/var/lib/ubuntu-release-upgrader /var/lib/update-notifier /var/lib/update-manager /var/lib/man-db /var/lib/apt-xapian-index /var/lib/{lxd,lxcfs} /var/lib/cloud/data/scripts /var/lib/cloud/scripts/per-instance /var/lib/cloud/data/user-data* /var/spool/cloud/* /tmp/* /var/tmp/* /usr/tmp/* /var/cache/* /var/mail/* /var/lib/ntp/ntp.drift /etc/hosts.backup.* /etc/pki/tls/private/* /root/.ssh /root/.gem /root/* /root/.*_history /home/ubuntu/.*_history /root/.vim* /root/.lesshst /root/.gemrc /var/lib/puppet /etc/puppet/ssl /lib/udev/rules.d/75-persistent-net-generator.rules /var/lib/dhcp/* /var/lib/dhcp3/* /etc/hardware/lshw.json /etc/mailname /etc/network/interfaces.d/50-cloud-init.cfg /etc/systemd/network/50-cloud-init-eth0.link /etc/blkid.tab /dev/.blkid.tab /etc/systemd/network/99-default.link /var/lib/dhclient/* /etc/network/interfaces.d/50-cloud-init.cfg /etc/apt/sources.list.d/raphink-augeas*"

# Delete these files
for filename in $CLEANUP_LIST; do
  if [ -e $filename ]; then
    rm -rf $filename
  fi
done

# Ensure no big deletes are still pending
sync

# If we got here without exiting we should return true
echo "Build complete!"
exit 0
