package main

import (
	"log"

	"code.justin.tv/common/config"
	"code.justin.tv/common/twitchhttp"
	"code.justin.tv/dta/knowledgebot/api"
)

func main() {
	// To add app-specific config flags, you can call config.Register()
	// https://godoc.internal.justin.tv/code.justin.tv/common/config
	err := config.Parse()
	if err != nil {
		log.Fatal("failed parsing config:", err)
	}

	server, err := api.NewServer()
	if err != nil {
		log.Fatal("failed creating server:", err)
	}

	if err := twitchhttp.ListenAndServe(server); err != nil {
		log.Fatal("failed starting server:", err)
	}
}
