job {
    name 'dta-syslog-build'
    using 'TEMPLATE-autobuild'
    scm {
        git {
            remote {
                github 'dta/logstashConfig', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
        branches 'origin/master'
        clean true
        }
        
    }
    steps {
        shell 'docker build -t dtaLogstash:$GIT_COMMIT ; docker tag dtaLogstash:$GIT_COMMIT docker.internal.justin.tv/devtools/dtaLogstash:$GIT_COMMIT ; docker push docker.internal.justin.tv/devtools/dtaLogstash:$GIT_COMMIT'
    }
}
job {
    name 'dta-syslog-deploy'
    parameters {
        stringParam 'GIT_COMMIT'
    }
    scm {
        git {
            remote {
                github 'dta/logstashConfig', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
        branches 'origin/master'
        clean true
        }
    }
    wrappers{
        credentialsBinding {
            string('dta_tools_deploy', 'dtatoolsdeploy')
        }
    }
    steps {
      shell 'courier deploy --hosts $HOSTS --environnent $ENVIRONMENT --repo "dta/logstashConfig" --image "docker.internal.justin.tv/devtools/dtaLogstash"'
    }
    wrappers {
        preBuildCleanup()
    }

}
