-- +goose Up
-- SQL in section 'Up' is executed when this migration is applied

CREATE TYPE status AS ENUM (
  'Created', 'Queued', 'InProgress', 'Succeeded', 'Failed', 'Stopped');
CREATE TYPE bundletype AS ENUM ('tar', 'tgz', 'zip');

CREATE TABLE deployments (
  id             TEXT PRIMARY KEY NOT NULL,
  created_at     TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT current_timestamp,
  triggered_by   TEXT NOT NULL,
  sha		         TEXT NOT NULL,
  owner          TEXT NOT NULL,
  repository     TEXT NOT NULL,
  environment	   TEXT NOT NULL,

  account        TEXT NOT NULL,
  application    TEXT NOT NULL,
  "group"        TEXT NOT NULL,
  s3location     TEXT NOT NULL,
  bundletype     bundletype NOT NULL,
  config         TEXT NOT NULL,

  status         status NOT NULL DEFAULT 'InProgress'
);
CREATE TABLE nodes (
  id             TEXT PRIMARY KEY NOT NULL,
  datacenter     TEXT NOT NULL
);
CREATE TABLE node_status (
  id             SERIAL PRIMARY KEY  NOT NULL,

  node           TEXT REFERENCES nodes (id),
  deployment     TEXT REFERENCES deployments (id),
  update_time    TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT current_timestamp,

  status         status NOT NULL DEFAULT 'InProgress'
);
CREATE TABLE node_history (
  id             SERIAL PRIMARY KEY  NOT NULL,

  node           TEXT REFERENCES nodes (id),
  deployment     TEXT REFERENCES deployments (id),
  update_time    TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT current_timestamp,

  status         status NOT NULL DEFAULT 'InProgress'
);

-- +goose Down
-- SQL section 'Down' is executed when this migration is rolled back
DROP TABLE node_status;
DROP TABLE node_history;
DROP TABLE nodes;
DROP TABLE deployments;
DROP TYPE bundletype;
DROP TYPE status;
