from setuptools import setup
from setuptools.command.test import test


class PytestTest(test):
    def finalize_options(self):
        test.finalize_options(self)
        self.test_args = []
        self.test_suite = True

    def run_tests(self):
        import pytest
        pytest.main([])


setup(
    name="Mekansm",
    version="0.3.0",
    description="An API for Deployment Validation.",
    packages=["mekansm"],
    author="Twitch",
    cmdclass={"test": PytestTest},
    install_requires=[
        "CherryPy>=3.8,<4",
        "boto3>=1.2.1,<2",
        "SQLAlchemy>=1.0.9,<2",
        "PyYAML>=3.11,<4.0",
        "psycopg2>=2.6.1,<3",
        "pygerduty>=0.12,<1",
        "utc>=0.0.3,<1"
    ],
    tests_require=[
        "pytest-cov>=2.2.0,<3",
        "pytest>=2.8.2,<3",
        "pytest-xdist>=1,<2",
        "testing.postgresql>=1.3,<2",
        "webtest>=2.0.20,<3"
    ]
)
